/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebIDBConnectionToServer.h"

#include "ArgumentCoders.h"
#include "Decoder.h"
#include "HandleMessage.h"
#include "WebCoreArgumentCoders.h"
#include "WebIDBConnectionToServerMessages.h"
#include "WebIDBResult.h"
#include <WebCore/IDBDatabaseNameAndVersion.h>
#include <WebCore/IDBError.h>
#include <WebCore/IDBResourceIdentifier.h>
#include <WebCore/IDBResultData.h>
#include <wtf/Vector.h>

namespace WebKit {

void WebIDBConnectionToServer::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidDeleteDatabase::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidDeleteDatabase>(connection, decoder, this, &WebIDBConnectionToServer::didDeleteDatabase);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidOpenDatabase::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidOpenDatabase>(connection, decoder, this, &WebIDBConnectionToServer::didOpenDatabase);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidAbortTransaction::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidAbortTransaction>(connection, decoder, this, &WebIDBConnectionToServer::didAbortTransaction);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidCommitTransaction::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidCommitTransaction>(connection, decoder, this, &WebIDBConnectionToServer::didCommitTransaction);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidCreateObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidCreateObjectStore>(connection, decoder, this, &WebIDBConnectionToServer::didCreateObjectStore);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidDeleteObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidDeleteObjectStore>(connection, decoder, this, &WebIDBConnectionToServer::didDeleteObjectStore);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidRenameObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidRenameObjectStore>(connection, decoder, this, &WebIDBConnectionToServer::didRenameObjectStore);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidClearObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidClearObjectStore>(connection, decoder, this, &WebIDBConnectionToServer::didClearObjectStore);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidCreateIndex::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidCreateIndex>(connection, decoder, this, &WebIDBConnectionToServer::didCreateIndex);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidDeleteIndex::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidDeleteIndex>(connection, decoder, this, &WebIDBConnectionToServer::didDeleteIndex);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidRenameIndex::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidRenameIndex>(connection, decoder, this, &WebIDBConnectionToServer::didRenameIndex);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidPutOrAdd::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidPutOrAdd>(connection, decoder, this, &WebIDBConnectionToServer::didPutOrAdd);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidGetRecord::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidGetRecord>(connection, decoder, this, &WebIDBConnectionToServer::didGetRecord);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidGetAllRecords::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidGetAllRecords>(connection, decoder, this, &WebIDBConnectionToServer::didGetAllRecords);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidGetCount::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidGetCount>(connection, decoder, this, &WebIDBConnectionToServer::didGetCount);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidDeleteRecord::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidDeleteRecord>(connection, decoder, this, &WebIDBConnectionToServer::didDeleteRecord);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidOpenCursor::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidOpenCursor>(connection, decoder, this, &WebIDBConnectionToServer::didOpenCursor);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidIterateCursor::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidIterateCursor>(connection, decoder, this, &WebIDBConnectionToServer::didIterateCursor);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::FireVersionChangeEvent::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::FireVersionChangeEvent>(connection, decoder, this, &WebIDBConnectionToServer::fireVersionChangeEvent);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidStartTransaction::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidStartTransaction>(connection, decoder, this, &WebIDBConnectionToServer::didStartTransaction);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidCloseFromServer::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidCloseFromServer>(connection, decoder, this, &WebIDBConnectionToServer::didCloseFromServer);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::NotifyOpenDBRequestBlocked::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::NotifyOpenDBRequestBlocked>(connection, decoder, this, &WebIDBConnectionToServer::notifyOpenDBRequestBlocked);
    if (decoder.messageName() == Messages::WebIDBConnectionToServer::DidGetAllDatabaseNamesAndVersions::name())
        return IPC::handleMessage<Messages::WebIDBConnectionToServer::DidGetAllDatabaseNamesAndVersions>(connection, decoder, this, &WebIDBConnectionToServer::didGetAllDatabaseNamesAndVersions);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit
