/* IconButton.c generated by valac 0.56.0, the Vala compiler
 * generated from IconButton.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include "icontasklistapplet.h"
#include <libwnck/libwnck.h>
#include <gio/gio.h>
#include "abomination.h"
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "appsys.h"
#include "plugin.h"
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define DEFAULT_OPACITY 0.1
#define INDICATOR_SIZE 2
#define INDICATOR_SPACING 1
#define INACTIVE_INDICATOR_SPACING 2

enum  {
	ICON_BUTTON_0_PROPERTY,
	ICON_BUTTON_ABOMINATION_PROPERTY,
	ICON_BUTTON_APP_SYSTEM_PROPERTY,
	ICON_BUTTON_DESKTOP_HELPER_PROPERTY,
	ICON_BUTTON_POPOVER_MANAGER_PROPERTY,
	ICON_BUTTON_NUM_PROPERTIES
};
static GParamSpec* icon_button_properties[ICON_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define __vala_GdkEventButton_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventButton_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
enum  {
	ICON_BUTTON_BECAME_EMPTY_SIGNAL,
	ICON_BUTTON_PINNED_CHANGED_SIGNAL,
	ICON_BUTTON_NUM_SIGNALS
};
static guint icon_button_signals[ICON_BUTTON_NUM_SIGNALS] = {0};

struct _IconButtonPrivate {
	BudgieIconPopover* popover;
	WnckScreen* screen;
	GSettings* settings;
	WnckWindow* window;
	BudgieAbominationAppGroup* class_group;
	GDesktopAppInfo* app_info;
	gint window_count;
	GtkAllocation definite_allocation;
	gboolean originally_pinned;
	GdkAppLaunchContext* launch_context;
	gint64 last_scroll_time;
	gboolean needs_attention;
	BudgieAbominationAbomination* _abomination;
	BudgieAppSystem* _app_system;
	DesktopHelper* _desktop_helper;
	BudgiePopoverManager* _popover_manager;
};

struct _Block2Data {
	int _ref_count_;
	IconButton* self;
	BudgieAbominationRunningApp* app;
};

struct _Block3Data {
	int _ref_count_;
	IconButton* self;
	gulong xid;
};

struct _Block4Data {
	int _ref_count_;
	IconButton* self;
	WnckWindow* window;
};

struct _Block5Data {
	int _ref_count_;
	IconButton* self;
	WnckWindow* window;
};

struct _Block6Data {
	int _ref_count_;
	IconButton* self;
	GdkEventButton* event;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gboolean one_active;
};

static gint IconButton_private_offset;
static gpointer icon_button_parent_class = NULL;
static GType icon_button_type_id = 0;

static void icon_button_gobject_constructors_suck (IconButton* self);
static gboolean icon_button_has_valid_windows (IconButton* self,
                                        gint* num_windows);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda35_ (Block2Data* _data2_);
static void ___lambda35__wnck_window_state_changed (WnckWindow* _sender,
                                             WnckWindowState changed_mask,
                                             WnckWindowState new_state,
                                             gpointer self);
static gboolean __lambda19_ (IconButton* self);
static gboolean ___lambda19__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda20_ (IconButton* self);
static gboolean ___lambda20__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static void __lambda21_ (IconButton* self,
                  GdkDragContext* context);
static void ___lambda21__gtk_widget_drag_begin (GtkWidget* _sender,
                                         GdkDragContext* context,
                                         gpointer self);
static void __lambda22_ (IconButton* self,
                  GtkWidget* widget,
                  GdkDragContext* context,
                  GtkSelectionData* selection_data,
                  guint info,
                  guint time);
static void ___lambda22__gtk_widget_drag_data_get (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self);
static void _icon_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                             GtkAllocation* allocation,
                                                             gpointer self);
static void icon_button_on_launched (IconButton* self,
                              GAppInfo* info,
                              GVariant* v);
static void _icon_button_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender,
                                                             GAppInfo* info,
                                                             GVariant* platform_data,
                                                             gpointer self);
static void icon_button_on_launch_failed (IconButton* self,
                                   const gchar* id);
static void _icon_button_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                                       const gchar* startup_notify_id,
                                                                       gpointer self);
static void ___lambda23_ (IconButton* self);
static void ____lambda23__budgie_abomination_running_app_renamed_app (BudgieAbominationRunningApp* _sender,
                                                               const gchar* old_name,
                                                               const gchar* new_name,
                                                               gpointer self);
static void ___lambda24_ (IconButton* self,
                   GDesktopAppInfo* app_info);
static void ____lambda24__budgie_abomination_running_app_app_info_changed (BudgieAbominationRunningApp* _sender,
                                                                    GDesktopAppInfo* app_info,
                                                                    gpointer self);
static void ___lambda25_ (IconButton* self);
static void ____lambda25__budgie_abomination_running_app_icon_changed (BudgieAbominationRunningApp* _sender,
                                                                const gchar* icon_name,
                                                                gpointer self);
static void __lambda26_ (IconButton* self);
static void icon_button_launch_app (IconButton* self,
                             guint32 time);
static void ___lambda26__budgie_icon_popover_launch_new_instance (BudgieIconPopover* _sender,
                                                           gpointer self);
static void __lambda27_ (IconButton* self);
static void ___lambda27__budgie_icon_popover_added_window (BudgieIconPopover* _sender,
                                                    gpointer self);
static void __lambda28_ (IconButton* self);
static void ___lambda28__budgie_icon_popover_closed_all (BudgieIconPopover* _sender,
                                                  gpointer self);
static void __lambda29_ (IconButton* self);
static void ___lambda29__budgie_icon_popover_closed_window (BudgieIconPopover* _sender,
                                                     gpointer self);
static void __lambda30_ (IconButton* self,
                  gboolean new_pinned_state);
static void ___lambda30__budgie_icon_popover_changed_pin_state (BudgieIconPopover* _sender,
                                                         gboolean new_state,
                                                         gpointer self);
static void __lambda31_ (IconButton* self,
                  gulong xid,
                  gint wid);
static void ___lambda31__budgie_icon_popover_move_window_to_workspace (BudgieIconPopover* _sender,
                                                                gulong xid,
                                                                gint workspace_num,
                                                                gpointer self);
static void __lambda32_ (IconButton* self,
                  const gchar* action);
static void ___lambda32__budgie_icon_popover_perform_action (BudgieIconPopover* _sender,
                                                      const gchar* action,
                                                      gpointer self);
static void __lambda33_ (IconButton* self,
                  WnckWorkspace* workspace);
static void ___lambda33__wnck_screen_workspace_created (WnckScreen* _sender,
                                                 WnckWorkspace* space,
                                                 gpointer self);
static void __lambda34_ (IconButton* self,
                  WnckWorkspace* workspace);
static void ___lambda34__wnck_screen_workspace_destroyed (WnckScreen* _sender,
                                                   WnckWorkspace* space,
                                                   gpointer self);
static void __lambda38_ (IconButton* self);
static void ___lambda38__budgie_abomination_app_group_icon_changed (BudgieAbominationAppGroup* _sender,
                                                             gpointer self);
static void __lambda39_ (IconButton* self,
                  WnckWindow* new_window);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean icon_button_should_add_window (IconButton* self,
                                        WnckWindow* new_window);
static void __lambda40_ (Block3Data* _data3_);
static void ___lambda40__wnck_window_name_changed (WnckWindow* _sender,
                                            gpointer self);
static void ___lambda39__budgie_abomination_app_group_added_window (BudgieAbominationAppGroup* _sender,
                                                             WnckWindow* window,
                                                             gpointer self);
static void __lambda41_ (IconButton* self,
                  WnckWindow* old_window);
static void ___lambda41__budgie_abomination_app_group_removed_window (BudgieAbominationAppGroup* _sender,
                                                               WnckWindow* window,
                                                               gpointer self);
static void icon_button_setup_popover_with_class (IconButton* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda36_ (Block4Data* _data4_);
static void ___lambda36__wnck_window_name_changed (WnckWindow* _sender,
                                            gpointer self);
static void __lambda37_ (Block4Data* _data4_);
static void ___lambda37__wnck_window_state_changed (WnckWindow* _sender,
                                             WnckWindowState changed_mask,
                                             WnckWindowState new_state,
                                             gpointer self);
static gboolean icon_button_real_draw (GtkWidget* base,
                                cairo_t* cr);
static void _____lambda42_ (IconButton* self);
static void ______lambda42__budgie_abomination_running_app_renamed_app (BudgieAbominationRunningApp* _sender,
                                                                 const gchar* old_name,
                                                                 const gchar* new_name,
                                                                 gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _______lambda43_ (Block5Data* _data5_);
static void ________lambda43__wnck_window_name_changed (WnckWindow* _sender,
                                                 gpointer self);
static void _______lambda44_ (Block5Data* _data5_);
static void ________lambda44__wnck_window_state_changed (WnckWindow* _sender,
                                                  WnckWindowState changed_mask,
                                                  WnckWindowState new_state,
                                                  gpointer self);
static void icon_button_real_get_preferred_width (GtkWidget* base,
                                           gint* min,
                                           gint* nat);
static void icon_button_real_get_preferred_height (GtkWidget* base,
                                            gint* min,
                                            gint* nat);
static gboolean icon_button_real_button_press_event (GtkWidget* base,
                                              GdkEventButton* event);
static void icon_button_handle_launch_clicks (IconButton* self,
                                       GdkEventButton* event,
                                       gboolean was_double_click);
static gboolean icon_button_real_button_release_event (GtkWidget* base,
                                                GdkEventButton* event);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static GdkEventButton* _vala_GdkEventButton_copy (GdkEventButton* self);
static void _vala_GdkEventButton_free (GdkEventButton* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void icon_button_toggle_window_minstate (IconButton* self,
                                         guint32 time,
                                         WnckWindow* win);
static void _____lambda45_ (Block7Data* _data7_,
                     WnckWindow* w);
static void ______lambda45__gfunc (gconstpointer data,
                            gpointer self);
static gboolean icon_button_real_scroll_event (GtkWidget* base,
                                        GdkEventScroll* event);
static void icon_button_finalize (GObject * obj);
static void _vala_icon_button_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_icon_button_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GtkTargetEntry DESKTOP_HELPER_targets[3];

static inline gpointer
icon_button_get_instance_private (IconButton* self)
{
	return G_STRUCT_MEMBER_P (self, IconButton_private_offset);
}

/**
 * Bootstrap a button without window nor group, as it should be for pinned
 * buttons without any active apps.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

IconButton*
icon_button_construct (GType object_type,
                       BudgieAbominationAbomination* ab,
                       BudgieAppSystem* appsys,
                       GSettings* c_settings,
                       DesktopHelper* helper,
                       BudgiePopoverManager* manager,
                       GDesktopAppInfo* info,
                       const gchar* button_id)
{
	IconButton * self = NULL;
	GSettings* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (button_id != NULL, NULL);
	self = (IconButton*) g_object_new (object_type, "abomination", ab, "app-system", appsys, "desktop-helper", helper, "popover-manager", manager, NULL);
	_tmp0_ = _g_object_ref0 (c_settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (info);
	_g_object_unref0 (self->priv->app_info);
	self->priv->app_info = _tmp1_;
	self->pinned = TRUE;
	self->priv->originally_pinned = TRUE;
	_tmp2_ = g_strdup (button_id);
	_g_free0 (self->button_id);
	self->button_id = _tmp2_;
	icon_button_gobject_constructors_suck (self);
	icon_button_create_popover (self);
	icon_button_update_icon (self);
	if (icon_button_has_valid_windows (self, NULL)) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp3_, "running");
	}
	return self;
}

IconButton*
icon_button_new (BudgieAbominationAbomination* ab,
                 BudgieAppSystem* appsys,
                 GSettings* c_settings,
                 DesktopHelper* helper,
                 BudgiePopoverManager* manager,
                 GDesktopAppInfo* info,
                 const gchar* button_id)
{
	return icon_button_construct (TYPE_ICON_BUTTON, ab, appsys, c_settings, helper, manager, info, button_id);
}

/**
 * Bootstrap our button to be ready to work with grouping DISABLED.
 */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		IconButton* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->app);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda35_ (Block2Data* _data2_)
{
	IconButton* self;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	gboolean _tmp2_;
	self = _data2_->self;
	_tmp0_ = budgie_abomination_running_app_get_window (_data2_->app);
	_tmp1_ = _tmp0_;
	_tmp2_ = wnck_window_needs_attention (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		icon_button_attention (self, TRUE);
	}
}

static void
___lambda35__wnck_window_state_changed (WnckWindow* _sender,
                                        WnckWindowState changed_mask,
                                        WnckWindowState new_state,
                                        gpointer self)
{
	__lambda35_ (self);
}

IconButton*
icon_button_construct_from_app (GType object_type,
                                BudgieAbominationAbomination* ab,
                                BudgieAppSystem* appsys,
                                GSettings* c_settings,
                                DesktopHelper* helper,
                                BudgiePopoverManager* manager,
                                BudgieAbominationRunningApp* app,
                                const gchar* button_id)
{
	IconButton * self = NULL;
	Block2Data* _data2_;
	BudgieAbominationRunningApp* _tmp0_;
	GSettings* _tmp1_;
	BudgieAbominationAbomination* _tmp2_;
	WnckWindow* _tmp3_;
	WnckWindow* _tmp4_;
	BudgieAbominationRunningApp* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	BudgieAbominationRunningApp* _tmp8_;
	WnckWindow* _tmp17_;
	WnckWindow* _tmp18_;
	WnckWindow* _tmp19_;
	WnckWindow* _tmp20_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (button_id != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (_data2_->app);
	_data2_->app = _tmp0_;
	self = (IconButton*) g_object_new (object_type, "abomination", ab, "app-system", appsys, "desktop-helper", helper, "popover-manager", manager, NULL);
	_data2_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (c_settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	self->pinned = FALSE;
	self->priv->originally_pinned = FALSE;
	_tmp2_ = self->priv->_abomination;
	_tmp3_ = budgie_abomination_running_app_get_window (_data2_->app);
	_tmp4_ = _tmp3_;
	_tmp5_ = budgie_abomination_abomination_get_app_from_window_id (_tmp2_, wnck_window_get_xid (_tmp4_));
	_g_object_unref0 (self->first_app);
	self->first_app = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp6_ = g_strdup (button_id);
	_g_free0 (self->button_id);
	self->button_id = _tmp6_;
	_tmp8_ = self->first_app;
	if (_tmp8_ != NULL) {
		BudgieAbominationRunningApp* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		GDesktopAppInfo* _tmp11_;
		_tmp9_ = self->first_app;
		_tmp10_ = budgie_abomination_running_app_get_app_info (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		BudgieAbominationRunningApp* _tmp12_;
		GDesktopAppInfo* _tmp13_;
		GDesktopAppInfo* _tmp14_;
		GDesktopAppInfo* _tmp15_;
		_tmp12_ = self->first_app;
		_tmp13_ = budgie_abomination_running_app_get_app_info (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (self->priv->app_info);
		self->priv->app_info = _tmp15_;
	}
	icon_button_gobject_constructors_suck (self);
	icon_button_update_icon (self);
	icon_button_create_popover (self);
	if (icon_button_has_valid_windows (self, NULL)) {
		GtkStyleContext* _tmp16_;
		_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp16_, "running");
	}
	_tmp17_ = budgie_abomination_running_app_get_window (_data2_->app);
	_tmp18_ = _tmp17_;
	g_signal_connect_data (_tmp18_, "state-changed", (GCallback) ___lambda35__wnck_window_state_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, G_CONNECT_AFTER);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = budgie_abomination_running_app_get_window (_data2_->app);
	_tmp20_ = _tmp19_;
	icon_button_set_wnck_window (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

IconButton*
icon_button_new_from_app (BudgieAbominationAbomination* ab,
                          BudgieAppSystem* appsys,
                          GSettings* c_settings,
                          DesktopHelper* helper,
                          BudgiePopoverManager* manager,
                          BudgieAbominationRunningApp* app,
                          const gchar* button_id)
{
	return icon_button_construct_from_app (TYPE_ICON_BUTTON, ab, appsys, c_settings, helper, manager, app, button_id);
}

/**
 * Bootstrap our button to be ready to work with grouping ENABLED.
 */
IconButton*
icon_button_construct_from_group (GType object_type,
                                  BudgieAbominationAbomination* ab,
                                  BudgieAppSystem* appsys,
                                  GSettings* c_settings,
                                  DesktopHelper* helper,
                                  BudgiePopoverManager* manager,
                                  BudgieAbominationAppGroup* group,
                                  const gchar* button_id)
{
	IconButton * self = NULL;
	GSettings* _tmp0_;
	BudgieAbominationAbomination* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BudgieAbominationRunningApp* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	BudgieAbominationRunningApp* _tmp7_;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (button_id != NULL, NULL);
	self = (IconButton*) g_object_new (object_type, "abomination", ab, "app-system", appsys, "desktop-helper", helper, "popover-manager", manager, NULL);
	_tmp0_ = _g_object_ref0 (c_settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	self->pinned = FALSE;
	self->priv->originally_pinned = FALSE;
	_tmp1_ = self->priv->_abomination;
	_tmp2_ = budgie_abomination_app_group_get_name (group);
	_tmp3_ = _tmp2_;
	_tmp4_ = budgie_abomination_abomination_get_first_app_of_group (_tmp1_, _tmp3_);
	_g_object_unref0 (self->first_app);
	self->first_app = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = g_strdup (button_id);
	_g_free0 (self->button_id);
	self->button_id = _tmp5_;
	_tmp7_ = self->first_app;
	if (_tmp7_ != NULL) {
		BudgieAbominationRunningApp* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		_tmp8_ = self->first_app;
		_tmp9_ = budgie_abomination_running_app_get_app_info (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		BudgieAbominationRunningApp* _tmp11_;
		GDesktopAppInfo* _tmp12_;
		GDesktopAppInfo* _tmp13_;
		GDesktopAppInfo* _tmp14_;
		_tmp11_ = self->first_app;
		_tmp12_ = budgie_abomination_running_app_get_app_info (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (self->priv->app_info);
		self->priv->app_info = _tmp14_;
	}
	icon_button_gobject_constructors_suck (self);
	icon_button_update_icon (self);
	icon_button_create_popover (self);
	if (icon_button_has_valid_windows (self, NULL)) {
		GtkStyleContext* _tmp15_;
		_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp15_, "running");
	}
	return self;
}

IconButton*
icon_button_new_from_group (BudgieAbominationAbomination* ab,
                            BudgieAppSystem* appsys,
                            GSettings* c_settings,
                            DesktopHelper* helper,
                            BudgiePopoverManager* manager,
                            BudgieAbominationAppGroup* group,
                            const gchar* button_id)
{
	return icon_button_construct_from_group (TYPE_ICON_BUTTON, ab, appsys, c_settings, helper, manager, group, button_id);
}

/**
 * We have race conditions in glib between the desired properties..
 */
static gboolean
__lambda19_ (IconButton* self)
{
	gboolean result;
	icon_button_set_tooltip (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda19__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda19_ ((IconButton*) self);
	return result;
}

static gboolean
__lambda20_ (IconButton* self)
{
	gboolean result;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, "");
	gtk_widget_set_has_tooltip ((GtkWidget*) self, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda20__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda20_ ((IconButton*) self);
	return result;
}

static void
__lambda21_ (IconButton* self,
             GdkDragContext* context)
{
	Icon* _tmp0_;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->icon;
	switch (gtk_image_get_storage_type ((GtkImage*) _tmp0_)) {
		case GTK_IMAGE_PIXBUF:
		{
			Icon* _tmp1_;
			GdkPixbuf* _tmp2_;
			Icon* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			Icon* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp1_ = self->icon;
			_tmp2_ = gtk_image_get_pixbuf ((GtkImage*) _tmp1_);
			_tmp3_ = self->icon;
			_tmp4_ = gtk_image_get_pixel_size ((GtkImage*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->icon;
			_tmp7_ = gtk_image_get_pixel_size ((GtkImage*) _tmp6_);
			_tmp8_ = _tmp7_;
			gtk_drag_set_icon_pixbuf (context, _tmp2_, _tmp5_ / 2, _tmp8_ / 2);
			break;
		}
		case GTK_IMAGE_ICON_NAME:
		{
			const gchar* icon_name = NULL;
			Icon* _tmp9_;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
			Icon* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			Icon* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			icon_name = NULL;
			_tmp9_ = self->icon;
			gtk_image_get_icon_name ((GtkImage*) _tmp9_, &_tmp10_, (GtkIconSize*) NULL);
			icon_name = _tmp10_;
			_tmp11_ = icon_name;
			_tmp12_ = self->icon;
			_tmp13_ = gtk_image_get_pixel_size ((GtkImage*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->icon;
			_tmp16_ = gtk_image_get_pixel_size ((GtkImage*) _tmp15_);
			_tmp17_ = _tmp16_;
			gtk_drag_set_icon_name (context, _tmp11_, _tmp14_ / 2, _tmp17_ / 2);
			break;
		}
		case GTK_IMAGE_GICON:
		{
			GIcon* gicon = NULL;
			Icon* _tmp18_;
			GIcon* _tmp19_ = NULL;
			GIcon* _tmp20_;
			Icon* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			Icon* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gicon = NULL;
			_tmp18_ = self->icon;
			gtk_image_get_gicon ((GtkImage*) _tmp18_, &_tmp19_, (GtkIconSize*) NULL);
			gicon = _tmp19_;
			_tmp20_ = gicon;
			_tmp21_ = self->icon;
			_tmp22_ = gtk_image_get_pixel_size ((GtkImage*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->icon;
			_tmp25_ = gtk_image_get_pixel_size ((GtkImage*) _tmp24_);
			_tmp26_ = _tmp25_;
			gtk_drag_set_icon_gicon (context, _tmp20_, _tmp23_ / 2, _tmp26_ / 2);
			break;
		}
		default:
		{
			gtk_drag_set_icon_default (context);
			break;
		}
	}
}

static void
___lambda21__gtk_widget_drag_begin (GtkWidget* _sender,
                                    GdkDragContext* context,
                                    gpointer self)
{
	__lambda21_ ((IconButton*) self, context);
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
__lambda22_ (IconButton* self,
             GtkWidget* widget,
             GdkDragContext* context,
             GtkSelectionData* selection_data,
             guint info,
             guint time)
{
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_;
	guchar* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = self->button_id;
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
	_tmp3_ = (guchar*) _tmp2_;
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guchar);
	gtk_selection_data_set (selection_data, gtk_selection_data_get_target (selection_data), 8, _tmp3_, (gint) ((_tmp1_ * sizeof (gchar)) / sizeof (guchar)));
	_tmp3_ = (g_free (_tmp3_), NULL);
}

static void
___lambda22__gtk_widget_drag_data_get (GtkWidget* _sender,
                                       GdkDragContext* context,
                                       GtkSelectionData* selection_data,
                                       guint info,
                                       guint time_,
                                       gpointer self)
{
	__lambda22_ ((IconButton*) self, _sender, context, selection_data, info, time_);
}

static void
_icon_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                        GtkAllocation* allocation,
                                                        gpointer self)
{
	icon_button_on_size_allocate ((IconButton*) self, allocation);
}

static void
_icon_button_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender,
                                                        GAppInfo* info,
                                                        GVariant* platform_data,
                                                        gpointer self)
{
	icon_button_on_launched ((IconButton*) self, info, platform_data);
}

static void
_icon_button_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                                  const gchar* startup_notify_id,
                                                                  gpointer self)
{
	icon_button_on_launch_failed ((IconButton*) self, startup_notify_id);
}

static void
___lambda23_ (IconButton* self)
{
	icon_button_set_tooltip (self);
}

static void
____lambda23__budgie_abomination_running_app_renamed_app (BudgieAbominationRunningApp* _sender,
                                                          const gchar* old_name,
                                                          const gchar* new_name,
                                                          gpointer self)
{
	___lambda23_ ((IconButton*) self);
}

static void
___lambda24_ (IconButton* self,
              GDesktopAppInfo* app_info)
{
	GDesktopAppInfo* _tmp0_;
	_tmp0_ = _g_object_ref0 (app_info);
	_g_object_unref0 (self->priv->app_info);
	self->priv->app_info = _tmp0_;
}

static void
____lambda24__budgie_abomination_running_app_app_info_changed (BudgieAbominationRunningApp* _sender,
                                                               GDesktopAppInfo* app_info,
                                                               gpointer self)
{
	___lambda24_ ((IconButton*) self, app_info);
}

static void
___lambda25_ (IconButton* self)
{
	icon_button_update_icon (self);
}

static void
____lambda25__budgie_abomination_running_app_icon_changed (BudgieAbominationRunningApp* _sender,
                                                           const gchar* icon_name,
                                                           gpointer self)
{
	___lambda25_ ((IconButton*) self);
}

static void
icon_button_gobject_constructors_suck (IconButton* self)
{
	Icon* _tmp0_;
	Icon* _tmp1_;
	GtkStyleContext* _tmp2_;
	Icon* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkAppLaunchContext* _tmp5_;
	DesktopHelper* _tmp6_;
	GtkStyleContext* st = NULL;
	GtkStyleContext* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkStyleContext* _tmp11_;
	GdkAppLaunchContext* _tmp12_;
	GdkAppLaunchContext* _tmp13_;
	BudgieAbominationRunningApp* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = icon_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->icon);
	self->icon = _tmp0_;
	_tmp1_ = self->icon;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "icon");
	_tmp3_ = self->icon;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda19__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) ___lambda20__gtk_widget_leave_notify_event, self, 0);
	self->priv->definite_allocation.width = 0;
	self->priv->definite_allocation.height = 0;
	_tmp4_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp5_ = gdk_display_get_app_launch_context (_tmp4_);
	_g_object_unref0 (self->priv->launch_context);
	self->priv->launch_context = _tmp5_;
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	_tmp6_ = self->priv->_desktop_helper;
	icon_button_set_draggable (self, !_tmp6_->lock_icons);
	g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) ___lambda21__gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) ___lambda22__gtk_widget_drag_data_get, self, 0);
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	st = _tmp8_;
	_tmp9_ = st;
	gtk_style_context_remove_class (_tmp9_, GTK_STYLE_CLASS_BUTTON);
	_tmp10_ = st;
	gtk_style_context_remove_class (_tmp10_, "toggle");
	_tmp11_ = st;
	gtk_style_context_add_class (_tmp11_, "launcher");
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _icon_button_on_size_allocate_gtk_widget_size_allocate, self, 0);
	_tmp12_ = self->priv->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp12_, "launched", (GCallback) _icon_button_on_launched_g_app_launch_context_launched, self, 0);
	_tmp13_ = self->priv->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp13_, "launch-failed", (GCallback) _icon_button_on_launch_failed_g_app_launch_context_launch_failed, self, 0);
	_tmp14_ = self->first_app;
	if (_tmp14_ != NULL) {
		BudgieAbominationRunningApp* _tmp15_;
		BudgieAbominationRunningApp* _tmp16_;
		BudgieAbominationRunningApp* _tmp17_;
		_tmp15_ = self->first_app;
		g_signal_connect_object (_tmp15_, "renamed-app", (GCallback) ____lambda23__budgie_abomination_running_app_renamed_app, self, 0);
		_tmp16_ = self->first_app;
		g_signal_connect_object (_tmp16_, "app-info-changed", (GCallback) ____lambda24__budgie_abomination_running_app_app_info_changed, self, 0);
		_tmp17_ = self->first_app;
		g_signal_connect_object (_tmp17_, "icon-changed", (GCallback) ____lambda25__budgie_abomination_running_app_icon_changed, self, 0);
	}
	_g_object_unref0 (st);
}

/**
 * create_popover will create our popover
 */
static void
__lambda26_ (IconButton* self)
{
	icon_button_launch_app (self, gtk_get_current_event_time ());
}

static void
___lambda26__budgie_icon_popover_launch_new_instance (BudgieIconPopover* _sender,
                                                      gpointer self)
{
	__lambda26_ ((IconButton*) self);
}

static void
__lambda27_ (IconButton* self)
{
	gint _tmp0_;
	_tmp0_ = self->priv->window_count;
	self->priv->window_count = _tmp0_ + 1;
}

static void
___lambda27__budgie_icon_popover_added_window (BudgieIconPopover* _sender,
                                               gpointer self)
{
	__lambda27_ ((IconButton*) self);
}

static void
__lambda28_ (IconButton* self)
{
	BudgieIconPopover* _tmp0_;
	self->priv->window_count = 0;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	g_signal_emit (self, icon_button_signals[ICON_BUTTON_BECAME_EMPTY_SIGNAL], 0);
}

static void
___lambda28__budgie_icon_popover_closed_all (BudgieIconPopover* _sender,
                                             gpointer self)
{
	__lambda28_ ((IconButton*) self);
}

static void
__lambda29_ (IconButton* self)
{
	gint _tmp0_;
	_tmp0_ = self->priv->window_count;
	self->priv->window_count = _tmp0_ - 1;
}

static void
___lambda29__budgie_icon_popover_closed_window (BudgieIconPopover* _sender,
                                                gpointer self)
{
	__lambda29_ ((IconButton*) self);
}

static void
__lambda30_ (IconButton* self,
             gboolean new_pinned_state)
{
	DesktopHelper* _tmp0_;
	self->pinned = new_pinned_state;
	_tmp0_ = self->priv->_desktop_helper;
	desktop_helper_update_pinned (_tmp0_);
	g_signal_emit (self, icon_button_signals[ICON_BUTTON_PINNED_CHANGED_SIGNAL], 0);
	if (!icon_button_has_valid_windows (self, NULL)) {
		g_signal_emit (self, icon_button_signals[ICON_BUTTON_BECAME_EMPTY_SIGNAL], 0);
	}
}

static void
___lambda30__budgie_icon_popover_changed_pin_state (BudgieIconPopover* _sender,
                                                    gboolean new_state,
                                                    gpointer self)
{
	__lambda30_ ((IconButton*) self, new_state);
}

static void
__lambda31_ (IconButton* self,
             gulong xid,
             gint wid)
{
	WnckWindow* requested_window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWorkspace* workspace = NULL;
	WnckScreen* _tmp2_;
	WnckWorkspace* _tmp3_;
	WnckWorkspace* _tmp4_;
	gboolean _tmp5_ = FALSE;
	WnckWindow* _tmp6_;
	_tmp0_ = wnck_window_get (xid);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	requested_window = _tmp1_;
	_tmp2_ = self->priv->screen;
	_tmp3_ = wnck_screen_get_workspace (_tmp2_, wid - 1);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	workspace = _tmp4_;
	_tmp6_ = requested_window;
	if (_tmp6_ != NULL) {
		WnckWorkspace* _tmp7_;
		_tmp7_ = workspace;
		_tmp5_ = _tmp7_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		WnckWindow* _tmp8_;
		WnckWorkspace* _tmp9_;
		_tmp8_ = requested_window;
		_tmp9_ = workspace;
		wnck_window_move_to_workspace (_tmp8_, _tmp9_);
	}
	_g_object_unref0 (workspace);
	_g_object_unref0 (requested_window);
}

static void
___lambda31__budgie_icon_popover_move_window_to_workspace (BudgieIconPopover* _sender,
                                                           gulong xid,
                                                           gint workspace_num,
                                                           gpointer self)
{
	__lambda31_ ((IconButton*) self, xid, workspace_num);
}

static void
__lambda32_ (IconButton* self,
             const gchar* action)
{
	GDesktopAppInfo* _tmp0_;
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->app_info;
	if (_tmp0_ != NULL) {
		GdkAppLaunchContext* _tmp1_;
		GdkScreen* _tmp2_;
		GdkAppLaunchContext* _tmp3_;
		GDesktopAppInfo* _tmp4_;
		GdkAppLaunchContext* _tmp5_;
		BudgieIconPopover* _tmp6_;
		_tmp1_ = self->priv->launch_context;
		_tmp2_ = gtk_widget_get_screen ((GtkWidget*) self);
		gdk_app_launch_context_set_screen (_tmp1_, _tmp2_);
		_tmp3_ = self->priv->launch_context;
		gdk_app_launch_context_set_timestamp (_tmp3_, (guint32) GDK_CURRENT_TIME);
		_tmp4_ = self->priv->app_info;
		_tmp5_ = self->priv->launch_context;
		g_desktop_app_info_launch_action (_tmp4_, action, (GAppLaunchContext*) _tmp5_);
		_tmp6_ = self->priv->popover;
		budgie_icon_popover_render (_tmp6_);
	}
}

static void
___lambda32__budgie_icon_popover_perform_action (BudgieIconPopover* _sender,
                                                 const gchar* action,
                                                 gpointer self)
{
	__lambda32_ ((IconButton*) self, action);
}

static void
__lambda33_ (IconButton* self,
             WnckWorkspace* workspace)
{
	BudgieIconPopover* _tmp0_;
	WnckScreen* _tmp1_;
	g_return_if_fail (workspace != NULL);
	_tmp0_ = self->priv->popover;
	_tmp1_ = self->priv->screen;
	budgie_icon_popover_set_workspace_count (_tmp0_, wnck_screen_get_workspace_count (_tmp1_));
}

static void
___lambda33__wnck_screen_workspace_created (WnckScreen* _sender,
                                            WnckWorkspace* space,
                                            gpointer self)
{
	__lambda33_ ((IconButton*) self, space);
}

static void
__lambda34_ (IconButton* self,
             WnckWorkspace* workspace)
{
	BudgieIconPopover* _tmp0_;
	WnckScreen* _tmp1_;
	g_return_if_fail (workspace != NULL);
	_tmp0_ = self->priv->popover;
	_tmp1_ = self->priv->screen;
	budgie_icon_popover_set_workspace_count (_tmp0_, wnck_screen_get_workspace_count (_tmp1_));
}

static void
___lambda34__wnck_screen_workspace_destroyed (WnckScreen* _sender,
                                              WnckWorkspace* space,
                                              gpointer self)
{
	__lambda34_ ((IconButton*) self, space);
}

void
icon_button_create_popover (IconButton* self)
{
	WnckScreen* _tmp0_;
	WnckScreen* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	WnckScreen* _tmp3_;
	BudgieIconPopover* _tmp4_;
	BudgieIconPopover* _tmp5_;
	BudgieIconPopover* _tmp6_;
	BudgieIconPopover* _tmp7_;
	BudgieIconPopover* _tmp8_;
	BudgieIconPopover* _tmp9_;
	BudgieIconPopover* _tmp10_;
	BudgieIconPopover* _tmp11_;
	BudgieIconPopover* _tmp12_;
	WnckScreen* _tmp13_;
	WnckScreen* _tmp14_;
	BudgiePopoverManager* _tmp15_;
	BudgieIconPopover* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wnck_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp1_;
	_tmp2_ = self->priv->app_info;
	_tmp3_ = self->priv->screen;
	_tmp4_ = budgie_icon_popover_new ((GtkWidget*) self, _tmp2_, wnck_screen_get_workspace_count (_tmp3_));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp4_;
	_tmp5_ = self->priv->popover;
	budgie_icon_popover_set_pinned_state (_tmp5_, self->pinned);
	_tmp6_ = self->priv->popover;
	g_signal_connect_object (_tmp6_, "launch-new-instance", (GCallback) ___lambda26__budgie_icon_popover_launch_new_instance, self, 0);
	_tmp7_ = self->priv->popover;
	g_signal_connect_object (_tmp7_, "added-window", (GCallback) ___lambda27__budgie_icon_popover_added_window, self, 0);
	_tmp8_ = self->priv->popover;
	g_signal_connect_object (_tmp8_, "closed-all", (GCallback) ___lambda28__budgie_icon_popover_closed_all, self, 0);
	_tmp9_ = self->priv->popover;
	g_signal_connect_object (_tmp9_, "closed-window", (GCallback) ___lambda29__budgie_icon_popover_closed_window, self, 0);
	_tmp10_ = self->priv->popover;
	g_signal_connect_object (_tmp10_, "changed-pin-state", (GCallback) ___lambda30__budgie_icon_popover_changed_pin_state, self, 0);
	_tmp11_ = self->priv->popover;
	g_signal_connect_object (_tmp11_, "move-window-to-workspace", (GCallback) ___lambda31__budgie_icon_popover_move_window_to_workspace, self, 0);
	_tmp12_ = self->priv->popover;
	g_signal_connect_object (_tmp12_, "perform-action", (GCallback) ___lambda32__budgie_icon_popover_perform_action, self, 0);
	_tmp13_ = self->priv->screen;
	g_signal_connect_object (_tmp13_, "workspace-created", (GCallback) ___lambda33__wnck_screen_workspace_created, self, 0);
	_tmp14_ = self->priv->screen;
	g_signal_connect_object (_tmp14_, "workspace-destroyed", (GCallback) ___lambda34__wnck_screen_workspace_destroyed, self, 0);
	_tmp15_ = self->priv->_popover_manager;
	_tmp16_ = self->priv->popover;
	budgie_popover_manager_register_popover (_tmp15_, (GtkWidget*) self, (BudgiePopover*) _tmp16_);
}

static void
__lambda38_ (IconButton* self)
{
	icon_button_update_icon (self);
}

static void
___lambda38__budgie_abomination_app_group_icon_changed (BudgieAbominationAppGroup* _sender,
                                                        gpointer self)
{
	__lambda38_ ((IconButton*) self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		IconButton* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda40_ (Block3Data* _data3_)
{
	IconButton* self;
	BudgieIconPopover* _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->popover;
	budgie_icon_popover_rename_window (_tmp0_, _data3_->xid);
}

static void
___lambda40__wnck_window_name_changed (WnckWindow* _sender,
                                       gpointer self)
{
	__lambda40_ (self);
}

static void
__lambda39_ (IconButton* self,
             WnckWindow* new_window)
{
	Block3Data* _data3_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	BudgieIconPopover* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (new_window != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	if (!icon_button_should_add_window (self, new_window)) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_data3_->xid = wnck_window_get_xid (new_window);
	_tmp1_ = wnck_window_get_name (new_window);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "Loading...";
	}
	_tmp2_ = g_strdup (_tmp0_);
	name = _tmp2_;
	_tmp3_ = self->priv->popover;
	_tmp4_ = name;
	budgie_icon_popover_add_window (_tmp3_, _data3_->xid, _tmp4_);
	g_signal_connect_data (new_window, "name-changed", (GCallback) ___lambda40__wnck_window_name_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	icon_button_update (self);
	_g_free0 (name);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
___lambda39__budgie_abomination_app_group_added_window (BudgieAbominationAppGroup* _sender,
                                                        WnckWindow* window,
                                                        gpointer self)
{
	__lambda39_ ((IconButton*) self, window);
}

static void
__lambda41_ (IconButton* self,
             WnckWindow* old_window)
{
	BudgieIconPopover* _tmp0_;
	g_return_if_fail (old_window != NULL);
	_tmp0_ = self->priv->popover;
	budgie_icon_popover_remove_window (_tmp0_, wnck_window_get_xid (old_window));
	icon_button_update (self);
}

static void
___lambda41__budgie_abomination_app_group_removed_window (BudgieAbominationAppGroup* _sender,
                                                          WnckWindow* window,
                                                          gpointer self)
{
	__lambda41_ ((IconButton*) self, window);
}

void
icon_button_set_class_group (IconButton* self,
                             BudgieAbominationAppGroup* class_group)
{
	BudgieAbominationAppGroup* _tmp0_;
	BudgieAbominationAppGroup* _tmp1_;
	WnckWindow* _tmp2_;
	BudgieAbominationAppGroup* _tmp3_;
	BudgieAbominationAppGroup* _tmp4_;
	BudgieAbominationAppGroup* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (class_group);
	_g_object_unref0 (self->priv->class_group);
	self->priv->class_group = _tmp0_;
	_tmp1_ = self->priv->class_group;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->window;
	if (_tmp2_ != NULL) {
		g_warning ("IconButton.vala:285: Button have both a group and a window defined");
	}
	_tmp3_ = self->priv->class_group;
	g_signal_connect_object (_tmp3_, "icon-changed", (GCallback) ___lambda38__budgie_abomination_app_group_icon_changed, self, G_CONNECT_AFTER);
	_tmp4_ = self->priv->class_group;
	g_signal_connect_object (_tmp4_, "added-window", (GCallback) ___lambda39__budgie_abomination_app_group_added_window, self, 0);
	_tmp5_ = self->priv->class_group;
	g_signal_connect_object (_tmp5_, "removed-window", (GCallback) ___lambda41__budgie_abomination_app_group_removed_window, self, 0);
	icon_button_set_app_for_class_group (self);
	icon_button_setup_popover_with_class (self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		IconButton* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->window);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda36_ (Block4Data* _data4_)
{
	IconButton* self;
	BudgieIconPopover* _tmp0_;
	self = _data4_->self;
	_tmp0_ = self->priv->popover;
	budgie_icon_popover_rename_window (_tmp0_, wnck_window_get_xid (_data4_->window));
}

static void
___lambda36__wnck_window_name_changed (WnckWindow* _sender,
                                       gpointer self)
{
	__lambda36_ (self);
}

static void
__lambda37_ (Block4Data* _data4_)
{
	IconButton* self;
	self = _data4_->self;
	if (wnck_window_needs_attention (_data4_->window)) {
		icon_button_attention (self, TRUE);
	}
}

static void
___lambda37__wnck_window_state_changed (WnckWindow* _sender,
                                        WnckWindowState changed_mask,
                                        WnckWindowState new_state,
                                        gpointer self)
{
	__lambda37_ (self);
}

void
icon_button_set_wnck_window (IconButton* self,
                             WnckWindow* window)
{
	Block4Data* _data4_;
	WnckWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	WnckWindow* _tmp5_;
	BudgieAbominationAbomination* _tmp6_;
	BudgieIconPopover* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data4_->window);
	_data4_->window = _tmp0_;
	if (_data4_->window == NULL) {
		WnckWindow* _tmp2_;
		_tmp2_ = self->priv->window;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BudgieIconPopover* _tmp3_;
		WnckWindow* _tmp4_;
		_tmp3_ = self->priv->popover;
		_tmp4_ = self->priv->window;
		budgie_icon_popover_remove_window (_tmp3_, wnck_window_get_xid (_tmp4_));
	}
	_tmp5_ = _g_object_ref0 (_data4_->window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp5_;
	if (_data4_->window == NULL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp6_ = self->priv->_abomination;
	if (budgie_abomination_abomination_is_disallowed_window_type (_tmp6_, _data4_->window)) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	g_signal_connect_data (_data4_->window, "name-changed", (GCallback) ___lambda36__wnck_window_name_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, G_CONNECT_AFTER);
	g_signal_connect_data (_data4_->window, "state-changed", (GCallback) ___lambda37__wnck_window_state_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, G_CONNECT_AFTER);
	_tmp7_ = self->priv->popover;
	_tmp8_ = wnck_window_get_name (_data4_->window);
	budgie_icon_popover_add_window (_tmp7_, wnck_window_get_xid (_data4_->window), _tmp8_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

void
icon_button_set_draggable (IconButton* self,
                           gboolean draggable)
{
	g_return_if_fail (self != NULL);
	if (draggable) {
		gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, DESKTOP_HELPER_targets, (gint) G_N_ELEMENTS (DESKTOP_HELPER_targets), GDK_ACTION_COPY);
	} else {
		gtk_drag_source_unset ((GtkWidget*) self);
	}
}

/**
 * should_add_window will return whether or not we should add this window to our popover
 */
static gboolean
icon_button_should_add_window (IconButton* self,
                               WnckWindow* new_window)
{
	gboolean add = FALSE;
	gboolean should_try_name_match = FALSE;
	gboolean is_matching_class_name = FALSE;
	BudgieAbominationRunningApp* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_window != NULL, FALSE);
	add = FALSE;
	should_try_name_match = FALSE;
	is_matching_class_name = FALSE;
	_tmp0_ = self->first_app;
	if (_tmp0_ != NULL) {
		BudgieAbominationRunningApp* app = NULL;
		BudgieAbominationAbomination* _tmp1_;
		BudgieAbominationRunningApp* _tmp2_;
		gboolean _tmp3_ = FALSE;
		BudgieAbominationRunningApp* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = self->priv->_abomination;
		_tmp2_ = budgie_abomination_abomination_get_app_from_window_id (_tmp1_, wnck_window_get_xid (new_window));
		app = _tmp2_;
		_tmp4_ = self->first_app;
		_tmp5_ = budgie_abomination_running_app_get_group_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_str_has_prefix (_tmp6_, "chrome-");
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			BudgieAbominationRunningApp* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->first_app;
			_tmp9_ = budgie_abomination_running_app_get_group_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp3_ = g_str_has_prefix (_tmp10_, "google-chrome");
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			BudgieAbominationRunningApp* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			BudgieAbominationRunningApp* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			should_try_name_match = TRUE;
			_tmp11_ = self->first_app;
			_tmp12_ = budgie_abomination_running_app_get_group_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = app;
			_tmp15_ = budgie_abomination_running_app_get_group_name (_tmp14_);
			_tmp16_ = _tmp15_;
			is_matching_class_name = g_strcmp0 (_tmp13_, _tmp16_) == 0;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp13_);
		} else {
			BudgieAbominationRunningApp* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp17_ = self->first_app;
			_tmp18_ = budgie_abomination_running_app_get_group_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_str_has_prefix (_tmp19_, "libreoffice");
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				BudgieAbominationRunningApp* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				BudgieAbominationRunningApp* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				should_try_name_match = TRUE;
				_tmp21_ = self->first_app;
				_tmp22_ = budgie_abomination_running_app_get_group_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = app;
				_tmp25_ = budgie_abomination_running_app_get_group_name (_tmp24_);
				_tmp26_ = _tmp25_;
				is_matching_class_name = g_strcmp0 (_tmp23_, _tmp26_) == 0;
				_g_free0 (_tmp26_);
				_g_free0 (_tmp23_);
			}
		}
		_g_object_unref0 (app);
	}
	if (should_try_name_match) {
		add = is_matching_class_name;
	} else {
		WnckWindow* old_window = NULL;
		BudgieAbominationAppGroup* _tmp27_;
		GList* _tmp28_;
		GList* _tmp29_;
		gconstpointer _tmp30_;
		WnckWindow* _tmp31_;
		WnckWindow* _tmp32_;
		const gchar* _tmp33_;
		WnckWindow* _tmp34_;
		const gchar* _tmp35_;
		_tmp27_ = self->priv->class_group;
		_tmp28_ = budgie_abomination_app_group_get_windows (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_list_nth_data (_tmp29_, (guint) 0);
		_tmp31_ = _g_object_ref0 ((WnckWindow*) _tmp30_);
		_tmp32_ = _tmp31_;
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (g_list_free (_tmp29_), NULL));
		old_window = _tmp32_;
		_tmp33_ = wnck_window_get_class_instance_name (new_window);
		_tmp34_ = old_window;
		_tmp35_ = wnck_window_get_class_instance_name (_tmp34_);
		add = g_strcmp0 (_tmp33_, _tmp35_) == 0;
		_g_object_unref0 (old_window);
	}
	result = add;
	return result;
}

void
icon_button_update_icon (IconButton* self)
{
	GIcon* app_icon = NULL;
	GDesktopAppInfo* _tmp1_;
	GdkPixbuf* pixbuf_icon = NULL;
	WnckWindow* _tmp4_;
	BudgieAbominationAppGroup* _tmp8_;
	GIcon* _tmp11_;
	Icon* _tmp18_;
	DesktopHelper* _tmp19_;
	g_return_if_fail (self != NULL);
	if (icon_button_has_valid_windows (self, NULL)) {
		Icon* _tmp0_;
		_tmp0_ = self->icon;
		_tmp0_->waiting = FALSE;
	}
	app_icon = NULL;
	_tmp1_ = self->priv->app_info;
	if (_tmp1_ != NULL) {
		GDesktopAppInfo* _tmp2_;
		GIcon* _tmp3_;
		_tmp2_ = self->priv->app_info;
		_tmp3_ = g_app_info_get_icon ((GAppInfo*) _tmp2_);
		app_icon = _tmp3_;
	}
	pixbuf_icon = NULL;
	_tmp4_ = self->priv->window;
	if (_tmp4_ != NULL) {
		WnckWindow* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		_tmp5_ = self->priv->window;
		_tmp6_ = wnck_window_get_icon (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (pixbuf_icon);
		pixbuf_icon = _tmp7_;
	}
	_tmp8_ = self->priv->class_group;
	if (_tmp8_ != NULL) {
		BudgieAbominationAppGroup* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp9_ = self->priv->class_group;
		_tmp10_ = budgie_abomination_app_group_get_icon (_tmp9_);
		_g_object_unref0 (pixbuf_icon);
		pixbuf_icon = _tmp10_;
	}
	_tmp11_ = app_icon;
	if (_tmp11_ != NULL) {
		Icon* _tmp12_;
		GIcon* _tmp13_;
		_tmp12_ = self->icon;
		_tmp13_ = app_icon;
		gtk_image_set_from_gicon ((GtkImage*) _tmp12_, _tmp13_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
	} else {
		GdkPixbuf* _tmp14_;
		_tmp14_ = pixbuf_icon;
		if (_tmp14_ != NULL) {
			Icon* _tmp15_;
			GdkPixbuf* _tmp16_;
			_tmp15_ = self->icon;
			_tmp16_ = pixbuf_icon;
			gtk_image_set_from_pixbuf ((GtkImage*) _tmp15_, _tmp16_);
		} else {
			Icon* _tmp17_;
			_tmp17_ = self->icon;
			gtk_image_set_from_icon_name ((GtkImage*) _tmp17_, "image-missing", (GtkIconSize) GTK_ICON_SIZE_INVALID);
		}
	}
	_tmp18_ = self->icon;
	_tmp19_ = self->priv->_desktop_helper;
	gtk_image_set_pixel_size ((GtkImage*) _tmp18_, _tmp19_->icon_size);
	_g_object_unref0 (pixbuf_icon);
}

void
icon_button_update (IconButton* self)
{
	gboolean has_active = FALSE;
	BudgieAbominationAppGroup* _tmp2_;
	DesktopHelper* _tmp12_;
	g_return_if_fail (self != NULL);
	if (!icon_button_has_valid_windows (self, NULL)) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp0_, "running");
		if (!self->pinned) {
			return;
		} else {
			_g_object_unref0 (self->priv->class_group);
			self->priv->class_group = NULL;
		}
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp1_, "running");
	}
	has_active = FALSE;
	_tmp2_ = self->priv->class_group;
	if (_tmp2_ != NULL) {
		BudgieAbominationAppGroup* _tmp3_;
		GList* _tmp4_;
		GList* _tmp5_;
		DesktopHelper* _tmp6_;
		WnckWindow* _tmp7_;
		WnckWindow* _tmp8_;
		GList* _tmp9_;
		_tmp3_ = self->priv->class_group;
		_tmp4_ = budgie_abomination_app_group_get_windows (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->_desktop_helper;
		_tmp7_ = desktop_helper_get_active_window (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_list_find (_tmp5_, _tmp8_);
		has_active = _tmp9_ != NULL;
		_g_object_unref0 (_tmp8_);
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	} else {
		WnckWindow* _tmp10_;
		_tmp10_ = self->priv->window;
		if (_tmp10_ != NULL) {
			WnckWindow* _tmp11_;
			_tmp11_ = self->priv->window;
			has_active = wnck_window_is_active (_tmp11_);
		}
	}
	gtk_toggle_button_set_active ((GtkToggleButton*) self, has_active);
	icon_button_set_tooltip (self);
	_tmp12_ = self->priv->_desktop_helper;
	icon_button_set_draggable (self, !_tmp12_->lock_icons);
	icon_button_update_icon (self);
	gtk_widget_queue_resize ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
icon_button_has_valid_windows (IconButton* self,
                               gint* num_windows)
{
	gint _vala_num_windows = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_num_windows = self->priv->window_count;
	result = self->priv->window_count != 0;
	if (num_windows) {
		*num_windows = _vala_num_windows;
	}
	return result;
}

gboolean
icon_button_has_window (IconButton* self,
                        WnckWindow* window)
{
	WnckWindow* _tmp0_;
	BudgieAbominationAppGroup* _tmp2_;
	BudgieAbominationAppGroup* _tmp3_;
	GList* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (window == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		WnckWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		result = _tmp1_ == window;
		return result;
	}
	_tmp2_ = self->priv->class_group;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->class_group;
	_tmp4_ = budgie_abomination_app_group_get_windows (_tmp3_);
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp4_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			WnckWindow* _tmp5_;
			WnckWindow* win = NULL;
			_tmp5_ = _g_object_ref0 ((WnckWindow*) win_it->data);
			win = _tmp5_;
			{
				WnckWindow* _tmp6_;
				_tmp6_ = win;
				if (_tmp6_ == window) {
					result = TRUE;
					_g_object_unref0 (win);
					(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
					return result;
				}
				_g_object_unref0 (win);
			}
		}
		(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
	}
	result = FALSE;
	return result;
}

gboolean
icon_button_has_window_on_workspace (IconButton* self,
                                     WnckWorkspace* workspace)
{
	BudgieAbominationAppGroup* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (workspace != NULL, FALSE);
	if (workspace == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->class_group;
	if (_tmp0_ != NULL) {
		BudgieAbominationAppGroup* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = self->priv->class_group;
		_tmp2_ = budgie_abomination_app_group_get_windows (_tmp1_);
		{
			GList* win_collection = NULL;
			GList* win_it = NULL;
			win_collection = _tmp2_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				WnckWindow* _tmp3_;
				WnckWindow* win = NULL;
				_tmp3_ = _g_object_ref0 ((WnckWindow*) win_it->data);
				win = _tmp3_;
				{
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
					WnckWindow* _tmp6_;
					_tmp6_ = win;
					if (!wnck_window_is_skip_pager (_tmp6_)) {
						WnckWindow* _tmp7_;
						_tmp7_ = win;
						_tmp5_ = !wnck_window_is_skip_tasklist (_tmp7_);
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						WnckWindow* _tmp8_;
						_tmp8_ = win;
						_tmp4_ = wnck_window_is_on_workspace (_tmp8_, workspace);
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						result = TRUE;
						_g_object_unref0 (win);
						(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
						return result;
					}
					_g_object_unref0 (win);
				}
			}
			(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
		}
	} else {
		WnckWindow* _tmp9_;
		_tmp9_ = self->priv->window;
		if (_tmp9_ != NULL) {
			gboolean _tmp10_ = FALSE;
			WnckWindow* _tmp11_;
			_tmp11_ = self->priv->window;
			if (!wnck_window_is_skip_tasklist (_tmp11_)) {
				WnckWindow* _tmp12_;
				_tmp12_ = self->priv->window;
				_tmp10_ = wnck_window_is_on_workspace (_tmp12_, workspace);
			} else {
				_tmp10_ = FALSE;
			}
			result = _tmp10_;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static void
icon_button_launch_app (IconButton* self,
                        guint32 time)
{
	GDesktopAppInfo* _tmp0_;
	GdkAppLaunchContext* _tmp1_;
	GdkScreen* _tmp2_;
	GdkAppLaunchContext* _tmp3_;
	Icon* _tmp4_;
	DesktopHelper* _tmp5_;
	Icon* _tmp6_;
	Icon* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app_info;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->launch_context;
	_tmp2_ = gtk_widget_get_screen ((GtkWidget*) self);
	gdk_app_launch_context_set_screen (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->launch_context;
	gdk_app_launch_context_set_timestamp (_tmp3_, time);
	_tmp4_ = self->icon;
	_tmp5_ = self->priv->_desktop_helper;
	icon_animate_launch (_tmp4_, _tmp5_->panel_position);
	_tmp6_ = self->icon;
	_tmp6_->waiting = TRUE;
	_tmp7_ = self->icon;
	icon_animate_wait (_tmp7_);
	{
		GDesktopAppInfo* _tmp8_;
		GdkAppLaunchContext* _tmp9_;
		_tmp8_ = self->priv->app_info;
		_tmp9_ = self->priv->launch_context;
		g_app_info_launch ((GAppInfo*) _tmp8_, NULL, (GAppLaunchContext*) _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("IconButton.vala:499: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
icon_button_is_empty (IconButton* self)
{
	gboolean _tmp0_ = FALSE;
	WnckWindow* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->window;
	if (_tmp1_ == NULL) {
		BudgieAbominationAppGroup* _tmp2_;
		_tmp2_ = self->priv->class_group;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
icon_button_is_pinned (IconButton* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->pinned;
	return result;
}

void
icon_button_attention (IconButton* self,
                       gboolean needs_it)
{
	g_return_if_fail (self != NULL);
	self->priv->needs_attention = needs_it;
	gtk_widget_queue_draw ((GtkWidget*) self);
	if (needs_it) {
		Icon* _tmp0_;
		DesktopHelper* _tmp1_;
		_tmp0_ = self->icon;
		_tmp1_ = self->priv->_desktop_helper;
		icon_animate_attention (_tmp0_, &_tmp1_->panel_position);
	}
}

/**
 * set_tooltip will set the tooltip text for this IconButton
 */
void
icon_button_set_tooltip (IconButton* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->window_count != 0) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->window_count == 1) {
			BudgieAbominationRunningApp* _tmp1_;
			_tmp1_ = self->first_app;
			_tmp0_ = _tmp1_ != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			BudgieAbominationRunningApp* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->first_app;
			_tmp3_ = budgie_abomination_running_app_get_name (_tmp2_);
			_tmp4_ = _tmp3_;
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp4_);
		} else {
			GDesktopAppInfo* _tmp5_;
			_tmp5_ = self->priv->app_info;
			if (_tmp5_ != NULL) {
				GDesktopAppInfo* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->app_info;
				_tmp7_ = g_app_info_get_display_name ((GAppInfo*) _tmp6_);
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp7_);
			} else {
				WnckWindow* _tmp8_;
				_tmp8_ = self->priv->window;
				if (_tmp8_ != NULL) {
					WnckWindow* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = self->priv->window;
					_tmp10_ = wnck_window_get_name (_tmp9_);
					gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp10_);
				}
			}
		}
	} else {
		GDesktopAppInfo* _tmp11_;
		_tmp11_ = self->priv->app_info;
		if (_tmp11_ != NULL) {
			GDesktopAppInfo* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = self->priv->app_info;
			_tmp13_ = g_app_info_get_display_name ((GAppInfo*) _tmp12_);
			_tmp14_ = g_strdup_printf ("Launch %s", _tmp13_);
			_tmp15_ = _tmp14_;
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp15_);
			_g_free0 (_tmp15_);
		} else {
			BudgieAbominationAppGroup* _tmp16_;
			_tmp16_ = self->priv->class_group;
			if (_tmp16_ != NULL) {
				BudgieAbominationAppGroup* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = self->priv->class_group;
				_tmp18_ = budgie_abomination_app_group_get_name (_tmp17_);
				_tmp19_ = _tmp18_;
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp19_);
				_g_free0 (_tmp19_);
			}
		}
	}
}

/**
 * Handle startup notification, set our own ID to the ID selected
 */
static void
icon_button_on_launched (IconButton* self,
                         GAppInfo* info,
                         GVariant* v)
{
	GVariant* elem = NULL;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = g_variant_iter_new (v);
	iter = _tmp0_;
	while (TRUE) {
		GVariantIter* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		gchar* key = NULL;
		GVariant* val = NULL;
		GVariant* _tmp4_;
		gchar* _tmp5_ = NULL;
		GVariant* _tmp6_ = NULL;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		const GVariantType* _tmp9_;
		const gchar* _tmp10_;
		GdkDisplay* _tmp11_;
		GVariant* _tmp12_;
		const gchar* _tmp13_;
		_tmp1_ = iter;
		_tmp2_ = g_variant_iter_next_value (_tmp1_);
		_g_variant_unref0 (elem);
		elem = _tmp2_;
		_tmp3_ = elem;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		key = NULL;
		val = NULL;
		_tmp4_ = elem;
		g_variant_get (_tmp4_, "{sv}", &_tmp5_, &_tmp6_, NULL);
		_g_free0 (key);
		key = _tmp5_;
		_g_variant_unref0 (val);
		val = _tmp6_;
		_tmp7_ = key;
		if (_tmp7_ == NULL) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp8_ = val;
		_tmp9_ = G_VARIANT_TYPE_STRING;
		if (!g_variant_is_of_type (_tmp8_, _tmp9_)) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp10_ = key;
		if (g_strcmp0 (_tmp10_, "startup-notification-id") != 0) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp11_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp12_ = val;
		_tmp13_ = g_variant_get_string (_tmp12_, NULL);
		gdk_display_notify_startup_complete (_tmp11_, _tmp13_);
		_g_variant_unref0 (val);
		_g_free0 (key);
	}
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (elem);
}

static void
icon_button_on_launch_failed (IconButton* self,
                              const gchar* id)
{
	GdkDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_warning ("IconButton.vala:571: launch_failed");
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	gdk_display_notify_startup_complete (_tmp0_, id);
}

void
icon_button_draw_inactive (IconButton* self,
                           cairo_t* cr,
                           GdkRGBA* col)
{
	gint x = 0;
	GtkAllocation _tmp0_;
	gint y = 0;
	GtkAllocation _tmp1_;
	gint width = 0;
	GtkAllocation _tmp2_;
	gint height = 0;
	GtkAllocation _tmp3_;
	GList* windows = NULL;
	BudgieAbominationAppGroup* _tmp4_;
	gint count = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_;
	gint _tmp10_ = 0;
	gint counter = 0;
	GList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (col != NULL);
	_tmp0_ = self->priv->definite_allocation;
	x = _tmp0_.x;
	_tmp1_ = self->priv->definite_allocation;
	y = _tmp1_.y;
	_tmp2_ = self->priv->definite_allocation;
	width = _tmp2_.width;
	_tmp3_ = self->priv->definite_allocation;
	height = _tmp3_.height;
	_tmp4_ = self->priv->class_group;
	if (_tmp4_ != NULL) {
		BudgieAbominationAppGroup* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = self->priv->class_group;
		_tmp6_ = budgie_abomination_app_group_get_windows (_tmp5_);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = _tmp6_;
	} else {
		WnckWindow* _tmp7_;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = NULL;
		_tmp7_ = self->priv->window;
		windows = g_list_insert (windows, _tmp7_, 0);
	}
	_tmp9_ = icon_button_has_valid_windows (self, &_tmp8_);
	count = _tmp8_;
	if (!_tmp9_) {
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return;
	}
	if (count > 5) {
		_tmp10_ = 5;
	} else {
		_tmp10_ = count;
	}
	count = _tmp10_;
	counter = 0;
	_tmp11_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp11_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* _tmp12_;
			WnckWindow* window = NULL;
			_tmp12_ = _g_object_ref0 ((WnckWindow*) window_it->data);
			window = _tmp12_;
			{
				gboolean _tmp13_ = FALSE;
				WnckWindow* _tmp14_;
				if (counter == count) {
					_g_object_unref0 (window);
					break;
				}
				_tmp14_ = window;
				if (!wnck_window_is_skip_pager (_tmp14_)) {
					WnckWindow* _tmp15_;
					_tmp15_ = window;
					_tmp13_ = !wnck_window_is_skip_tasklist (_tmp15_);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gint indicator_x = 0;
					gint indicator_y = 0;
					DesktopHelper* _tmp16_;
					GdkRGBA _tmp17_;
					GdkRGBA _tmp18_;
					GdkRGBA _tmp19_;
					gint _tmp20_;
					indicator_x = 0;
					indicator_y = 0;
					_tmp16_ = self->priv->_desktop_helper;
					switch (_tmp16_->panel_position) {
						case BUDGIE_PANEL_POSITION_TOP:
						{
							indicator_x = x + (width / 2);
							indicator_x -= ((count * (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING)) / 2) - INACTIVE_INDICATOR_SPACING;
							indicator_x += (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING) * counter;
							indicator_y = y + (INDICATOR_SIZE / 2);
							break;
						}
						case BUDGIE_PANEL_POSITION_BOTTOM:
						{
							indicator_x = x + (width / 2);
							indicator_x -= ((count * (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING)) / 2) - INACTIVE_INDICATOR_SPACING;
							indicator_x += (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING) * counter;
							indicator_y = (y + height) - (INDICATOR_SIZE / 2);
							break;
						}
						case BUDGIE_PANEL_POSITION_LEFT:
						{
							indicator_y = x + (height / 2);
							indicator_y -= ((count * (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING)) / 2) - (INACTIVE_INDICATOR_SPACING * 2);
							indicator_y += (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING) * counter;
							indicator_x = y + (INDICATOR_SIZE / 2);
							break;
						}
						case BUDGIE_PANEL_POSITION_RIGHT:
						{
							indicator_y = x + (height / 2);
							indicator_y -= ((count * (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING)) / 2) - INACTIVE_INDICATOR_SPACING;
							indicator_y += (INDICATOR_SIZE + INACTIVE_INDICATOR_SPACING) * counter;
							indicator_x = (y + width) - (INDICATOR_SIZE / 2);
							break;
						}
						default:
						{
							break;
						}
					}
					_tmp17_ = *col;
					_tmp18_ = *col;
					_tmp19_ = *col;
					cairo_set_source_rgba (cr, _tmp17_.red, _tmp18_.green, _tmp19_.blue, (gdouble) 1);
					cairo_arc (cr, (gdouble) indicator_x, (gdouble) indicator_y, (gdouble) INDICATOR_SIZE, (gdouble) 0, G_PI * 2);
					cairo_fill (cr);
					_tmp20_ = counter;
					counter = _tmp20_ + 1;
				}
				_g_object_unref0 (window);
			}
		}
	}
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
}

static gboolean
icon_button_real_draw (GtkWidget* base,
                       cairo_t* cr)
{
	IconButton * self;
	gint x = 0;
	GtkAllocation _tmp0_;
	gint y = 0;
	GtkAllocation _tmp1_;
	gint width = 0;
	GtkAllocation _tmp2_;
	gint height = 0;
	GtkAllocation _tmp3_;
	GList* windows = NULL;
	BudgieAbominationAppGroup* _tmp4_;
	gint count = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_;
	gint _tmp10_ = 0;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp11_;
	GtkStyleContext* _tmp12_;
	GdkRGBA col = {0};
	GtkStyleContext* _tmp13_;
	GdkRGBA _tmp14_ = {0};
	gboolean _tmp15_;
	gint counter = 0;
	gint previous_x = 0;
	gint previous_y = 0;
	gint spacing = 0;
	gint _tmp23_ = 0;
	GList* _tmp24_;
	gboolean result;
	self = (IconButton*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->definite_allocation;
	x = _tmp0_.x;
	_tmp1_ = self->priv->definite_allocation;
	y = _tmp1_.y;
	_tmp2_ = self->priv->definite_allocation;
	width = _tmp2_.width;
	_tmp3_ = self->priv->definite_allocation;
	height = _tmp3_.height;
	_tmp4_ = self->priv->class_group;
	if (_tmp4_ != NULL) {
		BudgieAbominationAppGroup* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = self->priv->class_group;
		_tmp6_ = budgie_abomination_app_group_get_windows (_tmp5_);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = _tmp6_;
	} else {
		WnckWindow* _tmp7_;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = NULL;
		_tmp7_ = self->priv->window;
		windows = g_list_insert (windows, _tmp7_, 0);
	}
	_tmp9_ = icon_button_has_valid_windows (self, &_tmp8_);
	count = _tmp8_;
	if (!_tmp9_) {
		result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), cr);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	if (count > 5) {
		_tmp10_ = 5;
	} else {
		_tmp10_ = count;
	}
	count = _tmp10_;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	context = _tmp12_;
	_tmp13_ = context;
	_tmp15_ = gtk_style_context_lookup_color (_tmp13_, "budgie_tasklist_indicator_color", &_tmp14_);
	col = _tmp14_;
	if (!_tmp15_) {
		gdk_rgba_parse (&col, "#3C6DA6");
	}
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self)) {
		GtkStyleContext* _tmp16_;
		GdkRGBA _tmp17_ = {0};
		gboolean _tmp18_;
		_tmp16_ = context;
		_tmp18_ = gtk_style_context_lookup_color (_tmp16_, "budgie_tasklist_indicator_color_active", &_tmp17_);
		col = _tmp17_;
		if (!_tmp18_) {
			gdk_rgba_parse (&col, "#5294E2");
		}
	} else {
		GdkRGBA _tmp22_;
		if (self->priv->needs_attention) {
			GtkStyleContext* _tmp19_;
			GdkRGBA _tmp20_ = {0};
			gboolean _tmp21_;
			_tmp19_ = context;
			_tmp21_ = gtk_style_context_lookup_color (_tmp19_, "budgie_tasklist_indicator_color_attention", &_tmp20_);
			col = _tmp20_;
			if (!_tmp21_) {
				gdk_rgba_parse (&col, "#D84E4E");
			}
		}
		_tmp22_ = col;
		icon_button_draw_inactive (self, cr, &_tmp22_);
		result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), cr);
		_g_object_unref0 (context);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	counter = 0;
	previous_x = 0;
	previous_y = 0;
	spacing = width % count;
	if (spacing == 0) {
		_tmp23_ = 1;
	} else {
		_tmp23_ = spacing;
	}
	spacing = _tmp23_;
	_tmp24_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp24_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* _tmp25_;
			WnckWindow* window = NULL;
			_tmp25_ = _g_object_ref0 ((WnckWindow*) window_it->data);
			window = _tmp25_;
			{
				WnckWindow* _tmp26_;
				if (counter == count) {
					_g_object_unref0 (window);
					break;
				}
				_tmp26_ = window;
				if (!wnck_window_is_skip_tasklist (_tmp26_)) {
					gint indicator_x = 0;
					gint indicator_y = 0;
					DesktopHelper* _tmp27_;
					gboolean _tmp28_ = FALSE;
					DesktopHelper* _tmp29_;
					WnckWindow* _tmp30_;
					WnckWindow* _tmp31_;
					WnckWindow* _tmp32_;
					gboolean _tmp33_;
					DesktopHelper* _tmp44_;
					gint _tmp45_;
					indicator_x = 0;
					indicator_y = 0;
					_tmp27_ = self->priv->_desktop_helper;
					switch (_tmp27_->panel_position) {
						case BUDGIE_PANEL_POSITION_TOP:
						{
							if (counter == 0) {
								indicator_x = x;
							} else {
								indicator_x = previous_x + (width / count);
								previous_x = indicator_x;
								indicator_x += spacing;
							}
							indicator_y = y;
							break;
						}
						case BUDGIE_PANEL_POSITION_BOTTOM:
						{
							if (counter == 0) {
								indicator_x = x;
							} else {
								indicator_x = previous_x + (width / count);
								previous_x = indicator_x;
								indicator_x += spacing;
							}
							indicator_y = y + height;
							break;
						}
						case BUDGIE_PANEL_POSITION_LEFT:
						{
							if (counter == 0) {
								indicator_y = y;
							} else {
								indicator_y = previous_y + (height / count);
								previous_y = indicator_y;
								indicator_y += spacing;
							}
							indicator_x = x;
							break;
						}
						case BUDGIE_PANEL_POSITION_RIGHT:
						{
							if (counter == 0) {
								indicator_y = y;
							} else {
								indicator_y = previous_y + (height / count);
								previous_y = indicator_y;
								indicator_y += spacing;
							}
							indicator_x = x + width;
							break;
						}
						default:
						{
							break;
						}
					}
					cairo_set_line_width (cr, (gdouble) 6);
					_tmp29_ = self->priv->_desktop_helper;
					_tmp30_ = desktop_helper_get_active_window (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = window;
					_tmp33_ = _tmp31_ == _tmp32_;
					_g_object_unref0 (_tmp31_);
					if (_tmp33_) {
						_tmp28_ = count > 1;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						GdkRGBA col2 = {0};
						GdkRGBA _tmp34_;
						GtkStyleContext* _tmp35_;
						GdkRGBA _tmp36_ = {0};
						gboolean _tmp37_;
						GdkRGBA _tmp38_;
						GdkRGBA _tmp39_;
						GdkRGBA _tmp40_;
						_tmp34_ = col;
						col2 = _tmp34_;
						_tmp35_ = context;
						_tmp37_ = gtk_style_context_lookup_color (_tmp35_, "budgie_tasklist_indicator_color_active_window", &_tmp36_);
						col2 = _tmp36_;
						if (!_tmp37_) {
							gdk_rgba_parse (&col2, "#6BBFFF");
						}
						_tmp38_ = col2;
						_tmp39_ = col2;
						_tmp40_ = col2;
						cairo_set_source_rgba (cr, _tmp38_.red, _tmp39_.green, _tmp40_.blue, (gdouble) 1);
					} else {
						GdkRGBA _tmp41_;
						GdkRGBA _tmp42_;
						GdkRGBA _tmp43_;
						_tmp41_ = col;
						_tmp42_ = col;
						_tmp43_ = col;
						cairo_set_source_rgba (cr, _tmp41_.red, _tmp42_.green, _tmp43_.blue, (gdouble) 1);
					}
					cairo_move_to (cr, (gdouble) indicator_x, (gdouble) indicator_y);
					_tmp44_ = self->priv->_desktop_helper;
					switch (_tmp44_->panel_position) {
						case BUDGIE_PANEL_POSITION_LEFT:
						case BUDGIE_PANEL_POSITION_RIGHT:
						{
							gint to = 0;
							to = 0;
							if (counter == (count - 1)) {
								to = y + height;
							} else {
								to = previous_y + (height / count);
							}
							cairo_line_to (cr, (gdouble) indicator_x, (gdouble) to);
							break;
						}
						default:
						{
							gint to = 0;
							to = 0;
							if (counter == (count - 1)) {
								to = x + width;
							} else {
								to = previous_x + (width / count);
							}
							cairo_line_to (cr, (gdouble) to, (gdouble) indicator_y);
							break;
						}
					}
					cairo_stroke (cr);
					_tmp45_ = counter;
					counter = _tmp45_ + 1;
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), cr);
	_g_object_unref0 (context);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

void
icon_button_on_size_allocate (IconButton* self,
                              GtkAllocation* allocation)
{
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	gint x = 0;
	gint y = 0;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkWidget* _tmp11_;
	GdkWindow* _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	BudgieAbominationAppGroup* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	self->priv->definite_allocation = _tmp0_;
	_tmp1_ = self->priv->definite_allocation;
	GTK_WIDGET_CLASS (icon_button_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp1_);
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	toplevel = _tmp3_;
	_tmp5_ = toplevel;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GtkWidget* _tmp6_;
		GdkWindow* _tmp7_;
		_tmp6_ = toplevel;
		_tmp7_ = gtk_widget_get_window (_tmp6_);
		_tmp4_ = _tmp7_ == NULL;
	}
	if (_tmp4_) {
		_g_object_unref0 (toplevel);
		return;
	}
	_tmp8_ = toplevel;
	gtk_widget_translate_coordinates ((GtkWidget*) self, _tmp8_, 0, 0, &_tmp9_, &_tmp10_);
	x = _tmp9_;
	y = _tmp10_;
	_tmp11_ = toplevel;
	_tmp12_ = gtk_widget_get_window (_tmp11_);
	gdk_window_get_root_coords (_tmp12_, x, y, &_tmp13_, &_tmp14_);
	x = _tmp13_;
	y = _tmp14_;
	_tmp15_ = self->priv->class_group;
	if (_tmp15_ != NULL) {
		BudgieAbominationAppGroup* _tmp16_;
		GList* _tmp17_;
		_tmp16_ = self->priv->class_group;
		_tmp17_ = budgie_abomination_app_group_get_windows (_tmp16_);
		{
			GList* win_collection = NULL;
			GList* win_it = NULL;
			win_collection = _tmp17_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				WnckWindow* _tmp18_;
				WnckWindow* win = NULL;
				_tmp18_ = _g_object_ref0 ((WnckWindow*) win_it->data);
				win = _tmp18_;
				{
					WnckWindow* _tmp19_;
					GtkAllocation _tmp20_;
					GtkAllocation _tmp21_;
					_tmp19_ = win;
					_tmp20_ = self->priv->definite_allocation;
					_tmp21_ = self->priv->definite_allocation;
					wnck_window_set_icon_geometry (_tmp19_, x, y, _tmp20_.width, _tmp21_.height);
					_g_object_unref0 (win);
				}
			}
			(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
		}
	} else {
		WnckWindow* _tmp22_;
		_tmp22_ = self->priv->window;
		if (_tmp22_ != NULL) {
			WnckWindow* _tmp23_;
			GtkAllocation _tmp24_;
			GtkAllocation _tmp25_;
			_tmp23_ = self->priv->window;
			_tmp24_ = self->priv->definite_allocation;
			_tmp25_ = self->priv->definite_allocation;
			wnck_window_set_icon_geometry (_tmp23_, x, y, _tmp24_.width, _tmp25_.height);
		}
	}
	_g_object_unref0 (toplevel);
}

/**
 * set_app_for_class_group will set our AbominationApp for the first window in a given class group, if there is any
 */
static void
_____lambda42_ (IconButton* self)
{
	icon_button_set_tooltip (self);
}

static void
______lambda42__budgie_abomination_running_app_renamed_app (BudgieAbominationRunningApp* _sender,
                                                            const gchar* old_name,
                                                            const gchar* new_name,
                                                            gpointer self)
{
	_____lambda42_ ((IconButton*) self);
}

void
icon_button_set_app_for_class_group (IconButton* self)
{
	BudgieAbominationRunningApp* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->first_app;
	if (_tmp0_ == NULL) {
		GList* class_windows = NULL;
		BudgieAbominationAppGroup* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		_tmp1_ = self->priv->class_group;
		_tmp2_ = budgie_abomination_app_group_get_windows (_tmp1_);
		class_windows = _tmp2_;
		_tmp3_ = class_windows;
		if (g_list_length (_tmp3_) != ((guint) 0)) {
			WnckWindow* first_window = NULL;
			GList* _tmp4_;
			gconstpointer _tmp5_;
			WnckWindow* _tmp6_;
			WnckWindow* _tmp7_;
			_tmp4_ = class_windows;
			_tmp5_ = g_list_nth_data (_tmp4_, (guint) 0);
			_tmp6_ = _g_object_ref0 ((WnckWindow*) _tmp5_);
			first_window = _tmp6_;
			_tmp7_ = first_window;
			if (_tmp7_ != NULL) {
				BudgieAbominationAbomination* _tmp8_;
				WnckWindow* _tmp9_;
				BudgieAbominationRunningApp* _tmp10_;
				BudgieAbominationRunningApp* _tmp11_;
				GDesktopAppInfo* _tmp12_;
				_tmp8_ = self->priv->_abomination;
				_tmp9_ = first_window;
				_tmp10_ = budgie_abomination_abomination_get_app_from_window_id (_tmp8_, wnck_window_get_xid (_tmp9_));
				_g_object_unref0 (self->first_app);
				self->first_app = _tmp10_;
				_tmp11_ = self->first_app;
				g_signal_connect_object (_tmp11_, "renamed-app", (GCallback) ______lambda42__budgie_abomination_running_app_renamed_app, self, 0);
				_tmp12_ = self->priv->app_info;
				if (_tmp12_ == NULL) {
					BudgieAbominationRunningApp* _tmp13_;
					GDesktopAppInfo* _tmp14_;
					GDesktopAppInfo* _tmp15_;
					GDesktopAppInfo* _tmp16_;
					_tmp13_ = self->first_app;
					_tmp14_ = budgie_abomination_running_app_get_app_info (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (self->priv->app_info);
					self->priv->app_info = _tmp16_;
				}
			}
			_g_object_unref0 (first_window);
		}
		(class_windows == NULL) ? NULL : (class_windows = (g_list_free (class_windows), NULL));
	}
}

/**
 * setup_popover_with_class will set up our popover with windows from the class
 */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		IconButton* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_______lambda43_ (Block5Data* _data5_)
{
	IconButton* self;
	gulong win_xid = 0UL;
	WnckWindow* _tmp0_;
	BudgieIconPopover* _tmp1_;
	self = _data5_->self;
	_tmp0_ = _data5_->window;
	win_xid = wnck_window_get_xid (_tmp0_);
	_tmp1_ = self->priv->popover;
	budgie_icon_popover_rename_window (_tmp1_, win_xid);
}

static void
________lambda43__wnck_window_name_changed (WnckWindow* _sender,
                                            gpointer self)
{
	_______lambda43_ (self);
}

static void
_______lambda44_ (Block5Data* _data5_)
{
	IconButton* self;
	WnckWindow* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->window;
	if (wnck_window_needs_attention (_tmp0_)) {
		icon_button_attention (self, TRUE);
	}
}

static void
________lambda44__wnck_window_state_changed (WnckWindow* _sender,
                                             WnckWindowState changed_mask,
                                             WnckWindowState new_state,
                                             gpointer self)
{
	_______lambda44_ (self);
}

static void
icon_button_setup_popover_with_class (IconButton* self)
{
	BudgieAbominationRunningApp* _tmp0_;
	BudgieAbominationAppGroup* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->first_app;
	if (_tmp0_ == NULL) {
		icon_button_set_app_for_class_group (self);
	}
	_tmp1_ = self->priv->class_group;
	_tmp2_ = budgie_abomination_app_group_get_windows (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window = NULL;
			window = (WnckWindow*) window_it->data;
			{
				Block5Data* _data5_;
				WnckWindow* _tmp3_;
				_data5_ = g_slice_new0 (Block5Data);
				_data5_->_ref_count_ = 1;
				_data5_->self = g_object_ref (self);
				_data5_->window = window;
				_tmp3_ = _data5_->window;
				if (_tmp3_ != NULL) {
					BudgieAbominationAbomination* _tmp4_;
					WnckWindow* _tmp5_;
					_tmp4_ = self->priv->_abomination;
					_tmp5_ = _data5_->window;
					if (!budgie_abomination_abomination_is_disallowed_window_type (_tmp4_, _tmp5_)) {
						WnckWindow* _tmp6_;
						_tmp6_ = _data5_->window;
						if (icon_button_should_add_window (self, _tmp6_)) {
							gulong xid = 0UL;
							WnckWindow* _tmp7_;
							gchar* name = NULL;
							WnckWindow* _tmp8_;
							const gchar* _tmp9_;
							gchar* _tmp10_;
							BudgieIconPopover* _tmp11_;
							const gchar* _tmp12_;
							WnckWindow* _tmp13_;
							WnckWindow* _tmp14_;
							_tmp7_ = _data5_->window;
							xid = wnck_window_get_xid (_tmp7_);
							_tmp8_ = _data5_->window;
							_tmp9_ = wnck_window_get_name (_tmp8_);
							_tmp10_ = g_strdup (_tmp9_);
							name = _tmp10_;
							_tmp11_ = self->priv->popover;
							_tmp12_ = name;
							budgie_icon_popover_add_window (_tmp11_, xid, _tmp12_);
							_tmp13_ = _data5_->window;
							g_signal_connect_data (_tmp13_, "name-changed", (GCallback) ________lambda43__wnck_window_name_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, G_CONNECT_AFTER);
							_tmp14_ = _data5_->window;
							g_signal_connect_data (_tmp14_, "state-changed", (GCallback) ________lambda44__wnck_window_state_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, G_CONNECT_AFTER);
							_g_free0 (name);
						}
					}
				}
				block5_data_unref (_data5_);
				_data5_ = NULL;
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

static void
icon_button_real_get_preferred_width (GtkWidget* base,
                                      gint* min,
                                      gint* nat)
{
	IconButton * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	DesktopHelper* _tmp0_;
	self = (IconButton*) base;
	_tmp0_ = self->priv->_desktop_helper;
	if (_tmp0_->orientation == GTK_ORIENTATION_HORIZONTAL) {
		DesktopHelper* _tmp1_;
		_tmp1_ = self->priv->_desktop_helper;
		_vala_nat = _tmp1_->panel_size;
		_vala_min = _vala_nat;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	} else {
		gint m = 0;
		gint n = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GTK_WIDGET_CLASS (icon_button_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp2_, &_tmp3_);
		m = _tmp2_;
		n = _tmp3_;
		_vala_min = m;
		_vala_nat = n;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
icon_button_real_get_preferred_height (GtkWidget* base,
                                       gint* min,
                                       gint* nat)
{
	IconButton * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	DesktopHelper* _tmp0_;
	self = (IconButton*) base;
	_tmp0_ = self->priv->_desktop_helper;
	if (_tmp0_->orientation == GTK_ORIENTATION_VERTICAL) {
		DesktopHelper* _tmp1_;
		_tmp1_ = self->priv->_desktop_helper;
		_vala_nat = _tmp1_->panel_size;
		_vala_min = _vala_nat;
	} else {
		gint m = 0;
		gint n = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GTK_WIDGET_CLASS (icon_button_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp2_, &_tmp3_);
		m = _tmp2_;
		n = _tmp3_;
		_vala_min = m;
		_vala_nat = n;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static gboolean
icon_button_real_button_press_event (GtkWidget* base,
                                     GdkEventButton* event)
{
	IconButton * self;
	gboolean was_double_click = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (IconButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	was_double_click = event->type == GDK_DOUBLE_BUTTON_PRESS;
	if (!was_double_click) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (was_double_click) {
			_tmp1_ = event->button != ((guint) 1);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	icon_button_handle_launch_clicks (self, event, TRUE);
	result = GTK_WIDGET_CLASS (icon_button_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), event);
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
icon_button_real_button_release_event (GtkWidget* base,
                                       GdkEventButton* event)
{
	IconButton * self;
	gboolean _tmp0_ = FALSE;
	BudgieAbominationAppGroup* _tmp1_;
	gboolean result;
	self = (IconButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->class_group;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		WnckWindow* _tmp3_;
		_tmp3_ = self->last_active_window;
		if (_tmp3_ == NULL) {
			_tmp2_ = TRUE;
		} else {
			BudgieAbominationAppGroup* _tmp4_;
			GList* _tmp5_;
			GList* _tmp6_;
			WnckWindow* _tmp7_;
			GList* _tmp8_;
			_tmp4_ = self->priv->class_group;
			_tmp5_ = budgie_abomination_app_group_get_windows (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = self->last_active_window;
			_tmp8_ = g_list_find (_tmp6_, _tmp7_);
			_tmp2_ = _tmp8_ == NULL;
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (g_list_free (_tmp6_), NULL));
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BudgieAbominationAppGroup* _tmp9_;
		GList* _tmp10_;
		GList* _tmp11_;
		gconstpointer _tmp12_;
		WnckWindow* _tmp13_;
		_tmp9_ = self->priv->class_group;
		_tmp10_ = budgie_abomination_app_group_get_windows (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
		_tmp13_ = _g_object_ref0 ((WnckWindow*) _tmp12_);
		_g_object_unref0 (self->last_active_window);
		self->last_active_window = _tmp13_;
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (g_list_free (_tmp11_), NULL));
	}
	if (event->button == ((guint) 3)) {
		BudgieIconPopover* _tmp14_;
		BudgiePopoverManager* _tmp15_;
		_tmp14_ = self->priv->popover;
		budgie_icon_popover_render (_tmp14_);
		_tmp15_ = self->priv->_popover_manager;
		budgie_popover_manager_show_popover (_tmp15_, (GtkWidget*) self);
		result = GDK_EVENT_STOP;
		return result;
	} else {
		if (event->button == ((guint) 1)) {
			icon_button_handle_launch_clicks (self, event, FALSE);
		} else {
			if (event->button == ((guint) 2)) {
				GList* windows = NULL;
				gboolean middle_click_create_new_instance = FALSE;
				GSettings* _tmp16_;
				middle_click_create_new_instance = FALSE;
				_tmp16_ = self->priv->settings;
				if (_tmp16_ != NULL) {
					GSettings* _tmp17_;
					_tmp17_ = self->priv->settings;
					middle_click_create_new_instance = g_settings_get_boolean (_tmp17_, "middle-click-launch-new-instance");
				}
				if (middle_click_create_new_instance) {
					BudgieAbominationAppGroup* _tmp18_;
					GList* _tmp22_;
					_tmp18_ = self->priv->class_group;
					if (_tmp18_ != NULL) {
						BudgieAbominationAppGroup* _tmp19_;
						GList* _tmp20_;
						_tmp19_ = self->priv->class_group;
						_tmp20_ = budgie_abomination_app_group_get_windows (_tmp19_);
						(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
						windows = _tmp20_;
					} else {
						WnckWindow* _tmp21_;
						(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
						windows = NULL;
						_tmp21_ = self->priv->window;
						windows = g_list_insert (windows, _tmp21_, 0);
					}
					_tmp22_ = windows;
					if (g_list_length (_tmp22_) == ((guint) 0)) {
						icon_button_launch_app (self, gtk_get_current_event_time ());
					} else {
						GDesktopAppInfo* _tmp23_;
						_tmp23_ = self->priv->app_info;
						if (_tmp23_ != NULL) {
							gchar** actions = NULL;
							GDesktopAppInfo* _tmp24_;
							gchar** _tmp25_;
							gchar** _tmp26_;
							gchar** _tmp27_;
							gint _tmp27__length1;
							gint actions_length1;
							gint _actions_size_;
							gchar** _tmp28_;
							gint _tmp28__length1;
							_tmp24_ = self->priv->app_info;
							_tmp26_ = _tmp25_ = g_desktop_app_info_list_actions (_tmp24_);
							_tmp27_ = (_tmp26_ != NULL) ? _vala_array_dup1 (_tmp26_, _vala_array_length (_tmp25_)) : _tmp26_;
							_tmp27__length1 = _vala_array_length (_tmp25_);
							actions = _tmp27_;
							actions_length1 = _tmp27__length1;
							_actions_size_ = actions_length1;
							_tmp28_ = actions;
							_tmp28__length1 = actions_length1;
							if (_vala_string_array_contains (_tmp28_, _tmp28__length1, "new-window")) {
								GdkAppLaunchContext* _tmp29_;
								GdkScreen* _tmp30_;
								GdkAppLaunchContext* _tmp31_;
								GDesktopAppInfo* _tmp32_;
								GdkAppLaunchContext* _tmp33_;
								_tmp29_ = self->priv->launch_context;
								_tmp30_ = gtk_widget_get_screen ((GtkWidget*) self);
								gdk_app_launch_context_set_screen (_tmp29_, _tmp30_);
								_tmp31_ = self->priv->launch_context;
								gdk_app_launch_context_set_timestamp (_tmp31_, (guint32) GDK_CURRENT_TIME);
								_tmp32_ = self->priv->app_info;
								_tmp33_ = self->priv->launch_context;
								g_desktop_app_info_launch_action (_tmp32_, "new-window", (GAppLaunchContext*) _tmp33_);
							} else {
								icon_button_launch_app (self, gtk_get_current_event_time ());
							}
							actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
				(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
			}
		}
	}
	result = GTK_WIDGET_CLASS (icon_button_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), event);
	return result;
}

static GdkEventButton*
_vala_GdkEventButton_copy (GdkEventButton* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventButton_copy0 (gpointer self)
{
	return self ? _vala_GdkEventButton_copy (self) : NULL;
}

static void
_vala_GdkEventButton_free (GdkEventButton* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		IconButton* self;
		self = _data6_->self;
		__vala_GdkEventButton_free0 (_data6_->event);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		IconButton* self;
		self = _data7_->_data6_->self;
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_____lambda45_ (Block7Data* _data7_,
                WnckWindow* w)
{
	Block6Data* _data6_;
	IconButton* self;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	g_return_if_fail (w != NULL);
	if (_data7_->one_active) {
		wnck_window_minimize (w);
	} else {
		wnck_window_unminimize (w, _data6_->event->time);
		wnck_window_activate (w, _data6_->event->time);
	}
}

static void
______lambda45__gfunc (gconstpointer data,
                       gpointer self)
{
	_____lambda45_ (self, (WnckWindow*) data);
}

static void
icon_button_handle_launch_clicks (IconButton* self,
                                  GdkEventButton* event,
                                  gboolean was_double_click)
{
	Block6Data* _data6_;
	GdkEventButton* _tmp0_;
	gboolean should_launch_app = FALSE;
	BudgieAbominationAppGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = __vala_GdkEventButton_copy0 (event);
	__vala_GdkEventButton_free0 (_data6_->event);
	_data6_->event = _tmp0_;
	should_launch_app = FALSE;
	_tmp1_ = self->priv->class_group;
	if (_tmp1_ != NULL) {
		Block7Data* _data7_;
		WnckWorkspace* active_workspace = NULL;
		WnckScreen* _tmp2_;
		WnckWorkspace* _tmp3_;
		WnckWorkspace* _tmp4_;
		GList* list = NULL;
		GList* win_ids = NULL;
		BudgieIconPopover* _tmp5_;
		GHashTable* _tmp6_;
		GList* _tmp7_;
		GList* _tmp8_;
		GList* _tmp13_;
		guint len = 0U;
		GList* _tmp16_;
		gboolean show_all_windows_on_click = FALSE;
		GSettings* _tmp17_;
		gboolean _tmp19_ = FALSE;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data6_ = block6_data_ref (_data6_);
		_data7_->one_active = FALSE;
		_tmp2_ = self->priv->screen;
		_tmp3_ = wnck_screen_get_active_workspace (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		active_workspace = _tmp4_;
		list = NULL;
		_tmp5_ = self->priv->popover;
		_tmp6_ = _tmp5_->window_id_to_name;
		_tmp7_ = g_hash_table_get_keys (_tmp6_);
		win_ids = _tmp7_;
		_tmp8_ = win_ids;
		{
			GList* id_collection = NULL;
			GList* id_it = NULL;
			id_collection = _tmp8_;
			for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
				gulong id = 0UL;
				id = *((gulong*) id_it->data);
				{
					WnckWindow* win = NULL;
					WnckWindow* _tmp9_;
					WnckWindow* _tmp10_;
					WnckWindow* _tmp11_;
					WnckWindow* _tmp12_;
					_tmp9_ = wnck_window_get (id);
					_tmp10_ = _g_object_ref0 (_tmp9_);
					win = _tmp10_;
					_tmp11_ = win;
					if (_tmp11_ == NULL) {
						_g_object_unref0 (win);
						continue;
					}
					_tmp12_ = win;
					list = g_list_append (list, _tmp12_);
					_g_object_unref0 (win);
				}
			}
		}
		_tmp13_ = list;
		{
			GList* win_collection = NULL;
			GList* win_it = NULL;
			win_collection = _tmp13_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				WnckWindow* _tmp14_;
				WnckWindow* win = NULL;
				_tmp14_ = _g_object_ref0 ((WnckWindow*) win_it->data);
				win = _tmp14_;
				{
					WnckWindow* _tmp15_;
					_tmp15_ = win;
					if (wnck_window_is_active (_tmp15_)) {
						_data7_->one_active = TRUE;
						_g_object_unref0 (win);
						break;
					}
					_g_object_unref0 (win);
				}
			}
		}
		_tmp16_ = list;
		len = g_list_length (_tmp16_);
		show_all_windows_on_click = FALSE;
		_tmp17_ = self->priv->settings;
		if (_tmp17_ != NULL) {
			GSettings* _tmp18_;
			_tmp18_ = self->priv->settings;
			show_all_windows_on_click = g_settings_get_boolean (_tmp18_, "show-all-windows-on-click");
		}
		if (len == ((guint) 1)) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			if (len > ((guint) 1)) {
				_tmp20_ = !show_all_windows_on_click;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp19_ = _tmp20_;
		}
		if (_tmp19_) {
			WnckWindow* only_window = NULL;
			GList* _tmp21_;
			gconstpointer _tmp22_;
			WnckWindow* _tmp23_;
			WnckWindow* _tmp24_;
			WnckWorkspace* _tmp25_;
			_tmp21_ = list;
			_tmp22_ = g_list_nth_data (_tmp21_, (guint) 0);
			_tmp23_ = _g_object_ref0 ((WnckWindow*) _tmp22_);
			only_window = _tmp23_;
			_tmp24_ = only_window;
			_tmp25_ = active_workspace;
			if (!wnck_window_is_on_workspace (_tmp24_, _tmp25_)) {
				WnckWorkspace* winspace = NULL;
				WnckWindow* _tmp26_;
				WnckWorkspace* _tmp27_;
				WnckWorkspace* _tmp28_;
				WnckWorkspace* _tmp29_;
				WnckWindow* _tmp30_;
				WnckWindow* _tmp31_;
				_tmp26_ = only_window;
				_tmp27_ = wnck_window_get_workspace (_tmp26_);
				_tmp28_ = _g_object_ref0 (_tmp27_);
				winspace = _tmp28_;
				_tmp29_ = winspace;
				wnck_workspace_activate (_tmp29_, _data6_->event->time);
				_tmp30_ = only_window;
				wnck_window_activate (_tmp30_, _data6_->event->time);
				_tmp31_ = only_window;
				wnck_window_unminimize (_tmp31_, _data6_->event->time);
				_g_object_unref0 (winspace);
			} else {
				GList* _tmp32_;
				gconstpointer _tmp33_;
				_tmp32_ = list;
				_tmp33_ = g_list_nth_data (_tmp32_, (guint) 0);
				icon_button_toggle_window_minstate (self, _data6_->event->time, (WnckWindow*) _tmp33_);
			}
			_g_object_unref0 (only_window);
		} else {
			gboolean _tmp34_ = FALSE;
			if (len > ((guint) 1)) {
				_tmp34_ = show_all_windows_on_click;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				GList* _tmp35_;
				_tmp35_ = list;
				g_list_foreach (_tmp35_, ______lambda45__gfunc, _data7_);
			} else {
				should_launch_app = TRUE;
			}
		}
		(win_ids == NULL) ? NULL : (win_ids = (g_list_free (win_ids), NULL));
		(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
		_g_object_unref0 (active_workspace);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	} else {
		WnckWindow* _tmp36_;
		_tmp36_ = self->priv->window;
		if (_tmp36_ != NULL) {
			WnckWindow* _tmp37_;
			_tmp37_ = self->priv->window;
			if (wnck_window_is_active (_tmp37_)) {
				WnckWindow* _tmp38_;
				_tmp38_ = self->priv->window;
				wnck_window_minimize (_tmp38_);
			} else {
				WnckWindow* _tmp39_;
				WnckWindow* _tmp40_;
				_tmp39_ = self->priv->window;
				wnck_window_unminimize (_tmp39_, _data6_->event->time);
				_tmp40_ = self->priv->window;
				wnck_window_activate (_tmp40_, _data6_->event->time);
			}
		} else {
			should_launch_app = TRUE;
		}
	}
	if (should_launch_app) {
		gboolean require_double_click = FALSE;
		GSettings* _tmp41_;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		_tmp41_ = self->priv->settings;
		require_double_click = g_settings_get_boolean (_tmp41_, "require-double-click-to-launch");
		if (was_double_click) {
			_tmp43_ = require_double_click;
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			_tmp42_ = TRUE;
		} else {
			_tmp42_ = !require_double_click;
		}
		if (_tmp42_) {
			icon_button_launch_app (self, _data6_->event->time);
		}
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gboolean
icon_button_real_scroll_event (GtkWidget* base,
                               GdkEventScroll* event)
{
	IconButton * self;
	gboolean _tmp0_ = FALSE;
	WnckWindow* target_window = NULL;
	WnckWindow* current_window = NULL;
	DesktopHelper* _tmp1_;
	WnckWindow* _tmp2_;
	gboolean have_current_window = FALSE;
	WnckWindow* _tmp3_;
	BudgieAbominationAppGroup* _tmp4_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	BudgieAbominationAppGroup* _tmp31_;
	gboolean result;
	self = (IconButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->direction >= 4) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (g_get_monotonic_time () - self->priv->last_scroll_time) < ((gint64) 300000);
	}
	if (_tmp0_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	target_window = NULL;
	_tmp1_ = self->priv->_desktop_helper;
	_tmp2_ = desktop_helper_get_active_window (_tmp1_);
	current_window = _tmp2_;
	_tmp3_ = current_window;
	have_current_window = _tmp3_ != NULL;
	_tmp4_ = self->priv->class_group;
	if (_tmp4_ != NULL) {
		GList* windows = NULL;
		BudgieAbominationAppGroup* _tmp5_;
		GList* _tmp6_;
		guint windows_length = 0U;
		GList* _tmp7_;
		_tmp5_ = self->priv->class_group;
		_tmp6_ = budgie_abomination_app_group_get_windows (_tmp5_);
		windows = _tmp6_;
		_tmp7_ = windows;
		windows_length = g_list_length (_tmp7_);
		if (windows_length > ((guint) 1)) {
			gulong _tmp8_ = 0UL;
			gulong win_id = 0UL;
			gint current_window_position = 0;
			gint _tmp16_ = 0;
			gint incr_index = 0;
			gulong new_window_id = 0UL;
			GList* _tmp17_;
			gconstpointer _tmp18_;
			if (event->direction != GDK_SCROLL_UP) {
				windows = g_list_reverse (windows);
			}
			if (have_current_window) {
				WnckWindow* _tmp9_;
				_tmp9_ = current_window;
				_tmp8_ = wnck_window_get_xid (_tmp9_);
			} else {
				_tmp8_ = (gulong) 0;
			}
			win_id = _tmp8_;
			current_window_position = 0;
			if (have_current_window) {
				{
					gint current_id_index = 0;
					current_id_index = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							WnckWindow* window = NULL;
							GList* _tmp12_;
							gconstpointer _tmp13_;
							WnckWindow* _tmp14_;
							WnckWindow* _tmp15_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = current_id_index;
								current_id_index = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							if (!(((guint) current_id_index) < windows_length)) {
								break;
							}
							_tmp12_ = windows;
							_tmp13_ = g_list_nth_data (_tmp12_, (guint) current_id_index);
							_tmp14_ = _g_object_ref0 ((WnckWindow*) _tmp13_);
							window = _tmp14_;
							_tmp15_ = window;
							if (win_id == wnck_window_get_xid (_tmp15_)) {
								current_window_position = current_id_index;
								_g_object_unref0 (window);
								break;
							}
							_g_object_unref0 (window);
						}
					}
				}
			}
			if (have_current_window) {
				_tmp16_ = current_window_position + 1;
			} else {
				_tmp16_ = 0;
			}
			incr_index = _tmp16_;
			if (((guint) incr_index) == windows_length) {
				incr_index = 0;
			}
			_tmp17_ = windows;
			_tmp18_ = g_list_nth_data (_tmp17_, (guint) incr_index);
			new_window_id = wnck_window_get_xid ((WnckWindow*) _tmp18_);
			if (new_window_id >= ((gulong) 0)) {
				WnckWindow* _tmp19_;
				WnckWindow* _tmp20_;
				_tmp19_ = wnck_window_get (new_window_id);
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (target_window);
				target_window = _tmp20_;
			}
		} else {
			if (windows_length == ((guint) 1)) {
				gulong id = 0UL;
				GList* _tmp21_;
				gconstpointer _tmp22_;
				WnckWindow* _tmp23_;
				WnckWindow* _tmp24_;
				_tmp21_ = windows;
				_tmp22_ = g_list_nth_data (_tmp21_, (guint) 0);
				id = wnck_window_get_xid ((WnckWindow*) _tmp22_);
				_tmp23_ = wnck_window_get (id);
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_g_object_unref0 (target_window);
				target_window = _tmp24_;
			}
		}
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	} else {
		WnckWindow* _tmp25_;
		_tmp25_ = self->priv->window;
		if (_tmp25_ != NULL) {
			WnckWindow* _tmp26_;
			WnckWindow* _tmp27_;
			_tmp26_ = self->priv->window;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (target_window);
			target_window = _tmp27_;
		}
	}
	_tmp31_ = self->priv->class_group;
	if (_tmp31_ == NULL) {
		_tmp30_ = TRUE;
	} else {
		BudgieAbominationAppGroup* _tmp32_;
		GList* _tmp33_;
		GList* _tmp34_;
		_tmp32_ = self->priv->class_group;
		_tmp33_ = budgie_abomination_app_group_get_windows (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp30_ = g_list_length (_tmp34_) == ((guint) 1);
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (g_list_free (_tmp34_), NULL));
	}
	if (_tmp30_) {
		_tmp29_ = have_current_window;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		_tmp28_ = event->direction != GDK_SCROLL_UP;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		WnckWindow* _tmp35_;
		_tmp35_ = target_window;
		wnck_window_minimize (_tmp35_);
	} else {
		WnckWindow* _tmp36_;
		_tmp36_ = target_window;
		if (_tmp36_ != NULL) {
			WnckWindow* _tmp37_;
			WnckWindow* _tmp38_;
			_tmp37_ = target_window;
			wnck_window_activate (_tmp37_, event->time);
			_tmp38_ = target_window;
			wnck_window_unminimize (_tmp38_, event->time);
		}
	}
	self->priv->last_scroll_time = g_get_monotonic_time ();
	result = GDK_EVENT_STOP;
	_g_object_unref0 (current_window);
	_g_object_unref0 (target_window);
	return result;
}

static void
icon_button_toggle_window_minstate (IconButton* self,
                                    guint32 time,
                                    WnckWindow* win)
{
	WnckWindow* current_active_window = NULL;
	WnckScreen* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	gulong _tmp3_ = 0UL;
	WnckWindow* _tmp4_;
	gboolean is_current_active_window = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_tmp0_ = wnck_window_get_screen (win);
	_tmp1_ = wnck_screen_get_active_window (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current_active_window = _tmp2_;
	_tmp4_ = current_active_window;
	if (_tmp4_ != NULL) {
		WnckWindow* _tmp5_;
		_tmp5_ = current_active_window;
		_tmp3_ = wnck_window_get_xid (_tmp5_);
	} else {
		_tmp3_ = (gulong) 0;
	}
	is_current_active_window = wnck_window_get_xid (win) == _tmp3_;
	if (wnck_window_is_minimized (win)) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !is_current_active_window;
	}
	if (_tmp6_) {
		wnck_window_activate (win, time);
		wnck_window_unminimize (win, time);
	} else {
		wnck_window_minimize (win);
	}
	_g_object_unref0 (current_active_window);
}

GDesktopAppInfo*
icon_button_get_appinfo (IconButton* self)
{
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->app_info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

BudgieAbominationAppGroup*
icon_button_get_class_group (IconButton* self)
{
	BudgieAbominationAppGroup* _tmp0_;
	BudgieAbominationAppGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->class_group;
	result = _tmp0_;
	return result;
}

BudgieAbominationAbomination*
icon_button_get_abomination (IconButton* self)
{
	BudgieAbominationAbomination* result;
	BudgieAbominationAbomination* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_abomination;
	result = _tmp0_;
	return result;
}

void
icon_button_set_abomination (IconButton* self,
                             BudgieAbominationAbomination* value)
{
	BudgieAbominationAbomination* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_abomination (self);
	if (old_value != value) {
		self->priv->_abomination = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_ABOMINATION_PROPERTY]);
	}
}

BudgieAppSystem*
icon_button_get_app_system (IconButton* self)
{
	BudgieAppSystem* result;
	BudgieAppSystem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_system;
	result = _tmp0_;
	return result;
}

void
icon_button_set_app_system (IconButton* self,
                            BudgieAppSystem* value)
{
	BudgieAppSystem* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_app_system (self);
	if (old_value != value) {
		self->priv->_app_system = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_APP_SYSTEM_PROPERTY]);
	}
}

DesktopHelper*
icon_button_get_desktop_helper (IconButton* self)
{
	DesktopHelper* result;
	DesktopHelper* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_helper;
	result = _tmp0_;
	return result;
}

void
icon_button_set_desktop_helper (IconButton* self,
                                DesktopHelper* value)
{
	DesktopHelper* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_desktop_helper (self);
	if (old_value != value) {
		self->priv->_desktop_helper = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_DESKTOP_HELPER_PROPERTY]);
	}
}

BudgiePopoverManager*
icon_button_get_popover_manager (IconButton* self)
{
	BudgiePopoverManager* result;
	BudgiePopoverManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_popover_manager;
	result = _tmp0_;
	return result;
}

void
icon_button_set_popover_manager (IconButton* self,
                                 BudgiePopoverManager* value)
{
	BudgiePopoverManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_popover_manager (self);
	if (old_value != value) {
		self->priv->_popover_manager = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_POPOVER_MANAGER_PROPERTY]);
	}
}

static void
icon_button_class_init (IconButtonClass * klass,
                        gpointer klass_data)
{
	icon_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconButton_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) icon_button_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) icon_button_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) icon_button_real_get_preferred_height;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) icon_button_real_button_press_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) icon_button_real_button_release_event;
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) icon_button_real_scroll_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = icon_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_ABOMINATION_PROPERTY, icon_button_properties[ICON_BUTTON_ABOMINATION_PROPERTY] = g_param_spec_object ("abomination", "abomination", "abomination", BUDGIE_ABOMINATION_TYPE_ABOMINATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_APP_SYSTEM_PROPERTY, icon_button_properties[ICON_BUTTON_APP_SYSTEM_PROPERTY] = g_param_spec_object ("app-system", "app-system", "app-system", BUDGIE_TYPE_APP_SYSTEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_DESKTOP_HELPER_PROPERTY, icon_button_properties[ICON_BUTTON_DESKTOP_HELPER_PROPERTY] = g_param_spec_object ("desktop-helper", "desktop-helper", "desktop-helper", TYPE_DESKTOP_HELPER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_POPOVER_MANAGER_PROPERTY, icon_button_properties[ICON_BUTTON_POPOVER_MANAGER_PROPERTY] = g_param_spec_object ("popover-manager", "popover-manager", "popover-manager", budgie_popover_manager_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Signals
	 */
	icon_button_signals[ICON_BUTTON_BECAME_EMPTY_SIGNAL] = g_signal_new ("became-empty", TYPE_ICON_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	icon_button_signals[ICON_BUTTON_PINNED_CHANGED_SIGNAL] = g_signal_new ("pinned-changed", TYPE_ICON_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
icon_button_instance_init (IconButton * self,
                           gpointer klass)
{
	self->priv = icon_button_get_instance_private (self);
	self->first_app = NULL;
	self->pinned = FALSE;
	self->last_active_window = NULL;
	self->priv->popover = NULL;
	self->priv->screen = NULL;
	self->priv->settings = NULL;
	self->priv->window = NULL;
	self->priv->class_group = NULL;
	self->priv->app_info = NULL;
	self->priv->window_count = 0;
	self->priv->originally_pinned = FALSE;
	self->priv->last_scroll_time = (gint64) 0;
	self->priv->needs_attention = FALSE;
	self->priv->_abomination = NULL;
	self->priv->_app_system = NULL;
	self->priv->_desktop_helper = NULL;
	self->priv->_popover_manager = NULL;
}

static void
icon_button_finalize (GObject * obj)
{
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_BUTTON, IconButton);
	_g_object_unref0 (self->first_app);
	_g_object_unref0 (self->icon);
	_g_object_unref0 (self->last_active_window);
	_g_free0 (self->button_id);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->screen);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->class_group);
	_g_object_unref0 (self->priv->app_info);
	_g_object_unref0 (self->priv->launch_context);
	G_OBJECT_CLASS (icon_button_parent_class)->finalize (obj);
}

/**
 * IconButton provides the pretty IconTasklist button to house one or more
 * windows in a group, as well as selection capabilities, interaction, animations
 * and rendering of "dots" for the renderable windows.
 */
GType
icon_button_get_type (void)
{
	return icon_button_type_id;
}

GType
icon_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconButton), 0, (GInstanceInitFunc) icon_button_instance_init, NULL };
	icon_button_type_id = g_type_module_register_type (module, gtk_toggle_button_get_type (), "IconButton", &g_define_type_info, 0);
	IconButton_private_offset = sizeof (IconButtonPrivate);
	return icon_button_type_id;
}

static void
_vala_icon_button_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_BUTTON, IconButton);
	switch (property_id) {
		case ICON_BUTTON_ABOMINATION_PROPERTY:
		g_value_set_object (value, icon_button_get_abomination (self));
		break;
		case ICON_BUTTON_APP_SYSTEM_PROPERTY:
		g_value_set_object (value, icon_button_get_app_system (self));
		break;
		case ICON_BUTTON_DESKTOP_HELPER_PROPERTY:
		g_value_set_object (value, icon_button_get_desktop_helper (self));
		break;
		case ICON_BUTTON_POPOVER_MANAGER_PROPERTY:
		g_value_set_object (value, icon_button_get_popover_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_icon_button_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_BUTTON, IconButton);
	switch (property_id) {
		case ICON_BUTTON_ABOMINATION_PROPERTY:
		icon_button_set_abomination (self, g_value_get_object (value));
		break;
		case ICON_BUTTON_APP_SYSTEM_PROPERTY:
		icon_button_set_app_system (self, g_value_get_object (value));
		break;
		case ICON_BUTTON_DESKTOP_HELPER_PROPERTY:
		icon_button_set_desktop_helper (self, g_value_get_object (value));
		break;
		case ICON_BUTTON_POPOVER_MANAGER_PROPERTY:
		icon_button_set_popover_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

