/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone, $) {
  Drupal.ckeditor.AuralView = Backbone.View.extend({
    events: {
      'click .ckeditor-buttons a': 'announceButtonHelp',
      'click .ckeditor-multiple-buttons a': 'announceSeparatorHelp',
      'focus .ckeditor-button a': 'onFocus',
      'focus .ckeditor-button-separator a': 'onFocus',
      'focus .ckeditor-toolbar-group': 'onFocus'
    },
    initialize: function initialize() {
      this.listenTo(this.model, 'change:isDirty', this.announceMove);
    },
    announceMove: function announceMove(model, isDirty) {
      if (!isDirty) {
        var item = document.activeElement || null;

        if (item) {
          var $item = $(item);

          if ($item.hasClass('ckeditor-toolbar-group')) {
            this.announceButtonGroupPosition($item);
          } else if ($item.parent().hasClass('ckeditor-button')) {
            this.announceButtonPosition($item.parent());
          }
        }
      }
    },
    onFocus: function onFocus(event) {
      event.stopPropagation();
      var $originalTarget = $(event.target);
      var $currentTarget = $(event.currentTarget);
      var $parent = $currentTarget.parent();

      if ($parent.hasClass('ckeditor-button') || $parent.hasClass('ckeditor-button-separator')) {
        this.announceButtonPosition($currentTarget.parent());
      } else if ($originalTarget.attr('role') !== 'button' && $currentTarget.hasClass('ckeditor-toolbar-group')) {
        this.announceButtonGroupPosition($currentTarget);
      }
    },
    announceButtonGroupPosition: function announceButtonGroupPosition($group) {
      var $groups = $group.parent().children();
      var $row = $group.closest('.ckeditor-row');
      var $rows = $row.parent().children();
      var position = $groups.index($group) + 1;
      var positionCount = $groups.not('.placeholder').length;
      var row = $rows.index($row) + 1;
      var rowCount = $rows.not('.placeholder').length;
      var text = Drupal.t('@groupName button group in position @position of @positionCount in row @row of @rowCount.', {
        '@groupName': $group.attr('data-drupal-ckeditor-toolbar-group-name'),
        '@position': position,
        '@positionCount': positionCount,
        '@row': row,
        '@rowCount': rowCount
      });

      if (position === 1 && row === rowCount) {
        text += '\n';
        text += Drupal.t('Press the down arrow key to create a new row.');
      }

      Drupal.announce(text, 'assertive');
    },
    announceButtonPosition: function announceButtonPosition($button) {
      var $row = $button.closest('.ckeditor-row');
      var $rows = $row.parent().children();
      var $buttons = $button.closest('.ckeditor-buttons').children();
      var $group = $button.closest('.ckeditor-toolbar-group');
      var $groups = $group.parent().children();
      var groupPosition = $groups.index($group) + 1;
      var groupPositionCount = $groups.not('.placeholder').length;
      var position = $buttons.index($button) + 1;
      var positionCount = $buttons.length;
      var row = $rows.index($row) + 1;
      var rowCount = $rows.not('.placeholder').length;
      var type = $button.attr('data-drupal-ckeditor-type') === 'separator' ? '' : Drupal.t('button');
      var text;

      if ($button.closest('.ckeditor-toolbar-disabled').length > 0) {
        text = Drupal.t('@name @type.', {
          '@name': $button.children().attr('aria-label'),
          '@type': type
        });
        text += "\n".concat(Drupal.t('Press the down arrow key to activate.'));
        Drupal.announce(text, 'assertive');
      } else if ($group.not('.placeholder').length === 1) {
          text = Drupal.t('@name @type in position @position of @positionCount in @groupName button group in row @row of @rowCount.', {
            '@name': $button.children().attr('aria-label'),
            '@type': type,
            '@position': position,
            '@positionCount': positionCount,
            '@groupName': $group.attr('data-drupal-ckeditor-toolbar-group-name'),
            '@row': row,
            '@rowCount': rowCount
          });

          if (groupPosition === 1 && position === 1 && row === rowCount) {
            text += '\n';
            text += Drupal.t('Press the down arrow key to create a new button group in a new row.');
          }

          if (groupPosition === groupPositionCount && position === positionCount) {
            text += '\n';
            text += Drupal.t('This is the last group. Move the button forward to create a new group.');
          }

          Drupal.announce(text, 'assertive');
        }
    },
    announceButtonHelp: function announceButtonHelp(event) {
      var $link = $(event.currentTarget);
      var $button = $link.parent();
      var enabled = $button.closest('.ckeditor-toolbar-active').length > 0;
      var message;

      if (enabled) {
        message = Drupal.t('The "@name" button is currently enabled.', {
          '@name': $link.attr('aria-label')
        });
        message += "\n".concat(Drupal.t('Use the keyboard arrow keys to change the position of this button.'));
        message += "\n".concat(Drupal.t('Press the up arrow key on the top row to disable the button.'));
      } else {
        message = Drupal.t('The "@name" button is currently disabled.', {
          '@name': $link.attr('aria-label')
        });
        message += "\n".concat(Drupal.t('Use the down arrow key to move this button into the active toolbar.'));
      }

      Drupal.announce(message);
      event.preventDefault();
    },
    announceSeparatorHelp: function announceSeparatorHelp(event) {
      var $link = $(event.currentTarget);
      var $button = $link.parent();
      var enabled = $button.closest('.ckeditor-toolbar-active').length > 0;
      var message;

      if (enabled) {
        message = Drupal.t('This @name is currently enabled.', {
          '@name': $link.attr('aria-label')
        });
        message += "\n".concat(Drupal.t('Use the keyboard arrow keys to change the position of this separator.'));
      } else {
        message = Drupal.t('Separators are used to visually split individual buttons.');
        message += "\n".concat(Drupal.t('This @name is currently disabled.', {
          '@name': $link.attr('aria-label')
        }));
        message += "\n".concat(Drupal.t('Use the down arrow key to move this separator into the active toolbar.'));
        message += "\n".concat(Drupal.t('You may add multiple separators to each button group.'));
      }

      Drupal.announce(message);
      event.preventDefault();
    }
  });
})(Drupal, Backbone, jQuery);