/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.mapviewer.MapViewer;
import net.sf.freecol.common.debug.FreeColDebugger;

public class CanvasMapViewer
extends JComponent {
    private static final Logger logger = Logger.getLogger(CanvasMapViewer.class.getName());
    private final FreeColClient freeColClient;
    private final MapViewer mapViewer;
    private double averageFullMapRenderTimeInMillis = 0.0;
    private long fullMapRenderNumber = 0L;
    private long lastFullMapRenderTimeInMillis = 0L;

    public CanvasMapViewer(FreeColClient freeColClient, MapViewer mapViewer) {
        this.freeColClient = freeColClient;
        this.mapViewer = mapViewer;
        this.setLayout(null);
    }

    public void changeSize(Dimension size) {
        this.setSize(size);
        this.mapViewer.changeSize(size);
    }

    public void paintImmediately() {
        if (!this.isMapAvailable()) {
            return;
        }
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        long startTime = System.currentTimeMillis();
        super.paintComponent(g);
        Dimension size = this.getSize();
        Graphics2D g2d = (Graphics2D)g;
        boolean fullMapRenderedWithoutUsingBackBuffer = false;
        if (this.isMapAvailable()) {
            fullMapRenderedWithoutUsingBackBuffer = this.mapViewer.displayMap(g2d, size);
        } else if (this.freeColClient.isMapEditor()) {
            this.paintBlackBackground(g2d, size);
        } else {
            this.paintMainMenuBackground(g2d, size);
        }
        if (FreeColDebugger.isInDebugMode()) {
            this.drawRenderingTimeStrings(g, startTime, fullMapRenderedWithoutUsingBackBuffer);
        }
    }

    private boolean isMapAvailable() {
        return this.freeColClient != null && this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null;
    }

    private void paintMainMenuBackground(Graphics2D g2d, Dimension size) {
        BufferedImage bgImage = ImageLibrary.getCanvasBackgroundImage();
        if (bgImage != null) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(bgImage, 0, 0, size.width, size.height, this);
            String versionStr = "v. " + FreeCol.getVersion();
            Font oldFont = g2d.getFont();
            Color oldColor = g2d.getColor();
            Font newFont = oldFont.deriveFont(1);
            TextLayout layout = new TextLayout(versionStr, newFont, g2d.getFontRenderContext());
            Rectangle2D bounds = layout.getBounds();
            float x = (float)size.width - (float)bounds.getWidth() - 5.0f;
            float y = (float)size.height - (float)bounds.getHeight();
            g2d.setColor(Color.white);
            layout.draw(g2d, x, y);
            g2d.setFont(oldFont);
            g2d.setColor(oldColor);
        } else {
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, size.width, size.height);
            logger.warning("Unable to load the canvas background");
        }
    }

    private void paintBlackBackground(Graphics2D g2d, Dimension size) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, size.width, size.height);
    }

    private void drawRenderingTimeStrings(Graphics g, long startTime, boolean fullMapRenderedWithoutUsingBackBuffer) {
        g.setColor(Color.white);
        long renderTime = System.currentTimeMillis() - startTime;
        if (fullMapRenderedWithoutUsingBackBuffer) {
            this.lastFullMapRenderTimeInMillis = renderTime;
            ++this.fullMapRenderNumber;
            this.averageFullMapRenderTimeInMillis = (this.averageFullMapRenderTimeInMillis * (double)(this.fullMapRenderNumber - 1L) + (double)renderTime) / (double)this.fullMapRenderNumber;
        }
        int art = (int)this.averageFullMapRenderTimeInMillis;
        g.drawString("Full map (average): " + art + "ms ==> " + 1000 / (art + 1) + "fps", 50, 50);
        g.drawString("Full map (last): " + this.lastFullMapRenderTimeInMillis + "ms ==> " + 1000L / (this.lastFullMapRenderTimeInMillis + 1L) + "fps", 50, 70);
        g.drawString("Last render: " + renderTime + "ms ==> " + 1000L / (renderTime + 1L) + "fps", 50, 90);
    }
}

