/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class InformationPanel
extends FreeColPanel {
    private BufferedImage skin = null;

    public InformationPanel(FreeColClient freeColClient, String[] texts, FreeColObject[] fcos, ImageIcon[] images) {
        super(freeColClient, null, new MigLayout());
        ImageLibrary fixedImageLibrary = freeColClient.getGUI().getFixedImageLibrary();
        this.skin = fixedImageLibrary.getInformationPanelSkin(freeColClient.getMyPlayer());
        float scaleFactor = fixedImageLibrary.getScaleFactor();
        int topInset = fixedImageLibrary.getInformationPanelSkinTopInset(freeColClient.getMyPlayer());
        int scaledTopInset = (int)((float)topInset * scaleFactor);
        int gap = (int)(10.0f * scaleFactor);
        this.getMigLayout().setLayoutConstraints("fill, wrap 1, insets 0 0 0 0");
        this.getMigLayout().setColumnConstraints(gap + "[grow]" + gap);
        this.getMigLayout().setRowConstraints(scaledTopInset + "px[grow]" + gap + "[]" + gap);
        JPanel textPanel = this.createPanelWithAllContent(texts, fcos, images, gap);
        JScrollPane scrollPane = new JScrollPane(textPanel, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "grow");
        this.add((Component)this.okButton, "tag ok");
        this.setPreferredSize(new Dimension(this.skin.getWidth(), this.skin.getHeight()));
        this.setBorder(null);
    }

    private JPanel createPanelWithAllContent(String[] texts, FreeColObject[] fcos, ImageIcon[] images, int gap) {
        MigPanel textPanel = new MigPanel(new MigLayout("fill, wrap 2"));
        textPanel.setOpaque(false);
        for (int i = 0; i < texts.length; ++i) {
            JTextArea txt = Utility.getDefaultTextArea(texts[i]);
            if (images[i] != null) {
                textPanel.add(new JLabel(images[i]));
                textPanel.add((Component)txt, "gapleft " + gap + ", growx");
            } else {
                textPanel.add((Component)txt, "skip, growx");
            }
            StringTemplate disp = this.displayLabel(fcos[i]);
            if (disp == null) continue;
            JButton button = Utility.localizedButton(StringTemplate.template("informationPanel.display").addStringTemplate("%object%", disp));
            FreeColObject fco = fcos[i];
            button.addActionListener(ae -> this.getGUI().displayObject(fco));
            if (i + 1 < texts.length) {
                textPanel.add((Component)button, "skip, gapbottom 25");
                continue;
            }
            textPanel.add((Component)button, "skip");
        }
        return textPanel;
    }

    private StringTemplate displayLabel(FreeColObject fco) {
        return fco instanceof Tile && ((Tile)fco).hasSettlement() ? this.displayLabel(((Tile)fco).getSettlement()) : (fco instanceof Unit ? this.displayLabel((FreeColObject)((Object)((Unit)fco).getLocation())) : (fco instanceof Location ? ((Location)((Object)fco)).getLocationLabelFor(this.getMyPlayer()) : null));
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.skin, 0, 0, this);
    }
}

