/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.EOFException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class ColonizationMapReader {
    public static final int WIDTH = 0;
    public static final int HEIGHT = 2;
    private static final char[] tiletypes = new char[]{'t', 'd', 'p', 'r', 'g', 'v', 'm', 's', 'B', 'S', 'M', 'L', 'C', 'T', 'W', 'R', 'B', 'S', 'M', 'L', 'C', 'T', 'W', 'R', '_', '.', ':', '?', '?', '?', '?', '?'};
    private static final byte[] header = new byte[]{58, 0, 72, 0, 4, 0};
    private static byte[] layer1;

    public static void main(String[] args) throws Exception {
        if ("--palette".equals(args[0])) {
            RandomAccessFile writer = new RandomAccessFile(args[1], "rw");
            int width = 58;
            int height = 72;
            int size = width * height * 3 + header.length;
            layer1 = new byte[size];
            for (int i = 0; i < header.length; ++i) {
                ColonizationMapReader.layer1[i] = header[i];
            }
            Arrays.fill(layer1, header.length, header.length + width * height, (byte)25);
            int ROWS = 32;
            int COLUMNS = 8;
            int offset = header.length + width + 1;
            for (int y = 0; y < ROWS; ++y) {
                for (int x = 0; x < COLUMNS; ++x) {
                    int value = COLUMNS * y + x;
                    if ((value & 0x18) == 24 && x > 2) {
                        value = 26;
                    }
                    ColonizationMapReader.layer1[offset + x] = value;
                }
                offset += width;
            }
            writer.write(layer1);
        } else {
            RandomAccessFile reader = new RandomAccessFile(args[0], "r");
            try {
                reader.readFully(header);
            }
            catch (EOFException ee) {
                System.err.println("Unable to read header of " + args[0] + ": " + ee);
                System.exit(1);
            }
            System.out.println(String.format("Map width:  %02d", header[0]));
            System.out.println(String.format("Map height: %02d", header[2]));
            int size = header[0] * header[2];
            layer1 = new byte[size];
            try {
                reader.readFully(layer1);
            }
            catch (EOFException ee) {
                System.err.println("Unable to read data of " + args[0] + ": " + ee);
                System.exit(1);
            }
            int index = 0;
            for (int y = 0; y < header[2]; ++y) {
                for (int x = 0; x < header[0]; ++x) {
                    int decimal = layer1[index] & 0xFF;
                    char terrain = tiletypes[decimal & 0x1F];
                    int overlay = decimal >> 5;
                    switch (overlay) {
                        case 1: {
                            terrain = '^';
                            break;
                        }
                        case 2: {
                            terrain = '~';
                            break;
                        }
                        case 3: {
                            terrain = 'x';
                            break;
                        }
                        case 5: {
                            terrain = '*';
                            break;
                        }
                        case 6: {
                            terrain = '=';
                            break;
                        }
                        case 7: {
                            terrain = 'X';
                            break;
                        }
                    }
                    System.out.print(terrain);
                    ++index;
                }
                System.out.println('\n');
            }
            System.out.println('\n');
        }
    }
}

