/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.desktop.preview.propertyeditors.DependantOriginalColorPropertyEditor;
import org.gephi.preview.types.DependantOriginalColor;
import org.gephi.ui.components.JColorButton;
import org.jdesktop.swingx.JXHeader;
import org.openide.util.NbBundle;

public class DependantOriginalColorPanel
extends JPanel
implements ItemListener {
    private DependantOriginalColorPropertyEditor propertyEditor;
    private ButtonGroup buttonGroup1;
    private JButton colorButton;
    private JRadioButton customRadio;
    private JXHeader jXHeader1;
    private JRadioButton originalRadio;
    private JRadioButton parentRadio;

    public DependantOriginalColorPanel() {
        this.initComponents();
        this.colorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color newColor = (Color)evt.getNewValue();
                DependantOriginalColorPanel.this.propertyEditor.setValue(new DependantOriginalColor(newColor));
            }
        });
        this.originalRadio.addItemListener(this);
        this.parentRadio.addItemListener(this);
        this.customRadio.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.colorButton.setEnabled(this.customRadio.isSelected());
        DependantOriginalColor.Mode selectedMode = null;
        if (this.originalRadio.isSelected()) {
            selectedMode = DependantOriginalColor.Mode.ORIGINAL;
        } else if (this.parentRadio.isSelected()) {
            selectedMode = DependantOriginalColor.Mode.PARENT;
        } else if (this.customRadio.isSelected()) {
            selectedMode = DependantOriginalColor.Mode.CUSTOM;
        }
        this.propertyEditor.setValue(new DependantOriginalColor(selectedMode));
    }

    public void setup(DependantOriginalColorPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        DependantOriginalColor dependantOriginalColor = (DependantOriginalColor)propertyEditor.getValue();
        if (dependantOriginalColor.getMode().equals((Object)DependantOriginalColor.Mode.CUSTOM)) {
            this.customRadio.setSelected(true);
            ((JColorButton)this.colorButton).setColor(dependantOriginalColor.getCustomColor());
        } else if (dependantOriginalColor.getMode().equals((Object)DependantOriginalColor.Mode.ORIGINAL)) {
            this.originalRadio.setSelected(true);
        } else if (dependantOriginalColor.getMode().equals((Object)DependantOriginalColor.Mode.PARENT)) {
            this.parentRadio.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jXHeader1 = new JXHeader();
        this.colorButton = new JColorButton(Color.BLACK);
        this.customRadio = new JRadioButton();
        this.originalRadio = new JRadioButton();
        this.parentRadio = new JRadioButton();
        this.jXHeader1.setDescription(NbBundle.getMessage(DependantOriginalColorPanel.class, (String)"DependantOriginalColorPanel.jXHeader1.description"));
        this.jXHeader1.setTitle(NbBundle.getMessage(DependantOriginalColorPanel.class, (String)"DependantOriginalColorPanel.jXHeader1.title"));
        this.buttonGroup1.add(this.customRadio);
        this.customRadio.setText(NbBundle.getMessage(DependantOriginalColorPanel.class, (String)"DependantOriginalColorPanel.customRadio.text"));
        this.buttonGroup1.add(this.originalRadio);
        this.originalRadio.setText(NbBundle.getMessage(DependantOriginalColorPanel.class, (String)"DependantOriginalColorPanel.originalRadio.text"));
        this.buttonGroup1.add(this.parentRadio);
        this.parentRadio.setText(NbBundle.getMessage(DependantOriginalColorPanel.class, (String)"DependantOriginalColorPanel.parentRadio.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.originalRadio).addContainerGap(360, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.parentRadio).addContainerGap(365, Short.MAX_VALUE)).addComponent((Component)this.jXHeader1, -1, 435, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.customRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorButton).addContainerGap(326, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXHeader1, -2, 77, -2).addGap(18, 18, 18).addComponent(this.originalRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.parentRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customRadio).addComponent(this.colorButton)).addGap(47, 47, 47)));
    }
}

