/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters;

import java.awt.BorderLayout;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.gephi.desktop.filters.FilterUIModel;
import org.gephi.desktop.filters.FiltersPanel;
import org.gephi.desktop.filters.WorkspaceColumnsObservers;
import org.gephi.filters.api.FilterModel;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="FiltersTopComponent", iconBase="org/gephi/desktop/filters/resources/small.png", persistenceType=0)
public final class FiltersTopComponent
extends TopComponent {
    static final String ICON_PATH = "org/gephi/desktop/filters/resources/small.png";
    private static final String PREFERRED_ID = "FiltersTopComponent";
    private static final long AUTO_REFRESH_RATE_MILLISECONDS = 3000L;
    private static FiltersTopComponent instance;
    private final FiltersPanel panel;
    private FilterModel filterModel;
    private WorkspaceColumnsObservers observers;
    private FilterUIModel uiModel;
    private Timer observersTimer;

    public FiltersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(FiltersTopComponent.class, (String)"CTL_FiltersTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.panel = new FiltersPanel();
        this.add(this.panel, "Center");
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add((Object)new FilterUIModel(workspace));
            }

            public void select(Workspace workspace) {
                FiltersTopComponent.this.activateWorkspace(workspace);
                FiltersTopComponent.this.refreshModel();
            }

            public void unselect(Workspace workspace) {
                FiltersTopComponent.this.observers.destroy();
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                FiltersTopComponent.this.filterModel = null;
                FiltersTopComponent.this.uiModel = null;
                FiltersTopComponent.this.observers = null;
                FiltersTopComponent.this.refreshModel();
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            Workspace workspace = pc.getCurrentWorkspace();
            this.activateWorkspace(workspace);
        }
        this.refreshModel();
        this.initEvents();
    }

    private void activateWorkspace(Workspace workspace) {
        this.filterModel = (FilterModel)workspace.getLookup().lookup(FilterModel.class);
        this.uiModel = (FilterUIModel)workspace.getLookup().lookup(FilterUIModel.class);
        if (this.uiModel == null) {
            this.uiModel = new FilterUIModel(workspace);
            workspace.add((Object)this.uiModel);
        }
        this.observers = (WorkspaceColumnsObservers)workspace.getLookup().lookup(WorkspaceColumnsObservers.class);
        if (this.observers == null) {
            this.observers = new WorkspaceColumnsObservers(workspace);
            workspace.add((Object)this.observers);
        }
        this.observers.initialize();
    }

    private void refreshModel() {
        this.panel.refreshModel(this.filterModel, this.uiModel);
    }

    public FilterUIModel getUiModel() {
        return this.uiModel;
    }

    private void initEvents() {
        this.observersTimer = new Timer("DataLaboratoryGraphObservers");
        this.observersTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (FiltersTopComponent.this.observers != null && FiltersTopComponent.this.observers.hasChanges()) {
                    FiltersTopComponent.this.refreshModel();
                }
            }
        }, 0L, 3000L);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

