/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Field;

public class FieldList {
    private Field[] _fieldArray;

    public FieldList() {
        this._fieldArray = new Field[0];
    }

    public FieldList(int n) {
        if (n < 0) {
            n = 0;
        }
        this._fieldArray = new Field[n];
    }

    public FieldList(Field[] fieldArray) {
        if (fieldArray == null || fieldArray.length == 0) {
            this._fieldArray = new Field[0];
        } else {
            this._fieldArray = new Field[fieldArray.length];
            System.arraycopy(fieldArray, 0, this._fieldArray, 0, fieldArray.length);
        }
    }

    public int getFieldIndex(Field field) {
        if (field == null) {
            return -1;
        }
        int n = 0;
        while (n < this._fieldArray.length) {
            if (this._fieldArray[n] != null && this._fieldArray[n].equals(field)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean contains(Field field) {
        return this.getFieldIndex(field) >= 0;
    }

    public int getNumFields() {
        if (this._fieldArray == null) {
            return 0;
        }
        return this._fieldArray.length;
    }

    public Field getField(int n) {
        if (this._fieldArray == null || n < 0 || n >= this._fieldArray.length) {
            return null;
        }
        return this._fieldArray[n];
    }

    public FieldList merge(FieldList fieldList) {
        int n = this._fieldArray.length;
        int n2 = 0;
        while (n2 < fieldList._fieldArray.length) {
            if (fieldList._fieldArray[n2] != null && !this.contains(fieldList._fieldArray[n2])) {
                ++n;
            }
            ++n2;
        }
        FieldList fieldList2 = new FieldList(n);
        System.arraycopy(this._fieldArray, 0, fieldList2._fieldArray, 0, this._fieldArray.length);
        if (n > this._fieldArray.length) {
            int n3 = this._fieldArray.length;
            int n4 = 0;
            while (n4 < fieldList._fieldArray.length) {
                if (fieldList._fieldArray[n4] != null && !this.contains(fieldList._fieldArray[n4])) {
                    fieldList2._fieldArray[n3] = fieldList._fieldArray[n4];
                    ++n3;
                }
                ++n4;
            }
        }
        return fieldList2;
    }

    public int extendList(Field field) {
        int n = this.getFieldIndex(field);
        if (n >= 0) {
            return n;
        }
        int n2 = this._fieldArray.length;
        Field[] fieldArray = new Field[n2 + 1];
        System.arraycopy(this._fieldArray, 0, fieldArray, 0, n2);
        this._fieldArray = fieldArray;
        this._fieldArray[n2] = field;
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        Field[] fieldArray = this._fieldArray;
        int n = this._fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            stringBuilder.append(field.getName()).append(',');
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

