/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.File;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.Cancellable;
import tim.prune.gui.GenericProgressDialog;
import tim.prune.load.MediaHelper;
import tim.prune.load.MediaLoadProgressDialog;
import tim.prune.undo.UndoLoadAudios;
import tim.prune.undo.UndoLoadPhotos;

public class AsyncMediaLoader
extends GenericFunction
implements Runnable,
Cancellable {
    private File _zipFile = null;
    private String[] _linkArray = null;
    private Track _track = null;
    private File _sourceFile = null;
    private boolean _cancelled = false;

    public AsyncMediaLoader(App app, File file, String[] stringArray, Track track, File file2) {
        super(app);
        this._zipFile = file;
        this._linkArray = stringArray;
        this._track = track;
        this._sourceFile = file2;
    }

    @Override
    public void begin() {
        this._cancelled = false;
        if (this._linkArray != null) {
            new Thread(this).start();
        }
    }

    @Override
    public void cancel() {
        this._cancelled = true;
    }

    @Override
    public String getNameKey() {
        return "function.asyncmediaload";
    }

    @Override
    public void run() {
        Object object;
        Object object2;
        int n = 0;
        String[] stringArray = this._linkArray;
        int n2 = this._linkArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = stringArray[n3];
            if (object2 != null) {
                ++n;
            }
            ++n3;
        }
        if (n <= 0) {
            return;
        }
        object2 = new MediaLoadProgressDialog(this._app.getFrame(), this);
        MediaObject[] mediaObjectArray = new MediaObject[n];
        n2 = 0;
        int n4 = 0;
        while (n4 < this._linkArray.length && !this._cancelled) {
            if (this._linkArray[n4] != null) {
                MediaObject mediaObject = MediaHelper.createMediaObject(this._zipFile, this._linkArray[n4], this._sourceFile);
                if (mediaObject != null) {
                    double d;
                    object = mediaObject.getDataPoint();
                    this._track.getPoint(n4).attachMedia(mediaObject);
                    MediaObject.Status status = object == null ? MediaObject.Status.NOT_CONNECTED : MediaObject.Status.TAGGED;
                    mediaObject.setOriginalStatus(status);
                    MediaObject.Status status2 = MediaObject.Status.TAGGED;
                    if (object != null && (d = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween((DataPoint)object, this._track.getPoint(n4)), UnitSetLibrary.UNITS_METRES)) > 10.0) {
                        status2 = MediaObject.Status.CONNECTED;
                    }
                    mediaObject.setCurrentStatus(status2);
                    mediaObjectArray[n2] = mediaObject;
                    if (!this._app.isBusyLoading()) {
                        ((GenericProgressDialog)object2).showProgress(n2, n);
                    }
                    ++n2;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n4;
        }
        ((GenericProgressDialog)object2).close();
        this.waitUntilAppReady();
        n4 = 0;
        int n5 = 0;
        n2 = 0;
        while (n2 < n) {
            object = mediaObjectArray[n2];
            if (object != null && this._track.containsPoint(((MediaObject)object).getDataPoint())) {
                if (object instanceof Photo) {
                    this._app.getTrackInfo().getPhotoList().addPhoto((Photo)object);
                    ++n4;
                } else if (object instanceof AudioClip) {
                    this._app.getTrackInfo().getAudioList().addAudio((AudioClip)object);
                    ++n5;
                }
            }
            ++n2;
        }
        if (n4 > 0) {
            this._app.completeFunction(new UndoLoadPhotos(n4, 0), n4 + " " + I18nManager.getText(n4 == 1 ? "confirm.jpegload.single" : "confirm.jpegload.multi"));
        }
        if (n5 > 0) {
            this._app.completeFunction(new UndoLoadAudios(n5), I18nManager.getText("confirm.audioload"));
        }
        UpdateMessageBroker.informSubscribers((byte)1);
    }

    private void waitUntilAppReady() {
        long l = 500L;
        while (this._app.isBusyLoading()) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
            l = (long)((double)l * 1.2);
        }
    }
}

