/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Photo;
import tim.prune.data.RecentFile;
import tim.prune.data.RecentFileList;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.ChooseSingleParameter;
import tim.prune.function.PasteCoordinateList;
import tim.prune.function.PasteCoordinates;
import tim.prune.function.PlusCodeFunction;
import tim.prune.function.SearchOpenCachingDeFunction;
import tim.prune.function.browser.UrlGenerator;
import tim.prune.function.browser.WebMapFunction;
import tim.prune.function.search.SearchMapillaryFunction;
import tim.prune.function.settings.SaveConfig;
import tim.prune.function.srtm.ConfigureSrtmSources;
import tim.prune.gui.FunctionLauncher;
import tim.prune.gui.IconManager;
import tim.prune.gui.RecentFileTrigger;

public class MenuManager
implements DataSubscriber {
    private App _app = null;
    private Track _track = null;
    private Selection _selection = null;
    private JMenuItem _sendGpsItem = null;
    private JMenuItem _saveItem = null;
    private JMenuItem _exportKmlItem = null;
    private JMenuItem _exportGpxItem = null;
    private JMenuItem _exportPovItem = null;
    private JMenuItem _exportImageItem = null;
    private JMenu _recentFileMenu = null;
    private JMenuItem _undoItem = null;
    private JMenuItem _clearUndoItem = null;
    private JMenuItem _editPointItem = null;
    private JMenuItem _editWaypointNameItem = null;
    private JMenuItem _deletePointItem = null;
    private JMenuItem _truncatePointCoordsItem = null;
    private JMenuItem _deleteRangeItem = null;
    private JMenuItem _cropTrackItem = null;
    private JMenuItem _compressItem = null;
    private JMenuItem _markRectangleItem = null;
    private JMenuItem _markUphillLiftsItem = null;
    private JMenuItem _deleteMarkedPointsItem = null;
    private JMenuItem _deleteByDateItem = null;
    private JMenuItem _interpolateItem = null;
    private JMenuItem _averageItem = null;
    private JMenuItem _selectAllItem = null;
    private JMenuItem _selectNoneItem = null;
    private JMenuItem _selectSegmentItem = null;
    private JMenuItem _selectStartItem = null;
    private JMenuItem _selectEndItem = null;
    private JMenuItem _findWaypointItem = null;
    private JMenuItem _duplicatePointItem = null;
    private JMenuItem _projectPointItem = null;
    private JMenuItem _projectCircleItem = null;
    private JMenuItem _reverseItem = null;
    private JMenuItem _addTimeOffsetItem = null;
    private JMenuItem _addAltitudeOffsetItem = null;
    private JMenuItem _mergeSegmentsItem = null;
    private JMenuItem _rearrangeWaypointsItem = null;
    private JMenuItem _splitSegmentsItem = null;
    private JMenuItem _sewSegmentsItem = null;
    private JMenuItem _createMarkerWaypointsItem = null;
    private JMenuItem _cutAndMoveItem = null;
    private JMenuItem _convertNamesToTimesItem = null;
    private JMenuItem _deleteFieldValuesItem = null;
    private JCheckBoxMenuItem _mapCheckbox = null;
    private JMenuItem _show3dItem = null;
    private JMenu _browserMapMenu = null;
    private JMenuItem _routingGraphHopperItem = null;
    private JMenuItem _chartItem = null;
    private JMenuItem _lookupSrtmItem = null;
    private JMenuItem _configureSrtmItem = null;
    private JMenuItem _nearbyWikipediaItem = null;
    private JMenuItem _nearbyOsmPoiItem = null;
    private JMenuItem _showPeakfinderItem = null;
    private JMenuItem _showGeohackItem = null;
    private JMenuItem _searchOpencachingDeItem = null;
    private JMenuItem _searchMapillaryItem = null;
    private JMenuItem _downloadOsmItem = null;
    private JMenuItem _getWeatherItem = null;
    private JMenuItem _distanceItem = null;
    private JMenuItem _viewFullDetailsItem = null;
    private JMenuItem _estimateTimeItem = null;
    private JMenuItem _learnEstimationParams = null;
    private JMenuItem _autoplayTrack = null;
    private JMenuItem _saveExifItem = null;
    private JMenuItem _photoPopupItem = null;
    private JMenuItem _selectNoPhotoItem = null;
    private JMenuItem _connectPhotoItem = null;
    private JMenuItem _removePhotoItem = null;
    private JMenuItem _disconnectPhotoItem = null;
    private JMenuItem _correlatePhotosItem = null;
    private JMenuItem _rearrangePhotosItem = null;
    private JMenuItem _rotatePhotoLeft = null;
    private JMenuItem _rotatePhotoRight = null;
    private JMenuItem _ignoreExifThumb = null;
    private JMenuItem _connectAudioItem = null;
    private JMenuItem _disconnectAudioItem = null;
    private JMenuItem _removeAudioItem = null;
    private JMenuItem _correlateAudiosItem = null;
    private JMenuItem _selectNoAudioItem = null;
    private JCheckBoxMenuItem _onlineCheckbox = null;
    private JCheckBoxMenuItem _autosaveSettingsCheckbox = null;
    private ActionListener _openFileAction = null;
    private ActionListener _addPhotoAction = null;
    private ActionListener _saveAction = null;
    private ActionListener _undoAction = null;
    private ActionListener _editPointAction = null;
    private ActionListener _deletePointAction = null;
    private ActionListener _selectStartAction = null;
    private ActionListener _selectEndAction = null;
    private JButton _saveButton = null;
    private JButton _undoButton = null;
    private JButton _editPointButton = null;
    private JButton _deletePointButton = null;
    private JButton _deleteRangeButton = null;
    private JButton _cutAndMoveButton = null;
    private JButton _selectStartButton = null;
    private JButton _selectEndButton = null;
    private JButton _connectButton = null;
    private static final int[] KEY_EVENTS = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

    public MenuManager(App app, TrackInfo trackInfo) {
        this._app = app;
        this._track = trackInfo.getTrack();
        this._selection = trackInfo.getSelection();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(I18nManager.getText("menu.file"));
        MenuManager.setAltKey(jMenu, "altkey.menu.file");
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("function.open"));
        MenuManager.setShortcut(jMenuItem, "shortcut.menu.file.open");
        this._openFileAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.openFile();
            }
        };
        jMenuItem.addActionListener(this._openFileAction);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IMPORTBABEL);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        this._addPhotoAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.addPhotos();
            }
        };
        jMenuItem3.addActionListener(this._addPhotoAction);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOAD_AUDIO);
        jMenu.add(jMenuItem4);
        this._recentFileMenu = new JMenu(I18nManager.getText("menu.file.recentfiles"));
        this._recentFileMenu.setEnabled(false);
        jMenu.add(this._recentFileMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSLOAD);
        MenuManager.setShortcut(jMenuItem5, "shortcut.menu.file.load");
        jMenu.add(jMenuItem5);
        this._sendGpsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSSAVE, false);
        jMenu.add(this._sendGpsItem);
        jMenu.addSeparator();
        this._saveItem = new JMenuItem(I18nManager.getText("menu.file.save"), 83);
        MenuManager.setShortcut(this._saveItem, "shortcut.menu.file.save");
        this._saveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.saveFile();
            }
        };
        this._saveItem.addActionListener(this._saveAction);
        this._saveItem.setEnabled(false);
        jMenu.add(this._saveItem);
        this._exportKmlItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_KMLEXPORT, false);
        jMenu.add(this._exportKmlItem);
        this._exportGpxItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPXEXPORT, false);
        jMenu.add(this._exportGpxItem);
        this._exportPovItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_POVEXPORT, false);
        jMenu.add(this._exportPovItem);
        this._exportImageItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IMAGEEXPORT, false);
        jMenu.add(this._exportImageItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(I18nManager.getText("menu.file.exit"));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.exit();
            }
        });
        jMenu.add(jMenuItem6);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(I18nManager.getText("menu.online"));
        MenuManager.setAltKey(jMenu2, "altkey.menu.online");
        this._lookupSrtmItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOOKUP_SRTM, false);
        jMenu2.add(this._lookupSrtmItem);
        this._configureSrtmItem = MenuManager.makeMenuItem(new ConfigureSrtmSources(this._app), true);
        jMenu2.add(this._configureSrtmItem);
        jMenu2.addSeparator();
        this._browserMapMenu = new JMenu(I18nManager.getText("menu.view.browser"));
        this._browserMapMenu.setEnabled(false);
        JMenuItem jMenuItem7 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_GOOGLE, "menu.view.browser.google"));
        this._browserMapMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_OSM, "menu.view.browser.openstreetmap"));
        this._browserMapMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_MAPQUEST, "menu.view.browser.mapquest"));
        this._browserMapMenu.add(jMenuItem9);
        JMenuItem jMenuItem10 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_YAHOO, "menu.view.browser.yahoo"));
        this._browserMapMenu.add(jMenuItem10);
        JMenuItem jMenuItem11 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_BING, "menu.view.browser.bing"));
        this._browserMapMenu.add(jMenuItem11);
        JMenuItem jMenuItem12 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_INLINESKATE, "menu.view.browser.inlinemap"));
        this._browserMapMenu.add(jMenuItem12);
        this._routingGraphHopperItem = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_GRAPHHOPPER, "menu.view.browser.graphhopper"));
        this._browserMapMenu.add(this._routingGraphHopperItem);
        jMenu2.add(this._browserMapMenu);
        this._nearbyWikipediaItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_NEARBY_WIKIPEDIA, false);
        jMenu2.add(this._nearbyWikipediaItem);
        JMenuItem jMenuItem13 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEARCH_WIKIPEDIA);
        jMenu2.add(jMenuItem13);
        this._nearbyOsmPoiItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEARCH_OSMPOIS);
        jMenu2.add(this._nearbyOsmPoiItem);
        this._showPeakfinderItem = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_PEAKFINDER, "webservice.peakfinder"), false);
        jMenu2.add(this._showPeakfinderItem);
        this._showGeohackItem = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_GEOHACK, "webservice.geohack"), false);
        jMenu2.add(this._showGeohackItem);
        jMenu2.addSeparator();
        this._searchOpencachingDeItem = MenuManager.makeMenuItem(new SearchOpenCachingDeFunction(this._app), false);
        jMenu2.add(this._searchOpencachingDeItem);
        this._searchMapillaryItem = MenuManager.makeMenuItem(new SearchMapillaryFunction(this._app), false);
        jMenu2.add(this._searchMapillaryItem);
        this._downloadOsmItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DOWNLOAD_OSM, false);
        jMenu2.add(this._downloadOsmItem);
        this._getWeatherItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GET_WEATHER_FORECAST, false);
        jMenu2.add(this._getWeatherItem);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(I18nManager.getText("menu.track"));
        MenuManager.setAltKey(jMenu3, "altkey.menu.track");
        this._undoItem = new JMenuItem(I18nManager.getText("menu.track.undo"));
        MenuManager.setShortcut(this._undoItem, "shortcut.menu.track.undo");
        this._undoAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.beginUndo();
            }
        };
        this._undoItem.addActionListener(this._undoAction);
        this._undoItem.setEnabled(false);
        jMenu3.add(this._undoItem);
        this._clearUndoItem = new JMenuItem(I18nManager.getText("menu.track.clearundo"));
        this._clearUndoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.clearUndo();
            }
        });
        this._clearUndoItem.setEnabled(false);
        jMenu3.add(this._clearUndoItem);
        jMenu3.addSeparator();
        this._compressItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_COMPRESS, false);
        MenuManager.setShortcut(this._compressItem, "shortcut.menu.track.compress");
        jMenu3.add(this._compressItem);
        this._markRectangleItem = new JMenuItem(I18nManager.getText("menu.track.markrectangle"));
        this._markRectangleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.setCurrentMode(App.AppMode.DRAWRECT);
                UpdateMessageBroker.informSubscribers();
            }
        });
        this._markRectangleItem.setEnabled(false);
        jMenu3.add(this._markRectangleItem);
        this._markUphillLiftsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_MARK_LIFTS, false);
        jMenu3.add(this._markUphillLiftsItem);
        this._deleteMarkedPointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_MARKED_POINTS, false);
        jMenu3.add(this._deleteMarkedPointsItem);
        this._deleteByDateItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_BY_DATE, false);
        jMenu3.add(this._deleteByDateItem);
        jMenu3.addSeparator();
        this._rearrangeWaypointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS, false);
        jMenu3.add(this._rearrangeWaypointsItem);
        this._splitSegmentsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SPLIT_SEGMENTS, false);
        jMenu3.add(this._splitSegmentsItem);
        this._sewSegmentsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEW_SEGMENTS, false);
        jMenu3.add(this._sewSegmentsItem);
        this._createMarkerWaypointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CREATE_MARKER_WAYPOINTS, false);
        jMenu3.add(this._createMarkerWaypointsItem);
        jMenu3.addSeparator();
        this._learnEstimationParams = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LEARN_ESTIMATION_PARAMS, false);
        jMenu3.add(this._learnEstimationParams);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu(I18nManager.getText("menu.range"));
        MenuManager.setAltKey(jMenu4, "altkey.menu.range");
        this._selectAllItem = new JMenuItem(I18nManager.getText("menu.range.all"));
        MenuManager.setShortcut(this._selectAllItem, "shortcut.menu.range.all");
        this._selectAllItem.setEnabled(false);
        this._selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRange(0, MenuManager.this._track.getNumPoints() - 1);
            }
        });
        jMenu4.add(this._selectAllItem);
        this._selectNoneItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoneItem.setEnabled(false);
        this._selectNoneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.selectNone();
            }
        });
        jMenu4.add(this._selectNoneItem);
        this._selectSegmentItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SELECT_SEGMENT);
        jMenu4.add(this._selectSegmentItem);
        jMenu4.addSeparator();
        this._selectStartItem = new JMenuItem(I18nManager.getText("menu.range.start"));
        this._selectStartItem.setEnabled(false);
        this._selectStartAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRangeStart();
            }
        };
        this._selectStartItem.addActionListener(this._selectStartAction);
        jMenu4.add(this._selectStartItem);
        this._selectEndItem = new JMenuItem(I18nManager.getText("menu.range.end"));
        this._selectEndItem.setEnabled(false);
        this._selectEndAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRangeEnd();
            }
        };
        this._selectEndItem.addActionListener(this._selectEndAction);
        jMenu4.add(this._selectEndItem);
        jMenu4.addSeparator();
        this._deleteRangeItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_RANGE, false);
        jMenu4.add(this._deleteRangeItem);
        this._cropTrackItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CROP_TRACK, false);
        jMenu4.add(this._cropTrackItem);
        this._reverseItem = new JMenuItem(I18nManager.getText("menu.range.reverse"));
        this._reverseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.reverseRange();
            }
        });
        this._reverseItem.setEnabled(false);
        jMenu4.add(this._reverseItem);
        this._addTimeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_TIME_OFFSET, false);
        jMenu4.add(this._addTimeOffsetItem);
        this._addAltitudeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_ALTITUDE_OFFSET, false);
        jMenu4.add(this._addAltitudeOffsetItem);
        this._mergeSegmentsItem = new JMenuItem(I18nManager.getText("menu.range.mergetracksegments"));
        this._mergeSegmentsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.mergeTrackSegments();
            }
        });
        this._mergeSegmentsItem.setEnabled(false);
        jMenu4.add(this._mergeSegmentsItem);
        this._deleteFieldValuesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_FIELD_VALUES, false);
        jMenu4.add(this._deleteFieldValuesItem);
        jMenu4.addSeparator();
        this._interpolateItem = MenuManager.makeMenuItem(new ChooseSingleParameter(this._app, FunctionLibrary.FUNCTION_INTERPOLATE), false);
        jMenu4.add(this._interpolateItem);
        this._averageItem = new JMenuItem(I18nManager.getText("menu.range.average"));
        this._averageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.averageSelection();
            }
        });
        this._averageItem.setEnabled(false);
        jMenu4.add(this._averageItem);
        this._cutAndMoveItem = new JMenuItem(I18nManager.getText("menu.range.cutandmove"));
        this._cutAndMoveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.cutAndMoveSelection();
            }
        });
        this._cutAndMoveItem.setEnabled(false);
        jMenu4.add(this._cutAndMoveItem);
        this._convertNamesToTimesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONVERT_NAMES_TO_TIMES, false);
        jMenu4.add(this._convertNamesToTimesItem);
        jMenuBar.add(jMenu4);
        JMenu jMenu5 = new JMenu(I18nManager.getText("menu.point"));
        MenuManager.setAltKey(jMenu5, "altkey.menu.point");
        this._editPointItem = new JMenuItem(I18nManager.getText("menu.point.editpoint"));
        this._editPointAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.editCurrentPoint();
            }
        };
        this._editPointItem.addActionListener(this._editPointAction);
        this._editPointItem.setEnabled(false);
        MenuManager.setShortcut(this._editPointItem, "shortcut.menu.point.edit");
        jMenu5.add(this._editPointItem);
        this._editWaypointNameItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_EDIT_WAYPOINT_NAME, false);
        jMenu5.add(this._editWaypointNameItem);
        this._deletePointItem = new JMenuItem(I18nManager.getText("menu.point.deletepoint"));
        this._deletePointAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.deleteCurrentPoint();
            }
        };
        this._deletePointItem.addActionListener(this._deletePointAction);
        this._deletePointItem.setEnabled(false);
        this._deletePointItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenu5.add(this._deletePointItem);
        this._truncatePointCoordsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_TRUNCATE_POINT_COORDS, false);
        jMenu5.add(this._truncatePointCoordsItem);
        jMenu5.addSeparator();
        this._findWaypointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_FIND_WAYPOINT, false);
        jMenu5.add(this._findWaypointItem);
        this._duplicatePointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DUPLICATE_POINT, false);
        jMenu5.add(this._duplicatePointItem);
        this._projectPointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PROJECT_POINT, false);
        jMenu5.add(this._projectPointItem);
        this._projectCircleItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PROJECT_CIRCLE, false);
        jMenu5.add(this._projectCircleItem);
        jMenu5.addSeparator();
        JMenuItem jMenuItem14 = MenuManager.makeMenuItem(new PasteCoordinates(this._app));
        jMenu5.add(jMenuItem14);
        JMenuItem jMenuItem15 = MenuManager.makeMenuItem(new PasteCoordinateList(this._app));
        jMenu5.add(jMenuItem15);
        JMenuItem jMenuItem16 = MenuManager.makeMenuItem(new PlusCodeFunction(this._app));
        jMenu5.add(jMenuItem16);
        jMenuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu(I18nManager.getText("menu.view"));
        MenuManager.setAltKey(jMenu6, "altkey.menu.view");
        this._mapCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.map.showmap"), false);
        this._mapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Config.setConfigBoolean("prune.showmap", MenuManager.this._mapCheckbox.isSelected());
                UpdateMessageBroker.informSubscribers((byte)64);
            }
        });
        jMenu6.add(this._mapCheckbox);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18nManager.getText("menu.view.showsidebars"));
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.toggleSidebars();
            }
        });
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        jMenu6.add(jCheckBoxMenuItem);
        this._show3dItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_3D, false);
        jMenu6.add(this._show3dItem);
        this._chartItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHARTS, false);
        jMenu6.add(this._chartItem);
        jMenu6.addSeparator();
        this._distanceItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISTANCES, false);
        jMenu6.add(this._distanceItem);
        this._viewFullDetailsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_FULL_DETAILS, false);
        jMenu6.add(this._viewFullDetailsItem);
        this._estimateTimeItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ESTIMATE_TIME, false);
        jMenu6.add(this._estimateTimeItem);
        jMenu6.addSeparator();
        this._autoplayTrack = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_AUTOPLAY_TRACK, false);
        jMenu6.add(this._autoplayTrack);
        jMenuBar.add(jMenu6);
        JMenu jMenu7 = new JMenu(I18nManager.getText("menu.photo"));
        MenuManager.setAltKey(jMenu7, "altkey.menu.photo");
        jMenuItem3 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        jMenuItem3.addActionListener(this._addPhotoAction);
        jMenu7.add(jMenuItem3);
        this._saveExifItem = new JMenuItem(I18nManager.getText("menu.photo.saveexif"));
        this._saveExifItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.saveExif();
            }
        });
        this._saveExifItem.setEnabled(false);
        jMenu7.add(this._saveExifItem);
        this._selectNoPhotoItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoPhotoItem.setEnabled(false);
        this._selectNoPhotoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.getTrackInfo().selectPhoto(-1);
            }
        });
        jMenu7.add(this._selectNoPhotoItem);
        jMenu7.addSeparator();
        this._connectPhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONNECT_TO_POINT, false);
        jMenu7.add(this._connectPhotoItem);
        this._disconnectPhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISCONNECT_PHOTO, false);
        jMenu7.add(this._disconnectPhotoItem);
        this._removePhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REMOVE_PHOTO, false);
        jMenu7.add(this._removePhotoItem);
        this._rotatePhotoLeft = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ROTATE_PHOTO_LEFT, false);
        jMenu7.add(this._rotatePhotoLeft);
        this._rotatePhotoRight = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ROTATE_PHOTO_RIGHT, false);
        jMenu7.add(this._rotatePhotoRight);
        this._photoPopupItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PHOTO_POPUP, false);
        jMenu7.add(this._photoPopupItem);
        this._ignoreExifThumb = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IGNORE_EXIF_THUMB, false);
        jMenu7.add(this._ignoreExifThumb);
        jMenu7.addSeparator();
        this._correlatePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_PHOTOS, false);
        jMenu7.add(this._correlatePhotosItem);
        this._rearrangePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REARRANGE_PHOTOS, false);
        jMenu7.add(this._rearrangePhotosItem);
        jMenuBar.add(jMenu7);
        JMenu jMenu8 = new JMenu(I18nManager.getText("menu.audio"));
        MenuManager.setAltKey(jMenu8, "altkey.menu.audio");
        jMenuItem4 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOAD_AUDIO);
        jMenu8.add(jMenuItem4);
        this._selectNoAudioItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoAudioItem.setEnabled(false);
        this._selectNoAudioItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.getTrackInfo().selectAudio(-1);
            }
        });
        jMenu8.add(this._selectNoAudioItem);
        jMenu8.addSeparator();
        this._connectAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONNECT_TO_POINT, false);
        jMenu8.add(this._connectAudioItem);
        this._disconnectAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISCONNECT_AUDIO, false);
        jMenu8.add(this._disconnectAudioItem);
        this._removeAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REMOVE_AUDIO, false);
        jMenu8.add(this._removeAudioItem);
        jMenu8.addSeparator();
        this._correlateAudiosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_AUDIOS, false);
        jMenu8.add(this._correlateAudiosItem);
        jMenuBar.add(jMenu8);
        JMenu jMenu9 = new JMenu(I18nManager.getText("menu.settings"));
        MenuManager.setAltKey(jMenu9, "altkey.menu.settings");
        JMenuItem jMenuItem17 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_MAP_BG);
        jMenu9.add(jMenuItem17);
        this._onlineCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.settings.onlinemode"));
        this._onlineCheckbox.setSelected(Config.getConfigBoolean("prune.onlinemode"));
        this._onlineCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MenuManager.this._onlineCheckbox.isSelected();
                Config.setConfigBoolean("prune.onlinemode", bl);
                if (bl) {
                    UpdateMessageBroker.informSubscribers();
                }
            }
        });
        jMenu9.add(this._onlineCheckbox);
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_DISK_CACHE));
        jMenu9.addSeparator();
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_PATHS));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_COLOURS));
        JMenuItem jMenuItem18 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_DISPLAY_SETTINGS);
        jMenu9.add(jMenuItem18);
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_LANGUAGE));
        jMenu9.add(MenuManager.makeMenuItem(new ChooseSingleParameter(this._app, FunctionLibrary.FUNCTION_SET_ALTITUDE_TOLERANCE)));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_TIMEZONE));
        jMenu9.addSeparator();
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SAVECONFIG));
        this._autosaveSettingsCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.settings.autosave"), false);
        this._autosaveSettingsCheckbox.setSelected(Config.getConfigBoolean("prune.autosavesettings"));
        this._autosaveSettingsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MenuManager.this._autosaveSettingsCheckbox.isSelected();
                Config.setConfigBoolean("prune.autosavesettings", bl);
                new SaveConfig(MenuManager.this._app).autosaveSwitched(bl);
            }
        });
        jMenu9.add(this._autosaveSettingsCheckbox);
        jMenuBar.add(jMenu9);
        JMenu jMenu10 = new JMenu(I18nManager.getText("menu.help"));
        MenuManager.setAltKey(jMenu10, "altkey.menu.help");
        JMenuItem jMenuItem19 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_HELP);
        MenuManager.setShortcut(jMenuItem19, "shortcut.menu.help.help");
        jMenu10.add(jMenuItem19);
        jMenu10.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SHOW_KEYS));
        jMenu10.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ABOUT));
        jMenu10.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHECK_VERSION));
        jMenuBar.add(jMenu10);
        return jMenuBar;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction, boolean bl) {
        JMenuItem jMenuItem = MenuManager.makeMenuItem(genericFunction);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction) {
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText(genericFunction.getNameKey()));
        jMenuItem.addActionListener(new FunctionLauncher(genericFunction));
        return jMenuItem;
    }

    private static void setAltKey(JMenu jMenu, String string) {
        int n;
        String string2 = I18nManager.getText(string);
        if (string2 != null && string2.length() == 1 && (n = string2.charAt(0) - 65) >= 0 && n < 26) {
            jMenu.setMnemonic(KEY_EVENTS[n]);
        }
    }

    private static void setShortcut(JMenuItem jMenuItem, String string) {
        int n;
        String string2 = I18nManager.getText(string);
        if (string2 != null && string2.length() == 1 && (n = string2.charAt(0) - 65) >= 0 && n < 26) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(KEY_EVENTS[n], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton(IconManager.getImageIcon("add_textfile_icon.png"));
        jButton.setToolTipText(I18nManager.getText("function.open"));
        jButton.addActionListener(this._openFileAction);
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(IconManager.getImageIcon("add_photo_icon.png"));
        jButton2.setToolTipText(I18nManager.getText("menu.file.addphotos"));
        jButton2.addActionListener(this._addPhotoAction);
        jToolBar.add(jButton2);
        this._saveButton = new JButton(IconManager.getImageIcon("save_icon.gif"));
        this._saveButton.setToolTipText(I18nManager.getText("menu.file.save"));
        this._saveButton.addActionListener(this._saveAction);
        this._saveButton.setEnabled(false);
        jToolBar.add(this._saveButton);
        this._undoButton = new JButton(IconManager.getImageIcon("undo_icon.gif"));
        this._undoButton.setToolTipText(I18nManager.getText("menu.track.undo"));
        this._undoButton.addActionListener(this._undoAction);
        this._undoButton.setEnabled(false);
        jToolBar.add(this._undoButton);
        this._editPointButton = new JButton(IconManager.getImageIcon("edit_point_icon.gif"));
        this._editPointButton.setToolTipText(I18nManager.getText("menu.point.editpoint"));
        this._editPointButton.addActionListener(this._editPointAction);
        this._editPointButton.setEnabled(false);
        jToolBar.add(this._editPointButton);
        this._deletePointButton = new JButton(IconManager.getImageIcon("delete_point_icon.gif"));
        this._deletePointButton.setToolTipText(I18nManager.getText("menu.point.deletepoint"));
        this._deletePointButton.addActionListener(this._deletePointAction);
        this._deletePointButton.setEnabled(false);
        jToolBar.add(this._deletePointButton);
        this._deleteRangeButton = new JButton(IconManager.getImageIcon("delete_range_icon.gif"));
        this._deleteRangeButton.setToolTipText(I18nManager.getText("function.deleterange"));
        this._deleteRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_DELETE_RANGE.begin();
            }
        });
        this._deleteRangeButton.setEnabled(false);
        jToolBar.add(this._deleteRangeButton);
        this._cutAndMoveButton = new JButton(IconManager.getImageIcon("cut_and_move.gif"));
        this._cutAndMoveButton.setToolTipText(I18nManager.getText("menu.range.cutandmove"));
        this._cutAndMoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.cutAndMoveSelection();
            }
        });
        this._cutAndMoveButton.setEnabled(false);
        jToolBar.add(this._cutAndMoveButton);
        this._selectStartButton = new JButton(IconManager.getImageIcon("set_start_icon.png"));
        this._selectStartButton.setToolTipText(I18nManager.getText("menu.range.start"));
        this._selectStartButton.addActionListener(this._selectStartAction);
        this._selectStartButton.setEnabled(false);
        jToolBar.add(this._selectStartButton);
        this._selectEndButton = new JButton(IconManager.getImageIcon("set_end_icon.png"));
        this._selectEndButton.setToolTipText(I18nManager.getText("menu.range.end"));
        this._selectEndButton.addActionListener(this._selectEndAction);
        this._selectEndButton.setEnabled(false);
        jToolBar.add(this._selectEndButton);
        this._connectButton = new JButton(IconManager.getImageIcon("link.gif"));
        this._connectButton.setToolTipText(I18nManager.getText(FunctionLibrary.FUNCTION_CONNECT_TO_POINT.getNameKey()));
        this._connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_CONNECT_TO_POINT.begin();
            }
        });
        this._connectButton.setEnabled(false);
        jToolBar.add(this._connectButton);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public void informFileLoaded() {
        this._sendGpsItem.setEnabled(true);
        this._saveItem.setEnabled(true);
        this._undoItem.setEnabled(true);
        this._compressItem.setEnabled(true);
        this._deleteMarkedPointsItem.setEnabled(false);
    }

    @Override
    public void dataUpdated(byte by) {
        block6: {
            RecentFileList recentFileList;
            int n;
            boolean bl = this._track != null && this._track.getNumPoints() > 0;
            boolean bl2 = bl && this._track.getNumPoints() > 1;
            this._sendGpsItem.setEnabled(bl);
            this._saveItem.setEnabled(bl);
            this._saveButton.setEnabled(bl);
            this._exportKmlItem.setEnabled(bl);
            this._exportGpxItem.setEnabled(bl);
            this._exportPovItem.setEnabled(bl2);
            this._exportImageItem.setEnabled(bl2);
            this._compressItem.setEnabled(bl);
            this._markRectangleItem.setEnabled(bl);
            this._markUphillLiftsItem.setEnabled(bl && this._track.hasAltitudeData());
            this._deleteMarkedPointsItem.setEnabled(bl && this._track.hasMarkedPoints());
            this._rearrangeWaypointsItem.setEnabled(bl && this._track.hasWaypoints() && this._track.getNumPoints() > 1);
            boolean bl3 = bl && this._track.hasTrackPoints() && this._track.getNumPoints() > 3;
            this._splitSegmentsItem.setEnabled(bl3);
            this._sewSegmentsItem.setEnabled(bl3);
            this._createMarkerWaypointsItem.setEnabled(bl3);
            this._selectAllItem.setEnabled(bl);
            this._selectNoneItem.setEnabled(bl);
            this._show3dItem.setEnabled(bl2);
            this._chartItem.setEnabled(bl);
            this._browserMapMenu.setEnabled(bl);
            this._distanceItem.setEnabled(bl);
            this._autoplayTrack.setEnabled(bl && this._track.getNumPoints() > 3);
            this._lookupSrtmItem.setEnabled(bl);
            this._nearbyWikipediaItem.setEnabled(bl);
            this._nearbyOsmPoiItem.setEnabled(bl);
            this._downloadOsmItem.setEnabled(bl);
            this._getWeatherItem.setEnabled(bl);
            this._findWaypointItem.setEnabled(bl && this._track.hasWaypoints());
            this._deleteByDateItem.setEnabled(bl && this._track.hasData(Field.TIMESTAMP));
            boolean bl4 = !this._app.getUndoStack().isEmpty();
            this._undoItem.setEnabled(bl4);
            this._undoButton.setEnabled(bl4);
            this._clearUndoItem.setEnabled(bl4);
            DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
            boolean bl5 = dataPoint != null;
            this._editPointItem.setEnabled(bl5);
            this._editPointButton.setEnabled(bl5);
            this._editWaypointNameItem.setEnabled(bl5);
            this._deletePointItem.setEnabled(bl5);
            this._deletePointButton.setEnabled(bl5);
            this._truncatePointCoordsItem.setEnabled(bl5);
            this._selectStartItem.setEnabled(bl5);
            this._selectStartButton.setEnabled(bl5);
            this._selectEndItem.setEnabled(bl5);
            this._selectEndButton.setEnabled(bl5);
            this._duplicatePointItem.setEnabled(bl5);
            this._projectPointItem.setEnabled(bl5);
            this._projectCircleItem.setEnabled(bl5);
            this._showPeakfinderItem.setEnabled(bl5);
            this._showGeohackItem.setEnabled(bl5);
            this._searchOpencachingDeItem.setEnabled(bl5);
            this._searchMapillaryItem.setEnabled(bl5);
            this._selectSegmentItem.setEnabled(bl5 && !dataPoint.isWaypoint());
            boolean bl6 = this._app.getTrackInfo().getPhotoList().getNumPhotos() > 0;
            this._saveExifItem.setEnabled(bl6 && this._app.getTrackInfo().getPhotoList().hasMediaWithFile());
            Photo photo = this._app.getTrackInfo().getCurrentPhoto();
            boolean bl7 = photo != null;
            AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
            boolean bl8 = audioClip != null;
            boolean bl9 = bl7 && bl5 && photo.getDataPoint() == null || bl8 && bl5 && audioClip.getDataPoint() == null;
            this._connectPhotoItem.setEnabled(bl7 && bl5 && photo.getDataPoint() == null);
            this._connectButton.setEnabled(bl9);
            this._disconnectPhotoItem.setEnabled(bl7 && photo.getDataPoint() != null);
            this._correlatePhotosItem.setEnabled(bl6 && bl);
            this._rearrangePhotosItem.setEnabled(bl6 && bl2);
            this._removePhotoItem.setEnabled(bl7);
            this._rotatePhotoLeft.setEnabled(bl7);
            this._rotatePhotoRight.setEnabled(bl7);
            this._photoPopupItem.setEnabled(bl7);
            this._ignoreExifThumb.setEnabled(bl7 && photo.getExifThumbnail() != null);
            this._selectNoPhotoItem.setEnabled(bl7);
            boolean bl10 = this._app.getTrackInfo().getAudioList().getNumAudios() > 0;
            this._selectNoAudioItem.setEnabled(bl8);
            this._removeAudioItem.setEnabled(bl8);
            this._connectAudioItem.setEnabled(bl8 && bl5 && audioClip.getDataPoint() == null);
            this._disconnectAudioItem.setEnabled(bl8 && audioClip.getDataPoint() != null);
            this._correlateAudiosItem.setEnabled(bl10 && bl);
            boolean bl11 = bl && this._selection.hasRangeSelected();
            this._deleteRangeItem.setEnabled(bl11);
            this._deleteRangeButton.setEnabled(bl11);
            this._cropTrackItem.setEnabled(bl11);
            this._interpolateItem.setEnabled(bl11);
            this._averageItem.setEnabled(bl11);
            this._mergeSegmentsItem.setEnabled(bl11);
            this._reverseItem.setEnabled(bl11);
            this._addTimeOffsetItem.setEnabled(bl11);
            this._addAltitudeOffsetItem.setEnabled(bl11);
            this._convertNamesToTimesItem.setEnabled(bl11 && this._track.hasWaypoints());
            this._deleteFieldValuesItem.setEnabled(bl11);
            this._viewFullDetailsItem.setEnabled(bl11 || bl5);
            this._estimateTimeItem.setEnabled(bl11);
            this._learnEstimationParams.setEnabled(bl && this._track.hasTrackPoints() && this._track.hasData(Field.TIMESTAMP) && this._track.hasAltitudeData());
            boolean bl12 = bl11 && bl5 && (this._selection.getCurrentPointIndex() < this._selection.getStart() || this._selection.getCurrentPointIndex() > this._selection.getEnd() + 1);
            this._cutAndMoveItem.setEnabled(bl12);
            this._cutAndMoveButton.setEnabled(bl12);
            boolean bl13 = bl && this._track.getNumPoints() == 2;
            this._routingGraphHopperItem.setEnabled(bl13 || bl && bl11);
            boolean bl14 = Config.getConfigBoolean("prune.showmap");
            if (this._mapCheckbox.isSelected() != bl14) {
                this._mapCheckbox.setSelected(bl14);
            }
            boolean bl15 = (n = (recentFileList = Config.getRecentFileList()).getNumEntries()) > 0;
            this._recentFileMenu.setEnabled(bl15);
            if (!bl15) break block6;
            int n2 = this._recentFileMenu.getMenuComponentCount();
            if (n2 == n) {
                int n3 = 0;
                while (n3 < n) {
                    JMenuItem jMenuItem = this._recentFileMenu.getItem(n3);
                    RecentFile recentFile = recentFileList.getFile(n3);
                    jMenuItem.setText(recentFile == null ? "" : recentFile.getFile().getName());
                    jMenuItem.setToolTipText(recentFile == null ? null : recentFile.getFile().getAbsolutePath());
                    ++n3;
                }
            } else {
                recentFileList.verifyAll();
                this._recentFileMenu.removeAll();
                int n4 = 0;
                while (n4 < recentFileList.getSize()) {
                    RecentFile recentFile = recentFileList.getFile(n4);
                    if (recentFile != null && recentFile.isValid()) {
                        JMenuItem jMenuItem = new JMenuItem(recentFile.getFile().getName());
                        jMenuItem.setToolTipText(recentFile.getFile().getAbsolutePath());
                        jMenuItem.addActionListener(new RecentFileTrigger(this._app, n4));
                        this._recentFileMenu.add(jMenuItem);
                    }
                    ++n4;
                }
            }
        }
    }

    @Override
    public void actionCompleted(String string) {
    }
}

