/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.config.Config;
import tim.prune.gui.map.CacheFailure;
import tim.prune.gui.map.DiskTileCacher;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.MapTile;
import tim.prune.gui.map.MemTileCacher;
import tim.prune.gui.map.TileConsumer;
import tim.prune.gui.map.TileDownloader;

public class MapTileManager
implements ImageObserver {
    private TileConsumer _consumer = null;
    private MapSource _mapSource = null;
    private MemTileCacher[] _tempCaches = null;
    private boolean _downloadTiles = true;
    private boolean _returnIncompleteImages = false;
    private int _numLayers = -1;
    private int _zoom = 0;
    private int _numTileIndices = 1;

    public MapTileManager(TileConsumer tileConsumer) {
        this._consumer = tileConsumer;
    }

    public void centreMap(int n, int n2, int n3) {
        this.setZoom(n);
        if (this._tempCaches != null) {
            MemTileCacher[] memTileCacherArray = this._tempCaches;
            int n4 = this._tempCaches.length;
            int n5 = 0;
            while (n5 < n4) {
                MemTileCacher memTileCacher = memTileCacherArray[n5];
                memTileCacher.centreMap(n, n2, n3);
                ++n5;
            }
        }
    }

    public void setZoom(int n) {
        this._zoom = n;
        this._numTileIndices = 1 << this._zoom;
    }

    public boolean isOverzoomed() {
        int n;
        int n2 = n = this._mapSource == null ? 0 : this._mapSource.getMaxZoomLevel();
        return this._zoom > n;
    }

    public void enableTileDownloading(boolean bl) {
        this._downloadTiles = bl;
    }

    public void setReturnIncompleteImages() {
        this._returnIncompleteImages = true;
    }

    public void clearMemoryCaches() {
        int n = this._mapSource.getNumLayers();
        if (this._tempCaches == null || this._tempCaches.length != n) {
            this._tempCaches = new MemTileCacher[n];
            int n2 = 0;
            while (n2 < n) {
                this._tempCaches[n2] = new MemTileCacher();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                this._tempCaches[n3].clearAll();
                ++n3;
            }
        }
    }

    public void setMapSource(int n) {
        this.setMapSource(MapSourceLibrary.getSource(n));
    }

    public void setMapSource(MapSource mapSource) {
        this._mapSource = mapSource;
        if (this._mapSource == null) {
            this._mapSource = MapSourceLibrary.getSource(0);
        }
        this.clearMemoryCaches();
        this._numLayers = this._mapSource.getNumLayers();
    }

    public int getNumLayers() {
        return this._numLayers;
    }

    public Image getTile(int n, int n2, int n3, boolean bl) {
        boolean bl2;
        if (n3 < 0 || n3 >= this._numTileIndices) {
            return null;
        }
        n2 = (n2 % this._numTileIndices + this._numTileIndices) % this._numTileIndices;
        Image image = null;
        MemTileCacher memTileCacher = null;
        if (this._tempCaches != null && (image = (memTileCacher = this._tempCaches[n]).getTile(n2, n3)) != null) {
            return image;
        }
        String string = Config.getConfigString("prune.diskcache");
        boolean bl3 = string != null;
        boolean bl4 = Config.getConfigBoolean("prune.onlinemode");
        MapTile mapTile = null;
        if (bl3 && (mapTile = DiskTileCacher.getTile(string, this._mapSource.makeFilePath(n, this._zoom, n2, n3))) != null && mapTile.getImage() != null) {
            image = mapTile.getImage();
            if (this._returnIncompleteImages) {
                return image;
            }
            if (memTileCacher != null) {
                memTileCacher.setTile(image, n2, n3, this._zoom);
            }
            image.getWidth(this);
        }
        boolean bl5 = bl2 = image == null || mapTile == null || mapTile.isExpired();
        if (bl4 && this._downloadTiles && bl && bl2) {
            try {
                URL uRL = new URL(this._mapSource.makeURL(n, this._zoom, n2, n3));
                if (bl3) {
                    DiskTileCacher.saveTile(uRL, string, this._mapSource.makeFilePath(n, this._zoom, n2, n3), this);
                } else {
                    TileDownloader.triggerLoad(this, uRL, n, n2, n3, this._zoom);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (CacheFailure cacheFailure) {
                this._consumer.reportCacheFailure();
            }
        }
        return image;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = (n & 0x20) > 0;
        boolean bl3 = bl = (n & 0x40) > 0;
        if (bl2 || bl) {
            this._consumer.tilesUpdated(bl2);
        }
        return !bl2;
    }

    public void notifyImageLoaded(Image image, int n, int n2, int n3, int n4) {
        if (image != null && this._tempCaches != null) {
            MemTileCacher memTileCacher = this._tempCaches[n];
            if (memTileCacher.getTile(n2, n3) == null) {
                memTileCacher.setTile(image, n2, n3, n4);
                image.getWidth(this);
            }
        } else if (image != null) {
            image.getWidth(this);
        }
    }
}

