/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs3.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs3.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.UDPCleanupRunner;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySenderThread;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.jcs3.utils.net.HostNameUtil;

public class UDPDiscoveryService
implements IShutdownObserver,
IRequireScheduler {
    private static final Log log = LogManager.getLog(UDPDiscoveryService.class);
    private Thread udpReceiverThread;
    private UDPDiscoveryReceiver receiver;
    private UDPDiscoverySenderThread sender = null;
    private UDPDiscoveryAttributes udpDiscoveryAttributes = null;
    private boolean shutdown = false;
    private final Set<DiscoveredService> discoveredServices = new CopyOnWriteArraySet<DiscoveredService>();
    private final Set<String> cacheNames = new CopyOnWriteArraySet<String>();
    private final Set<IDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<IDiscoveryListener>();

    public UDPDiscoveryService(UDPDiscoveryAttributes attributes) {
        this.udpDiscoveryAttributes = attributes.clone();
        try {
            this.udpDiscoveryAttributes.setServiceAddress(HostNameUtil.getLocalHostAddress());
        }
        catch (UnknownHostException e) {
            log.error("Couldn't get localhost address", e);
        }
        try {
            this.receiver = new UDPDiscoveryReceiver(this, this.getUdpDiscoveryAttributes().getUdpDiscoveryInterface(), this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort());
        }
        catch (IOException e) {
            log.error("Problem creating UDPDiscoveryReceiver, address [{0}] port [{1}] we won't be able to find any other caches", this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort(), e);
        }
        this.sender = new UDPDiscoverySenderThread(this.getUdpDiscoveryAttributes(), this.getCacheNames());
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.sender != null) {
            scheduledExecutor.scheduleAtFixedRate(this.sender, 0L, 15L, TimeUnit.SECONDS);
        }
        UDPCleanupRunner cleanup = new UDPCleanupRunner(this);
        scheduledExecutor.scheduleAtFixedRate(cleanup, 0L, this.getUdpDiscoveryAttributes().getMaxIdleTimeSec(), TimeUnit.SECONDS);
    }

    protected void serviceRequestBroadcast() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort(), this.getUdpDiscoveryAttributes().getUdpTTL());){
            sender.passiveBroadcast(this.getUdpDiscoveryAttributes().getServiceAddress(), this.getUdpDiscoveryAttributes().getServicePort(), this.getCacheNames());
            log.debug("Called sender to issue a passive broadcast");
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender, address [{0}] port [{1}]", this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort(), e);
        }
    }

    public void addParticipatingCacheName(String cacheName) {
        this.cacheNames.add(cacheName);
        this.sender.setCacheNames(this.getCacheNames());
    }

    public void removeDiscoveredService(DiscoveredService service) {
        boolean contained = this.getDiscoveredServices().remove(service);
        if (contained) {
            log.info("Removing {0}", service);
        }
        for (IDiscoveryListener listener : this.getDiscoveryListeners()) {
            listener.removeDiscoveredService(service);
        }
    }

    protected void addOrUpdateService(DiscoveredService discoveredService) {
        Set<DiscoveredService> discoveredServices = this.getDiscoveredServices();
        if (!discoveredServices.contains(discoveredService)) {
            log.info("Set does not contain service. I discovered {0}", discoveredService);
            log.debug("Adding service in the set {0}", discoveredService);
            discoveredServices.add(discoveredService);
        } else {
            log.debug("Set contains service.");
            log.debug("Updating service in the set {0}", discoveredService);
            DiscoveredService theOldServiceInformation = null;
            for (DiscoveredService service1 : discoveredServices) {
                if (!discoveredService.equals(service1)) continue;
                theOldServiceInformation = service1;
                break;
            }
            if (theOldServiceInformation != null && !theOldServiceInformation.getCacheNames().equals(discoveredService.getCacheNames())) {
                log.info("List of cache names changed for service: {0}", discoveredService);
            }
            discoveredServices.remove(discoveredService);
            discoveredServices.add(discoveredService);
        }
        for (IDiscoveryListener listener : this.getDiscoveryListeners()) {
            listener.addDiscoveredService(discoveredService);
        }
    }

    protected ArrayList<String> getCacheNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.cacheNames);
        return names;
    }

    public void setUdpDiscoveryAttributes(UDPDiscoveryAttributes attr) {
        this.udpDiscoveryAttributes = attr;
    }

    public UDPDiscoveryAttributes getUdpDiscoveryAttributes() {
        return this.udpDiscoveryAttributes;
    }

    public void startup() {
        this.udpReceiverThread = new Thread(this.receiver);
        this.udpReceiverThread.setDaemon(true);
        this.udpReceiverThread.start();
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (this.receiver != null) {
                log.info("Shutting down UDP discovery service receiver.");
                this.receiver.shutdown();
                this.udpReceiverThread.interrupt();
            }
            if (this.sender != null) {
                log.info("Shutting down UDP discovery service sender.");
                this.sender.shutdown();
            }
        } else {
            log.debug("Shutdown already called.");
        }
    }

    public Set<DiscoveredService> getDiscoveredServices() {
        return this.discoveredServices;
    }

    private Set<IDiscoveryListener> getDiscoveryListeners() {
        return this.discoveryListeners;
    }

    public Set<IDiscoveryListener> getCopyOfDiscoveryListeners() {
        HashSet<IDiscoveryListener> copy = new HashSet<IDiscoveryListener>();
        copy.addAll(this.getDiscoveryListeners());
        return copy;
    }

    public boolean addDiscoveryListener(IDiscoveryListener listener) {
        return this.getDiscoveryListeners().add(listener);
    }

    public boolean removeDiscoveryListener(IDiscoveryListener listener) {
        return this.getDiscoveryListeners().remove(listener);
    }
}

