/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.SSLSession;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.util.ByteList;

public class SSLSocket
extends RubyObject {
    private static final long serialVersionUID = -2084816623554406237L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new SSLSocket(runtime, klass);
        }
    };
    private SSLContext sslContext;
    private SSLEngine engine;
    private RubyIO io;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer netData;
    private ByteBuffer dummy;
    private boolean initialHandshake = false;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private SSLEngineResult.Status status;
    int verifyResult = 0;
    private static final int READ_WOULD_BLOCK_RESULT = -2147483647;
    private static final int WRITE_WOULD_BLOCK_RESULT = -2147483646;
    private transient SSLSession session;
    private transient SSLSession setSession = null;
    private transient SocketChannelImpl socketChannel;

    public static void createSSLSocket(Ruby runtime, RubyModule SSL2) {
        CallSiteIndex[] values = CallSiteIndex.values();
        CallSite[] extraCallSites = new CallSite[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            extraCallSites[i2] = values[i2].name().startsWith("_respond_to") ? new RespondToCallSite() : new FunctionalCachingCallSite(values[i2].method);
        }
        RubyClass SSLSocket2 = runtime.defineClassUnder("SSLSocket", runtime.getObject(), ALLOCATOR, SSL2, extraCallSites);
        ThreadContext context2 = runtime.getCurrentContext();
        SSLSocket2.addReadWriteAttribute(context2, "sync_close");
        SSLSocket2.addReadWriteAttribute(context2, "hostname");
        SSLSocket2.defineAnnotatedMethods(SSLSocket.class);
        SSLSocket2.undefineMethod("dup");
    }

    public SSLSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private static RaiseException newSSLError(Ruby runtime, Exception exception) {
        return SSL.newSSLError(runtime, exception);
    }

    private static RaiseException newSSLError(Ruby runtime, String message) {
        return SSL.newSSLError(runtime, message);
    }

    private static RaiseException newSSLErrorFromHandshake(Ruby runtime, SSLHandshakeException exception) {
        Exception cause = exception;
        while (cause.getCause() != null && cause instanceof SSLHandshakeException) {
            cause = (Exception)cause.getCause();
        }
        return SSL.newSSLError(runtime, cause);
    }

    private static CallSite callSite(CallSite[] sites, CallSiteIndex index) {
        return sites[index.ordinal()];
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        this.sslContext = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2) == 1 ? new SSLContext(runtime).initializeImpl() : (SSLContext)args[1];
        if (!(args[0] instanceof RubyIO)) {
            throw runtime.newTypeError("IO expected but got " + args[0].getMetaClass().getName());
        }
        this.setInstanceVariable("@context", (IRubyObject)this.sslContext);
        this.io = (RubyIO)args[0];
        this.setInstanceVariable("@io", (IRubyObject)this.io);
        this.set_io_nonblock_checked(context2, runtime.getTrue());
        this.set_sync(context2, (IRubyObject)runtime.getTrue());
        this.setInstanceVariable("@sync_close", (IRubyObject)runtime.getFalse());
        this.sslContext.setup(context2);
        return Utils.invokeSuper(context2, (IRubyObject)this, args, Block.NULL_BLOCK);
    }

    private IRubyObject set_io_nonblock_checked(ThreadContext context2, RubyBoolean value2) {
        CallSite[] sites = this.getMetaClass().getExtraCallSites();
        if (sites == null) {
            return this.fallback_set_io_nonblock_checked(context2, value2);
        }
        IRubyObject respond = SSLSocket.callSite(sites, CallSiteIndex._respond_to_nonblock_w).call(context2, (IRubyObject)this.io, (IRubyObject)this.io, (IRubyObject)context2.runtime.newSymbol("nonblock="));
        if (respond.isTrue()) {
            return SSLSocket.callSite(sites, CallSiteIndex.nonblock_w).call(context2, (IRubyObject)this.io, (IRubyObject)this.io, (IRubyObject)value2);
        }
        return context2.nil;
    }

    private IRubyObject fallback_set_io_nonblock_checked(ThreadContext context2, RubyBoolean value2) {
        if (this.io.respondsTo("nonblock=")) {
            return this.io.callMethod(context2, "nonblock=", (IRubyObject)value2);
        }
        return context2.nil;
    }

    private SSLEngine ossl_ssl_setup(ThreadContext context2, boolean server) {
        SSLEngine engine = this.engine;
        if (engine != null) {
            return engine;
        }
        IRubyObject hostname = this.getInstanceVariable("@hostname");
        String peerHost = hostname == null ? null : hostname.toString();
        int peerPort = this.socketChannelImpl().getRemotePort();
        engine = this.sslContext.createSSLEngine(peerHost, peerPort);
        javax.net.ssl.SSLSession session2 = engine.getSession();
        this.peerNetData = ByteBuffer.allocate(session2.getPacketBufferSize());
        this.peerAppData = ByteBuffer.allocate(session2.getApplicationBufferSize());
        this.netData = ByteBuffer.allocate(session2.getPacketBufferSize());
        this.peerNetData.limit(0);
        this.peerAppData.limit(0);
        this.netData.limit(0);
        this.dummy = ByteBuffer.allocate(0);
        this.engine = engine;
        this.copySessionSetupIfSet(context2);
        this.sslContext.setApplicationProtocolsOrSelector(engine);
        return engine;
    }

    @JRubyMethod(name={"io"}, alias={"to_io"})
    public final RubyIO io() {
        return this.io;
    }

    @JRubyMethod(name={"context"})
    public final SSLContext context() {
        return this.sslContext;
    }

    @JRubyMethod(name={"alpn_protocol"})
    public IRubyObject alpn_protocol(ThreadContext context2) {
        String protocol = this.engine.getApplicationProtocol();
        return protocol == null ? context2.nil : RubyString.newString((Ruby)context2.runtime, (String)protocol);
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext context2) {
        CallSite[] sites = this.getMetaClass().getExtraCallSites();
        if (sites == null) {
            return this.fallback_sync(context2);
        }
        return SSLSocket.callSite(sites, CallSiteIndex.sync).call(context2, (IRubyObject)this.io, (IRubyObject)this.io);
    }

    private IRubyObject fallback_sync(ThreadContext context2) {
        return this.io.callMethod(context2, "sync");
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject set_sync(ThreadContext context2, IRubyObject sync2) {
        CallSite[] sites = this.getMetaClass().getExtraCallSites();
        if (sites == null) {
            return this.fallback_set_sync(context2, sync2);
        }
        return SSLSocket.callSite(sites, CallSiteIndex.sync_w).call(context2, (IRubyObject)this.io, (IRubyObject)this.io, sync2);
    }

    private IRubyObject fallback_set_sync(ThreadContext context2, IRubyObject sync2) {
        return this.io.callMethod(context2, "sync=", sync2);
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context2) {
        return this.connectImpl(context2, true, true);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context2) {
        return this.connectImpl(context2, false, true);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context2, IRubyObject opts) {
        return this.connectImpl(context2, false, SSLSocket.getExceptionOpt(context2, opts));
    }

    private IRubyObject connectImpl(ThreadContext context2, boolean blocking, boolean exception) {
        if (!this.sslContext.isProtocolForClient()) {
            throw SSLSocket.newSSLError(context2.runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                SSLEngine engine = this.ossl_ssl_setup(context2, false);
                engine.setUseClientMode(true);
                engine.beginHandshake();
                this.handshakeStatus = engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.callRenegotiationCallback(context2);
            IRubyObject ex = this.doHandshake(blocking, exception);
            if (ex != null) {
                return ex;
            }
        }
        catch (SSLHandshakeException e) {
            this.forceClose();
            throw SSLSocket.newSSLErrorFromHandshake(context2.runtime, e);
        }
        catch (IOException e) {
            this.forceClose();
            throw SSLSocket.newSSLError(context2.runtime, e);
        }
        catch (NotYetConnectedException e) {
            throw SSLSocket.newErrnoEPIPEError(context2.runtime, "SSL_connect");
        }
        return this;
    }

    private static RaiseException newErrnoEPIPEError(Ruby runtime, String detail) {
        return Utils.newError(runtime, runtime.getErrno().getClass("EPIPE"), detail);
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context2) {
        return this.acceptImpl(context2, true, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context2) {
        return this.acceptImpl(context2, false, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context2, IRubyObject opts) {
        return this.acceptImpl(context2, false, SSLSocket.getExceptionOpt(context2, opts));
    }

    @Deprecated
    public SSLSocket acceptCommon(ThreadContext context2, boolean blocking) {
        return (SSLSocket)this.acceptImpl(context2, blocking, true);
    }

    private IRubyObject acceptImpl(ThreadContext context2, boolean blocking, boolean exception) {
        if (!this.sslContext.isProtocolForServer()) {
            throw SSLSocket.newSSLError(context2.runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                SSLEngine engine = this.ossl_ssl_setup(context2, true);
                engine.setUseClientMode(false);
                IRubyObject verify_mode = this.verify_mode(context2);
                if (verify_mode != context2.nil) {
                    int verify2 = RubyNumeric.fix2int((IRubyObject)verify_mode);
                    if (verify2 == 0) {
                        engine.setNeedClientAuth(false);
                        engine.setWantClientAuth(false);
                    }
                    if ((verify2 & 1) != 0) {
                        engine.setWantClientAuth(true);
                    }
                    if ((verify2 & 2) != 0) {
                        engine.setNeedClientAuth(true);
                    }
                }
                engine.beginHandshake();
                this.handshakeStatus = engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.callRenegotiationCallback(context2);
            IRubyObject ex = this.doHandshake(blocking, exception);
            if (ex != null) {
                return ex;
            }
        }
        catch (SSLHandshakeException e) {
            String msg = e.getMessage();
            if (e.getCause() == null && msg != null && msg.contains("(protocol is disabled or cipher suites are inappropriate)")) {
                OpenSSL.debug(context2.runtime, this.sslContext.getProtocol() + " protocol has been deactivated and is not available by default\n see the java.security.Security property jdk.tls.disabledAlgorithms in <JRE_HOME>/lib/security/java.security file");
            } else {
                OpenSSL.debugStackTrace(context2.runtime, e);
            }
            throw SSLSocket.newSSLErrorFromHandshake(context2.runtime, e);
        }
        catch (IOException e) {
            OpenSSL.debugStackTrace(context2.runtime, e);
            throw SSLSocket.newSSLError(context2.runtime, e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(context2.runtime, e);
            if ("Could not generate DH keypair".equals(e.getMessage())) {
                throw SSL.handleCouldNotGenerateDHKeyPairError(context2.runtime, e);
            }
            throw SSLSocket.newSSLError(context2.runtime, e);
        }
        return this;
    }

    final IRubyObject verify_mode(ThreadContext context2) {
        CallSite[] sites = this.getMetaClass().getExtraCallSites();
        if (sites == null) {
            return this.fallback_verify_mode(context2);
        }
        return SSLSocket.callSite(sites, CallSiteIndex.verify_mode).call(context2, (IRubyObject)this.sslContext, (IRubyObject)this.sslContext);
    }

    private IRubyObject fallback_verify_mode(ThreadContext context2) {
        return this.sslContext.callMethod(context2, "verify_mode");
    }

    @JRubyMethod
    public IRubyObject verify_result(ThreadContext context2) {
        if (this.engine == null) {
            context2.runtime.getWarnings().warn("SSL session is not started yet.");
            return context2.nil;
        }
        return context2.runtime.newFixnum(this.verifyResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object waitSelect(int operations, boolean blocking, boolean exception) throws IOException {
        channel = this.socketChannelImpl();
        if (!channel.isSelectable()) {
            return Boolean.TRUE;
        }
        runtime = this.getRuntime();
        thread = runtime.getCurrentContext().getThread();
        channel.configureBlocking(false);
        selector = runtime.getSelectorPool().get();
        key = channel.register(selector, operations);
        try {
            result = new int[1];
            if (!blocking) {
                try {
                    result[0] = selector.selectNow();
                    if (result[0] != 0) ** GOTO lbl31
                    if ((operations & 1) != 0 && (operations & 4) != 0) {
                        if (key.isReadable()) {
                            SSLSocket.writeWouldBlock(runtime, exception, result);
                        }
                        SSLSocket.readWouldBlock(runtime, exception, result);
                    }
                    if ((operations & 1) != 0) {
                        SSLSocket.readWouldBlock(runtime, exception, result);
                    }
                    if ((operations & 4) == 0) ** GOTO lbl31
                    SSLSocket.writeWouldBlock(runtime, exception, result);
                }
                catch (IOException ioe) {
                    throw runtime.newRuntimeError("Error with selector: " + ioe.getMessage());
                }
            } else {
                this.io.addBlockingThread(thread);
                thread.executeBlockingTask(new RubyThread.BlockingTask(){

                    public void run() throws InterruptedException {
                        try {
                            result[0] = selector.select();
                        }
                        catch (IOException ioe) {
                            throw runtime.newRuntimeError("Error with selector: " + ioe.getMessage());
                        }
                    }

                    public void wakeup() {
                        selector.wakeup();
                    }
                });
            }
lbl31:
            // 7 sources

            switch (result[0]) {
                case -2147483647: {
                    var10_12 = runtime.newSymbol("wait_readable");
                    return var10_12;
                }
                case -2147483646: {
                    var10_13 = runtime.newSymbol("wait_writable");
                    return var10_13;
                }
                case 0: {
                    var10_14 = Boolean.FALSE;
                    return var10_14;
                }
            }
            var10_15 = selector.selectedKeys().contains(key) != false ? Boolean.TRUE : Boolean.FALSE;
            return var10_15;
        }
        catch (InterruptedException interrupt) {
            var10_16 = Boolean.FALSE;
            return var10_16;
        }
        finally {
            try {
                if (key != null) {
                    key.cancel();
                }
                if (selector != null) {
                    selector.selectNow();
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
            try {
                if (selector != null) {
                    runtime.getSelectorPool().put(selector);
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
            if (blocking) {
                this.io.removeBlockingThread(thread);
                thread.afterBlockingCall();
            }
        }
    }

    private static void readWouldBlock(Ruby runtime, boolean exception, int[] result) {
        if (exception) {
            throw SSL.newSSLErrorWaitReadable(runtime, "read would block");
        }
        result[0] = -2147483647;
    }

    private static void writeWouldBlock(Ruby runtime, boolean exception, int[] result) {
        if (exception) {
            throw SSL.newSSLErrorWaitWritable(runtime, "write would block");
        }
        result[0] = -2147483646;
    }

    private void doHandshake(boolean blocking) throws IOException {
        this.doHandshake(blocking, true);
    }

    private IRubyObject doHandshake(boolean blocking, boolean exception) throws IOException {
        block6: while (true) {
            Object sel;
            if ((sel = this.waitSelect(5, blocking, exception)) instanceof IRubyObject) {
                return (IRubyObject)sel;
            }
            if (!blocking && sel != Boolean.TRUE) {
                throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            switch (this.handshakeStatus) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    if (this.initialHandshake) {
                        this.finishInitialHandshake();
                    }
                    return null;
                }
                case NEED_TASK: {
                    this.doTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    if (this.readAndUnwrap(blocking) == -1 && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                        throw new SSLHandshakeException("Socket closed");
                    }
                    if (!this.initialHandshake || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW || !((sel = this.waitSelect(1, blocking, exception)) instanceof IRubyObject)) continue block6;
                    return (IRubyObject)sel;
                }
                case NEED_WRAP: {
                    if (this.netData.hasRemaining()) {
                        while (this.flushData(blocking)) {
                        }
                    }
                    this.netData.clear();
                    SSLEngineResult result = this.engine.wrap(this.dummy, this.netData);
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.netData.flip();
                    this.flushData(blocking);
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown handshaking status: " + (Object)((Object)this.handshakeStatus));
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
        this.handshakeStatus = this.engine.getHandshakeStatus();
        this.verifyResult = this.sslContext.getLastVerifyResult();
    }

    private boolean flushData(boolean blocking) throws IOException {
        try {
            this.writeToChannel(this.netData, blocking);
        }
        catch (IOException ioe) {
            this.netData.position(this.netData.limit());
            throw ioe;
        }
        return this.netData.hasRemaining();
    }

    private int writeToChannel(ByteBuffer buffer, boolean blocking) throws IOException {
        int totalWritten = 0;
        while (buffer.hasRemaining()) {
            totalWritten += this.socketChannelImpl().write(buffer);
            if (blocking) continue;
            break;
        }
        return totalWritten;
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
    }

    private void callRenegotiationCallback(ThreadContext context2) throws RaiseException {
        IRubyObject renegotiationCallback = this.sslContext.getInstanceVariable("@renegotiation_cb");
        if (renegotiationCallback == null || renegotiationCallback.isNil()) {
            return;
        }
        renegotiationCallback.callMethod(context2, "call", (IRubyObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src, boolean blocking) throws SSLException, IOException {
        if (this.initialHandshake) {
            throw new IOException("Writing not possible during handshake");
        }
        SocketChannelImpl channel = this.socketChannelImpl();
        boolean blockingMode = channel.isBlocking();
        if (!blocking) {
            channel.configureBlocking(false);
        }
        try {
            if (this.netData.hasRemaining()) {
                this.flushData(blocking);
            }
            this.netData.clear();
            SSLEngineResult result = this.engine.wrap(src, this.netData);
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                throw this.getRuntime().newIOError("closed SSL engine");
            }
            this.netData.flip();
            this.flushData(blocking);
            int n = result.bytesConsumed();
            return n;
        }
        finally {
            if (!blocking) {
                channel.configureBlocking(blockingMode);
            }
        }
    }

    public int read(ByteBuffer dst, boolean blocking) throws IOException {
        int appBytesProduced;
        if (this.initialHandshake) {
            return 0;
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        if (!(this.peerAppData.hasRemaining() || (appBytesProduced = this.readAndUnwrap(blocking)) != -1 && appBytesProduced != 0)) {
            return appBytesProduced;
        }
        int limit = Math.min(this.peerAppData.remaining(), dst.remaining());
        this.peerAppData.get(dst.array(), dst.arrayOffset(), limit);
        dst.position(dst.arrayOffset() + limit);
        return limit;
    }

    private int readAndUnwrap(boolean blocking) throws IOException {
        SSLEngineResult result;
        int bytesRead = this.socketChannelImpl().read(this.peerNetData);
        if (!(bytesRead != -1 || this.peerNetData.hasRemaining() && this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
            this.closeInbound();
            return -1;
        }
        this.peerAppData.clear();
        this.peerNetData.flip();
        while ((result = this.engine.unwrap(this.peerNetData, this.peerAppData)).getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && result.bytesProduced() == 0) {
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishInitialHandshake();
        }
        if (this.peerAppData.position() == 0 && result.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
            result = this.engine.unwrap(this.peerNetData, this.peerAppData);
        }
        this.status = result.getStatus();
        this.handshakeStatus = result.getHandshakeStatus();
        if (bytesRead == -1 && !this.peerNetData.hasRemaining()) {
            this.closeInbound();
        }
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.doShutdown();
            return -1;
        }
        this.peerNetData.compact();
        this.peerAppData.flip();
        if (!(this.initialHandshake || this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.doHandshake(blocking);
        }
        return this.peerAppData.remaining();
    }

    private void closeInbound() {
        try {
            this.engine.closeInbound();
        }
        catch (SSLException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.closeInbound", e);
        }
    }

    private void doShutdown() throws IOException {
        if (this.engine.isOutboundDone()) {
            return;
        }
        this.netData.clear();
        try {
            this.engine.wrap(this.dummy, this.netData);
        }
        catch (SSLException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.doShutdown", e);
            return;
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(this.getRuntime(), e);
            return;
        }
        this.netData.flip();
        this.flushData(true);
    }

    private IRubyObject sysreadImpl(ThreadContext context2, IRubyObject len, IRubyObject buff, boolean blocking, boolean exception) {
        Ruby runtime = context2.runtime;
        int length = RubyNumeric.fix2int((IRubyObject)len);
        RubyString buffStr = buff != null && !buff.isNil() ? buff.asString() : RubyString.newEmptyString((Ruby)runtime);
        if (length == 0) {
            buffStr.clear();
            return buffStr;
        }
        if (length < 0) {
            throw runtime.newArgumentError("negative string size (or size too big)");
        }
        try {
            Object ex;
            if ((this.engine == null || !this.peerAppData.hasRemaining() && this.peerNetData.position() <= 0) && (ex = this.waitSelect(1, blocking, exception)) instanceof IRubyObject) {
                return (IRubyObject)ex;
            }
            ByteBuffer dst = ByteBuffer.allocate(length);
            int read2 = -1;
            while (read2 <= 0) {
                Object ex2;
                read2 = this.engine == null ? this.socketChannelImpl().read(dst) : this.read(dst, blocking);
                if (read2 == -1) {
                    if (exception) {
                        throw runtime.newEOFError();
                    }
                    return runtime.getNil();
                }
                if (read2 != 0 || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW || !((ex2 = this.waitSelect(1, blocking, exception)) instanceof IRubyObject)) continue;
                return (IRubyObject)ex2;
            }
            byte[] bytesRead = dst.array();
            int offset = dst.position() - read2;
            buffStr.setValue(new ByteList(bytesRead, offset, read2, false));
            return buffStr;
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject sysread(ThreadContext context2, IRubyObject len) {
        return this.sysreadImpl(context2, len, null, true, true);
    }

    @JRubyMethod
    public IRubyObject sysread(ThreadContext context2, IRubyObject len, IRubyObject buff) {
        return this.sysreadImpl(context2, len, buff, true, true);
    }

    @Deprecated
    public IRubyObject sysread(ThreadContext context2, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.sysread(context2, args[0]);
            }
            case 2: {
                return this.sysread(context2, args[0], args[1]);
            }
        }
        Arity.checkArgumentCount((Ruby)context2.runtime, (int)args.length, (int)1, (int)2);
        return null;
    }

    @JRubyMethod
    public IRubyObject sysread_nonblock(ThreadContext context2, IRubyObject len) {
        return this.sysreadImpl(context2, len, null, false, true);
    }

    @JRubyMethod
    public IRubyObject sysread_nonblock(ThreadContext context2, IRubyObject len, IRubyObject arg) {
        if (arg instanceof RubyHash) {
            return this.sysreadImpl(context2, len, null, false, SSLSocket.getExceptionOpt(context2, arg));
        }
        return this.sysreadImpl(context2, len, arg, false, true);
    }

    @JRubyMethod
    public IRubyObject sysread_nonblock(ThreadContext context2, IRubyObject len, IRubyObject buff, IRubyObject opts) {
        return this.sysreadImpl(context2, len, buff, false, SSLSocket.getExceptionOpt(context2, opts));
    }

    @Deprecated
    public IRubyObject sysread_nonblock(ThreadContext context2, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.sysread_nonblock(context2, args[0]);
            }
            case 2: {
                return this.sysread_nonblock(context2, args[0], args[1]);
            }
            case 3: {
                return this.sysread_nonblock(context2, args[0], args[1], args[2]);
            }
        }
        Arity.checkArgumentCount((Ruby)context2.runtime, (int)args.length, (int)1, (int)3);
        return null;
    }

    private IRubyObject syswriteImpl(ThreadContext context2, IRubyObject arg, boolean blocking, boolean exception) {
        Ruby runtime = context2.runtime;
        try {
            this.checkClosed();
            Object ex = this.waitSelect(4, blocking, exception);
            if (ex instanceof IRubyObject) {
                return (IRubyObject)ex;
            }
            ByteList bytes = arg.asString().getByteList();
            ByteBuffer buff = ByteBuffer.wrap(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize());
            int written = this.engine == null ? this.writeToChannel(buff, blocking) : this.write(buff, blocking);
            this.io_flush(context2);
            return runtime.newFixnum(written);
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    private IRubyObject io_flush(ThreadContext context2) {
        CallSite[] sites = this.getMetaClass().getExtraCallSites();
        if (sites == null) {
            return this.fallback_io_flush(context2);
        }
        return SSLSocket.callSite(sites, CallSiteIndex.flush).call(context2, (IRubyObject)this.io, (IRubyObject)this.io);
    }

    private IRubyObject fallback_io_flush(ThreadContext context2) {
        return this.io.callMethod(context2, "flush");
    }

    @JRubyMethod
    public IRubyObject syswrite(ThreadContext context2, IRubyObject arg) {
        return this.syswriteImpl(context2, arg, true, true);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context2, IRubyObject arg) {
        return this.syswriteImpl(context2, arg, false, true);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context2, IRubyObject arg, IRubyObject opts) {
        return this.syswriteImpl(context2, arg, false, SSLSocket.getExceptionOpt(context2, opts));
    }

    private static boolean getExceptionOpt(ThreadContext context2, IRubyObject opts) {
        if (opts instanceof RubyHash) {
            Ruby runtime = context2.runtime;
            IRubyObject exc = ((RubyHash)opts).op_aref(context2, (IRubyObject)runtime.newSymbol("exception"));
            return exc != runtime.getFalse();
        }
        return true;
    }

    private void checkClosed() {
        if (!this.socketChannelImpl().isOpen()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void forceClose() {
        this.close(true);
    }

    private void close(boolean force) {
        if (this.engine == null) {
            return;
        }
        this.engine.closeOutbound();
        if (!force && this.netData.hasRemaining()) {
            return;
        }
        try {
            this.doShutdown();
        }
        catch (IOException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.close doShutdown failed", e);
        }
        catch (NotYetConnectedException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.close doShutdown failed", e);
        }
    }

    @JRubyMethod
    public IRubyObject stop(ThreadContext context2) {
        this.close(this.sslContext.isProtocolForClient());
        return context2.nil;
    }

    @JRubyMethod
    public IRubyObject cert(ThreadContext context2) {
        if (this.engine == null) {
            return context2.nil;
        }
        try {
            Certificate[] cert2 = this.engine.getSession().getLocalCertificates();
            if (cert2 != null && cert2.length > 0) {
                return X509Cert.wrap(context2, cert2[0]);
            }
        }
        catch (CertificateEncodingException e) {
            throw X509Cert.newCertificateError(context2.runtime, e);
        }
        return context2.nil;
    }

    @Deprecated
    public final IRubyObject cert() {
        return this.cert(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject peer_cert(ThreadContext context2) {
        block5: {
            if (this.engine == null) {
                return context2.nil;
            }
            try {
                Certificate[] cert2 = this.engine.getSession().getPeerCertificates();
                if (cert2.length > 0) {
                    return X509Cert.wrap(context2, cert2[0]);
                }
            }
            catch (CertificateEncodingException e) {
                throw X509Cert.newCertificateError(context2.runtime, e);
            }
            catch (SSLPeerUnverifiedException e) {
                if (!OpenSSL.isDebug(context2.runtime)) break block5;
                context2.runtime.getWarnings().warning(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
            }
        }
        return context2.nil;
    }

    @Deprecated
    public final IRubyObject peer_cert() {
        return this.peer_cert(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject peer_cert_chain(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        if (this.engine == null) {
            return runtime.getNil();
        }
        try {
            Certificate[] certs = this.engine.getSession().getPeerCertificates();
            IRubyObject[] cert_chain = new IRubyObject[certs.length];
            for (int i2 = 0; i2 < certs.length; ++i2) {
                cert_chain[i2] = X509Cert.wrap(context2, certs[i2]);
            }
            return runtime.newArrayNoCopy(cert_chain);
        }
        catch (CertificateEncodingException e) {
            throw X509Cert.newCertificateError(runtime, e);
        }
        catch (SSLPeerUnverifiedException e) {
            if (runtime.isVerbose() || OpenSSL.isDebug(runtime)) {
                runtime.getWarnings().warning(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
            }
            return runtime.getNil();
        }
    }

    @Deprecated
    public final IRubyObject peer_cert_chain() {
        return this.peer_cert_chain(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject cipher() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString(this.engine.getSession().getCipherSuite());
    }

    @JRubyMethod
    public IRubyObject npn_protocol() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "OpenSSL::SSL::SSLSocket#npn_protocol is not supported");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject state() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: OpenSSL::SSL::SSLSocket#state");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject pending() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: OpenSSL::SSL::SSLSocket#pending");
        return this.getRuntime().getNil();
    }

    private boolean reusableSSLEngine() {
        String peerHost;
        return this.engine != null && (peerHost = this.engine.getPeerHost()) != null && peerHost.length() > 0;
    }

    @JRubyMethod(name={"session_reused?"})
    public IRubyObject session_reused_p() {
        if (this.reusableSSLEngine() && !this.engine.getEnableSessionCreation()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getNil();
    }

    final javax.net.ssl.SSLSession sslSession() {
        return this.engine == null ? null : this.engine.getSession();
    }

    @JRubyMethod(name={"session"})
    public IRubyObject session(ThreadContext context2) {
        if (this.sslSession() == null) {
            return context2.nil;
        }
        return this.getSession(context2.runtime);
    }

    private SSLSession getSession(Ruby runtime) {
        if (this.session == null) {
            this.session = new SSLSession(runtime).initializeImpl(this);
            return this.session;
        }
        return this.session;
    }

    @JRubyMethod(name={"session="})
    public IRubyObject set_session(ThreadContext context2, IRubyObject session2) {
        if (session2 instanceof SSLSession) {
            this.setSession = (SSLSession)session2;
            if (this.engine != null) {
                this.copySessionSetupIfSet(context2);
            }
        }
        return context2.nil;
    }

    @Deprecated
    public IRubyObject set_session(IRubyObject session2) {
        return this.set_session(this.getRuntime().getCurrentContext(), session2);
    }

    private void copySessionSetupIfSet(ThreadContext context2) {
        if (this.setSession != null && this.reusableSSLEngine()) {
            this.engine.setEnableSessionCreation(false);
            if (!this.setSession.equals((Object)this.getSession(context2.runtime))) {
                this.getSession(context2.runtime).set_timeout(context2, this.setSession.timeout(context2));
            }
        }
    }

    @JRubyMethod
    public IRubyObject ssl_version(ThreadContext context2) {
        if (this.engine == null) {
            return context2.nil;
        }
        return context2.runtime.newString(this.engine.getSession().getProtocol());
    }

    private SocketChannelImpl socketChannelImpl() {
        if (this.socketChannel != null) {
            return this.socketChannel;
        }
        Channel channel = this.io.getChannel();
        if (channel instanceof SocketChannel) {
            this.socketChannel = new JavaSocketChannel((SocketChannel)channel);
            return this.socketChannel;
        }
        throw new IllegalStateException("unknow channel impl: " + channel + " of type " + channel.getClass().getName());
    }

    private static boolean jnrChannel(Channel channel) {
        return channel.getClass().getName().startsWith("jnr.");
    }

    private static final class JavaSocketChannel
    implements SocketChannelImpl {
        private final SocketChannel channel;

        JavaSocketChannel(SocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.channel.read(dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        @Override
        public int getRemotePort() {
            return this.channel.socket().getPort();
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isBlocking() {
            return this.channel.isBlocking();
        }

        @Override
        public void configureBlocking(boolean block) throws IOException {
            this.channel.configureBlocking(block);
        }

        @Override
        public SelectionKey register(Selector selector, int ops) throws ClosedChannelException {
            return this.channel.register(selector, ops);
        }

        public boolean selectionOpsReadable(int readyOps) {
            return (readyOps & 1) != 0;
        }

        public boolean selectionOpsWritable(int readyOps) {
            return (readyOps & 4) != 0;
        }
    }

    private static interface SocketChannelImpl {
        public boolean isOpen();

        public int read(ByteBuffer var1) throws IOException;

        public int write(ByteBuffer var1) throws IOException;

        public int getRemotePort();

        public boolean isSelectable();

        public boolean isBlocking();

        public void configureBlocking(boolean var1) throws IOException;

        public SelectionKey register(Selector var1, int var2) throws IOException;
    }

    private static enum CallSiteIndex {
        _respond_to_nonblock_w("nonblock="),
        nonblock_w("nonblock="),
        sync("sync"),
        sync_w("sync="),
        flush("flush"),
        verify_mode("verify_mode");

        final String method;

        private CallSiteIndex(String method) {
            this.method = method;
        }
    }
}

