/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.DecimalFormat;
import java.util.List;
import mediathek.config.Daten;
import mediathek.daten.DatenDownload;
import mediathek.daten.ListeDownloads;
import mediathek.gui.messages.DownloadInfoUpdateAvailableEvent;
import mediathek.gui.messages.TimerEvent;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;

public class DownloadInfos {
    private static final DecimalFormat formatter = new DecimalFormat("####0.00");
    private long bandwidth;
    private long timeRestAllDownloads;
    private long timeRestAktDownloads;
    private long byteAktDownloads;
    private long byteAlleDownloads;
    private int anzDownloadsRun;
    private String bandwidthStr = "";

    public DownloadInfos() {
        MessageBus.getMessageBus().subscribe(this);
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public long getTimeRestAllDownloads() {
        return this.timeRestAllDownloads;
    }

    public long getTimeRestAktDownloads() {
        return this.timeRestAktDownloads;
    }

    public long getByteAktDownloads() {
        return this.byteAktDownloads;
    }

    public long getByteAlleDownloads() {
        return this.byteAlleDownloads;
    }

    public String getBandwidthStr() {
        return this.bandwidthStr;
    }

    public void formatBandwidthString() {
        this.bandwidthStr = (double)this.bandwidth > 1000000.0 ? formatter.format((double)this.bandwidth / 1000000.0) + " MByte/s" : ((double)this.bandwidth > 1000.0 ? Math.round((double)this.bandwidth / 1000.0) + " kByte/s" : this.bandwidth + " Byte/s");
    }

    public String getGesamtRestzeit() {
        if (this.timeRestAllDownloads > 0L) {
            if (this.timeRestAllDownloads < 60L) {
                return "< 1 Min";
            }
            return this.timeRestAllDownloads / 60L + " Min";
        }
        return "";
    }

    public String getRestzeit() {
        if (this.timeRestAktDownloads > 0L) {
            if (this.timeRestAktDownloads < 60L) {
                return "< 1 Min";
            }
            return this.timeRestAktDownloads / 60L + " Min";
        }
        return "";
    }

    @Handler
    private void handleTimerEvent(TimerEvent e) {
        this.makeDownloadInfos();
    }

    private void makeDownloadInfos() {
        this.resetData();
        ListeDownloads listeDownloads = Daten.getInstance().getListeDownloads();
        List<DatenDownload> aktivDownloads = listeDownloads.getListOfStartsNotFinished(-1);
        for (DatenDownload download : aktivDownloads) {
            ++this.anzDownloadsRun;
            this.byteAlleDownloads += download.mVFilmSize.getSize() > 0L ? download.mVFilmSize.getSize() : 0L;
            if (download.start == null || download.start.status != 2) continue;
            this.bandwidth += download.start.bandbreite;
            this.byteAktDownloads += download.mVFilmSize.getAktSize() > 0L ? download.mVFilmSize.getAktSize() : 0L;
            if (download.start.restSekunden <= this.timeRestAktDownloads) continue;
            this.timeRestAktDownloads = download.start.restSekunden;
        }
        aktivDownloads.clear();
        if (this.bandwidth < 0L) {
            this.bandwidth = 0L;
        }
        if (this.bandwidth > 0L) {
            long b = this.byteAlleDownloads - this.byteAktDownloads;
            this.timeRestAllDownloads = b <= 0L ? 0L : b / this.bandwidth;
            if (this.timeRestAllDownloads < this.timeRestAktDownloads) {
                this.timeRestAllDownloads = this.timeRestAktDownloads;
            }
            if (this.anzDownloadsRun == 1) {
                this.timeRestAllDownloads = 0L;
            }
        }
        this.formatBandwidthString();
        MessageBus.getMessageBus().publishAsync(new DownloadInfoUpdateAvailableEvent());
    }

    private void resetData() {
        this.anzDownloadsRun = 0;
        this.byteAlleDownloads = 0L;
        this.byteAktDownloads = 0L;
        this.timeRestAktDownloads = 0L;
        this.timeRestAllDownloads = 0L;
        this.bandwidth = 0L;
    }
}

