/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.FileSize;
import okhttp3.HttpUrl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0004J\u001c\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u001b"}, d2={"Lmediathek/tool/MVInfoFile;", "", "()V", "appendFormattedTableLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "formatString", "", "keyTitle", "value", "formatFilmAsString", "film", "Lmediathek/daten/DatenFilm;", "url", "Lokhttp3/HttpUrl;", "splitStringIntoMaxFixedLengthLines", "input", "lineLength", "", "writeInfoFile", "", "datenDownload", "Lmediathek/daten/DatenDownload;", "path", "Ljava/nio/file/Path;", "Companion", "MediathekView"})
public class MVInfoFile {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    private static final Logger logger = LogManager.getLogger(MVInfoFile.class);
    @Deprecated
    @NotNull
    private static final String FILM_GROESSE = "Gr\u00f6\u00dfe";
    @Deprecated
    @NotNull
    private static final String FILM_SENDER = "Sender";
    @Deprecated
    @NotNull
    private static final String FILM_THEMA = "Thema";
    @Deprecated
    @NotNull
    private static final String FILM_TITEL = "Titel";
    @Deprecated
    @NotNull
    private static final String FILM_DATUM = "Datum";
    @Deprecated
    @NotNull
    private static final String FILM_ZEIT = "Zeit";
    @Deprecated
    @NotNull
    private static final String FILM_DAUER = "Dauer";
    @Deprecated
    @NotNull
    private static final String FILM_URL = "URL";
    @Deprecated
    private static final int MAX_HEADER_LENGTH = 12;
    @Deprecated
    private static final int MAX_LINE_LENGTH = 62;

    private final String formatFilmAsString(DatenFilm film, HttpUrl url) {
        if (film == null || url == null) {
            return "";
        }
        long fileSize = FileSize.getFileSizeFromUrl(url);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        CharSequence charSequence = "%%-%ds %%s";
        Object[] objectArray = new Object[]{12};
        boolean bl = false;
        String string = String.format(charSequence, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "java.lang.String.format(format, *args)");
        String formatString = string;
        CharSequence sb = new StringBuilder();
        sb = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_SENDER, film.getSender());
        charSequence = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_THEMA, film.getThema()).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue(charSequence, "appendFormattedTableLine(sb, formatString, FILM_THEMA, film.thema).append(System.lineSeparator())");
        sb = charSequence;
        charSequence = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_TITEL, film.getTitle()).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue(charSequence, "appendFormattedTableLine(sb, formatString, FILM_TITEL, film.title).append(System.lineSeparator())");
        sb = charSequence;
        sb = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_DATUM, film.getSendeDatum());
        sb = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_ZEIT, film.getSendeZeit());
        sb = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_DAUER, film.getDauer());
        if (fileSize > -1L) {
            sb = this.appendFormattedTableLine((StringBuilder)sb, formatString, FILM_GROESSE, FileUtils.byteCountToDisplaySize(fileSize));
        } else {
            ((StringBuilder)sb).append(System.lineSeparator());
        }
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append("Website");
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(film.getWebsiteLink());
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(FILM_URL);
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(url);
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(this.splitStringIntoMaxFixedLengthLines(film.getDescription(), 62));
        ((StringBuilder)sb).append(System.lineSeparator());
        ((StringBuilder)sb).append(System.lineSeparator());
        charSequence = ((StringBuilder)sb).toString();
        Intrinsics.checkNotNullExpressionValue(charSequence, "sb.toString()");
        return charSequence;
    }

    @NotNull
    protected final StringBuilder appendFormattedTableLine(@NotNull StringBuilder sb, @Nullable String formatString, @Nullable String keyTitle, @Nullable String value) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Intrinsics.checkNotNull(formatString);
        String string = formatString;
        Object[] objectArray = new Object[2];
        StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
        String string2 = "%s:";
        Object[] objectArray2 = new Object[]{keyTitle};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue(String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), "java.lang.String.format(format, *args)");
        objectArray[1] = value;
        boolean bl2 = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        StringBuilder stringBuilder = sb.append(string3).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "sb.append(String.format(formatString!!, String.format(\"%s:\", keyTitle), value))\n                .append(System.lineSeparator())");
        return stringBuilder;
    }

    @NotNull
    protected final String splitStringIntoMaxFixedLengthLines(@Nullable String input, int lineLength) {
        String string = Optional.ofNullable(input).map(arg_0 -> MVInfoFile.splitStringIntoMaxFixedLengthLines$lambda-0(lineLength, arg_0)).orElse("");
        Intrinsics.checkNotNullExpressionValue(string, "ofNullable(input)\n                .map { s: String? -> WordUtils.wrap(s, lineLength) }\n                .orElse(\"\")");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeInfoFile(@Nullable DatenFilm film, @NotNull Path path, @Nullable HttpUrl url) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        logger.info("Infofile schreiben nach: {}", (Object)((Object)path.toAbsolutePath()).toString());
        path.toFile().getParentFile().mkdirs();
        Closeable closeable = Files.newOutputStream(path, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new DataOutputStream(os);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                DataOutputStream dos = (DataOutputStream)closeable2;
                boolean bl6 = false;
                Closeable closeable3 = new OutputStreamWriter(dos);
                boolean bl7 = false;
                boolean bl8 = false;
                Throwable throwable3 = null;
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)closeable3;
                    boolean bl9 = false;
                    Closeable closeable4 = new BufferedWriter(osw);
                    boolean bl10 = false;
                    boolean bl11 = false;
                    Throwable throwable4 = null;
                    try {
                        BufferedWriter br = (BufferedWriter)closeable4;
                        boolean bl12 = false;
                        br.write(this.formatFilmAsString(film, url));
                        br.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable4, throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally(closeable3, throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        logger.info("Infodatei geschrieben");
    }

    public final void writeInfoFile(@NotNull DatenDownload datenDownload) throws IOException {
        Intrinsics.checkNotNullParameter(datenDownload, "datenDownload");
        new File(datenDownload.arr[30]).mkdirs();
        Path path = Paths.get(Intrinsics.stringPlus(datenDownload.getFileNameWithoutSuffix(), ".txt"), new String[0]);
        DatenFilm film = datenDownload.film;
        Object object = datenDownload.arr[21];
        Intrinsics.checkNotNullExpressionValue(object, "datenDownload.arr[DatenDownload.DOWNLOAD_URL]");
        HttpUrl url = HttpUrl.Companion.get((String)object);
        object = film;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(path, "path");
            this.writeInfoFile((DatenFilm)it, path, url);
        }
    }

    private static final String splitStringIntoMaxFixedLengthLines$lambda-0(int $lineLength, String s2) {
        return WordUtils.wrap(s2, $lineLength);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmediathek/tool/MVInfoFile$Companion;", "", "()V", "FILM_DATUM", "", "FILM_DAUER", "FILM_GROESSE", "FILM_SENDER", "FILM_THEMA", "FILM_TITEL", "FILM_URL", "FILM_ZEIT", "MAX_HEADER_LENGTH", "", "MAX_LINE_LENGTH", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

