(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["src_CardSelector_vue"],{33447:(t,n,e)=>{"use strict";e.d(n,{Z:()=>l});var o=e(87537),r=e.n(o),a=e(23645),s=e.n(a)()(r());s.push([t.id,"\n#modal-inner[data-v-76089da2] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n\theight: 200px;\n}\n.multiselect[data-v-76089da2] {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\nul[data-v-76089da2] {\n\tmin-height: 100px;\n}\nli[data-v-76089da2] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-76089da2]:hover, li[data-v-76089da2]:focus {\n\tbackground-color: var(--color-background-dark);\n}\n.board-bullet[data-v-76089da2] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nbutton[data-v-76089da2] {\n\tfloat: right;\n}\n.card-selector[data-v-76089da2] .modal-container {\n\toverflow: visible !important;\n}\n","",{version:3,sources:["webpack://./src/CardSelector.vue"],names:[],mappings:";AAsIA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,mBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,4BAAA;AACA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2019 Julius Härtl <jus@bitgrid.net>\n  -\n  - @author Julius Härtl <jus@bitgrid.net>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n\n<template>\n\t<Modal class=\"card-selector\" @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t\t<Multiselect v-model=\"selectedBoard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a board')\"\n\t\t\t\t:options=\"boards\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\tlabel=\"title\"\n\t\t\t\t@select=\"fetchCardsFromBoard\">\n\t\t\t\t<template slot=\"singleLabel\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t\t<template slot=\"option\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t</Multiselect>\n\n\t\t\t<Multiselect v-model=\"selectedCard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a card')\"\n\t\t\t\t:options=\"cardsFromBoard\"\n\t\t\t\t:disabled=\"loading || selectedBoard === ''\"\n\t\t\t\tlabel=\"title\" />\n\n\t\t\t<button :disabled=\"!isBoardAndStackChoosen\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ action }}\n\t\t\t</button>\n\t\t\t<button @click=\"close\">\n\t\t\t\t{{ t('deck', 'Cancel') }}\n\t\t\t</button>\n\t\t</div>\n\t</Modal>\n</template>\n\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport Modal from '@nextcloud/vue/dist/Components/Modal'\nimport Multiselect from '@nextcloud/vue/dist/Components/Multiselect'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'CardSelector',\n\tcomponents: {\n\t\tModal,\n\t\tMultiselect,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Select the card to link to a project'),\n\t\t},\n\t\taction: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Link to card'),\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tboards: [],\n\t\t\tselectedBoard: '',\n\t\t\tcardsFromBoard: [],\n\t\t\tselectedCard: '',\n\t\t\tloading: true,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisBoardAndStackChoosen() {\n\t\t\treturn !(this.selectedBoard === '' || this.selectedCard === '')\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tasync fetchCardsFromBoard(board) {\n\t\t\ttry {\n\t\t\t\tthis.cardsFromBoard = []\n\t\t\t\tconst url = generateUrl('/apps/deck/stacks/' + board.id)\n\t\t\t\tconst response = await axios.get(url)\n\t\t\t\tresponse.data.forEach(stack => {\n\t\t\t\t\tthis.cardsFromBoard.push(...stack.cards)\n\t\t\t\t})\n\t\t\t} catch (err) {\n\t\t\t\treturn err\n\t\t\t}\n\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedCard.id)\n\n\t\t},\n\t},\n\n}\n<\/script>\n\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t\theight: 200px;\n\t}\n\n\t.multiselect {\n\t\twidth: 100%;\n\t\tmargin-bottom: 10px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tbutton {\n\t\tfloat: right;\n\t}\n\n\t.card-selector::v-deep .modal-container {\n\t\toverflow: visible !important;\n\t}\n</style>\n"],sourceRoot:""}]);const l=s},91706:(n,e,o)=>{"use strict";o.r(e),o.d(e,{default:()=>M});var r=o(79753),a=o(47450),s=o.n(a),l=o(7811),i=o.n(l),d=o(4820);function c(t){return function(t){if(Array.isArray(t))return u(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,n){if(!t)return;if("string"==typeof t)return u(t,n);var e=Object.prototype.toString.call(t).slice(8,-1);"Object"===e&&t.constructor&&(e=t.constructor.name);if("Map"===e||"Set"===e)return Array.from(t);if("Arguments"===e||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))return u(t,n)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function u(t,n){(null==n||n>t.length)&&(n=t.length);for(var e=0,o=new Array(n);e<n;e++)o[e]=t[e];return o}function p(t,n,e,o,r,a,s){try{var l=t[a](s),i=l.value}catch(t){return void e(t)}l.done?n(i):Promise.resolve(i).then(o,r)}const A={name:"CardSelector",components:{Modal:s(),Multiselect:i()},props:{title:{type:String,default:t("deck","Select the card to link to a project")},action:{type:String,default:t("deck","Link to card")}},data:function(){return{boards:[],selectedBoard:"",cardsFromBoard:[],selectedCard:"",loading:!0}},computed:{isBoardAndStackChoosen:function(){return!(""===this.selectedBoard||""===this.selectedCard)}},beforeMount:function(){this.fetchBoards()},methods:{fetchBoards:function(){var t=this;d.default.get((0,r.generateUrl)("/apps/deck/boards")).then((function(n){t.boards=n.data,t.loading=!1}))},fetchCardsFromBoard:function(t){var n,e=this;return(n=regeneratorRuntime.mark((function n(){var o;return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return n.prev=0,e.cardsFromBoard=[],o=(0,r.generateUrl)("/apps/deck/stacks/"+t.id),n.next=5,d.default.get(o);case 5:n.sent.data.forEach((function(t){var n;(n=e.cardsFromBoard).push.apply(n,c(t.cards))})),n.next=12;break;case 9:return n.prev=9,n.t0=n.catch(0),n.abrupt("return",n.t0);case 12:case"end":return n.stop()}}),n,null,[[0,9]])})),function(){var t=this,e=arguments;return new Promise((function(o,r){var a=n.apply(t,e);function s(t){p(a,o,r,s,l,"next",t)}function l(t){p(a,o,r,s,l,"throw",t)}s(void 0)}))})()},close:function(){this.$root.$emit("close")},select:function(){this.$root.$emit("select",this.selectedCard.id)}}};var h=o(93379),b=o.n(h),f=o(7795),m=o.n(f),C=o(90569),v=o.n(C),g=o(3565),k=o.n(g),y=o(19216),x=o.n(y),B=o(44589),w=o.n(B),S=o(33447),_={};_.styleTagTransform=w(),_.setAttributes=k(),_.insert=v().bind(null,"head"),_.domAPI=m(),_.insertStyleElement=x();b()(S.Z,_);S.Z&&S.Z.locals&&S.Z.locals;const M=(0,o(51900).Z)(A,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Modal",{staticClass:"card-selector",on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h3",[t._v(t._s(t.title))]),t._v(" "),e("Multiselect",{attrs:{placeholder:t.t("deck","Select a board"),options:t.boards,disabled:t.loading,label:"title"},on:{select:t.fetchCardsFromBoard},scopedSlots:t._u([{key:"singleLabel",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}},{key:"option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}}]),model:{value:t.selectedBoard,callback:function(n){t.selectedBoard=n},expression:"selectedBoard"}}),t._v(" "),e("Multiselect",{attrs:{placeholder:t.t("deck","Select a card"),options:t.cardsFromBoard,disabled:t.loading||""===t.selectedBoard,label:"title"},model:{value:t.selectedCard,callback:function(n){t.selectedCard=n},expression:"selectedCard"}}),t._v(" "),e("button",{staticClass:"primary",attrs:{disabled:!t.isBoardAndStackChoosen},on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.action)+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.close}},[t._v("\n\t\t\t"+t._s(t.t("deck","Cancel"))+"\n\t\t")])],1)])}),[],!1,null,"76089da2",null).exports}}]);
//# sourceMappingURL=deck-src_CardSelector_vue.js.map?v=d20527d24cbb1e17655d