/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic;

import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArabicMorphoFeatureSpecification
extends MorphoFeatureSpecification {
    private static final long serialVersionUID = 4448045447200922076L;
    public static final String[] defVals = new String[]{"DT"};
    public static final String[] caseVals = new String[]{"NOM", "ACC", "GEN"};
    public static final String[] genVals = new String[]{"M", "F"};
    public static final String[] numVals = new String[]{"SG", "DU", "PL"};
    public static final String[] perVals = new String[]{"1", "2", "3"};
    public static final String[] possVals = new String[]{"POSS"};
    public static final String[] voiceVals = new String[]{"ACT", "PASS"};
    public static final String[] moodVals = new String[]{"I", "S", "J"};
    public static final String[] tenseVals = new String[]{"PAST", "PRES", "IMP"};
    private static final Pattern pPronom = Pattern.compile("PRON_(.+)$");
    private static final Pattern pMood = Pattern.compile("_MOOD:(.+)$");
    private static final Pattern pTbPrefix = Pattern.compile("^(FUT|JUS)\\+");
    private static final Pattern pPvFeats = Pattern.compile(":(.+)$");

    @Override
    public List<String> getValues(MorphoFeatureSpecification.MorphoFeatureType feat) {
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.DEF) {
            return Arrays.asList(defVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.CASE) {
            throw new RuntimeException(this.getClass().getName() + ": Case is presently unsupported!");
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.GEN) {
            return Arrays.asList(genVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.NUM) {
            return Arrays.asList(numVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.PER) {
            return Arrays.asList(perVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.POSS) {
            return Arrays.asList(possVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.VOICE) {
            return Arrays.asList(voiceVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.MOOD) {
            return Arrays.asList(moodVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.TENSE) {
            return Arrays.asList(tenseVals);
        }
        throw new IllegalArgumentException("Arabic does not support feature type: " + feat.toString());
    }

    @Override
    public MorphoFeatures strToFeatures(String spec) {
        ArabicMorphoFeatures feats = new ArabicMorphoFeatures();
        if (spec == null || spec.equals("")) {
            return feats;
        }
        if (spec.startsWith("DET") && this.isActive(MorphoFeatureSpecification.MorphoFeatureType.DEF)) {
            feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.DEF, defVals[0]);
        }
        if (spec.contains("POSS") && this.isActive(MorphoFeatureSpecification.MorphoFeatureType.POSS)) {
            feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.POSS, possVals[0]);
        }
        if (spec.contains("NSUFF") || spec.contains("REL_PRON") || spec.contains("INTERROG_PRON")) {
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.GEN)) {
                if (spec.contains("MASC")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[0]);
                } else if (spec.contains("FEM")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[1]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.NUM)) {
                if (spec.contains("SG")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[0]);
                } else if (spec.contains("DU")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[1]);
                } else if (spec.contains("PL")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[2]);
                }
            }
        } else if (spec.contains("PRON")) {
            Matcher m;
            if (spec.startsWith("DEM_PRON")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.DEF, defVals[0]);
            }
            if ((m = pPronom.matcher(spec)).find()) {
                spec = m.group(1);
                this.processDefaultSpec(feats, spec);
            }
        } else if (spec.contains("+IV") || spec.contains("+CV") || spec.contains("+PV") || spec.equals("PV_PASS")) {
            Matcher m;
            String featStr;
            spec = pTbPrefix.matcher(spec).replaceAll("");
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.TENSE)) {
                if (spec.contains("PV")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.TENSE, tenseVals[0]);
                } else if (spec.contains("IV")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.TENSE, tenseVals[1]);
                } else if (spec.contains("CV")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.TENSE, tenseVals[2]);
                }
            }
            if (spec.startsWith("IV") && !spec.equals("IV+IVSUFF_SUBJ:3FS")) {
                String[] toks = spec.split("\\+");
                featStr = toks[0].replace("IV", "");
                this.processDefaultSpec(feats, featStr);
            } else {
                m = pPvFeats.matcher(spec);
                if (m.find()) {
                    featStr = m.group(1);
                    this.processDefaultSpec(feats, featStr);
                } else if (spec.equals("PV+PVSUFF_3MS")) {
                    String[] toks = spec.split("_");
                    this.processDefaultSpec(feats, toks[1]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.MOOD) && (m = pMood.matcher(spec)).find()) {
                String moodStr = m.group(1);
                if (moodStr.equals("I")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.MOOD, moodVals[0]);
                } else if (moodStr.equals("S")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.MOOD, moodVals[1]);
                } else if (moodStr.equals("J")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.MOOD, moodVals[2]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.VOICE)) {
                if (spec.contains("PASS")) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.VOICE, voiceVals[1]);
                } else {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.VOICE, voiceVals[0]);
                }
            }
        }
        return feats;
    }

    private void processDefaultSpec(MorphoFeatures feats, String spec) {
        if (spec == null || spec.equals("")) {
            return;
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.GEN)) {
            if (spec.contains("M")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[0]);
            } else if (spec.contains("F")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[1]);
            }
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.NUM)) {
            if (spec.endsWith("S")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[0]);
            } else if (spec.endsWith("D")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[1]);
            } else if (spec.endsWith("P")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[2]);
            }
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.PER)) {
            if (spec.contains("1")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[0]);
            } else if (spec.contains("2")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[1]);
            } else if (spec.contains("3")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[2]);
            }
        }
    }

    public static void main(String[] args) {
        String[] feats;
        if (args.length != 2) {
            System.err.printf("Usage: java %s filename feats%n", ArabicMorphoFeatureSpecification.class.getName());
            System.exit(-1);
        }
        ArabicMorphoFeatureSpecification fSpec = new ArabicMorphoFeatureSpecification();
        for (String feat : feats = args[1].split(",")) {
            MorphoFeatureSpecification.MorphoFeatureType fType = MorphoFeatureSpecification.MorphoFeatureType.valueOf(feat);
            fSpec.activate(fType);
        }
        File fName = new File(args[0]);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fName)));
            int nLine = 0;
            while ((line = br.readLine()) != null) {
                MorphoFeatures mFeats = ((MorphoFeatureSpecification)fSpec).strToFeatures(line.trim());
                System.out.printf("%s\t%s%n", line.trim(), mFeats.toString());
                ++nLine;
            }
            br.close();
            System.out.printf("%nRead %d lines%n", nLine);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ArabicMorphoFeatures
    extends MorphoFeatures {
        private static final long serialVersionUID = -4611776415583633186L;

        public MorphoFeatures fromTagString(String str) {
            String baseTag;
            String[] feats = str.split("\\-");
            ArabicMorphoFeatures mFeats = new ArabicMorphoFeatures();
            if (feats.length > 0 && (baseTag = feats[0]).startsWith("DT")) {
                mFeats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.DEF, defVals[0]);
            }
            for (int i = 1; i < feats.length; ++i) {
                String[] keyValue = feats[i].split(":");
                if (keyValue.length != 2) continue;
                MorphoFeatureSpecification.MorphoFeatureType fName = MorphoFeatureSpecification.MorphoFeatureType.valueOf(keyValue[0].trim());
                mFeats.addFeature(fName, keyValue[1].trim());
            }
            return mFeats;
        }

        public String getTag(String baseTag) {
            StringBuilder sb = new StringBuilder();
            if (baseTag.startsWith("VB") && !baseTag.equals("VBG")) {
                baseTag = "VB";
            }
            for (MorphoFeatureSpecification.MorphoFeatureType feat : MorphoFeatureSpecification.MorphoFeatureType.values()) {
                if (!this.hasFeature(feat)) continue;
                if (feat == MorphoFeatureSpecification.MorphoFeatureType.DEF) {
                    if (baseTag.startsWith("DT")) continue;
                    baseTag = "DT" + baseTag;
                    continue;
                }
                sb.append(String.format("-%s:%s", new Object[]{feat, this.fSpec.get((Object)feat)}));
            }
            return baseTag + sb.toString();
        }
    }
}

