/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;

public class ProcessState {
    private final String name;
    private final IOException cause;
    private static final ProcessState INIT = new ProcessState("INIT", null);
    private static final ProcessState RUNNING = new ProcessState("RUNNING", null);
    private static final ProcessState TERMINATED_OK = new ProcessState("TERMINATED_OK", null);
    private static final ProcessState TIMEOUT = new ProcessState("TIMEOUT", null);

    private ProcessState(String name, IOException cause) {
        this.name = name;
        this.cause = cause;
    }

    public String toString() {
        if (this.cause == null) {
            return this.name;
        }
        return this.name + " " + this.cause.toString();
    }

    public static ProcessState INIT() {
        return INIT;
    }

    public static ProcessState RUNNING() {
        return RUNNING;
    }

    public static ProcessState TERMINATED_OK() {
        return TERMINATED_OK;
    }

    public static ProcessState TIMEOUT() {
        return TIMEOUT;
    }

    public static ProcessState IO_EXCEPTION1(IOException e) {
        return new ProcessState("IO_EXCEPTION1", e);
    }

    public static ProcessState IO_EXCEPTION2(IOException e) {
        return new ProcessState("IO_EXCEPTION2", e);
    }

    public boolean differs(ProcessState other) {
        return !this.name.equals(other.name);
    }

    public boolean equals(Object o) {
        ProcessState other = (ProcessState)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Throwable getCause() {
        return this.cause;
    }
}

