/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImagePseudoState
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final TextBlock desc;
    private final SName sname;

    public EntityImagePseudoState(ILeaf entity, ISkinParam skinParam, SName sname) {
        this(entity, skinParam, "H", sname);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.diamond);
    }

    public EntityImagePseudoState(ILeaf entity, ISkinParam skinParam, String historyText, SName sname) {
        super(entity, skinParam);
        this.sname = sname;
        Stereotype stereotype = entity.getStereotype();
        FontConfiguration fontConfiguration = UseStyle.useBetaStyle() ? FontConfiguration.create(this.getSkinParam(), FontParam.STATE, stereotype) : FontConfiguration.create(this.getSkinParam(), this.getStyle());
        this.desc = Display.create(historyText).create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(22.0, 22.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        HColor backgroundColor;
        HColor borderColor;
        UEllipse circle = new UEllipse(22.0, 22.0);
        double shadow = 0.0;
        UStroke stroke = new UStroke(1.5);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getStyle();
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            shadow = style.value(PName.Shadowing).asDouble();
            stroke = style.getStroke();
        } else {
            backgroundColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
            borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder);
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                shadow = 4.0;
            }
        }
        circle.setDeltaShadow(shadow);
        ug = ug.apply(stroke);
        ug = ug.apply(backgroundColor.bg()).apply(borderColor);
        ug.draw(circle);
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double heightDesc = dimDesc.getHeight();
        double x = (22.0 - widthDesc) / 2.0;
        double y = (22.0 - heightDesc) / 2.0;
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

