/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class WPrint {
    private final UTranslate position;
    private final HColor color;
    private final Display label;
    private final ISkinParam skinParam;

    public WPrint(ISkinParam skinParam, UTranslate position, HColor color, Display label) {
        this.position = position;
        this.skinParam = skinParam;
        this.label = label;
        this.color = color == null ? this.getBlack() : color;
    }

    private HColor getBlack() {
        return HColorUtils.BLACK.withDark(HColorUtils.WHITE);
    }

    private TextBlock getTextBlock() {
        FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.sansSerif(10)).changeColor(this.color);
        return this.label.create(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
    }

    public UChange getPosition() {
        return this.position;
    }

    public void drawMe(UGraphic ug) {
        this.getTextBlock().drawU(ug);
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getTextBlock().calculateDimension(stringBounder).getHeight();
    }
}

