# Promscale command line doc

This document gives you information about the configuration flags and arguments supported by Promscale.
You can also find information on flags with `promscale_<version> -help`.

**Note:** Flags can be set as environment variables by converting `-` to `_` (if any), and prefixing with `PROMSCALE_`. For example, `db-host` can be set as an environment variable as `PROMSCALE_DB_HOST`.

## Arguments

| Argument | Description |
|:------:|:-----|
| version | Prints the version information of Promscale. |
| help | Prints the information related to flags supported by Promscale.

## General flags

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| cache.memory-target | unsigned-integer or percentage | 80% | Target for max amount of memory to use. Specified in bytes or as a percentage of system memory (e.g. 80%). |
| config | string | config.yml | YAML configuration file path for Promscale. |
| enable-feature | string | "" | Enable one or more experimental promscale features (as a comma-separated list). Current experimental features are `tracing`, `promql-at-modifier`, and `promql-negative-offset`. For more information, please consult the following resources: [tracing](tracing.md), [promql-at-modifier](https://prometheus.io/docs/prometheus/latest/feature_flags/#modifier-in-promql), [promql-negative-offset](https://prometheus.io/docs/prometheus/latest/feature_flags/#negative-offset-in-promql). |
| thanos.store-api.server-address | string | "" (disabled) | Address to listen on for Thanos Store API endpoints. |
| tracing.otlp.server-address string | string | "" (disabled) | Address to listen on for OTLP GRPC server. |

## Auth flags

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| auth.tls-cert-file | string | "" (disabled) | TLS certificate file path for web server. To disable TLS, leave this field as blank. |
| auth.tls-key-file | string | "" (disabled) | TLS key file path for web server. To disable TLS, leave this field as blank. |

## Database flags

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| db.app | string | promscale@{version} | 'app' sets application_name in database connection string. This is helpful during debugging when looking at pg_stat_activity. |
| db.connection-timeout | duration | 60 seconds | Timeout for establishing the connection between Promscale and TimescaleDB. |
| db.connections-max | integer | 80% of possible connections db | Maximum number of connections to the database that should be opened at once. It defaults to 80% of the maximum connections that the database can handle. |
| db.host | string | localhost | Host for TimescaleDB/Vanilla Postgres. |
| db.name | string | timescale | Database name. |
| db.num-writer-connections | integer | 1 | Maximum number of database connections for writing per go thread (as configured via GOMAXPROCS) |
| db.password | string | | Password for connecting to TimescaleDB/Vanilla Postgres. |
| db.port | int | 5432 | TimescaleDB/Vanilla Postgres connection password. |
| db.read-only | boolean | false | Read-only mode for the connector. Operations related to writing or updating the database are disallowed. It is used when pointing the connector to a TimescaleDB read replica. |
| db.ssl-mode | string | require | TimescaleDB/Vanilla Postgres connection ssl mode. If you do not want to use ssl, pass `allow` as value. |
| db.statements-cache | boolean | true | Whether database connection pool should use cached prepared statements. Disable if using PgBouncer. |
| db.uri | string | | TimescaleDB/Vanilla PostgresSQL URI. Example:`postgres://postgres:password@localhost:5432/timescale?sslmode=require` |
| db.user | string | postgres | TimescaleDB/Vanilla Postgres user. |

## Telemetry flags (for telemetry generated by the Promscale connector itself)

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| telemetry.log.format | string | logfmt | Log format to use from [ "logfmt", "json" ]. |
| telemetry.log.level | string | debug | Log level to use from [ "error", "warn", "info", "debug" ]. |
| telemetry.log.throughput-report-interval | duration | 0 second | Duration interval at which throughput should be reported. Setting duration to `0` will disable reporting throughput, otherwise, an interval with unit must be provided, e.g. `10s` or `3m`. |
| telemetry.trace.otel-endpoint | string | "" (empty) | OpenTelemetry tracing collector GRPC URL endpoint to send telemetry to. (i.e. otel-collector:4317) |
| telemetry.trace.otel-tls-cert-file | string | "" (empty) | TLS Certificate file used for client authentication against the OTEL tracing collector GRPC endpoint, leave blank to disable TLS. |
| telemetry.trace.otel-tls-key-file | string | "" (empty) | TLS Key file for client authentication against the OTEL tracing collector GRPC endpoint, leave blank to disable TLS. |
| telemetry.trace.jaeger-endpoint | string | "" (empty) | Jaeger tracing collector thrift HTTP URL endpoint to send telemetry to (e.g. https://jaeger-collector:14268/api/traces). |
| telemetry.trace.sample-ratio | float | 1.0 | Trace sampling ratio, amount of spans to send to collector. Valid values from 0.0 (none) to 1.0 (all). |

## Metrics specific flags flags

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| metrics.async-acks | boolean | false | Acknowledge asynchronous inserts. If this is true, the inserter will not wait after insertion of metric data in the database. This increases throughput at the cost of a small chance of data loss. |
| metrics.cache.exemplar.size | unsigned-integer | 10000 | Maximum number of exemplar metrics key-position to cache. It has one-to-one mapping with number of metrics that have exemplar, as key positions are saved per metric basis. |
| metrics.cache.labels.size | unsigned-integer | 10000 | Maximum number of labels to cache. |
| metrics.cache.metrics.size | unsigned-integer | 10000 | Maximum number of metric names to cache. |
| metrics.cache.series.initial-size | unsigned-integer| 250000 | Initial number of elements in the series cache. |
| metrics.cache.series.max-bytes | unsigned-integer or percentage | 50% |  Target for amount of memory to use for the series cache. Specified in bytes or as a percentage of the memory-target (e.g. 50%). |
| metrics.high-availability | boolean | false | Enable external_labels based HA. |
| metrics.ignore-samples-written-to-compressed-chunks | boolean | false | Ignore/drop samples that are being written to compressed chunks. Setting this to false allows Promscale to ingest older data by decompressing chunks that were earlier compressed. However, setting this to true will save your resources that may be required during decompression. |
| metrics.multi-tenancy | boolean | false | Use multi-tenancy mode in Promscale. |
| metrics.multi-tenancy.allow-non-tenants | boolean | false | Allow Promscale to ingest/query all tenants as well as non-tenants. By setting this to true, Promscale will ingest data from non multi-tenant Prometheus instances as well. If this is false, only multi-tenants (tenants listed in 'multi-tenancy-valid-tenants') are allowed for ingesting and querying data. |
| metrics.multi-tenancy.valid-tenants | string | allow-all |  Sets valid tenants that are allowed to be ingested/queried from Promscale. This can be set as: 'allow-all' (default) or a comma separated tenant names. 'allow-all' makes Promscale ingest or query any tenant from itself. A comma separated list will indicate only those tenants that are authorized for operations from Promscale. |
| metrics.promql.default-subquery-step-interval | duration | 1 minute | Default step interval to be used for PromQL subquery evaluation. This value is used if the subquery does not specify the step value explicitly. Example: <metric_name>[30m:]. Note: in Prometheus this setting is set by the evaluation_interval option. |
| metrics.promql.lookback-delta | duration | 5 minute | The maximum look-back duration for retrieving metrics during expression evaluations and federation. |
| metrics.promql.max-points-per-ts  | integer64 | 11000 | Maximum number of points per time-series in a query-range request. This calculation is an estimation, that happens as (start - end)/step where start and end are the 'start' and 'end' timestamps of the query_range. |
| metrics.promql.max-samples | integer64 | 50000000 | Maximum number of samples a single query can load into memory. Note that queries will fail if they try to load more samples than this into memory, so this also limits the number of samples a query can return. |
| metrics.promql.query-timeout | duration | 2 minutes | Maximum time a query may take before being aborted. This option sets both the default and maximum value of the 'timeout' parameter in '/api/v1/query.*' endpoints. |

## Startup process flags

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| startup.dataset.config | string | "" (disabled) | Dataset configuration in YAML format for Promscale. It is used for setting various dataset configuration like default metric chunk interval. For more information, please consult the following resources: [dataset](dataset.md)  |
| startup.install-extensions | boolean | true | Install TimescaleDB & Promscale extensions. |
| startup.only | boolean | false | Only run startup configuration with Promscale (i.e. migrate) and exit. Can be used to run promscale as an init container for HA setups. |
| startup.skip-migrate | boolean | false | Skip migrating Promscale SQL schema to latest version on startup. |
| startup.upgrade-extensions | boolean | true | Upgrades TimescaleDB & Promscale extensions. |
| startup.upgrade-prerelease-extensions | boolean | false | Upgrades to pre-release TimescaleDB, Promscale extensions. |
| startup.use-schema-version-lease | boolean | true | Use schema version lease to prevent race conditions during migration. |

## Web server flags

| Flag | Type | Default | Description |
|------|:-----:|:-------:|:-----------|
| web.auth.bearer-token | string | "" (disabled) | Bearer token (JWT) used for web endpoint authentication. Disabled by default. Mutually exclusive with bearer-token-file and basic auth methods. |
| web.auth.bearer-token-file | string | "" (disabled) | Path of the file containing the bearer token (JWT) used for web endpoint authentication. Disabled by default. Mutually exclusive with bearer-token and basic auth methods. |
| web.auth.password | string | "" | Authentication password used for web endpoint authentication. This flag should be set together with auth-username. It is mutually exclusive with auth-password-file and bearer-token methods. |
| web.auth.password-file | string | "" | Path for auth password file containing the actual password used for web endpoint authentication. This flag should be set together with auth-username. It is mutually exclusive with auth-password and bearer-token methods. |
| web.auth.username | string | "" | Authentication username used for web endpoint authentication. Disabled by default. |
| web.cors-origin | string | `.*` |  Regex for CORS origin. It is fully anchored. Example: 'https?://(domain1|domain2)\.com' |
| web.enable-admin-api | boolean | false | Allow operations via API that are for advanced users. Currently, these operations are limited to deletion of series. |
| web.listen-address | string | `:9201` | Address to listen on for web endpoints. |
| web.telemetry-path | string | `/metrics` | Web endpoint for exposing Promscale's Prometheus metrics. |
