/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.util.ArrayList;
import java.util.List;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.xml.sax.helpers.DefaultHandler;

public class TabbedWorkspaceStateManager
extends DefaultHandler {
    public static final String TABS_PREFERENCES_SET = "tabs";
    public static final String VISIBLE_TABS_PREFERENCE_KEY = "visible_tabs";
    private List<String> tabs = new ArrayList<String>();

    public TabbedWorkspaceStateManager() {
        this.load();
    }

    public TabbedWorkspaceStateManager(TabbedWorkspace workspace) {
        for (WorkspaceTab tab : workspace.getWorkspaceTabs()) {
            this.tabs.add(tab.getId());
        }
    }

    public List<String> getTabs() {
        return new ArrayList<String>(this.tabs);
    }

    public void load() {
        this.tabs.clear();
        this.tabs.addAll(TabbedWorkspaceStateManager.getPreferences().getStringList(VISIBLE_TABS_PREFERENCE_KEY, new ArrayList<String>()));
    }

    public void save() {
        TabbedWorkspaceStateManager.getPreferences().putStringList(VISIBLE_TABS_PREFERENCE_KEY, this.tabs);
    }

    protected static Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(TABS_PREFERENCES_SET);
    }
}

