from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Message import *
from OCC.Core.Poly import *
from OCC.Core.TopoDS import *
from OCC.Core.TCollection import *
from OCC.Core.RWMesh import *
from OCC.Core.Graphic3d import *
from OCC.Core.gp import *


class RWObj_SubMeshReason(IntEnum):
    RWObj_SubMeshReason_NewObject: int = ...
    RWObj_SubMeshReason_NewGroup: int = ...
    RWObj_SubMeshReason_NewMaterial: int = ...
    RWObj_SubMeshReason_NewSmoothGroup: int = ...

RWObj_SubMeshReason_NewObject = RWObj_SubMeshReason.RWObj_SubMeshReason_NewObject
RWObj_SubMeshReason_NewGroup = RWObj_SubMeshReason.RWObj_SubMeshReason_NewGroup
RWObj_SubMeshReason_NewMaterial = RWObj_SubMeshReason.RWObj_SubMeshReason_NewMaterial
RWObj_SubMeshReason_NewSmoothGroup = RWObj_SubMeshReason.RWObj_SubMeshReason_NewSmoothGroup

class rwobj:
    @staticmethod
    def ReadFile(theFile: str, aProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> Poly_Triangulation: ...

class RWObj_IShapeReceiver:
    def BindNamedShape(self, theShape: TopoDS_Shape, theName: TCollection_AsciiString, theMaterial: RWObj_Material, theIsRootShape: bool) -> None: ...

class RWObj_Material:
    def __init__(self) -> None: ...

class RWObj_Reader(Standard_Transient):
    def ExternalFiles(self) -> False: ...
    def FileComments(self) -> TCollection_AsciiString: ...
    def IsSinglePrecision(self) -> bool: ...
    def MemoryLimit(self) -> int: ...
    def NbProbeElems(self) -> int: ...
    def NbProbeNodes(self) -> int: ...
    def Probe(self, theFile: TCollection_AsciiString, theProgress: Message_ProgressRange) -> bool: ...
    def Read(self, theFile: TCollection_AsciiString, theProgress: Message_ProgressRange) -> bool: ...
    def SetMemoryLimit(self, theMemLimit: int) -> None: ...
    def SetSinglePrecision(self, theIsSinglePrecision: bool) -> None: ...
    def SetTransformation(self, theCSConverter: RWMesh_CoordinateSystemConverter) -> None: ...
    def Transformation(self) -> RWMesh_CoordinateSystemConverter: ...

class RWObj_SubMesh:
    pass

class RWObj_CafReader(RWMesh_CafReader, RWObj_IShapeReceiver):
    def __init__(self) -> None: ...
    def IsSinglePrecision(self) -> bool: ...
    def SetSinglePrecision(self, theIsSinglePrecision: bool) -> None: ...

class RWObj_TriangulationReader(RWObj_Reader):
    def __init__(self) -> None: ...
    def GetTriangulation(self) -> Poly_Triangulation: ...
    def ResultShape(self) -> TopoDS_Shape: ...
    def SetCreateShapes(self, theToCreateShapes: bool) -> None: ...
    def SetShapeReceiver(self, theReceiver: RWObj_IShapeReceiver) -> None: ...

#classnotwrapped
class RWObj_MtlReader: ...

# harray1 classes
# harray2 classes
# hsequence classes

rwobj_ReadFile = rwobj.ReadFile
