/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.Environment;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.factory.DataFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.ClassLoaderToAppPropertiesMap;
import com.ibm.db2.cmx.runtime.internal.ConfigFileMonitorTask;
import com.ibm.db2.cmx.runtime.internal.PdqTimerServices;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DataProperties {
    public static final String LOG_FILE_PROPERTY = "pdq.traceFile";
    public static final String LOG_FILE_DEFAULT = "pdq.log";
    public static final String ENABLE_CMX_SERVER_LOG_PROPERTY = "pdq.enableCMXServerLog";
    public static final String ENABLE_CMX_SERVER_LOG_DEFAULT = "ON";
    public static final String CMX_SERVER_LOG_FILE_COUNT_PROPERTY = "pdq.cmxServerLogFileCount";
    public static final String CMX_SERVER_LOG_FILE_COUNT_DEFAULT = "6";
    public static final String CMX_SERVER_LOG_FILE_SIZE_PROPERTY = "pdq.cmxServerLogFileSize";
    public static final String CMX_SERVER_LOG_FILE_SIZE_DEFAULT = "50000000";
    public static final String CMX_SERVER_LOG_TRACE_LEVEL_PROPERTY = "pdq.cmxServerLogTraceLevel";
    public static final String CMX_SERVER_LOG_TRACE_LEVEL_DEFAULT = "INFO";
    public static final String ENABLE_ROLLING_LOG_PROPERTY = "pdq.enableRollingLog";
    public static final String ENABLE_ROLLING_LOG_DEFAULT = "ON";
    public static final String ROLLING_LOG_FILE_COUNT_PROPERTY = "pdq.rollingLogFileCount";
    public static final String ROLLING_LOG_FILE_COUNT_DEFAULT = "5";
    public static final String ROLLING_LOG_FILE_SIZE_PROPERTY = "pdq.rollingLogFileSize";
    public static final String ROLLING_LOG_FILE_SIZE_DEFAULT = "50000000";
    static Timer traceTimer_;
    public static final String ENABLE_TRACE_POLLING_PROPERTY = "pdq.enableTracePolling";
    public static final String ENABLE_TRACE_POLLING_DEFAULT = "ON";
    public static final String TRACE_POLLING_INTERVAL_PROPERTY = "pdq.tracePollingInterval";
    public static final String TRACE_POLLING_INTERVAL_DEFAULT = "30";
    public static final String LOG_FILE_LEVEL_PROPERTY = "pdq.traceLevel";
    public static final String LOG_FILE_LEVEL_DEFAULT = "OFF";
    public static final String LOG_TRACE_BUFFER_ROW_COUNT = "pdq.traceBufferRowCount";
    public static final String LOG_TRACE_BUFFER_ROW_COUNT_DEFAULT = "0";
    public static final String LOG_SQL_ERR_CODE_DUMP_PROPERTY = "pdq.dumpLogsOnSqlCodes";
    public static final String LOG_EXCLUDED_SQL_ERR_CODE_PROPERTY = "pdq.dumpLogsExcludingSqlCodes";
    public static final String LOG_EXCLUDED_SQL_ERR_CODE_DEFAULT = "";
    public static final String EXECUTION_MODE_PROPERTY = "pdq.executionMode";
    public static final String EXECUTION_MODE_DEFAULT = "DYNAMIC";
    public static final String QUERY_TIMEOUT = "pdq.queryTimeoutInSeconds";
    public static final String MAX_ROWS = "pdq.maxResultRows";
    public static final String PROPERTIES_REFRESH_INTERVAL = "pdq.propertiesRefreshInterval";
    public static final String PROPERTIES_REFRESH_INTERVAL_DEFAULT = "0";
    public static final String REPOSITORY_RTG_ACTIVATION_CHECK_INTERVAL = "pdq.runtimeGroupActivationCheckInterval";
    public static final String REPOSITORY_RTG_ACTIVATION_CHECK_INTERVAL_DEFAULT = "2";
    public static final String DISABLE_REPOSITORY_PROPERTIES_AND_XML_RELOAD = "pdq.disableRepositoryPropertiesAndXMLReload";
    public static final String DISABLE_REPOSITORY_PROPERTIES_AND_XML_RELOAD_DEFAULT = "FALSE";
    public static final String ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD = "pdq.allowGetterSetterMethodWithPublicField";
    public static final String ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD_DEFAULT = "false";
    public static final String IGNORE_ORPHAN_GETTER_SETTER_METHODS = "pdq.ignoreOrphanGetterSetterMethods";
    public static final String IGNORE_ORPHAN_GETTER_SETTER_METHODS_DEFAULT = "false";
    public static final String ALLOW_MDM_BEAN_RULES = "pdq.allowMDMBeanRules";
    public static final String ALLOW_MDM_BEAN_RULES_DEFAULT = "false";
    public static final String CONTROLLER_DISCOVERY_PORT = "pdq.cmx.controllerDiscoveryPort";
    public static final String CONTROLLER_DISCOVERY_PORT_DEFAULT = "50000";
    public static final String CONTROLLER_DISCOVERY_INTERVAL = "pdq.cmx.controllerDiscoveryInterval";
    public static final String CONTROLLER_DISCOVERY_INTERVAL_DEFAULT = "-1";
    public static final String CONTROLLER_DISCOVERY_DISABLED = "-2";
    public static final String CONTROLLER_URL_PROPERTY = "pdq.cmx.controllerURL";
    public static final String CMX_SERVER_PROPERTY = "pdq.cmx.server";
    public static final String CMX_CONTROLLER_ACCESS_POLICY = "pdq.cmx.controllerAccessPolicy";
    public static final String CMX_CONTROLLER_ACCESS_POLICY_DEFAULT;
    public static final String CMX_READ_TIMEOUT_PROPERTY = "pdq.cmx.readTimeout";
    public static final String CMX_READ_TIMEOUT_PROPERTY_DEFAULT;
    public static final String CMX_CONNECT_TIMEOUT_PROPERTY = "pdq.cmx.connectTimeout";
    public static final String CMX_CONNECT_TIMEOUT_PROPERTY_DEFAULT;
    public static final String CMX_HTTP_CONTROLLER_URL_PROPERTY = "pdq.cmx.http.controllerURL";
    public static final String CMX_HTTP_PROXY_URL_PROPERTY = "pdq.cmx.http.proxyURL";
    public static final String CMX_CLIENT_CACHE_DIRECTORY = "pdq.cmx.clientCacheDirectory";
    public static final String CMX_UUID_PROPERTY = "pdq.cmx.uuid";
    public static final String CMX_HTTP_REQUEST_PATH_PROPERTY = "pdq.cmx.http.requestPath";
    public static final String CMX_HTTP_REQUEST_PATH_PROPERTY_DEFAULT = "/cmx/controller";
    public static final String CMX_HTTP_DISCONNECT_PROPERTY = "pdq.cmx.http.disconnect";
    public static final String CMX_HTTP_DISCONNECT_PROPERTY_DEFAULT = "false";
    public static final String MULTICAST_TTL_PROPERTY = "pdq.cmx.multicastTimeToLive";
    public static final String MULTICAST_TTL_DEFAULT = "10";
    public static final String DATASOURCE_LOOKUP_INTERVAL_PROPERTY = "pdq.cmx.dataSourceLookupInterval";
    public static final String DATASOURCE_LOOKUP_INTERVAL_DEFAULT = "20";
    public static final String PACKAGE_PREFIX_EXCLUSIONS = "pdq.packagePrefixExclusions";
    public static final String ENABLE_DYN_SQL_REPLACEMENT = "pdq.enableDynamicSQLReplacement";
    public static final String ENABLE_DYN_SQL_REPLACEMENT_DEFAULT = "false";
    public static final String MAX_STACK_TRACES_CAPTURED = "pdq.maxStackTracesCaptured";
    public static final String MAX_STACK_TRACES_CAPTURED_DEFAULT = "5";
    public static final String CAPTURE_MODE = "pdq.captureMode";
    public static final String CAPTURE_MODE_DEFAULT = "OFF";
    public static final String ALLOW_DYN_SQL = "pdq.allowDynamicSQL";
    public static final String ALLOW_DYN_SQL_DEFAULT = "true";
    public static final String INPUT_PUREQUERY_XML = "pdq.pureQueryXml";
    public static final String OUTPUT_PUREQUERY_XML = "pdq.outputPureQueryXml";
    public static final String STACK_TRACE_DEPTH = "pdq.stackTraceDepth";
    public static final String STACK_TRACE_DEPTH_DEFAULT = "10";
    public static final String MAX_NON_PARAM_SQL = "pdq.maxNonParmSQL";
    public static final String MAX_NON_PARAM_SQL_DEFAULT = "-1";
    public static final String CAPTURE_STMT_BATCH_SQL = "pdq.captureStatementBatchSQL";
    public static final String CAPTURE_STMT_BATCH_SQL_DEFAULT = "ON";
    public static final String CAPTURED_ONLY = "pdq.capturedOnly";
    public static final String CAPTURED_ONLY_DEFAULT = "false";
    public static final String DISABLE_JDBC_PREREQUISITE_ENFORCEMENT = "pdq.disableJDBCPrerequisiteEnforcement";
    public static final String DISABLE_JDBC_PREREQUISITE_ENFORCEMENT_DEFAULT = "false";
    public static final String SQL_LITERAL_SUBSTITUTION = "pdq.sqlLiteralSubstitution";
    public static final String SQL_LITERAL_SUBSTITUTION_DEFAULT = "NOT_SET";
    public static final String FINAL_REPOSITORY_PROPERTIES = "pdq.finalRepositoryProperties";
    public static final String PROPERTIES_GROUP_ID = "pdq.propertiesGroupId";
    public static final String REPOSITORY_SCHEMA = "pdq.repositorySchema";
    public static final String REPOSITORY_SCHEMA_DEFAULT = "IBMPDQ";
    public static final String OUTPUT_XML_REPOSITORY = "pdq.outputXmlRepository";
    public static final String REPOSITORY_REQUIRED = "pdq.repositoryRequired";
    public static final String REPOSITORY_REQUIRED_DEFAULT;
    public static final long RepositoryErrorCheckTime = 10L;
    private static Properties properties_;
    private static CentralStoreKey dataPropertiesCentralStoreKey_;
    private static List<String> allowedAppSpecificProperties_;
    public static final boolean runningUnderSecurityManager_;
    private static ClassLoaderToAppPropertiesMap<Properties> applicationToPropertiesFileMap_;
    public static final String DS_NAME_KEY = "dataSourceName";
    public static final String PDQ_DS_PROPERTIES_ABSOLUTE_PATH_KEY = "pdq.dataSourceName.properties";
    public static final String PDQ_APPWIDE_PROPERTIES_ABSOLUTE_PATH_KEY = "pdq.appwide.properties";
    public static final String PDQ_WAS_EXT_CLASS_LOADER = "wasExtClassLoader";
    private static boolean isDataPropertiesInitialized__;
    private static List<Throwable> deferredExceptionsToLog__;
    private static List<String[]> deferredPropertyLogs__;
    private static String globalPropertiesFileName_;
    private static boolean propertiesWereSetFromSystemProperties_;
    public static final String CMX_WAS_PURGEPOOL = "pdq.cmx.purgeWASPool";
    public static String CMX_WAS_PURGEPOOL_DEFAULT;
    public static final String CMX_WAS_PURGEPOOL_TYPE = "pdq.cmx.purgeWASPool.type";
    public static String CMX_WAS_PURGEPOOL_TYPE_DEFAULT;
    private static final DataRuntimeException initializationExceptionToThrow;

    public static Properties cloneProperties() {
        return (Properties)properties_.clone();
    }

    public static void logReconfiguredProperties() {
        if (isDataPropertiesInitialized__) {
            Log.getGlobalLogger().logp(Level.CONFIG, "Log.ConfigureLoggerAction", "run", "Logger has been reconfigured with a new handler and properties:" + Messages.getText("MSG_PROP_DUMP", properties_));
        }
    }

    private static void startConfigFileMonitorTask(String string) {
        long l10;
        if (string == null) {
            return;
        }
        String string2 = DataProperties.getProperty(TRACE_POLLING_INTERVAL_PROPERTY);
        long l11 = l10 = Long.valueOf(TRACE_POLLING_INTERVAL_DEFAULT).longValue();
        try {
            l11 = string2 == null ? l10 : Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            l11 = l10;
        }
        if (l11 <= 0L) {
            l11 = l10;
        }
        try {
            ConfigFileMonitorTask configFileMonitorTask = new ConfigFileMonitorTask(string, l11);
            traceTimer_ = new Timer(true);
            traceTimer_.schedule((TimerTask)configFileMonitorTask, l11 * 1000L, l11 * 1000L);
        }
        catch (Exception exception) {
            Logger logger = Log.getGlobalLogger();
            if (logger == null) {
                exception.printStackTrace();
            }
            DataLogger.logThrowable(logger, exception);
            logger.logp(Level.WARNING, "DataProperties", "startConfigFileMonitorTask", "Unable to configure property file polling");
        }
    }

    private static void trimProperties() {
        Enumeration<Object> enumeration = properties_.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties_.getProperty(string);
            if (string2 == null) continue;
            string2 = string2.trim();
            properties_.setProperty(string, string2);
        }
    }

    private static boolean isToolRunning() {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            String string = stackTraceElement.getClassName();
            if (!string.startsWith("com.ibm.db2.cmx.tools.") || string.startsWith("com.ibm.db2.cmx.tools.internal.") || string.endsWith(".DataVersion")) continue;
            return true;
        }
        return false;
    }

    private static synchronized void throwInitializationException() {
        if (isDataPropertiesInitialized__ && null != initializationExceptionToThrow) {
            throw initializationExceptionToThrow;
        }
    }

    public static String getMessageDescribingPropertyLocations(CentralStoreKey centralStoreKey, SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties, boolean bl2, String string) {
        String string2;
        boolean bl3;
        boolean bl4;
        Properties properties;
        String string3;
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (null == sourceInfoForNonGlobalProperties && null != centralStoreKey) {
            sourceInfoForNonGlobalProperties = centralStoreKey.getSourceInfoForNonGlobalProperties();
        }
        String string4 = null == centralStoreKey || !centralStoreKey.getHavePropertiesBeenLoaded() ? null : centralStoreKey.toString();
        String string5 = string3 = null == dataPropertiesCentralStoreKey_ || !dataPropertiesCentralStoreKey_.getHavePropertiesBeenLoaded() ? null : dataPropertiesCentralStoreKey_.toString();
        if (null != sourceInfoForNonGlobalProperties) {
            properties = sourceInfoForNonGlobalProperties.appwideAndDSProperties_;
            bl4 = sourceInfoForNonGlobalProperties.propertiesSetOnDataSourceOrUrlUsed_;
            bl3 = sourceInfoForNonGlobalProperties.propertiesSetInJccGlobalPropertiesUsed_;
        } else {
            properties = null;
            bl4 = false;
            bl3 = false;
        }
        if (bl2) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_DATAFACTORY_GETDATA", new Object[0]));
        }
        if (null != string4) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_REPOSITORY", string4));
        }
        if (null != string3 && !string3.equals(string4)) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_REPOSITORY", string3));
        }
        if (null != properties && null != (string2 = properties.getProperty(PDQ_DS_PROPERTIES_ABSOLUTE_PATH_KEY))) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_FILE", string2));
        }
        if (null != properties && null != (string2 = properties.getProperty(PDQ_APPWIDE_PROPERTIES_ABSOLUTE_PATH_KEY))) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_FILE", string2));
        }
        if (bl4) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_DATASOURCE_PDQPROPERTIES", new Object[0]));
        }
        if (bl3) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_JCC_GLOBAL_PDQPROPERTIES", new Object[0]));
        }
        if (propertiesWereSetFromSystemProperties_) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_SYSTEM_PROPERTIES", new Object[0]));
        }
        if (null != (string2 = globalPropertiesFileName_)) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(Messages.getText("MSG_LIST_PROPERTY_SOURCE_FILE", string2));
        }
        if (0 == stringBuilder.length()) {
            stringBuilder.append(Messages.getText("MSG_DEFAULT_PROPERTIES_BECAUSE_NONE_FOUND", "pureQuery Runtime"));
        } else {
            stringBuilder.insert(0, "  ");
            stringBuilder.insert(0, Messages.getText(Messages.getText("MSG_LIST_PREFIX_FOR_PROPERTY_SOURCES", "pureQuery Runtime"), new Object[0]));
        }
        if (null != string && 0 < stringBuilder.length()) {
            stringBuilder.insert(0, string);
        }
        return stringBuilder.toString();
    }

    public static void fetchPropertiesAndXMLFromCentralStore(CentralStoreKey centralStoreKey, Properties properties, SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties, long l10, RepositoryRequiredValue repositoryRequiredValue) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        Properties properties2 = new Properties(properties);
        try {
            if (centralStoreKey.getKeyType() == CentralStoreKey.CentralStoreKeyType.FILE_SYSTEM) {
                CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_PROPERTIES, centralStoreKey, properties2);
            } else {
                InputStream inputStream = null;
                inputStream = CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_PROPERTIES_XML_FILE, centralStoreKey, properties2);
                centralStoreKey.setTempInputStreamHold(inputStream);
            }
        }
        catch (SQLException sQLException) {
            centralStoreKey.addToExceptionChain(sQLException);
        }
        if (centralStoreKey.getExceptionChain() != null) {
            if (repositoryRequiredValue == RepositoryRequiredValue.REQUIRED_AT_STARTUP || repositoryRequiredValue == RepositoryRequiredValue.REQUIRED_AT_STARTUP_AND_FOR_OUTPUT) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_REPOSITORY_REQUIRED_BUT_UNAVAILABLE", "pureQuery Runtime", REPOSITORY_REQUIRED, repositoryRequiredValue.getPropertyValue()) + DataProperties.getMessageDescribingPropertyLocations(centralStoreKey, sourceInfoForNonGlobalProperties, false, "  "), centralStoreKey.getExceptionChain(), 11038);
            }
            long l11 = l10 > 0L && l10 < 10L ? l10 : 10L;
            PdqTimerServices.addToModificationDetectionQueue(centralStoreKey, l11);
            return;
        }
        DataProperties.mergeProperties(properties, properties2);
    }

    private static String getFileNameFromSystemProperty() {
        String string;
        if (runningUnderSecurityManager_) {
            try {
                string = AccessController.doPrivileged(DataProperties.getSystemPropertyPriv("pdq.configFile"));
            }
            catch (Exception exception) {
                deferredExceptionsToLog__.add(exception);
                string = null;
            }
        } else {
            string = DataProperties.getSystemProperty("pdq.configFile");
        }
        if (isDataPropertiesInitialized__) {
            Logger logger = Log.getGlobalLogger();
            if (logger.isLoggable(Level.CONFIG)) {
                DataLogger.logConfigHighVis(logger, DataProperties.class, "getFileNameFromSystemProperty", Messages.getText("MSG_CONFIG_FILE", "pdq.configFile", string), false);
            }
        } else if (!isDataPropertiesInitialized__) {
            deferredPropertyLogs__.add(new String[]{"getFileNameFromSystemProperty", Messages.getText("MSG_CONFIG_FILE", "pdq.configFile", string)});
        }
        return string;
    }

    public static String getResourceName() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return "pdq.properties";
    }

    private static boolean initFromSystemProperties(Properties properties) {
        boolean bl2 = false;
        Properties properties2 = new Properties();
        List<String> list = DataProperties.getAvailablePropertyNames();
        for (String string : list) {
            String string2;
            if (runningUnderSecurityManager_) {
                try {
                    string2 = AccessController.doPrivileged(DataProperties.getSystemPropertyPriv(string));
                }
                catch (Exception exception) {
                    deferredExceptionsToLog__.add(exception);
                    string2 = null;
                }
            } else {
                string2 = DataProperties.getSystemProperty(string);
            }
            if (string2 == null) continue;
            properties.setProperty(string, string2);
            properties2.setProperty(string, string2);
            bl2 = true;
        }
        Logger logger = Log.getGlobalLogger();
        if (isDataPropertiesInitialized__ && logger.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(logger, DataProperties.class, "initFromSystemProperties", Messages.getText("MSG_PROP_DUMP", "system properties", properties2), true);
        } else if (!isDataPropertiesInitialized__) {
            deferredPropertyLogs__.add(new String[]{"initFromSystemProperties", Messages.getText("MSG_PROP_DUMP", "system properties", properties2)});
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeProperties(Properties properties, Properties properties2) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        Properties properties3 = properties;
        synchronized (properties3) {
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties2.getProperty(string).trim();
                properties.setProperty(string, string2);
            }
            DataFactory.isPropertiesCacheInitialized__ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeDynamicProperties(Properties properties, Properties properties2) {
        Properties properties3 = properties;
        synchronized (properties3) {
            properties.remove(LOG_FILE_PROPERTY);
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!DataProperties.isDynamicProperty(string)) continue;
                String string2 = properties2.getProperty(string).trim();
                properties.setProperty(string, string2);
            }
            DataFactory.isPropertiesCacheInitialized__ = false;
        }
    }

    public static boolean isDynamicProperty(String string) {
        return string.equals(LOG_FILE_LEVEL_PROPERTY) || string.equals(LOG_FILE_PROPERTY) || string.equals(ENABLE_ROLLING_LOG_PROPERTY) || string.equals(ROLLING_LOG_FILE_SIZE_PROPERTY) || string.equals(ROLLING_LOG_FILE_COUNT_PROPERTY) || string.equals(ENABLE_TRACE_POLLING_PROPERTY) || string.equals(TRACE_POLLING_INTERVAL_PROPERTY) || string.equals(ENABLE_CMX_SERVER_LOG_PROPERTY) || string.equals(CMX_SERVER_LOG_FILE_COUNT_PROPERTY) || string.equals(CMX_SERVER_LOG_FILE_SIZE_PROPERTY) || string.equals(CMX_SERVER_LOG_TRACE_LEVEL_PROPERTY);
    }

    public static void mergeProperties(Properties properties) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        DataProperties.mergeProperties(properties_, properties);
    }

    public static void mergeDynamicProperties(Properties properties) {
        DataProperties.mergeDynamicProperties(properties_, properties);
    }

    public static List<String> getAllowedAppSpecificProperties() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return allowedAppSpecificProperties_;
    }

    public static CentralStoreKey getGlobalCentralStoreKey() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return dataPropertiesCentralStoreKey_;
    }

    public static String getProperty(String string) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return properties_.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        properties_.setProperty(string, string2);
        DataFactory.isPropertiesCacheInitialized__ = false;
    }

    public static String getProperty(Properties properties, String string) {
        String string2;
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        if (properties != null && (string2 = properties.getProperty(string)) != null) {
            return string2;
        }
        return DataProperties.getProperty(string);
    }

    public static Integer getPropertyInteger(Properties properties, String string, boolean bl2) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        Integer n2 = null;
        String string2 = DataProperties.getProperty(properties, string);
        if (null != string2) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROPERTY_NOT_INTEGER", string2, string) + DataProperties.getMessageDescribingPropertyLocations(null, null, bl2, "  "), numberFormatException, 10517);
            }
        }
        return n2;
    }

    public static Boolean getPropertyBoolean(String string) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        Boolean bl2 = false;
        String string2 = DataProperties.getProperty(string);
        if (null != string2) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static List<String> getAvailablePropertyNames() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LOG_FILE_PROPERTY);
        arrayList.add(LOG_FILE_LEVEL_PROPERTY);
        arrayList.add(LOG_TRACE_BUFFER_ROW_COUNT);
        arrayList.add(LOG_SQL_ERR_CODE_DUMP_PROPERTY);
        arrayList.add(LOG_EXCLUDED_SQL_ERR_CODE_PROPERTY);
        arrayList.add(ENABLE_ROLLING_LOG_PROPERTY);
        arrayList.add(ROLLING_LOG_FILE_COUNT_PROPERTY);
        arrayList.add(ROLLING_LOG_FILE_SIZE_PROPERTY);
        arrayList.add(ENABLE_TRACE_POLLING_PROPERTY);
        arrayList.add(TRACE_POLLING_INTERVAL_PROPERTY);
        arrayList.add(ENABLE_CMX_SERVER_LOG_PROPERTY);
        arrayList.add(CMX_SERVER_LOG_FILE_COUNT_PROPERTY);
        arrayList.add(CMX_SERVER_LOG_FILE_SIZE_PROPERTY);
        arrayList.add(CMX_SERVER_LOG_TRACE_LEVEL_PROPERTY);
        arrayList.add(EXECUTION_MODE_PROPERTY);
        arrayList.add(QUERY_TIMEOUT);
        arrayList.add(MAX_ROWS);
        arrayList.add(ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD);
        arrayList.add(IGNORE_ORPHAN_GETTER_SETTER_METHODS);
        arrayList.add(ALLOW_MDM_BEAN_RULES);
        arrayList.add(CONTROLLER_DISCOVERY_PORT);
        arrayList.add(CONTROLLER_DISCOVERY_INTERVAL);
        arrayList.add(CMX_SERVER_PROPERTY);
        arrayList.add(CONTROLLER_URL_PROPERTY);
        arrayList.add(CMX_CONTROLLER_ACCESS_POLICY);
        arrayList.add(CMX_READ_TIMEOUT_PROPERTY);
        arrayList.add(CMX_CONNECT_TIMEOUT_PROPERTY);
        arrayList.add(CMX_HTTP_CONTROLLER_URL_PROPERTY);
        arrayList.add(CMX_HTTP_PROXY_URL_PROPERTY);
        arrayList.add(CMX_CLIENT_CACHE_DIRECTORY);
        arrayList.add(CMX_UUID_PROPERTY);
        arrayList.add(CMX_HTTP_REQUEST_PATH_PROPERTY);
        arrayList.add(CMX_HTTP_DISCONNECT_PROPERTY);
        arrayList.add(MULTICAST_TTL_PROPERTY);
        arrayList.add(DATASOURCE_LOOKUP_INTERVAL_PROPERTY);
        arrayList.add(PACKAGE_PREFIX_EXCLUSIONS);
        arrayList.add(ENABLE_DYN_SQL_REPLACEMENT);
        arrayList.add(MAX_STACK_TRACES_CAPTURED);
        arrayList.add(CAPTURE_MODE);
        arrayList.add(ALLOW_DYN_SQL);
        arrayList.add(INPUT_PUREQUERY_XML);
        arrayList.add(OUTPUT_PUREQUERY_XML);
        arrayList.add(STACK_TRACE_DEPTH);
        arrayList.add(MAX_NON_PARAM_SQL);
        arrayList.add(CAPTURE_STMT_BATCH_SQL);
        arrayList.add(CAPTURED_ONLY);
        arrayList.add(DISABLE_JDBC_PREREQUISITE_ENFORCEMENT);
        arrayList.add(SQL_LITERAL_SUBSTITUTION);
        arrayList.add(PROPERTIES_REFRESH_INTERVAL);
        arrayList.add(FINAL_REPOSITORY_PROPERTIES);
        arrayList.add(OUTPUT_XML_REPOSITORY);
        arrayList.add(REPOSITORY_REQUIRED);
        arrayList.add(PROPERTIES_GROUP_ID);
        arrayList.add(REPOSITORY_SCHEMA);
        arrayList.add(REPOSITORY_RTG_ACTIVATION_CHECK_INTERVAL);
        arrayList.add(DISABLE_REPOSITORY_PROPERTIES_AND_XML_RELOAD);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static List<String> getInternalOnlyPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD);
        arrayList.add(IGNORE_ORPHAN_GETTER_SETTER_METHODS);
        arrayList.add(ALLOW_MDM_BEAN_RULES);
        arrayList.add(DISABLE_JDBC_PREREQUISITE_ENFORCEMENT);
        return arrayList;
    }

    public static Properties createDefaultProperties() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        Properties properties = new Properties();
        properties.setProperty(ENABLE_ROLLING_LOG_PROPERTY, "ON");
        properties.setProperty(ROLLING_LOG_FILE_COUNT_PROPERTY, "5");
        properties.setProperty(ROLLING_LOG_FILE_SIZE_PROPERTY, "50000000");
        properties.setProperty(ENABLE_TRACE_POLLING_PROPERTY, "ON");
        properties.setProperty(TRACE_POLLING_INTERVAL_PROPERTY, TRACE_POLLING_INTERVAL_DEFAULT);
        properties.setProperty(ENABLE_CMX_SERVER_LOG_PROPERTY, "ON");
        properties.setProperty(CMX_SERVER_LOG_FILE_COUNT_PROPERTY, CMX_SERVER_LOG_FILE_COUNT_DEFAULT);
        properties.setProperty(CMX_SERVER_LOG_FILE_SIZE_PROPERTY, "50000000");
        properties.setProperty(CMX_SERVER_LOG_TRACE_LEVEL_PROPERTY, CMX_SERVER_LOG_TRACE_LEVEL_DEFAULT);
        properties.setProperty(LOG_FILE_LEVEL_PROPERTY, "OFF");
        properties.setProperty(LOG_TRACE_BUFFER_ROW_COUNT, "0");
        properties.setProperty(EXECUTION_MODE_PROPERTY, EXECUTION_MODE_DEFAULT);
        properties.setProperty(ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD, "false");
        properties.setProperty(IGNORE_ORPHAN_GETTER_SETTER_METHODS, "false");
        properties.setProperty(ALLOW_MDM_BEAN_RULES, "false");
        properties.setProperty(CONTROLLER_DISCOVERY_PORT, CONTROLLER_DISCOVERY_PORT_DEFAULT);
        properties.setProperty(CONTROLLER_DISCOVERY_INTERVAL, "-1");
        properties.setProperty(CMX_CONTROLLER_ACCESS_POLICY, CMX_CONTROLLER_ACCESS_POLICY_DEFAULT);
        properties.setProperty(CMX_READ_TIMEOUT_PROPERTY, CMX_READ_TIMEOUT_PROPERTY_DEFAULT);
        properties.setProperty(CMX_CONNECT_TIMEOUT_PROPERTY, CMX_CONNECT_TIMEOUT_PROPERTY_DEFAULT);
        properties.setProperty(CMX_WAS_PURGEPOOL, CMX_WAS_PURGEPOOL_DEFAULT);
        properties.setProperty(CMX_WAS_PURGEPOOL_TYPE, CMX_WAS_PURGEPOOL_TYPE_DEFAULT);
        properties.setProperty(CMX_HTTP_REQUEST_PATH_PROPERTY, CMX_HTTP_REQUEST_PATH_PROPERTY_DEFAULT);
        properties.setProperty(CMX_HTTP_DISCONNECT_PROPERTY, "false");
        properties.setProperty(MULTICAST_TTL_PROPERTY, "10");
        properties.setProperty(DATASOURCE_LOOKUP_INTERVAL_PROPERTY, DATASOURCE_LOOKUP_INTERVAL_DEFAULT);
        properties.setProperty(ENABLE_DYN_SQL_REPLACEMENT, "false");
        properties.setProperty(MAX_STACK_TRACES_CAPTURED, "5");
        properties.setProperty(CAPTURE_MODE, "OFF");
        properties.setProperty(ALLOW_DYN_SQL, ALLOW_DYN_SQL_DEFAULT);
        properties.setProperty(STACK_TRACE_DEPTH, "10");
        properties.setProperty(MAX_NON_PARAM_SQL, "-1");
        properties.setProperty(CAPTURE_STMT_BATCH_SQL, "ON");
        properties.setProperty(CAPTURED_ONLY, "false");
        properties.setProperty(DISABLE_JDBC_PREREQUISITE_ENFORCEMENT, "false");
        properties.setProperty(SQL_LITERAL_SUBSTITUTION, SQL_LITERAL_SUBSTITUTION_DEFAULT);
        properties.setProperty(PROPERTIES_REFRESH_INTERVAL, "0");
        properties.setProperty(REPOSITORY_REQUIRED, REPOSITORY_REQUIRED_DEFAULT);
        properties.setProperty(REPOSITORY_RTG_ACTIVATION_CHECK_INTERVAL, REPOSITORY_RTG_ACTIVATION_CHECK_INTERVAL_DEFAULT);
        properties.setProperty(REPOSITORY_SCHEMA, REPOSITORY_SCHEMA_DEFAULT);
        properties.setProperty(DISABLE_REPOSITORY_PROPERTIES_AND_XML_RELOAD, DISABLE_REPOSITORY_PROPERTIES_AND_XML_RELOAD_DEFAULT);
        return properties;
    }

    public static void resetPropertiesBeforeMergingWithCentralStoreProperties() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        properties_.setProperty(EXECUTION_MODE_PROPERTY, EXECUTION_MODE_DEFAULT);
        properties_.setProperty(ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD, "false");
        properties_.setProperty(IGNORE_ORPHAN_GETTER_SETTER_METHODS, "false");
        properties_.setProperty(ALLOW_MDM_BEAN_RULES, "false");
        properties_.setProperty(ENABLE_DYN_SQL_REPLACEMENT, "false");
        properties_.setProperty(MAX_STACK_TRACES_CAPTURED, "5");
        properties_.setProperty(CAPTURE_MODE, "OFF");
        properties_.setProperty(ALLOW_DYN_SQL, ALLOW_DYN_SQL_DEFAULT);
        properties_.setProperty(STACK_TRACE_DEPTH, "10");
        properties_.setProperty(MAX_NON_PARAM_SQL, "-1");
        properties_.setProperty(CAPTURE_STMT_BATCH_SQL, "ON");
        properties_.setProperty(CAPTURED_ONLY, "false");
        properties_.setProperty(DISABLE_JDBC_PREREQUISITE_ENFORCEMENT, "false");
        properties_.setProperty(SQL_LITERAL_SUBSTITUTION, SQL_LITERAL_SUBSTITUTION_DEFAULT);
        properties_.setProperty(PROPERTIES_REFRESH_INTERVAL, "0");
        properties_.remove(FINAL_REPOSITORY_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFromResourceInputStream(InputStream inputStream, String string, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        if (inputStream == null) {
            return properties;
        }
        try {
            properties.load(inputStream);
            Logger logger = Log.getGlobalLogger();
            if (isDataPropertiesInitialized__ && logger != null) {
                DataLogger.logConfigHighVis(logger, DataProperties.class, "getPropertiesFromResourceInputStream", Messages.getText("MSG_PROP_DUMP", classLoader.getResource(string).toExternalForm(), properties), true);
            } else if (!isDataPropertiesInitialized__) {
                deferredPropertyLogs__.add(new String[]{"getPropertiesFromResourceInputStream", Messages.getText("MSG_PROP_DUMP", classLoader.getResource(string).toExternalForm(), properties)});
            }
        }
        finally {
            inputStream.close();
        }
        return properties;
    }

    static Properties getPropertiesFromFile(String string) throws Exception {
        if (runningUnderSecurityManager_) {
            return AccessController.doPrivileged(DataProperties.loadPropertiesFromFilePriv(string));
        }
        return DataProperties.loadPropertiesFromFile(string);
    }

    static Properties getPolledPropertiesFromFile(File file) throws Exception {
        if (runningUnderSecurityManager_) {
            return AccessController.doPrivileged(DataProperties.loadPolledPropertiesFromFilePriv(file));
        }
        return DataProperties.loadPolledPropertiesFromFile(file);
    }

    private static String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    private static final PrivilegedAction<String> getSystemPropertyPriv(final String string) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return DataProperties.getSystemProperty(string);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String string) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            properties.load(fileInputStream);
            Logger logger = Log.getGlobalLogger();
            if (isDataPropertiesInitialized__) {
                DataLogger.logConfigHighVis(logger, DataProperties.class, "loadPropertiesFromFile", Messages.getText("MSG_LOADED_PROP_FILE", string), true);
                DataLogger.logConfigHighVis(logger, DataProperties.class, "loadPropertiesFromFile", Messages.getText("MSG_PROP_DUMP", string, properties), true);
            } else if (!isDataPropertiesInitialized__) {
                deferredPropertyLogs__.add(new String[]{"loadPropertiesFromFile", Messages.getText("MSG_LOADED_PROP_FILE", string)});
                deferredPropertyLogs__.add(new String[]{"loadPropertiesFromFile", Messages.getText("MSG_PROP_DUMP", string, properties)});
            }
        }
        finally {
            fileInputStream.close();
        }
        return properties;
    }

    private static Properties loadPolledPropertiesFromFile(File file) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        return properties;
    }

    private static final PrivilegedExceptionAction<Properties> loadPropertiesFromFilePriv(final String string) {
        return new PrivilegedExceptionAction<Properties>(){

            @Override
            public Properties run() throws Exception {
                return DataProperties.loadPropertiesFromFile(string);
            }
        };
    }

    private static final PrivilegedExceptionAction<Properties> loadPolledPropertiesFromFilePriv(final File file) {
        return new PrivilegedExceptionAction<Properties>(){

            @Override
            public Properties run() throws Exception {
                return DataProperties.loadPolledPropertiesFromFile(file);
            }
        };
    }

    private static InputStream getResourceAsInputStream(ClassLoader classLoader, String string) {
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            Logger logger = Log.getGlobalLogger();
            if (isDataPropertiesInitialized__ && logger != null) {
                DataLogger.logConfigHighVis(logger, DataProperties.class, "getResourceAsInputStream", Messages.getText("MSG_LOADED_RESOURCE", classLoader.getResource(string).toExternalForm()), true);
            } else if (!isDataPropertiesInitialized__) {
                deferredPropertyLogs__.add(new String[]{"loadPropertiesFromFile", Messages.getText("MSG_LOADED_RESOURCE", classLoader.getResource(string).toExternalForm())});
            }
            return new BufferedInputStream(inputStream);
        }
        return inputStream;
    }

    private static final PrivilegedAction<InputStream> getResourceAsInputStreamPriv(final ClassLoader classLoader, final String string) {
        return new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return DataProperties.getResourceAsInputStream(classLoader, string);
            }
        };
    }

    private static List<String> createAllowedListOfAppSpecificProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(EXECUTION_MODE_PROPERTY);
        arrayList.add(QUERY_TIMEOUT);
        arrayList.add(MAX_ROWS);
        arrayList.add(ENABLE_DYN_SQL_REPLACEMENT);
        arrayList.add(MAX_STACK_TRACES_CAPTURED);
        arrayList.add(PACKAGE_PREFIX_EXCLUSIONS);
        arrayList.add(CAPTURE_MODE);
        arrayList.add(ALLOW_DYN_SQL);
        arrayList.add(INPUT_PUREQUERY_XML);
        arrayList.add(OUTPUT_PUREQUERY_XML);
        arrayList.add(STACK_TRACE_DEPTH);
        arrayList.add(MAX_NON_PARAM_SQL);
        arrayList.add(CAPTURE_STMT_BATCH_SQL);
        arrayList.add(CAPTURED_ONLY);
        arrayList.add(SQL_LITERAL_SUBSTITUTION);
        arrayList.add(FINAL_REPOSITORY_PROPERTIES);
        arrayList.add(PROPERTIES_REFRESH_INTERVAL);
        arrayList.add(OUTPUT_XML_REPOSITORY);
        arrayList.add(REPOSITORY_REQUIRED);
        arrayList.add(PROPERTIES_GROUP_ID);
        arrayList.add(REPOSITORY_SCHEMA);
        return arrayList;
    }

    private static Properties getPdqPropertiesFromAppClasspath(String string, ClassLoader classLoader) throws SQLException {
        Logger logger = Log.getGlobalLogger();
        if (logger != null) {
            DataLogger.enter(logger, DataProperties.class, "getPdqPropertiesFromAppClasspath: " + string + " " + classLoader);
        }
        String string2 = null;
        if (string != null) {
            string2 = "pdq." + string + ".properties";
        }
        String string3 = PDQ_APPWIDE_PROPERTIES_ABSOLUTE_PATH_KEY;
        Properties properties = DataProperties.getPropertiesForResource(classLoader, logger, string3);
        Properties properties2 = DataProperties.getPropertiesForResource(classLoader, logger, string2);
        Properties properties3 = null;
        if (!properties2.isEmpty() && properties.isEmpty()) {
            properties3 = properties2;
        } else if (!properties.isEmpty() && properties2.isEmpty()) {
            properties3 = properties;
        } else {
            Iterator<String> iterator = allowedAppSpecificProperties_.iterator();
            String string4 = null;
            String string5 = null;
            properties3 = new Properties();
            while (iterator.hasNext()) {
                string4 = iterator.next();
                string5 = properties.getProperty(string4);
                if ((string5 = DataProperties.applyAppVariables(string5)) != null) {
                    properties3.setProperty(string4, string5);
                }
                string5 = properties2.getProperty(string4);
                if ((string5 = DataProperties.applyAppVariables(string5)) == null) continue;
                properties3.setProperty(string4, string5);
            }
        }
        if (string != null) {
            properties3.put(DS_NAME_KEY, string);
        }
        if (!properties2.isEmpty()) {
            properties3.put(PDQ_DS_PROPERTIES_ABSOLUTE_PATH_KEY, DataProperties.getResourceURL(string2, classLoader));
        }
        if (!properties.isEmpty()) {
            properties3.put(PDQ_APPWIDE_PROPERTIES_ABSOLUTE_PATH_KEY, DataProperties.getResourceURL(string3, classLoader));
        }
        if (logger != null) {
            DataLogger.exit(logger, DataProperties.class, "getPdqPropertiesFromAppClasspath", properties3);
        }
        return properties3;
    }

    private static String applyAppVariables(String string) {
        if (string != null) {
            int n2;
            int n3;
            String string2;
            if (string.contains("${appName}")) {
                try {
                    string2 = (String)new InitialContext().lookup("java:app/AppName");
                    if (string2 != null) {
                        string = string.replaceAll("${appName}", string2);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (string.contains("${moduleName}")) {
                try {
                    string2 = (String)new InitialContext().lookup("java:module/ModuleName");
                    if (string2 != null) {
                        string = string.replaceAll("${moduleName}", string2);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if ((n3 = string.indexOf("${")) > -1 && (n2 = string.indexOf(125, n3 + 2)) > -1) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INV_PROP_VARIABLE", string.substring(n3, n2 + 1)), null, 11745);
            }
        }
        return string;
    }

    private static Properties getPropertiesForResource(ClassLoader classLoader, Logger logger, String string) throws SQLException {
        if (logger != null) {
            DataLogger.enter(logger, DataProperties.class, "getPropertiesForResource: " + string + " " + classLoader);
        }
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        try {
            InputStream inputStream = DataProperties.fileExistsOnClasspath(string, classLoader);
            if (inputStream != null) {
                properties = DataProperties.getPropertiesFromResourceInputStream(inputStream, string, classLoader);
            }
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(DataProperties.class, Messages.getText("ERR_PDQ_APP_PROPERTIES_FILE_CANNOT_LOAD", DataProperties.getResourceURL(string, classLoader), classLoader), null, iOException, 10721);
        }
        Enumeration<Object> enumeration = properties.keys();
        Object object = null;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (allowedAppSpecificProperties_.contains(object)) continue;
            Level level = Level.FINEST;
            if (logger != null && logger.isLoggable(level)) {
                String string2 = Messages.getText("WARN_IGNORE_APP_PROPERTY", "pureQuery Runtime", StaticProfileConstants.maskJdbcURLPasswords(object.toString()), DataProperties.getResourceURL(string, classLoader));
                logger.logp(level, DataLogger.getShortName(DataProperties.class), "getPropertiesForResource", string2);
            }
            properties.remove(object);
        }
        if (logger != null) {
            DataLogger.exit(logger, DataProperties.class, "getPropertiesForResource: ", properties);
        }
        return properties;
    }

    private static String getResourceURL(String string, ClassLoader classLoader) {
        String string2 = null;
        try {
            if (null != string) {
                string2 = StaticProfileConstants.maskJdbcURLPasswords(classLoader.getResource(string).toExternalForm());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null != string2 ? string2 : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getAppSpecificProperties(boolean bl2, ClassLoader classLoader, String string) throws SQLException {
        Properties properties;
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        if ((properties = applicationToPropertiesFileMap_.getValueForClsLoaderAndDS(classLoader, string)) == null) {
            ClassLoaderToAppPropertiesMap<Properties> classLoaderToAppPropertiesMap = applicationToPropertiesFileMap_;
            synchronized (classLoaderToAppPropertiesMap) {
                properties = applicationToPropertiesFileMap_.getValueForClsLoaderAndDS(classLoader, string);
                if (properties == null) {
                    Logger logger;
                    String string2 = classLoader.getClass().getName();
                    if (string2.startsWith("com.ibm.") && string2.endsWith(".ExtClassLoader")) {
                        properties = new Properties();
                        properties.setProperty(PDQ_WAS_EXT_CLASS_LOADER, "TRUE");
                        if (string != null) {
                            properties.setProperty(DS_NAME_KEY, string);
                        }
                    } else {
                        properties = DataProperties.getPdqPropertiesFromAppClasspath(string, classLoader);
                    }
                    if (bl2) {
                        applicationToPropertiesFileMap_.replaceValueForClsLoaderAndDS(classLoader, string, properties);
                    }
                    if ((logger = Log.getGlobalLogger()) != null) {
                        DataLogger.logAtLevelFiner(logger, DataProperties.class, "getAppSpecificProperties", "New combination of DataSourceName: " + string + ", ClassLoader: " + string2 + "(" + DataLogger.getShortName(classLoader) + ", allowMapsUpdate: " + bl2 + ", Properties: " + properties.toString() + ")");
                    }
                }
            }
        }
        return properties;
    }

    public static void replaceAppSpecificProperties(boolean bl2, ClassLoader classLoader, Properties properties, String string) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        if (bl2) {
            applicationToPropertiesFileMap_.replaceValueForClsLoaderAndDS(classLoader, string, properties);
        }
    }

    public static RepositoryRequiredValue parseRepositoryRequiredValue(String string, CentralStoreKey centralStoreKey, SourceInfoForNonGlobalProperties sourceInfoForNonGlobalProperties) throws SQLException {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        for (RepositoryRequiredValue repositoryRequiredValue : RepositoryRequiredValue.values()) {
            if (!string.equalsIgnoreCase(repositoryRequiredValue.getPropertyValue())) continue;
            return repositoryRequiredValue;
        }
        String string2 = RepositoryRequiredValue.NOT_REQUIRED.getPropertyValue() + ", " + RepositoryRequiredValue.REQUIRED_AT_STARTUP.getPropertyValue() + ", " + RepositoryRequiredValue.REQUIRED_FOR_OUTPUT.getPropertyValue() + ", " + RepositoryRequiredValue.REQUIRED_AT_STARTUP_AND_FOR_OUTPUT.getPropertyValue();
        throw ExceptionFactory.createDataSQLExceptionForOptimizer(DataProperties.class, Messages.getText("ERR_SQLINSIGHT_INVALID_PROPERTY_VALUE", "repositoryRequired", string, string2) + DataProperties.getMessageDescribingPropertyLocations(centralStoreKey, sourceInfoForNonGlobalProperties, false, "  "), null, null, 10949);
    }

    public static <T> ClassLoaderToAppPropertiesMap<T> createClassLoaderDSFileMap(Class<?> clazz) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return new ClassLoaderToAppPropertiesMap();
    }

    public static boolean isDataPropertiesInitialized() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return isDataPropertiesInitialized__;
    }

    public static List<Throwable> getDeferredExceptionsToLog() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return deferredExceptionsToLog__;
    }

    public static void setDeferredExceptionsToLog(List<Throwable> list) {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        deferredExceptionsToLog__ = list;
    }

    public static List<String[]> getDeferredPropertyLogs() {
        if (null != initializationExceptionToThrow) {
            DataProperties.throwInitializationException();
        }
        return deferredPropertyLogs__;
    }

    private static Properties getFilteredExternalProperties(Properties properties) {
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        for (String string : DataProperties.getInternalOnlyPropertyNames()) {
            properties2.remove(string);
        }
        return properties2;
    }

    private static Boolean doesFileExist(String string) {
        return new File(string).exists();
    }

    private static final PrivilegedAction<Boolean> doesFileExistPriv(final String string) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return DataProperties.doesFileExist(string);
            }
        };
    }

    private static boolean fileExists(String string) {
        try {
            if (runningUnderSecurityManager_) {
                return AccessController.doPrivileged(DataProperties.doesFileExistPriv(string));
            }
            return DataProperties.doesFileExist(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String fileAbsolutePath(String string) {
        try {
            if (runningUnderSecurityManager_) {
                return AccessController.doPrivileged(DataProperties.getFileAbsolutePathPriv(string));
            }
            return DataProperties.getFileAbsolutePath_doNotCallDirectly(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static final PrivilegedAction<String> getFileAbsolutePathPriv(final String string) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return DataProperties.getFileAbsolutePath_doNotCallDirectly(string);
            }
        };
    }

    private static String getFileAbsolutePath_doNotCallDirectly(String string) {
        return new File(string).getAbsolutePath();
    }

    private static ClassLoader getClassloaderForClass(final Class clazz) {
        if (runningUnderSecurityManager_) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    private static InputStream fileExistsOnClasspath(String string, ClassLoader classLoader) {
        InputStream inputStream = runningUnderSecurityManager_ ? AccessController.doPrivileged(DataProperties.getResourceAsInputStreamPriv(classLoader, string)) : DataProperties.getResourceAsInputStream(classLoader, string);
        return inputStream;
    }

    private static ProtectionDomain getProtectionDomainForClass(final Class clazz) {
        if (runningUnderSecurityManager_) {
            return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

                @Override
                public ProtectionDomain run() {
                    return clazz.getProtectionDomain();
                }
            });
        }
        return clazz.getProtectionDomain();
    }

    static {
        String string;
        traceTimer_ = null;
        CMX_CONTROLLER_ACCESS_POLICY_DEFAULT = String.valueOf(Environment.defaultControllerAccessPolicy__.ordinal());
        CMX_READ_TIMEOUT_PROPERTY_DEFAULT = String.valueOf(50);
        CMX_CONNECT_TIMEOUT_PROPERTY_DEFAULT = String.valueOf(20);
        REPOSITORY_REQUIRED_DEFAULT = RepositoryRequiredValue.NOT_REQUIRED.getPropertyValue();
        isDataPropertiesInitialized__ = false;
        deferredExceptionsToLog__ = new ArrayList<Throwable>();
        deferredPropertyLogs__ = new ArrayList<String[]>();
        globalPropertiesFileName_ = null;
        propertiesWereSetFromSystemProperties_ = false;
        CMX_WAS_PURGEPOOL_DEFAULT = ALLOW_DYN_SQL_DEFAULT;
        CMX_WAS_PURGEPOOL_TYPE_DEFAULT = "false";
        runningUnderSecurityManager_ = null != System.getSecurityManager();
        DataRuntimeException dataRuntimeException = null;
        try {
            Object object;
            properties_ = DataProperties.createDefaultProperties();
            deferredPropertyLogs__.add(new String[]{"init", Messages.getText("MSG_DEFAULT_PROPS", DataProperties.getFilteredExternalProperties(properties_))});
            allowedAppSpecificProperties_ = DataProperties.createAllowedListOfAppSpecificProperties();
            string = DataProperties.getFileNameFromSystemProperty();
            ClassLoader classLoader = DataProperties.getClassloaderForClass(DataProperties.class);
            if (string != null) {
                InputStream inputStream = DataProperties.fileExistsOnClasspath(string, classLoader);
                if (inputStream != null) {
                    globalPropertiesFileName_ = DataProperties.getResourceURL(string, classLoader);
                    try {
                        object = DataProperties.getPropertiesFromResourceInputStream(inputStream, string, classLoader);
                        DataProperties.mergeProperties(properties_, (Properties)object);
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_CANNOT_LOAD_PROPERTIES_FILE_AS_RESOURCE", globalPropertiesFileName_, classLoader.toString()), throwable, 11033);
                    }
                } else {
                    globalPropertiesFileName_ = DataProperties.fileAbsolutePath(string);
                    try {
                        object = DataProperties.getPropertiesFromFile(string);
                        DataProperties.mergeProperties(properties_, (Properties)object);
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_CANNOT_LOAD_PROPERTIES_FILE", globalPropertiesFileName_), throwable, 11034);
                    }
                }
            } else {
                InputStream inputStream = DataProperties.fileExistsOnClasspath(DataProperties.getResourceName(), classLoader);
                if (inputStream != null) {
                    globalPropertiesFileName_ = DataProperties.getResourceURL(DataProperties.getResourceName(), classLoader);
                    try {
                        object = DataProperties.getPropertiesFromResourceInputStream(inputStream, DataProperties.getResourceName(), classLoader);
                        DataProperties.mergeProperties(properties_, (Properties)object);
                    }
                    catch (IOException iOException) {
                        deferredExceptionsToLog__.add(iOException);
                    }
                } else if (!DataProperties.isToolRunning()) {
                    object = "pdq.properties";
                    if (DataProperties.fileExists((String)object)) {
                        globalPropertiesFileName_ = DataProperties.fileAbsolutePath((String)object);
                        try {
                            Properties properties = DataProperties.getPropertiesFromFile((String)object);
                            DataProperties.mergeProperties(properties_, properties);
                        }
                        catch (Throwable throwable) {
                            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_CANNOT_LOAD_PROPERTIES_FILE", globalPropertiesFileName_), throwable, 11035);
                        }
                    }
                    ProtectionDomain protectionDomain = DataProperties.getProtectionDomainForClass(DataProperties.class);
                    String string2 = protectionDomain.getCodeSource().getLocation().getPath();
                    int n2 = string2.lastIndexOf("pdq.jar");
                    if (n2 >= 0) {
                        string2 = string2.substring(0, n2);
                    }
                    if (DataProperties.fileExists(string2 = string2 + "pdq.properties")) {
                        globalPropertiesFileName_ = string2;
                        try {
                            Properties properties = DataProperties.getPropertiesFromFile(string2);
                            DataProperties.mergeProperties(properties_, properties);
                        }
                        catch (Throwable throwable) {
                            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_CANNOT_LOAD_PROPERTIES_FILE", globalPropertiesFileName_), throwable, 11772);
                        }
                    }
                }
            }
            if (applicationToPropertiesFileMap_ == null) {
                applicationToPropertiesFileMap_ = DataProperties.createClassLoaderDSFileMap(Properties.class);
            }
            propertiesWereSetFromSystemProperties_ = DataProperties.initFromSystemProperties(properties_);
            if (properties_.getProperty(FINAL_REPOSITORY_PROPERTIES) != null) {
                try {
                    dataPropertiesCentralStoreKey_ = new CentralStoreKey(properties_.getProperty(FINAL_REPOSITORY_PROPERTIES), properties_.getProperty(PROPERTIES_GROUP_ID), properties_.getProperty(REPOSITORY_SCHEMA), true, null);
                    dataPropertiesCentralStoreKey_.setDataProperties(true);
                }
                catch (Throwable throwable) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_ILLEGAL_PROPERTY_VALUE_2", FINAL_REPOSITORY_PROPERTIES, PROPERTIES_GROUP_ID), throwable, 11036);
                }
            }
            deferredPropertyLogs__.add(new String[]{"init", Messages.getText("MSG_ACTIVE_PROPERTIES", properties_)});
        }
        catch (DataRuntimeException dataRuntimeException2) {
            dataRuntimeException = dataRuntimeException2;
        }
        catch (Throwable throwable) {
            dataRuntimeException = ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_EXCEPTION_WHILE_LOADING_PROPERTIES", "pureQuery Runtime") + DataProperties.getMessageDescribingPropertyLocations(dataPropertiesCentralStoreKey_, null, false, "  "), throwable, 11037);
        }
        initializationExceptionToThrow = dataRuntimeException;
        if (null != initializationExceptionToThrow) {
            deferredExceptionsToLog__.add(initializationExceptionToThrow);
        }
        string = DataProperties.getProperty(ENABLE_TRACE_POLLING_PROPERTY);
        if (globalPropertiesFileName_ != null && string.trim().equals("ON")) {
            DataProperties.startConfigFileMonitorTask(globalPropertiesFileName_);
        }
        isDataPropertiesInitialized__ = true;
    }

    public static class SourceInfoForNonGlobalProperties {
        public Properties appwideAndDSProperties_ = null;
        public boolean propertiesSetOnDataSourceOrUrlUsed_ = false;
        public boolean propertiesSetInJccGlobalPropertiesUsed_ = false;
        public String dataSourceName_ = null;
    }

    public static enum RepositoryRequiredValue {
        REQUIRED_AT_STARTUP("atStartup"),
        REQUIRED_FOR_OUTPUT("forOutput"),
        REQUIRED_AT_STARTUP_AND_FOR_OUTPUT("atStartupAndForOutput"),
        NOT_REQUIRED("no");

        private String propertyValue;

        private RepositoryRequiredValue(String string2) {
            this.propertyValue = string2;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }
    }
}

