/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird;

import java.util.ResourceBundle;
import org.firebirdsql.logging.LoggerFactory;

public final class Version {
    public static final String JAYBIRD_SIMPLE_VERSION;
    public static final String JAYBIRD_DISPLAY_VERSION;
    public static final int JAYBIRD_MAJOR_VERSION;
    public static final int JAYBIRD_MINOR_VERSION;

    private Version() {
    }

    private static int tryParseInt(String stringValue) {
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(Version.class).error("org.firebirdsql.jaybird.Version: Unable to parse number " + stringValue + "; defaulting to 0: " + e);
            return 0;
        }
    }

    static {
        int jaybirdMinorVersion;
        int jaybirdMajorVersion;
        String jaybirdDisplayVersion;
        String jaybirdSimpleVersion;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.firebirdsql.jaybird.version");
            jaybirdSimpleVersion = resourceBundle.getString("jaybird.version.simple");
            jaybirdDisplayVersion = resourceBundle.getString("jaybird.version.display");
            jaybirdMajorVersion = Version.tryParseInt(resourceBundle.getString("jaybird.version.major"));
            jaybirdMinorVersion = Version.tryParseInt(resourceBundle.getString("jaybird.version.minor"));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Version.class).error("org.firebirdsql.jaybird.Version: Unable to load version information: " + e);
            jaybirdSimpleVersion = "version unknown";
            jaybirdDisplayVersion = "Jaybird (version unknown)";
            jaybirdMajorVersion = 0;
            jaybirdMinorVersion = 0;
        }
        JAYBIRD_SIMPLE_VERSION = jaybirdSimpleVersion;
        JAYBIRD_DISPLAY_VERSION = jaybirdDisplayVersion;
        JAYBIRD_MAJOR_VERSION = jaybirdMajorVersion;
        JAYBIRD_MINOR_VERSION = jaybirdMinorVersion;
    }
}

