/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.lint;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.command.lint.options.LintReportOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.lint.LintDispatch;
import schemacrawler.tools.lint.LintReport;
import schemacrawler.tools.lint.Linters;
import schemacrawler.tools.lint.config.LinterConfigUtility;
import schemacrawler.tools.lint.config.LinterConfigs;
import schemacrawler.tools.lint.formatter.LintReportBuilder;
import schemacrawler.tools.lint.formatter.LintReportJsonBuilder;
import schemacrawler.tools.lint.formatter.LintReportTextFormatter;
import schemacrawler.tools.lint.formatter.LintReportYamlBuilder;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public class LintCommand
extends BaseSchemaCrawlerCommand<LintOptions> {
    private static final Logger LOGGER = Logger.getLogger(LintCommand.class.getName());
    public static final String COMMAND = "lint";

    public LintCommand() {
        super(COMMAND);
    }

    public void checkAvailability() {
    }

    public void execute() {
        this.checkCatalog();
        LinterConfigs linterConfigs = LinterConfigUtility.readLinterConfigs((LintOptions)this.commandOptions);
        LOGGER.log(Level.FINEST, (Supplier<String>)new ObjectToStringFormat((Object)linterConfigs));
        Linters linters = new Linters(linterConfigs, ((LintOptions)this.commandOptions).isRunAllLinters());
        linters.lint(this.catalog, this.connection);
        LintReport lintReport = new LintReport(this.outputOptions.getTitle(), this.catalog.getCrawlInfo(), linters.getCollector().getLints());
        LOGGER.log(Level.INFO, "Generating lint report");
        this.getLintReportBuilder().generateLintReport(lintReport);
        LOGGER.log(Level.INFO, "Dispatching lint results");
        this.dispatch(linters);
    }

    public boolean usesConnection() {
        return true;
    }

    private void dispatch(Linters linters) {
        boolean exceedsThreshold = linters.exceedsThreshold();
        String lintSummary = linters.getLintSummary();
        if (!lintSummary.isEmpty()) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Lint summary:%n%s", new Object[]{lintSummary}));
            if (exceedsThreshold) {
                System.err.println(lintSummary);
            }
        }
        if (!exceedsThreshold) {
            return;
        }
        LintDispatch lintDispatch = ((LintOptions)this.commandOptions).getLintDispatch();
        lintDispatch.dispatch();
    }

    private LintReportBuilder getLintReportBuilder() {
        LintReportBuilder lintReportBuilder;
        LintReportOutputFormat outputFormat = LintReportOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        switch (outputFormat) {
            case json: {
                lintReportBuilder = new LintReportJsonBuilder(this.outputOptions);
                break;
            }
            case yaml: {
                lintReportBuilder = new LintReportYamlBuilder(this.outputOptions);
                break;
            }
            default: {
                lintReportBuilder = new LintReportTextFormatter(this.catalog, (LintOptions)this.commandOptions, this.outputOptions, this.identifiers.getIdentifierQuoteString());
            }
        }
        return lintReportBuilder;
    }
}

