/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.Linter;
import us.fatehi.utility.string.StringFormat;

public final class LinterRegistry
implements Iterable<String> {
    private static final Logger LOGGER = Logger.getLogger(LinterRegistry.class.getName());
    private static final Linter NO_OP_LINTER = new BaseLinter(){

        @Override
        public String getLinterId() {
            return "schemacrawler.NO_OP_LINTER";
        }

        @Override
        public String getSummary() {
            return "No-op linter";
        }

        @Override
        protected void lint(Table table, Connection connection) {
        }
    };
    private final Map<String, Class<Linter>> linterRegistry = LinterRegistry.loadLinterRegistry();

    private static Map<String, Class<Linter>> loadLinterRegistry() {
        HashMap<String, Class<Linter>> linterRegistry = new HashMap<String, Class<Linter>>();
        try {
            ServiceLoader<Linter> serviceLoader = ServiceLoader.load(Linter.class);
            for (Linter linter : serviceLoader) {
                String linterId = linter.getLinterId();
                Class<?> linterClass = linter.getClass();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Loading linter, %s=%s", new Object[]{linterId, linterClass.getName()}));
                linterRegistry.put(linterId, linterClass);
            }
        }
        catch (Exception e) {
            throw new InternalRuntimeException("Could not load linter registry", (Throwable)e);
        }
        return linterRegistry;
    }

    public Set<String> allRegisteredLinters() {
        return new TreeSet<String>(this.linterRegistry.keySet());
    }

    public boolean hasLinter(String linterId) {
        return this.linterRegistry.containsKey(linterId);
    }

    @Override
    public Iterator<String> iterator() {
        return this.allRegisteredLinters().iterator();
    }

    public Linter newLinter(String linterId) {
        if (this.hasLinter(linterId)) {
            Class<Linter> linterClass = this.linterRegistry.get(linterId);
            try {
                Linter linter = linterClass.newInstance();
                return linter;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not instantiate linter <%s>", new Object[]{linterClass.getName()}));
                return NO_OP_LINTER;
            }
        }
        LOGGER.log(Level.WARNING, (Supplier<String>)new StringFormat("Could not instantiate linter with id <%s>", new Object[]{linterId}));
        return NO_OP_LINTER;
    }
}

