/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.text.diagram.GraphExecutor;
import schemacrawler.tools.command.text.diagram.GraphExecutorFactory;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.text.formatter.diagram.SchemaDotFormatter;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.IOUtility;

public final class DiagramRenderer
extends BaseSchemaCrawlerCommand<DiagramOptions> {
    private DiagramOutputFormat diagramOutputFormat;
    private final GraphExecutorFactory graphExecutorFactory;

    public DiagramRenderer(String command, GraphExecutorFactory graphExecutorFactory) {
        super(command);
        this.graphExecutorFactory = Objects.requireNonNull(graphExecutorFactory, "No graph executor factory provided");
    }

    public void checkAvailability() {
        this.graphExecutorFactory.canGenerate(this.diagramOutputFormat);
    }

    public void execute() {
        Path dotFile;
        this.checkCatalog();
        this.outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.outputOptions).withOutputFormat((OutputFormat)this.diagramOutputFormat).withOutputFormatValue(this.diagramOutputFormat.getFormat()).toOptions();
        try {
            dotFile = IOUtility.createTempFilePath((String)"schemacrawler.", (String)"dot");
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not create temporary DOT file", e);
        }
        OutputOptions dotFileOutputOptions = this.diagramOutputFormat == DiagramOutputFormat.scdot ? this.outputOptions : OutputOptionsBuilder.builder((OutputOptions)this.outputOptions).withOutputFormat((OutputFormat)DiagramOutputFormat.scdot).withOutputFile(dotFile).toOptions();
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFileOutputOptions);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(this.catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator((Comparator)NamedObjectSort.getNamedObjectSort((boolean)((DiagramOptions)this.commandOptions).isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator((Comparator)NamedObjectSort.getNamedObjectSort((boolean)((DiagramOptions)this.commandOptions).isAlphabeticalSortForRoutines()));
        traverser.traverse();
        Path outputFile = this.outputOptions.getOutputFile(this.outputOptions.getOutputFormatValue());
        this.outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.outputOptions).withOutputFormat((OutputFormat)this.diagramOutputFormat).withOutputFormatValue(this.diagramOutputFormat.getFormat()).withOutputFile(outputFile).toOptions();
        try {
            GraphExecutor graphExecutor = this.graphExecutorFactory.getGraphExecutor(dotFile, this.diagramOutputFormat, outputFile, (DiagramOptions)this.commandOptions);
            graphExecutor.run();
        }
        catch (Exception e) {
            String message = IOUtility.readResourceFully((String)"/dot.error.txt");
            throw new ExecutionRuntimeException(message);
        }
    }

    public void initialize() {
        super.initialize();
        this.diagramOutputFormat = DiagramOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
    }

    public boolean usesConnection() {
        return false;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf((String)this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(OutputOptions outputOptions) {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, (DiagramOptions)this.commandOptions, outputOptions, identifierQuoteString);
        return formatter;
    }
}

