/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.ng.AbstractImmutableAttachProperties;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;

public final class FbImmutableConnectionProperties
extends AbstractImmutableAttachProperties<IConnectionProperties>
implements IConnectionProperties {
    private final String databaseName;
    private final short connectionDialect;
    private final int pageCacheSize;
    private final boolean resultSetDefaultHoldable;
    private final boolean columnLabelForName;
    private final String sessionTimezone;
    private final DatabaseParameterBuffer extraDatabaseParameters;

    public FbImmutableConnectionProperties(IConnectionProperties src) {
        super(src);
        this.databaseName = src.getDatabaseName();
        this.connectionDialect = src.getConnectionDialect();
        this.pageCacheSize = src.getPageCacheSize();
        this.resultSetDefaultHoldable = src.isResultSetDefaultHoldable();
        this.columnLabelForName = src.isColumnLabelForName();
        this.sessionTimezone = src.getSessionTimeZone();
        this.extraDatabaseParameters = src.getExtraDatabaseParameters().deepCopy();
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.immutable();
    }

    @Override
    public String getAttachObjectName() {
        return this.getDatabaseName();
    }

    @Override
    public short getConnectionDialect() {
        return this.connectionDialect;
    }

    @Override
    public void setConnectionDialect(short connectionDialect) {
        this.immutable();
    }

    @Override
    public int getPageCacheSize() {
        return this.pageCacheSize;
    }

    @Override
    public void setPageCacheSize(int pageCacheSize) {
        this.immutable();
    }

    @Override
    public void setResultSetDefaultHoldable(boolean holdable) {
        this.immutable();
    }

    @Override
    public boolean isResultSetDefaultHoldable() {
        return this.resultSetDefaultHoldable;
    }

    @Override
    public void setColumnLabelForName(boolean columnLabelForName) {
        this.immutable();
    }

    @Override
    public boolean isColumnLabelForName() {
        return this.columnLabelForName;
    }

    @Override
    public void setSessionTimeZone(String sessionTimeZone) {
        this.immutable();
    }

    @Override
    public String getSessionTimeZone() {
        return this.sessionTimezone;
    }

    @Override
    public DatabaseParameterBuffer getExtraDatabaseParameters() {
        return this.extraDatabaseParameters.deepCopy();
    }

    @Override
    public IConnectionProperties asImmutable() {
        return this;
    }

    @Override
    public IConnectionProperties asNewMutable() {
        return new FbConnectionProperties(this);
    }
}

