/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DependantObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schemacrawler.Identifiers;

abstract class AbstractDependantObject<D extends DatabaseObject>
extends AbstractDatabaseObject
implements DependantObject<D> {
    private static final long serialVersionUID = -4327208866052082457L;
    private final DatabaseObjectReference<D> parent;
    private transient NamedObjectKey key;
    private transient String fullName;
    private transient String shortName;

    AbstractDependantObject(DatabaseObjectReference<D> parent, String name) {
        super(Objects.requireNonNull(parent, "Parent of dependent object not provided").get().getSchema(), name);
        this.parent = parent;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DependantObject)) {
            return false;
        }
        return Objects.equals(this.parent, ((DependantObject)obj).getParent());
    }

    @Override
    public final String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public final D getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.get();
    }

    @Override
    public final String getShortName() {
        this.buildShortName();
        return this.shortName;
    }

    @Override
    public final int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.parent);
        return result;
    }

    @Override
    public final boolean isParentPartial() {
        return this.parent.isPartialDatabaseObjectReference();
    }

    @Override
    public NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        this.fullName = Identifiers.STANDARD.quoteFullName(this);
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = this.parent.get().key().with(this.getName());
    }

    private void buildShortName() {
        if (this.shortName != null) {
            return;
        }
        this.shortName = Identifiers.STANDARD.quoteShortName(this);
    }
}

