/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class DatabaseConnectorRegistry
implements Iterable<DatabaseServerType> {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnectorRegistry.class.getName());
    private static DatabaseConnectorRegistry databaseConnectorRegistrySingleton;
    private final Map<String, DatabaseConnector> databaseConnectorRegistry;

    public static DatabaseConnectorRegistry getDatabaseConnectorRegistry() {
        if (databaseConnectorRegistrySingleton == null) {
            databaseConnectorRegistrySingleton = new DatabaseConnectorRegistry();
        }
        return databaseConnectorRegistrySingleton;
    }

    private static Map<String, DatabaseConnector> loadDatabaseConnectorRegistry() {
        HashMap<String, DatabaseConnector> databaseConnectorRegistry = new HashMap<String, DatabaseConnector>();
        try {
            ServiceLoader<DatabaseConnector> serviceLoader = ServiceLoader.load(DatabaseConnector.class);
            for (DatabaseConnector databaseConnector : serviceLoader) {
                String databaseSystemIdentifier = databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier();
                try {
                    LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loading database connector, %s=%s", new Object[]{databaseSystemIdentifier, databaseConnector.getClass().getName()}));
                    databaseConnectorRegistry.put(databaseSystemIdentifier, databaseConnector);
                }
                catch (Exception e) {
                    LOGGER.log(Level.CONFIG, e, (Supplier<String>)new StringFormat("Could not load database connector, %s=%s", new Object[]{databaseSystemIdentifier, databaseConnector.getClass().getName()}));
                }
            }
        }
        catch (Exception e) {
            throw new InternalRuntimeException("Could not load database connector registry", (Throwable)e);
        }
        return databaseConnectorRegistry;
    }

    private static void loadJdbcDrivers() {
        boolean log = LOGGER.isLoggable(Level.CONFIG);
        int index = 0;
        StringBuilder buffer = new StringBuilder(1024);
        try {
            buffer.append("Registered JDBC drivers:").append(System.lineSeparator());
            ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class);
            for (Driver driver : serviceLoader) {
                ++index;
                if (!log) continue;
                buffer.append(String.format("%2d %50s", index, driver.getClass().getName()));
                try {
                    buffer.append(String.format(" %2d.%d", driver.getMajorVersion(), driver.getMinorVersion()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer.append(System.lineSeparator());
            }
        }
        catch (Throwable e) {
            throw new InternalRuntimeException("Could not load database drivers", e);
        }
        if (log) {
            LOGGER.log(Level.CONFIG, buffer.toString());
        }
    }

    private DatabaseConnectorRegistry() {
        DatabaseConnectorRegistry.loadJdbcDrivers();
        this.databaseConnectorRegistry = DatabaseConnectorRegistry.loadDatabaseConnectorRegistry();
    }

    public DatabaseConnector findDatabaseConnector(Connection connection) {
        try {
            DatabaseUtility.checkConnection((Connection)connection);
            String url = connection.getMetaData().getURL();
            return this.findDatabaseConnectorFromUrl(url);
        }
        catch (SQLException e) {
            return DatabaseConnector.UNKNOWN;
        }
    }

    public DatabaseConnector findDatabaseConnectorFromDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        if (this.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
            return this.databaseConnectorRegistry.get(databaseSystemIdentifier);
        }
        return DatabaseConnector.UNKNOWN;
    }

    public DatabaseConnector findDatabaseConnectorFromUrl(String url) {
        if (Utility.isBlank((CharSequence)url)) {
            return DatabaseConnector.UNKNOWN;
        }
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            if (!databaseConnector.supportsUrl(url)) continue;
            return databaseConnector;
        }
        return DatabaseConnector.UNKNOWN;
    }

    public Collection<PluginCommand> getHelpCommands() {
        ArrayList<PluginCommand> commandLineHelpCommands = new ArrayList<PluginCommand>();
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            commandLineHelpCommands.add(databaseConnector.getHelpCommand());
        }
        return commandLineHelpCommands;
    }

    public boolean hasDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        return this.databaseConnectorRegistry.containsKey(databaseSystemIdentifier);
    }

    @Override
    public Iterator<DatabaseServerType> iterator() {
        ArrayList<Object> databaseServerTypes = new ArrayList<Object>();
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            databaseServerTypes.add(databaseConnector.getDatabaseServerType());
        }
        databaseServerTypes.sort(Comparator.naturalOrder());
        return databaseServerTypes.iterator();
    }
}

