SELECT /*+ PARALLEL(AUTO) */
  NULL AS SYNONYM_CATALOG,
  SYNONYMS.OWNER AS SYNONYM_SCHEMA,
  SYNONYMS.SYNONYM_NAME,
  NULL AS REFERENCED_OBJECT_CATALOG,
  SYNONYMS.TABLE_OWNER AS REFERENCED_OBJECT_SCHEMA,
  SYNONYMS.TABLE_NAME AS REFERENCED_OBJECT_NAME
FROM
  ${catalogscope}_SYNONYMS SYNONYMS
WHERE
  SYNONYMS.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(SYNONYMS.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(SYNONYMS.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(SYNONYMS.OWNER, '${schemas}')
  AND SYNONYMS.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(SYNONYMS.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
ORDER BY
  SYNONYM_SCHEMA,
  SYNONYM_NAME
