/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.concurrent.Semaphore;

public final class AdjustableSemaphore {
    private final ResizeableSemaphore semaphore;
    private int maxPermits = 0;

    public AdjustableSemaphore(int size) {
        this.semaphore = new ResizeableSemaphore(size);
    }

    public synchronized void setMaxPermits(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + newMax);
        }
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            this.semaphore.reducePermits(delta *= -1);
        }
        this.maxPermits = newMax;
    }

    public void release() {
        this.semaphore.release();
    }

    public void release(int numPermits) {
        this.semaphore.release(numPermits);
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public synchronized int getMaxPermits() {
        return this.maxPermits;
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        ResizeableSemaphore(int size) {
            super(size);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

