/*
 * Copyright (c) 2013-2014 Samsung Electronics Co., Ltd.
 *              http://www.samsung.com/
 *
 * EXYNOS542X - Adaptive Supply Voltage Header file
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_EXYNOS542X_ASV_H
#define __ASM_ARCH_EXYNOS542X_ASV_H

#include <mach/asv-exynos.h>

#define EXYNOS542X_MAX_ASV_GRP_NR		15
#define EXYNOS5420_MAX_ASV_GRP_NR		15
#define EXYNOS5422_MAX_ASV_GRP_NR		14

#define EXYNOS5420_ARM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_arm_asv_volt_info)
#define EXYNOS5420_ARM_MAX_VOLT			1362500

#define EXYNOS5420_KFC_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_kfc_asv_volt_info)
#define EXYNOS5420_KFC_MAX_VOLT			1312500

#define EXYNOS5420_G3D_MP4_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_g3d_mp4_asv_volt_info)
#define EXYNOS5420_G3D_MP4_MAX_VOLT		1150000

#define EXYNOS5420_G3D_MP6_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_g3d_mp6_asv_volt_info)
#define EXYNOS5420_G3D_MP6_MAX_VOLT		1200000

#define EXYNOS5420_INT_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_int_asv_volt_info)
#define EXYNOS5420_INT_MAX_VOLT			1212500

#define EXYNOS5420_MIF_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_mif_asv_volt_info)
#define EXYNOS5420_MIF_MAX_VOLT			1050000

#define EXYNOS5420_MIF_SRAM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_mif_sram_asv_volt_info)
#define EXYNOS5420_MIF_SRAM_MAX_VOLT		1050000

#define EXYNOS5420_G3D_MP4_SRAM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_g3d_mp4_sram_asv_volt_info)
#define EXYNOS5420_G3D_MP4_SRAM_MAX_VOLT	1050000

#define EXYNOS5420_G3D_MP6_SRAM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5420_g3d_mp6_sram_asv_volt_info)
#define EXYNOS5420_G3D_MP6_SRAM_MAX_VOLT	1200000

#define EXYNOS5422_ARM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_arm_asv_volt_info)
#define EXYNOS5422_ARM_MAX_VOLT			1362500

#define EXYNOS5422_KFC_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_kfc_asv_volt_info)
#define EXYNOS5422_KFC_MAX_VOLT			1300000

#define EXYNOS5422_G3D_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_g3d_asv_volt_info)
#define EXYNOS5422_G3D_MAX_VOLT			1025000

#define EXYNOS5422_INT_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_int_asv_volt_info)
#define EXYNOS5422_INT_MAX_VOLT			1025000

#define EXYNOS5422_MIF_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_mif_asv_volt_info)
#define EXYNOS5422_MIF_MAX_VOLT			1000000

#define EXYNOS5422_MIF_SRAM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_mif_sram_asv_volt_info)
#define EXYNOS5422_MIF_SRAM_MAX_VOLT		1000000

#define EXYNOS5422_G3D_SRAM_DVFS_LEVEL_NR \
			ARRAY_SIZE(exynos5422_g3d_sram_asv_volt_info)
#define EXYNOS5422_G3D_SRAM_MAX_VOLT		1025000

static const unsigned int
exynos5420_refer_table_get_asv[2][EXYNOS542X_MAX_ASV_GRP_NR] = {
	{ 0, 11, 15, 20, 24, 29, 36, 43, 52, 63, 76, 91, 100, 110, 999 },
	{ 0, 65, 69, 72, 74, 76, 78, 80, 82, 84, 87, 89,  91,  92, 999 },
};

static const unsigned int
exynos5420_refer_use_table_get_asv[2][EXYNOS542X_MAX_ASV_GRP_NR] = {
	{ 0, 1,  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,   1,   1,  1 },
	{ 0, 1,  1,  1,  1,  1,  1,  1,  1,  1,   1,  1,   1,   1,  1 },
};

static const unsigned int
exynos5420_arm_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5420_kfc_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	  ABB_X080,   ABB_X080,   ABB_X080,   ABB_X080, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5420_g3d_mp4_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5420_g3d_mp6_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5420_int_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5420_mif_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
};

static const unsigned int exynos5420_arm_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 2000000,
		1362500, 1350000, 1337500, 1325000, 1312500,
		1325000, 1312500, 1300000, 1287500, 1262500,
		1237500, 1237500, 1225000, 1212500, 1200000 },
	{ 1900000,
		1300000, 1287500, 1262500, 1237500, 1225000,
		1212500, 1200000, 1187500, 1175000, 1162500,
		1150000, 1137500, 1125000, 1112500, 1112500 },
	{ 1800000,
		1250000, 1250000, 1225000, 1212500, 1200000,
		1187500, 1175000, 1162500, 1150000, 1137500,
		1125000, 1112500, 1100000, 1087500, 1087500 },
	{ 1700000,
		1212500, 1212500, 1187500, 1175000, 1162500,
		1150000, 1137500, 1125000, 1112500, 1100000,
		1087500, 1075000, 1062500, 1050000, 1050000 },
	{ 1600000,
		1175000, 1175000, 1150000, 1137500, 1125000,
		1112500, 1100000, 1087500, 1075000, 1062500,
		1050000, 1037500, 1025000, 1012500, 1012500 },
	{ 1500000,
		1137500, 1137500, 1112500, 1100000, 1087500,
		1075000, 1062500, 1050000, 1037500, 1025000,
		1012500, 1000000,  987500,  975000,  975000 },
	{ 1400000,
		1112500, 1112500, 1087500, 1075000, 1062500,
		1050000, 1037500, 1025000, 1012500, 1000000,
		 987500,  975000,  962500,  950000,  950000 },
	{ 1300000,
		1062500, 1062500, 1037500, 1025000, 1012500,
		1000000,  987500,  975000,  962500,  950000,
		 937500,  925000,  912500,  900000,  900000 },
	{ 1200000,
		1037500, 1037500, 1012500, 1000000,  987500,
		 975000,  962500,  950000,  937500,  925000,
		 912500,  900000,  900000,  900000,  900000 },
	{ 1100000,
		1012500, 1012500,  987500,  975000,  962500,
		 950000,  937500,  925000,  912500,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{ 1000000,
		 987500,  987500,  962500,  950000,  937500,
		 925000,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  900000,
		 962500,  962500,  937500,  925000,  912500,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  800000,
		 937500,  937500,  912500,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  700000,
		 912500,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  600000,
		 912500,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  500000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  400000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  300000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  200000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
};

static const unsigned int exynos5420_kfc_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 1300000,
		1275000, 1262500, 1250000, 1237500, 1237500,
		1225000, 1212500, 1200000, 1187500, 1175000,
		1162500, 1150000, 1137500, 1125000, 1125000 },
	{ 1200000,
		1212500, 1200000, 1187500, 1175000, 1175000,
		1162500, 1150000, 1137500, 1125000, 1112500,
		1100000, 1087500, 1075000, 1075000, 1075000 },
	{ 1100000,
		1162500, 1150000, 1137500, 1125000, 1125000,
		1112500, 1100000, 1087500, 1075000, 1062500,
		1050000, 1037500, 1025000, 1025000, 1025000 },
	{ 1000000,
		1112500, 1100000, 1087500, 1075000, 1075000,
		1062500, 1050000, 1037500, 1025000, 1012500,
		1000000,  987500,  975000,  975000,  975000 },
	{  900000,
		1062500, 1050000, 1037500, 1025000, 1025000,
		1012500, 1000000,  987500,  975000,  962500,
		 950000,  937500,  925000,  925000,  925000 },
	{  800000,
		1025000, 1012500, 1000000,  987500,  987500,
		 975000,  962500,  950000,  937500,  925000,
		 912500,  912500,  912500,  912500,  912500 },
	{  700000,
		 975000,  962500,  950000,  937500,  937500,
		 925000,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  600000,
		 937500,  925000,  912500,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  500000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  400000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  300000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{  200000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
};

static const unsigned int exynos5420_g3d_mp4_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 600000,
		1025000, 1012500, 1000000,  987500,  975000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  887500,  875000,  862500,  850000 },
	{ 533000,
		 987500,  975000,  962500,  950000,  937500,
		 925000,  912500,  900000,  887500,  875000,
		 862500,  850000,  837500,  825000,  825000 },
	{ 480000,
		 950000,  937500,  925000,  912500,  900000,
		 887500,  875000,  862500,  850000,  837500,
		 825000,  812500,  812500,  812500,  812500 },
	{ 420000,
		 937500,  925000,  912500,  900000,  887500,
		 875000,  862500,  850000,  837500,  825000,
		 812500,  800000,  800000,  800000,  800000 },
	{ 350000,
		 900000,  887500,  875000,  862500,  850000,
		 837500,  825000,  812500,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
	{ 266000,
		 862500,  850000,  837500,  825000,  825000,
		 812500,  800000,  800000,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
	{ 177000,
		 862500,  850000,  837500,  825000,  825000,
		 812500,  800000,  800000,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
	{ 100000,
		 862500,  850000,  837500,  825000,  825000,
		 812500,  800000,  800000,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
};

static const unsigned int exynos5420_g3d_mp6_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 533000,
		1062500, 1050000, 1037500, 1025000, 1012500,
		1000000,  987500,  975000,  962500,  950000,
		 937500,  925000,  912500,  900000,  900000 },
	{ 480000,
		1025000, 1012500, 1000000,  987500,  975000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  887500,  875000,  862500,  862500 },
	{ 420000,
		 987500,  975000,  962500,  950000,  937500,
		 925000,  912500,  900000,  887500,  875000,
		 862500,  850000,  837500,  825000,  825000 },
	{ 350000,
		 937500,  925000,  912500,  900000,  887500,
		 875000,  862500,  850000,  837500,  825000,
		 812500,  800000,  800000,  800000,  800000 },
	{ 266000,
		 887500,  875000,  862500,  850000,  837500,
		 825000,  812500,  800000,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
	{ 177000,
		 850000,  837500,  825000,  812500,  800000,
		 800000,  800000,  800000,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
	{ 100000,
		 850000,  837500,  825000,  812500,  800000,
		 800000,  800000,  800000,  800000,  800000,
		 800000,  800000,  800000,  800000,  800000 },
};

static const unsigned int exynos5420_int_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 600000,
		1025000, 1012500, 1000000,  987500,  975000,
		 962500,  950000,  962500,  950000,  937500,
		 925000,  912500,  900000,  900000,  900000 },
	{ 500000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000 },
	{ 400000,
		 950000,  937500,  925000,  912500,  912500,
		 912500,  912500,  912500,  900000,  887500,
		 875000,  862500,  862500,  862500,  862500 },
	{ 333000,
		 912500,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  887500,  875000,
		 862500,  850000,  850000,  850000,  850000 },
	{ 222000,
		 912500,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  887500,  875000,
		 862500,  850000,  850000,  850000,  850000 },
	{ 111000,
		 912500,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  887500,  875000,
		 862500,  850000,  850000,  850000,  850000 },
	{  83000,
		 912500,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  887500,  875000,
		 862500,  850000,  850000,  850000,  850000 },
};

static const unsigned int
exynos5420_mif_asv_volt_info[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{      0,
		1000000, 1000000, 1000000, 1000000,  1000000,
		1000000, 1000000, 1000000, 1000000,  1000000,
		1000000, 1000000, 1000000, 1000000,  1000000 },
};

static const unsigned int
exynos5420_mif_sram_asv_volt_info[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{      0,
		1000000, 1000000, 1000000, 1000000, 1000000,
		1000000, 1000000, 1000000, 1000000, 1000000,
		1000000, 1000000, 1000000, 1000000, 1000000 },
};

static const unsigned int
exynos5420_g3d_mp4_sram_asv_volt_info[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{      0,
		1025000, 1025000, 1000000, 1000000,  975000,
		 975000,  950000,  950000,  925000,  925000,
		 900000,  900000,  900000,  900000,  900000 },
};

static const unsigned int
exynos5420_g3d_mp6_sram_asv_volt_info[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{      0,
		1075000, 1050000, 1050000, 1025000, 1025000,
		1000000, 1000000,  975000,  975000,  950000,
		 950000,  925000,  925000,  900000,  900000 },
};

static const unsigned int
exynos5422_refer_table_get_asv[2][EXYNOS542X_MAX_ASV_GRP_NR] = {
	{ 13, 21, 25, 30, 36, 43, 51, 65, 81, 98, 119, 135, 150, 999},
	{ 55, 65, 69, 72, 74, 76, 78, 80, 82, 84, 87, 89, 92, 999},
};

static const unsigned int
exynos5422_refer_use_table_get_asv[2][EXYNOS542X_MAX_ASV_GRP_NR] = {
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
};

static const unsigned int
exynos5422_arm_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5422_int_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
};

static const unsigned int
exynos5422_mif_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
	  ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,
};

static const unsigned int
exynos5422_g3d_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int
exynos5422_kfc_asv_abb_info[EXYNOS542X_MAX_ASV_GRP_NR] = {
	  ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
	ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,
};

static const unsigned int exynos5422_arm_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 2100000,
		1350000, 1350000, 1350000, 1350000, 1350000,
		1337500, 1325000, 1312500, 1300000, 1287500,
		1275000, 1262500, 1250000, 1237500 },
	{ 2000000,
		1312500, 1312500, 1312500, 1300000, 1287500,
		1275000, 1262500, 1250000, 1237500, 1225000,
		1212500, 1200000, 1187500, 1175000 },
	{ 1900000,
		1275000, 1262500, 1250000, 1237500, 1225000,
		1212500, 1200000, 1187500, 1175000, 1162500,
		1150000, 1137500, 1125000, 1112500 },
	{ 1800000,
		1225000, 1212500, 1200000, 1187500, 1175000,
		1162500, 1150000, 1137500, 1125000, 1112500,
		1100000, 1087500, 1075000, 1062500 },
	{ 1700000,
		1187500, 1175000, 1162500, 1150000, 1137500,
		1125000, 1112500, 1100000, 1087500, 1075000,
		1062500, 1050000, 1037500, 1025000 },
	{ 1600000,
		1150000, 1137500, 1125000, 1112500, 1100000,
		1087500, 1075000, 1062500, 1050000, 1037500,
		1025000, 1012500, 1000000,  987500 },
	{ 1500000,
		1112500, 1100000, 1087500, 1075000, 1062500,
		1050000, 1037500, 1025000, 1012500, 1000000,
		 987500,  975000,  962500,  950000 },
	{ 1400000,
		1087500, 1075000, 1062500, 1050000, 1037500,
		1025000, 1012500, 1000000,  987500,  975000,
		 962500,  950000,  937500,  925000 },
	{ 1300000,
		1062500, 1050000, 1037500, 1025000, 1012500,
		1000000,  987500,  975000,  962500,  950000,
		 937500,  925000,  912500,  900000 },
	{ 1200000,
		1037500, 1025000, 1012500, 1000000,  987500,
		 975000,  962500,  950000,  937500,  925000,
		 912500,  900000,  900000,  900000 },
	{ 1100000,
		1012500, 1000000,  987500,  975000,  962500,
		 950000,  937500,  925000,  912500,  900000,
		 900000,  900000,  900000,  900000 },
	{ 1000000,
		 987500,  975000,  962500,  950000,  937500,
		 925000,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 900000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 800000,
		 937500,  925000,  912500,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 700000,
		 912500,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 600000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 500000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 400000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 300000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 200000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
};

static const unsigned int exynos5422_kfc_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 1500000,
		1300000, 1300000, 1300000, 1300000, 1300000,
		1300000, 1287500, 1275000, 1262500, 1250000,
		1237500, 1222500, 1212500, 1200000 },
	{ 1400000,
		1287500, 1275000, 1262500, 1250000, 1237500,
		1225000, 1212500, 1200000, 1187500, 1175000,
		1162500, 1150000, 1137500, 1125000 },
	{ 1300000,
		1237500, 1225000, 1212500, 1200000, 1187500,
		1175000, 1162500, 1150000, 1137500, 1125000,
		1112500, 1100000, 1087500, 1075000 },
	{ 1200000,
		1187500, 1175000, 1162500, 1150000, 1137500,
		1125000, 1112500, 1100000, 1087500, 1075000,
		1062500, 1050000, 1037500, 1025000 },
	{ 1100000,
		1150000, 1137500, 1125000, 1112500, 1100000,
		1087500, 1075000, 1062500, 1050000, 1037500,
		1025000, 1012500, 1000000,  987500 },
	{ 1000000,
		1112500, 1100000, 1087500, 1075000, 1062500,
		1050000, 1037500, 1025000, 1012500, 1000000,
		 987500,  975000,  962500,  950000 },
	{ 900000,
		1075000, 1062500, 1050000, 1037500, 1025000,
		1012500, 1000000,  987500,  975000,  962500,
		 950000,  937500,  925000,  912500 },
	{ 800000,
		1037500, 1025000, 1012500, 1000000,  987500,
		 975000,  962500,  950000,  937500,  925000,
		 912500,  900000,  900000,  900000 },
	{ 700000,
		1000000,  987500,  975000,  962500,  950000,
		 937500,  925000,  912500,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 600000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 500000,
		 925000,  912500,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 400000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 300000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
	{ 200000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000,  900000,
		 900000,  900000,  900000,  900000 },
};

/*
 * DVFS V2.40 table for 5422 supports INT levels upto 420MHz. The 500MHz
 * level has the 420MHz INT bus level voltages and will stay disabled till
 * we enabled 2.1GHz support which requires a locking to the 420MHz level.
 */
static const unsigned int exynos5422_int_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 600000,
		      0,       0,       0,       0,       0,
		      0,       0,       0,       0,       0,
		      0,       0,       0,       0 },
	{ 500000,
		 1075000, 1062500, 1050000, 1037500, 1025000,
		 1012500, 1000000,  987500,  975000,  987500,
		  975000,  962500,  950000,  937500 },
	{ 400000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  887500,  887500,  887500,  875000,
		 887500,  875000,  862500,  850000 },
	{ 333000,
		 925000,  912500,  900000,  887500,  875000,
		 862500,  850000,  850000,  850000,  850000,
		 850000,  850000,  850000,  850000 },
	{ 222000,
		 900000,  887500,  875000,  862500,  850000,
		 850000,  850000,  850000,  850000,  850000,
		 850000,  850000,  850000,  850000 },
	{ 111000,
		 900000,  887500,  875000,  862500,  850000,
		 850000,  850000,  850000,  850000,  850000,
		 850000,  850000,  850000,  850000 },
	{ 83000,
		 850000,  850000,  850000,  850000,  850000,
		 850000,  850000,  850000,  850000,  850000,
		 850000,  850000,  850000,  850000 },
};

static const unsigned int exynos5422_mif_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 0,
		1000000, 1000000, 1000000, 1000000, 1000000,
		1000000, 1000000, 1000000, 1000000, 1000000,
		1000000, 1000000, 1000000, 1000000 },
};

static const unsigned int exynos5422_g3d_asv_volt_info
[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 543000,
		1025000, 1012500, 1000000,  987500,  975000,
		 962500,  950000,  937500,  925000,  912500,
		 900000,  887500,  875000,  862500 },
	{ 480000,
		 975000,  962500,  950000,  937500,  925000,
		 912500,  900000,  887500,  875000,  862500,
		 850000,  837500,  825000,  812500 },
	{ 420000,
		 937500,  925000,  912500,  900000,  887500,
		 875000,  862500,  850000,  837500,  825000,
		 812500,  800000,  787500, 775000 },
	{ 350000,
		 912500,  900000,  887500,  875000,  862500,
		 850000,  837500,  825000,  812500,  800000,
		 787500,  775000,  775000,  775000 },
	{ 266000,
		 887500,  875000,  862500,  850000,  837500,
		 825000,  812500,  800000,  787500,  775000,
		 775000,  775000,  775000,  775000 },
	{ 177000,
		 825000,  812500,  800000,  787500,  775000,
		 775000,  775000,  775000,  775000,  775000,
		 775000,  775000,  775000,  775000 },
	{ 100000,
		 825000,  812500,  800000,  787500,  775000,
		 775000,  775000,  775000,  775000,  775000,
		 775000,  775000,  775000,  775000 },
};

static const unsigned int
exynos5422_mif_sram_asv_volt_info[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 0,
		1000000, 1000000, 1000000, 1000000, 1000000,
		1000000, 1000000, 1000000, 1000000, 1000000,
		1000000, 1000000, 1000000, 1000000 },
};

static const unsigned int
exynos5422_g3d_sram_asv_volt_info[][EXYNOS542X_MAX_ASV_GRP_NR + 1] = {
	{ 0,
		1025000, 1025000, 1000000, 1000000,  975000,
		 975000,  950000,  950000,  925000,  925000,
		 900000,  900000,  900000,  900000 },
};

#endif /* EXYNOS542X_ASV_H */
