/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public abstract class PackageVisibilityStatement
extends ModuleStatement {
    public ImportReference pkgRef;
    public ModuleReference[] targets;
    public char[] pkgName;
    public PlainPackageBinding resolvedPackage;

    public PackageVisibilityStatement(ImportReference importReference, ModuleReference[] moduleReferenceArray) {
        this.pkgRef = importReference;
        this.pkgName = CharOperation.concatWith(this.pkgRef.tokens, '.');
        this.targets = moduleReferenceArray;
    }

    public boolean isQualified() {
        return this.targets != null && this.targets.length > 0;
    }

    public ModuleReference[] getTargetedModules() {
        return this.targets;
    }

    public boolean resolve(Scope scope) {
        boolean bl;
        boolean bl2 = bl = this.resolvePackageReference(scope) == null;
        if (this.isQualified()) {
            HashtableOfObject hashtableOfObject = new HashtableOfObject(this.targets.length);
            for (int i = 0; i < this.targets.length; ++i) {
                ModuleReference moduleReference = this.targets[i];
                if (hashtableOfObject.containsKey(moduleReference.moduleName)) {
                    scope.problemReporter().duplicateModuleReference(8389922, moduleReference);
                    bl = true;
                    continue;
                }
                hashtableOfObject.put(moduleReference.moduleName, moduleReference);
            }
        }
        return !bl;
    }

    public int computeSeverity(int n) {
        return 1;
    }

    protected PlainPackageBinding resolvePackageReference(Scope scope) {
        if (this.resolvedPackage != null) {
            return this.resolvedPackage;
        }
        ModuleDeclaration moduleDeclaration = scope.compilationUnitScope().referenceContext.moduleDeclaration;
        SourceModuleBinding sourceModuleBinding = moduleDeclaration.binding;
        this.resolvedPackage = sourceModuleBinding != null ? sourceModuleBinding.getOrCreateDeclaredPackage(this.pkgRef.tokens) : null;
        return this.resolvedPackage;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        this.pkgRef.print(n, stringBuffer);
        if (this.isQualified()) {
            stringBuffer.append(" to ");
            for (int i = 0; i < this.targets.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                this.targets[i].print(0, stringBuffer);
            }
        }
        return stringBuffer;
    }
}

