
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "locationbar_loadaction_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_LocationBar_LoadAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::LocationBar::LoadAction >()))
        return -1;

    ::LocationBar::LoadAction *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LocationBar.LoadAction.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "LoadAction", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: LoadAction::LoadAction()
    // 1: LoadAction::LoadAction(LocationBar::LoadAction)
    if (numArgs == 0) {
        overloadId = 0; // LoadAction()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // LoadAction(LocationBar::LoadAction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_LocationBar_LoadAction_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // LoadAction()
        {

            if (!PyErr_Occurred()) {
                // LoadAction()
                cptr = new ::LocationBar::LoadAction();
            }
            break;
        }
        case 1: // LoadAction(const LocationBar::LoadAction & LoadAction)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::LocationBar::LoadAction cppArg0_local;
            ::LocationBar::LoadAction *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // LoadAction(LocationBar::LoadAction)
                cptr = new ::LocationBar::LoadAction(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::LocationBar::LoadAction >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_LocationBar_LoadAction_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_LocationBar_LoadAction_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_LocationBar_LoadAction___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_LocationBar_LoadAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_LocationBar_LoadAction_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_LocationBar_LoadAction___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_LocationBar_LoadAction_get_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::LocationBar::LoadAction::Type cppOut_local = cppSelf->type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_LocationBar_LoadAction_set_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'Type' or convertible type expected");
        return -1;
    }

    ::LocationBar::LoadAction::Type cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_LocationBar_LoadAction_get_searchEngine(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->searchEngine)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->searchEngine))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->searchEngine)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), &(cppSelf->searchEngine), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_LocationBar_LoadAction_set_searchEngine(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'searchEngine' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'searchEngine', 'Engine' or convertible type expected");
        return -1;
    }

    ::SearchEnginesManager::Engine& cppOut_ptr = cppSelf->searchEngine;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_LocationBar_LoadAction_get_bookmark(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppSelf->bookmark);
    return pyOut;
}
static int Sbk_LocationBar_LoadAction_set_bookmark(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'bookmark' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'bookmark', 'BookmarkItem' or convertible type expected");
        return -1;
    }

    ::BookmarkItem *& cppOut_ptr = cppSelf->bookmark;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "bookmark", pyIn);
    return 0;
}

static PyObject *Sbk_LocationBar_LoadAction_get_loadRequest(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->loadRequest)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->loadRequest))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->loadRequest)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), &(cppSelf->loadRequest), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_LocationBar_LoadAction_set_loadRequest(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'loadRequest' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'loadRequest', 'LoadRequest' or convertible type expected");
        return -1;
    }

    ::LoadRequest& cppOut_ptr = cppSelf->loadRequest;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for LoadAction
static PyGetSetDef Sbk_LocationBar_LoadAction_getsetlist[] = {
    {const_cast<char *>("type"), Sbk_LocationBar_LoadAction_get_type, Sbk_LocationBar_LoadAction_set_type},
    {const_cast<char *>("searchEngine"), Sbk_LocationBar_LoadAction_get_searchEngine, Sbk_LocationBar_LoadAction_set_searchEngine},
    {const_cast<char *>("bookmark"), Sbk_LocationBar_LoadAction_get_bookmark, Sbk_LocationBar_LoadAction_set_bookmark},
    {const_cast<char *>("loadRequest"), Sbk_LocationBar_LoadAction_get_loadRequest, Sbk_LocationBar_LoadAction_set_loadRequest},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_LocationBar_LoadAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_LocationBar_LoadAction_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_LocationBar_LoadAction_Type = nullptr;
static SbkObjectType *Sbk_LocationBar_LoadAction_TypeF(void)
{
    return _Sbk_LocationBar_LoadAction_Type;
}

static PyType_Slot Sbk_LocationBar_LoadAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_LocationBar_LoadAction_spec = {
    "1:PyFalkon.LocationBar.LoadAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_LocationBar_LoadAction_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void LocationBar_LoadAction_Type_PythonToCpp_LocationBar_LoadAction_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::LocationBar::LoadAction::Type *>(cppOut) =
        static_cast<::LocationBar::LoadAction::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_LocationBar_LoadAction_Type_PythonToCpp_LocationBar_LoadAction_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX]))
        return LocationBar_LoadAction_Type_PythonToCpp_LocationBar_LoadAction_Type;
    return {};
}
static PyObject *LocationBar_LoadAction_Type_CppToPython_LocationBar_LoadAction_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::LocationBar::LoadAction::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void LoadAction_PythonToCpp_LoadAction_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_LocationBar_LoadAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_LoadAction_PythonToCpp_LoadAction_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_LocationBar_LoadAction_TypeF())))
        return LoadAction_PythonToCpp_LoadAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *LoadAction_PTR_CppToPython_LoadAction(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::LocationBar::LoadAction *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_LocationBar_LoadAction_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *LoadAction_COPY_CppToPython_LoadAction(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_LocationBar_LoadAction_TypeF(), new ::LocationBar::LoadAction(*reinterpret_cast<const ::LocationBar::LoadAction *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void LoadAction_PythonToCpp_LoadAction_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::LocationBar::LoadAction *>(cppOut) = *reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_LoadAction_PythonToCpp_LoadAction_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_LocationBar_LoadAction_TypeF())))
        return LoadAction_PythonToCpp_LoadAction_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *LocationBar_LoadAction_SignatureStrings[] = {
    "1:PyFalkon.LocationBar.LoadAction(self)",
    "0:PyFalkon.LocationBar.LoadAction(self,LoadAction:PyFalkon.LocationBar.LoadAction)",
    "PyFalkon.LocationBar.LoadAction.__copy__()",
    nullptr}; // Sentinel

void init_LocationBar_LoadAction(PyObject *enclosingClass)
{
    _Sbk_LocationBar_LoadAction_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "LoadAction",
        "LocationBar::LoadAction",
        &Sbk_LocationBar_LoadAction_spec,
        &Shiboken::callCppDestructor< ::LocationBar::LoadAction >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_LocationBar_LoadAction_Type);
    InitSignatureStrings(pyType, LocationBar_LoadAction_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_LocationBar_LoadAction_Type), Sbk_LocationBar_LoadAction_PropertyStrings);
    SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_LocationBar_LoadAction_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_LocationBar_LoadAction_TypeF(),
        LoadAction_PythonToCpp_LoadAction_PTR,
        is_LoadAction_PythonToCpp_LoadAction_PTR_Convertible,
        LoadAction_PTR_CppToPython_LoadAction,
        LoadAction_COPY_CppToPython_LoadAction);

    Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction");
    Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction*");
    Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction&");
    Shiboken::Conversions::registerConverterName(converter, "LoadAction");
    Shiboken::Conversions::registerConverterName(converter, "LoadAction*");
    Shiboken::Conversions::registerConverterName(converter, "LoadAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::LocationBar::LoadAction).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        LoadAction_PythonToCpp_LoadAction_COPY,
        is_LoadAction_PythonToCpp_LoadAction_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_LocationBar_LoadAction_TypeF(),
        "Type",
        "1:PyFalkon.LocationBar.LoadAction.Type",
        "LocationBar::LoadAction::Type");
    if (!SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX],
        Sbk_LocationBar_LoadAction_TypeF(), "Invalid", (long) LocationBar::LoadAction::Type::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX],
        Sbk_LocationBar_LoadAction_TypeF(), "Search", (long) LocationBar::LoadAction::Type::Search))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX],
        Sbk_LocationBar_LoadAction_TypeF(), "Bookmark", (long) LocationBar::LoadAction::Type::Bookmark))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX],
        Sbk_LocationBar_LoadAction_TypeF(), "Url", (long) LocationBar::LoadAction::Type::Url))
        return;
    // Register converter for enum 'LocationBar::LoadAction::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX],
            LocationBar_LoadAction_Type_CppToPython_LocationBar_LoadAction_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            LocationBar_LoadAction_Type_PythonToCpp_LocationBar_LoadAction_Type,
            is_LocationBar_LoadAction_Type_PythonToCpp_LocationBar_LoadAction_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_LOCATIONBAR_LOADACTION_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction::Type");
        Shiboken::Conversions::registerConverterName(converter, "LoadAction::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.


    qRegisterMetaType< ::LocationBar::LoadAction >("LoadAction");
    qRegisterMetaType< ::LocationBar::LoadAction >("LocationBar::LoadAction");
    qRegisterMetaType< ::LocationBar::LoadAction::Type >("LoadAction::Type");
    qRegisterMetaType< ::LocationBar::LoadAction::Type >("LocationBar::LoadAction::Type");
}
