/* gnome-calculator.c generated by valac 0.56.0, the Vala compiler
 * generated from gnome-calculator.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "calculator.h"
#include "mpfr.h"
#include <gtksourceview/gtksource.h>
#include <stdio.h>
#include <langinfo.h>
#include <gdk/gdk.h>
#include <locale.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CALCULATOR (calculator_get_type ())
#define CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALCULATOR, Calculator))
#define CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALCULATOR, CalculatorClass))
#define IS_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALCULATOR))
#define IS_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALCULATOR))
#define CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALCULATOR, CalculatorClass))

typedef struct _Calculator Calculator;
typedef struct _CalculatorClass CalculatorClass;
typedef struct _CalculatorPrivate CalculatorPrivate;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
enum  {
	CALCULATOR_0_PROPERTY,
	CALCULATOR_NUM_PROPERTIES
};
static GParamSpec* calculator_properties[CALCULATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Calculator {
	AdwApplication parent_instance;
	CalculatorPrivate * priv;
};

struct _CalculatorClass {
	AdwApplicationClass parent_class;
};

struct _CalculatorPrivate {
	GSettings* settings;
	MathWindow* last_opened_window;
	MathPreferencesDialog* preferences_dialog;
	GtkShortcutsWindow* shortcuts_window;
};

static gint Calculator_private_offset;
static gpointer calculator_parent_class = NULL;
static gchar* calculator_mode_string;
static gchar* calculator_equation_string;
static gchar* calculator_program_name;
static gchar* calculator_program_name = NULL;
static gchar* calculator_equation_string = NULL;
static gchar* calculator_mode_string = NULL;

VALA_EXTERN GType calculator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Calculator, g_object_unref)
VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
VALA_EXTERN GType math_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPreferencesDialog, g_object_unref)
static void calculator_new_window_cb (Calculator* self);
static void _calculator_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void calculator_show_preferences_cb (Calculator* self);
static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void calculator_keyboard_shortcuts_cb (Calculator* self);
static void _calculator_keyboard_shortcuts_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void calculator_help_cb (Calculator* self);
static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void calculator_about_cb (Calculator* self);
static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void calculator_quit_cb (Calculator* self);
static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN Calculator* calculator_new (void);
VALA_EXTERN Calculator* calculator_construct (GType object_type);
static MathWindow* calculator_create_new_window (Calculator* self,
                                          GSettings* settings);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MathWindow* math_window_new (GtkApplication* app,
                             MathEquation* equation);
VALA_EXTERN MathWindow* math_window_construct (GType object_type,
                                   GtkApplication* app,
                                   MathEquation* equation);
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN MathButtons* math_window_get_buttons (MathWindow* self);
VALA_EXTERN void math_buttons_set_programming_base (MathButtons* self,
                                        gint value);
VALA_EXTERN void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
static void calculator_real_startup (GApplication* base);
static void __lambda53_ (Calculator* self);
static void ___lambda53__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static MathWindow* calculator_get_active_math_window (Calculator* self);
static void calculator_real_activate (GApplication* base);
VALA_EXTERN MathEquation* math_window_get_equation (MathWindow* self);
static void calculator_real_shutdown (GApplication* base);
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
VALA_EXTERN gint math_buttons_get_programming_base (MathButtons* self);
static gint calculator_real_handle_local_options (GApplication* base,
                                           GVariantDict* options);
static gchar* _variant_get1 (GVariant* value);
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_construct (GType object_type,
                                                          MathEquation* eq);
static gboolean ___lambda51_ (Calculator* self);
static gboolean ____lambda51__gtk_window_close_request (GtkWindow* _sender,
                                                 gpointer self);
static void ___lambda52_ (Calculator* self,
                   gint _result_);
static void ____lambda52__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static gint calculator_main (gchar** args,
                      gint args_length1);
static void calculator_finalize (GObject * obj);
static GType calculator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry CALCULATOR_option_entries[5] = {{"mode", 'm', (gint) 0, G_OPTION_ARG_STRING, &calculator_mode_string, N_ ("Start in given mode (basic, advanced, financial, programming, keyboard" \
")"), "mode"}, {"solve", 's', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Solve given equation"), "equation"}, {"equation", 'e', (gint) 0, G_OPTION_ARG_STRING, &calculator_equation_string, N_ ("Start with given equation"), "equation"}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const GActionEntry CALCULATOR_app_entries[6] = {{"new-window", _calculator_new_window_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"preferences", _calculator_show_preferences_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"shortcuts", _calculator_keyboard_shortcuts_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"help", _calculator_help_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"about", _calculator_about_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"quit", _calculator_quit_cb_gsimple_action_activate_callback, NULL, NULL, NULL}};

static inline gpointer
calculator_get_instance_private (Calculator* self)
{
	return G_STRUCT_MEMBER_P (self, Calculator_private_offset);
}

static void
_calculator_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	calculator_new_window_cb ((Calculator*) self);
}

static void
_calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	calculator_show_preferences_cb ((Calculator*) self);
}

static void
_calculator_keyboard_shortcuts_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	calculator_keyboard_shortcuts_cb ((Calculator*) self);
}

static void
_calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	calculator_help_cb ((Calculator*) self);
}

static void
_calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	calculator_about_cb ((Calculator*) self);
}

static void
_calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	calculator_quit_cb ((Calculator*) self);
}

Calculator*
calculator_construct (GType object_type)
{
	Calculator * self = NULL;
	self = (Calculator*) g_object_new (object_type, "flags", G_APPLICATION_NON_UNIQUE, "application-id", APP_ID, NULL);
	g_application_set_resource_base_path ((GApplication*) self, "/org/gnome/calculator");
	g_application_add_main_option_entries ((GApplication*) self, CALCULATOR_option_entries);
	return self;
}

Calculator*
calculator_new (void)
{
	return calculator_construct (TYPE_CALCULATOR);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MathWindow*
calculator_create_new_window (Calculator* self,
                              GSettings* settings)
{
	gint accuracy = 0;
	gint word_size = 0;
	gint number_base = 0;
	gboolean show_tsep = FALSE;
	gboolean show_zeroes = FALSE;
	DisplayFormat number_format = 0;
	AngleUnit angle_units = 0;
	ButtonMode button_mode = 0;
	gchar* source_currency = NULL;
	gchar* _tmp0_;
	gchar* target_currency = NULL;
	gchar* _tmp1_;
	gchar* source_units = NULL;
	gchar* _tmp2_;
	gchar* target_units = NULL;
	gchar* _tmp3_;
	gint precision = 0;
	MathEquation* equation = NULL;
	MathEquation* _tmp4_;
	MathWindow* current_window = NULL;
	MathWindow* _tmp5_;
	MathButtons* buttons = NULL;
	MathButtons* _tmp6_;
	MathButtons* _tmp7_;
	MathButtons* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gchar* _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar* _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	gchar** _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	gchar* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	MathWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	accuracy = g_settings_get_int (settings, "accuracy");
	word_size = g_settings_get_int (settings, "word-size");
	number_base = g_settings_get_int (settings, "base");
	show_tsep = g_settings_get_boolean (settings, "show-thousands");
	show_zeroes = g_settings_get_boolean (settings, "show-zeroes");
	number_format = (DisplayFormat) g_settings_get_enum (settings, "number-format");
	angle_units = (AngleUnit) g_settings_get_enum (settings, "angle-units");
	button_mode = (ButtonMode) g_settings_get_enum (settings, "button-mode");
	_tmp0_ = g_settings_get_string (settings, "source-currency");
	source_currency = _tmp0_;
	_tmp1_ = g_settings_get_string (settings, "target-currency");
	target_currency = _tmp1_;
	_tmp2_ = g_settings_get_string (settings, "source-units");
	source_units = _tmp2_;
	_tmp3_ = g_settings_get_string (settings, "target-units");
	target_units = _tmp3_;
	precision = g_settings_get_int (settings, "precision");
	_tmp4_ = math_equation_new ();
	equation = _tmp4_;
	math_equation_set_accuracy (equation, accuracy);
	math_equation_set_word_size (equation, word_size);
	math_equation_set_show_thousands_separators (equation, show_tsep);
	math_equation_set_show_trailing_zeroes (equation, show_zeroes);
	math_equation_set_number_format (equation, number_format);
	math_equation_set_angle_units (equation, angle_units);
	math_equation_set_source_currency (equation, source_currency);
	math_equation_set_target_currency (equation, target_currency);
	math_equation_set_source_units (equation, source_units);
	math_equation_set_target_units (equation, target_units);
	number_set_precision ((mpfr_prec_t) precision);
	g_action_map_add_action_entries ((GActionMap*) self, CALCULATOR_app_entries, (gint) G_N_ELEMENTS (CALCULATOR_app_entries), self);
	_tmp5_ = math_window_new ((GtkApplication*) self, equation);
	g_object_ref_sink (_tmp5_);
	current_window = _tmp5_;
	gtk_window_set_title ((GtkWindow*) current_window, _ ("Calculator"));
	_tmp6_ = math_window_get_buttons (current_window);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	buttons = _tmp8_;
	math_buttons_set_programming_base (buttons, number_base);
	math_buttons_set_mode (buttons, button_mode);
	_tmp9_ = g_strdup ("<control><alt>B");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::basic", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<control><alt>A");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::advanced", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<control><alt>F");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::financial", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<control><alt>P");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::programming", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("<control><alt>K");
	_tmp22_ = g_strdup ("<control><alt>T");
	_tmp23_ = g_new0 (gchar*, 2 + 1);
	_tmp23_[0] = _tmp21_;
	_tmp23_[1] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::keyboard", _tmp24_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_strdup ("<control>C");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.copy", _tmp27_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = g_strdup ("<control>V");
	_tmp29_ = g_new0 (gchar*, 1 + 1);
	_tmp29_[0] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.paste", _tmp30_);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = g_strdup ("<control>Z");
	_tmp32_ = g_new0 (gchar*, 1 + 1);
	_tmp32_[0] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp33_);
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp34_ = g_strdup ("<control>W");
	_tmp35_ = g_new0 (gchar*, 1 + 1);
	_tmp35_[0] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.close", _tmp36_);
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	_tmp37_ = g_strdup ("<control><shift>Z");
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp39_);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp40_ = g_strdup ("<Primary>Escape");
	_tmp41_ = g_new0 (gchar*, 1 + 1);
	_tmp41_[0] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.clear", _tmp42_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = g_strdup ("<control>Q");
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	_tmp45_ = _tmp44_;
	_tmp45__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp45_);
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	_tmp46_ = g_strdup ("<control>N");
	_tmp47_ = g_new0 (gchar*, 1 + 1);
	_tmp47_[0] = _tmp46_;
	_tmp48_ = _tmp47_;
	_tmp48__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-window", _tmp48_);
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_tmp49_ = g_strdup ("F1");
	_tmp50_ = g_new0 (gchar*, 1 + 1);
	_tmp50_[0] = _tmp49_;
	_tmp51_ = _tmp50_;
	_tmp51__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp51_);
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
	_tmp52_ = g_strdup ("<control>question");
	_tmp53_ = g_new0 (gchar*, 1 + 1);
	_tmp53_[0] = _tmp52_;
	_tmp54_ = _tmp53_;
	_tmp54__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.shortcuts", _tmp54_);
	_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
	result = current_window;
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
	_g_free0 (target_units);
	_g_free0 (source_units);
	_g_free0 (target_currency);
	_g_free0 (source_currency);
	return result;
}

static void
__lambda53_ (Calculator* self)
{
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp1_;
	GSettings* _tmp2_;
	CurrencyManager* _tmp3_;
	CurrencyManager* _tmp4_;
	_tmp0_ = currency_manager_get_default (TRUE, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->settings;
	currency_manager_set_refresh_interval (_tmp1_, g_settings_get_int (_tmp2_, "refresh-interval"));
	_g_object_unref0 (_tmp1_);
	_tmp3_ = currency_manager_get_default (TRUE, TRUE);
	_tmp4_ = _tmp3_;
	currency_manager_refresh_async (_tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
___lambda53__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda53_ ((Calculator*) self);
}

static void
calculator_real_startup (GApplication* base)
{
	Calculator * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	MathWindow* _tmp3_;
	CurrencyManager* _tmp4_;
	CurrencyManager* _tmp5_;
	GSettings* _tmp6_;
	CurrencyManager* _tmp7_;
	CurrencyManager* _tmp8_;
	GSettings* _tmp9_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	gtk_source_init ();
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = calculator_create_new_window (self, _tmp2_);
	_g_object_unref0 (self->priv->last_opened_window);
	self->priv->last_opened_window = _tmp3_;
	_tmp4_ = currency_manager_get_default (TRUE, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->settings;
	currency_manager_set_refresh_interval (_tmp5_, g_settings_get_int (_tmp6_, "refresh-interval"));
	_g_object_unref0 (_tmp5_);
	_tmp7_ = currency_manager_get_default (TRUE, TRUE);
	_tmp8_ = _tmp7_;
	currency_manager_refresh_async (_tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->settings;
	g_signal_connect_object (_tmp9_, "changed::refresh-interval", (GCallback) ___lambda53__g_settings_changed, self, 0);
}

static MathWindow*
calculator_get_active_math_window (Calculator* self)
{
	GtkWindow* _tmp0_;
	MathWindow* _tmp1_;
	MathWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MATH_WINDOW, MathWindow));
	result = _tmp1_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
calculator_real_activate (GApplication* base)
{
	Calculator * self;
	MathWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = self->priv->last_opened_window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp2_ = calculator_equation_string;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = calculator_equation_string;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** equations = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gint equations_length1;
		gint _equations_size_;
		_tmp4_ = calculator_equation_string;
		_tmp5_ = g_strcompress (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_g_free0 (_tmp6_);
		equations = _tmp9_;
		equations_length1 = _tmp9__length1;
		_equations_size_ = equations_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gchar** _tmp12_;
					gint _tmp12__length1;
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gboolean _tmp19_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = equations;
					_tmp12__length1 = equations_length1;
					if (!(i < _tmp12__length1)) {
						break;
					}
					_tmp13_ = equations;
					_tmp13__length1 = equations_length1;
					_tmp14_ = _tmp13_[i];
					_tmp15_ = string_strip (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = strlen (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = _tmp18_ > 0;
					_g_free0 (_tmp16_);
					if (_tmp19_) {
						MathWindow* _tmp20_;
						MathEquation* _tmp21_;
						MathEquation* _tmp22_;
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						_tmp20_ = self->priv->last_opened_window;
						_tmp21_ = math_window_get_equation (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = equations;
						_tmp23__length1 = equations_length1;
						_tmp24_ = _tmp23_[i];
						math_equation_set (_tmp22_, _tmp24_);
					} else {
						MathWindow* _tmp25_;
						MathEquation* _tmp26_;
						MathEquation* _tmp27_;
						_tmp25_ = self->priv->last_opened_window;
						_tmp26_ = math_window_get_equation (_tmp25_);
						_tmp27_ = _tmp26_;
						math_equation_solve (_tmp27_);
					}
				}
			}
		}
		equations = (_vala_array_free (equations, equations_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp29_ = calculator_mode_string;
	if (g_strcmp0 (_tmp29_, "") != 0) {
		const gchar* _tmp30_;
		_tmp30_ = calculator_mode_string;
		_tmp28_ = _tmp30_ != NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		ButtonMode mode = 0;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		GQuark _tmp34_ = 0U;
		static GQuark _tmp33_label0 = 0;
		static GQuark _tmp33_label1 = 0;
		static GQuark _tmp33_label2 = 0;
		static GQuark _tmp33_label3 = 0;
		static GQuark _tmp33_label4 = 0;
		MathWindow* _tmp35_;
		MathButtons* _tmp36_;
		MathButtons* _tmp37_;
		mode = BUTTON_MODE_BASIC;
		_tmp31_ = calculator_mode_string;
		_tmp32_ = _tmp31_;
		_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
		if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("basic")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_BASIC;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("advanced")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_ADVANCED;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("financial")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_FINANCIAL;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("programming")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_PROGRAMMING;
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label4) ? _tmp33_label4 : (_tmp33_label4 = g_quark_from_static_string ("keyboard")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_KEYBOARD;
					break;
				}
			}
		}
		_tmp35_ = self->priv->last_opened_window;
		_tmp36_ = math_window_get_buttons (_tmp35_);
		_tmp37_ = _tmp36_;
		math_buttons_set_mode (_tmp37_, mode);
	}
}

static void
calculator_real_shutdown (GApplication* base)
{
	Calculator * self;
	MathWindow* window = NULL;
	MathWindow* _tmp0_;
	MathWindow* _tmp1_;
	MathEquation* equation = NULL;
	MathEquation* _tmp2_;
	MathEquation* _tmp3_;
	MathEquation* _tmp4_;
	MathButtons* buttons = NULL;
	MathButtons* _tmp5_;
	MathButtons* _tmp6_;
	MathButtons* _tmp7_;
	GSettings* _tmp8_;
	ButtonMode _tmp9_;
	ButtonMode _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GSettings* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GSettings* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GSettings* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GSettings* _tmp23_;
	DisplayFormat _tmp24_;
	DisplayFormat _tmp25_;
	GSettings* _tmp26_;
	AngleUnit _tmp27_;
	AngleUnit _tmp28_;
	GSettings* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GSettings* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GSettings* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GSettings* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GSettings* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GSettings* _tmp48_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = self->priv->last_opened_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = math_window_get_equation (window);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	equation = _tmp4_;
	_tmp5_ = math_window_get_buttons (window);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	buttons = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = math_buttons_get_mode (buttons);
	_tmp10_ = _tmp9_;
	g_settings_set_enum (_tmp8_, "button-mode", (gint) _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = math_equation_get_accuracy (equation);
	_tmp13_ = _tmp12_;
	g_settings_set_int (_tmp11_, "accuracy", _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = math_equation_get_word_size (equation);
	_tmp16_ = _tmp15_;
	g_settings_set_int (_tmp14_, "word-size", _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = math_equation_get_show_thousands_separators (equation);
	_tmp19_ = _tmp18_;
	g_settings_set_boolean (_tmp17_, "show-thousands", _tmp19_);
	_tmp20_ = self->priv->settings;
	_tmp21_ = math_equation_get_show_trailing_zeroes (equation);
	_tmp22_ = _tmp21_;
	g_settings_set_boolean (_tmp20_, "show-zeroes", _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = math_equation_get_number_format (equation);
	_tmp25_ = _tmp24_;
	g_settings_set_enum (_tmp23_, "number-format", (gint) _tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = math_equation_get_angle_units (equation);
	_tmp28_ = _tmp27_;
	g_settings_set_enum (_tmp26_, "angle-units", (gint) _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = math_equation_get_source_currency (equation);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_;
	g_settings_set_string (_tmp29_, "source-currency", _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = math_equation_get_target_currency (equation);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	g_settings_set_string (_tmp33_, "target-currency", _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = self->priv->settings;
	_tmp38_ = math_equation_get_source_units (equation);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_;
	g_settings_set_string (_tmp37_, "source-units", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = self->priv->settings;
	_tmp42_ = math_equation_get_target_units (equation);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_;
	g_settings_set_string (_tmp41_, "target-units", _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->settings;
	_tmp46_ = math_buttons_get_programming_base (buttons);
	_tmp47_ = _tmp46_;
	g_settings_set_int (_tmp45_, "base", _tmp47_);
	_tmp48_ = self->priv->settings;
	g_settings_apply (_tmp48_);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
	_g_object_unref0 (window);
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
calculator_real_handle_local_options (GApplication* base,
                                      GVariantDict* options)
{
	Calculator * self;
	gint result;
	self = (Calculator*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = stderr;
		_tmp1_ = calculator_program_name;
		fprintf (_tmp0_, "%1$s %2$s\n", _tmp1_, VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (g_variant_dict_contains (options, "solve")) {
		gchar* solve_equation = NULL;
		const GVariantType* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* tsep_string = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		gchar* decimal = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		GSettings* _tmp17_;
		AngleUnit angle_units = 0;
		GSettings* _tmp18_;
		ConvertEquation* e = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		ConvertEquation* _tmp26_;
		ConvertEquation* _tmp27_;
		ConvertEquation* _tmp28_;
		ConvertEquation* _tmp29_;
		ConvertEquation* _tmp30_;
		ErrorCode _error_ = 0;
		gchar* error_token = NULL;
		guint representation_base = 0U;
		Number* _result_ = NULL;
		ConvertEquation* _tmp31_;
		guint _tmp32_ = 0U;
		ErrorCode _tmp33_ = 0;
		gchar* _tmp34_ = NULL;
		Number* _tmp35_;
		Number* _tmp46_;
		_tmp2_ = G_VARIANT_TYPE_STRING;
		_tmp3_ = g_variant_dict_lookup_value (options, "solve", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _variant_get1 (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_variant_unref0 (_tmp4_);
		solve_equation = _tmp6_;
		_tmp7_ = nl_langinfo (THOUSEP);
		_tmp8_ = g_strdup (_tmp7_);
		tsep_string = _tmp8_;
		_tmp10_ = tsep_string;
		if (_tmp10_ == NULL) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = tsep_string;
			_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
		}
		if (_tmp9_) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp12_;
		}
		_tmp13_ = nl_langinfo (RADIXCHAR);
		_tmp14_ = g_strdup (_tmp13_);
		decimal = _tmp14_;
		_tmp15_ = decimal;
		if (_tmp15_ == NULL) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("");
			_g_free0 (decimal);
			decimal = _tmp16_;
		}
		_tmp17_ = g_settings_new ("org.gnome.calculator");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp17_;
		_tmp18_ = self->priv->settings;
		angle_units = (AngleUnit) g_settings_get_enum (_tmp18_, "angle-units");
		_tmp19_ = solve_equation;
		_tmp20_ = tsep_string;
		_tmp21_ = string_replace (_tmp19_, _tmp20_, "");
		_tmp22_ = _tmp21_;
		_tmp23_ = decimal;
		_tmp24_ = string_replace (_tmp22_, _tmp23_, ".");
		_tmp25_ = _tmp24_;
		_tmp26_ = convert_equation_new (_tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp22_);
		e = _tmp27_;
		_tmp28_ = e;
		((Equation*) _tmp28_)->base = 10;
		_tmp29_ = e;
		((Equation*) _tmp29_)->wordlen = 32;
		_tmp30_ = e;
		((Equation*) _tmp30_)->angle_units = angle_units;
		error_token = NULL;
		_tmp31_ = e;
		_tmp35_ = equation_parse ((Equation*) _tmp31_, &_tmp32_, &_tmp33_, &_tmp34_, NULL, NULL);
		representation_base = _tmp32_;
		_error_ = _tmp33_;
		_g_free0 (error_token);
		error_token = _tmp34_;
		_result_ = _tmp35_;
		if (_error_ == ERROR_CODE_UNKNOWN_CONVERSION) {
			CurrencyManager* _tmp36_;
			CurrencyManager* _tmp37_;
			GSettings* _tmp38_;
			CurrencyManager* _tmp39_;
			CurrencyManager* _tmp40_;
			ConvertEquation* _tmp41_;
			guint _tmp42_ = 0U;
			ErrorCode _tmp43_ = 0;
			gchar* _tmp44_ = NULL;
			Number* _tmp45_;
			_tmp36_ = currency_manager_get_default (TRUE, TRUE);
			_tmp37_ = _tmp36_;
			_tmp38_ = self->priv->settings;
			currency_manager_set_refresh_interval (_tmp37_, g_settings_get_int (_tmp38_, "refresh-interval"));
			_g_object_unref0 (_tmp37_);
			_tmp39_ = currency_manager_get_default (TRUE, TRUE);
			_tmp40_ = _tmp39_;
			currency_manager_refresh_sync (_tmp40_);
			_g_object_unref0 (_tmp40_);
			_tmp41_ = e;
			_tmp45_ = equation_parse ((Equation*) _tmp41_, &_tmp42_, &_tmp43_, &_tmp44_, NULL, NULL);
			representation_base = _tmp42_;
			_error_ = _tmp43_;
			_g_free0 (error_token);
			error_token = _tmp44_;
			_g_object_unref0 (_result_);
			_result_ = _tmp45_;
		}
		_tmp46_ = _result_;
		if (_tmp46_ != NULL) {
			Serializer* serializer = NULL;
			Serializer* _tmp47_;
			Serializer* _tmp48_;
			gchar* eq_result = NULL;
			Serializer* _tmp49_;
			Number* _tmp50_;
			gchar* _tmp51_;
			Serializer* _tmp52_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			FILE* _tmp59_;
			const gchar* _tmp60_;
			_tmp47_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
			serializer = _tmp47_;
			_tmp48_ = serializer;
			serializer_set_representation_base (_tmp48_, representation_base);
			_tmp49_ = serializer;
			_tmp50_ = _result_;
			_tmp51_ = serializer_to_string (_tmp49_, _tmp50_);
			eq_result = _tmp51_;
			_tmp52_ = serializer;
			_tmp53_ = serializer_get_error (_tmp52_);
			_tmp54_ = _tmp53_;
			if (_tmp54_ != NULL) {
				FILE* _tmp55_;
				Serializer* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				_tmp55_ = stderr;
				_tmp56_ = serializer;
				_tmp57_ = serializer_get_error (_tmp56_);
				_tmp58_ = _tmp57_;
				fprintf (_tmp55_, "%s", _tmp58_);
				result = EXIT_FAILURE;
				_g_free0 (eq_result);
				_g_object_unref0 (serializer);
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
			_tmp59_ = stdout;
			_tmp60_ = eq_result;
			fprintf (_tmp59_, "%s\n", _tmp60_);
			result = EXIT_SUCCESS;
			_g_free0 (eq_result);
			_g_object_unref0 (serializer);
			_g_object_unref0 (_result_);
			_g_free0 (error_token);
			_g_object_unref0 (e);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			_g_free0 (solve_equation);
			return result;
		} else {
			if (_error_ == ERROR_CODE_MP) {
				const gchar* _tmp61_ = NULL;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				FILE* _tmp67_;
				_tmp62_ = number_get_error ();
				_tmp63_ = _tmp62_;
				if (_tmp63_ != NULL) {
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					_tmp64_ = number_get_error ();
					_tmp65_ = _tmp64_;
					_tmp61_ = _tmp65_;
				} else {
					const gchar* _tmp66_;
					_tmp66_ = error_token;
					_tmp61_ = _tmp66_;
				}
				_tmp67_ = stderr;
				fprintf (_tmp67_, "Error: %s\n", _tmp61_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			} else {
				FILE* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp68_ = stderr;
				_tmp69_ = mp_error_code_to_string (_error_);
				_tmp70_ = _tmp69_;
				fprintf (_tmp68_, "Error: %s\n", _tmp70_);
				_g_free0 (_tmp70_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
		}
		_g_object_unref0 (_result_);
		_g_free0 (error_token);
		_g_object_unref0 (e);
		_g_free0 (decimal);
		_g_free0 (tsep_string);
		_g_free0 (solve_equation);
	}
	result = -1;
	return result;
}

static void
calculator_show_preferences_cb (Calculator* self)
{
	MathPreferencesDialog* _tmp0_;
	MathPreferencesDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		MathWindow* _tmp1_;
		MathWindow* _tmp2_;
		MathEquation* _tmp3_;
		MathEquation* _tmp4_;
		MathPreferencesDialog* _tmp5_;
		MathPreferencesDialog* _tmp6_;
		GtkWindow* _tmp7_;
		_tmp1_ = calculator_get_active_math_window (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = math_window_get_equation (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = math_preferences_dialog_new (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp5_;
		_g_object_unref0 (_tmp2_);
		_tmp6_ = self->priv->preferences_dialog;
		_tmp7_ = gtk_application_get_active_window ((GtkApplication*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp8_);
}

static gboolean
___lambda51_ (Calculator* self)
{
	gboolean result;
	_g_object_unref0 (self->priv->shortcuts_window);
	self->priv->shortcuts_window = NULL;
	result = FALSE;
	return result;
}

static gboolean
____lambda51__gtk_window_close_request (GtkWindow* _sender,
                                        gpointer self)
{
	gboolean result;
	result = ___lambda51_ ((Calculator*) self);
	return result;
}

static void
calculator_keyboard_shortcuts_cb (Calculator* self)
{
	GtkShortcutsWindow* _tmp0_;
	GtkWindow* _tmp8_;
	GtkShortcutsWindow* _tmp9_;
	GtkWindow* _tmp10_;
	GtkShortcutsWindow* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shortcuts_window;
	if (_tmp0_ == NULL) {
		GtkBuilder* builder = NULL;
		GtkBuilder* _tmp1_;
		GtkBuilder* _tmp4_;
		GObject* _tmp5_;
		GtkShortcutsWindow* _tmp6_;
		GtkShortcutsWindow* _tmp7_;
		_tmp1_ = gtk_builder_new ();
		builder = _tmp1_;
		{
			GtkBuilder* _tmp2_;
			_tmp2_ = builder;
			gtk_builder_add_from_resource (_tmp2_, "/org/gnome/calculator/math-shortcuts.ui", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e->message;
			g_error ("gnome-calculator.vala:281: Error loading shortcuts window UI: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = builder;
		_tmp5_ = gtk_builder_get_object (_tmp4_, "shortcuts-calculator");
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_shortcuts_window_get_type ()) ? ((GtkShortcutsWindow*) _tmp5_) : NULL);
		_g_object_unref0 (self->priv->shortcuts_window);
		self->priv->shortcuts_window = _tmp6_;
		_tmp7_ = self->priv->shortcuts_window;
		g_signal_connect_object ((GtkWindow*) _tmp7_, "close-request", (GCallback) ____lambda51__gtk_window_close_request, self, 0);
		_g_object_unref0 (builder);
	}
	_tmp8_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp9_ = self->priv->shortcuts_window;
	_tmp10_ = gtk_window_get_transient_for ((GtkWindow*) _tmp9_);
	if (_tmp8_ != _tmp10_) {
		GtkShortcutsWindow* _tmp11_;
		GtkWindow* _tmp12_;
		_tmp11_ = self->priv->shortcuts_window;
		_tmp12_ = gtk_application_get_active_window ((GtkApplication*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp12_);
	}
	_tmp13_ = self->priv->shortcuts_window;
	gtk_window_present ((GtkWindow*) _tmp13_);
}

static void
calculator_help_cb (Calculator* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	gtk_show_uri (_tmp0_, "help:gnome-calculator", (guint32) GDK_CURRENT_TIME);
}

static void
calculator_about_cb (Calculator* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint documenters_length1;
	gint _documenters_size_;
	gchar* translator_credits = NULL;
	gchar* _tmp8_;
	GtkWindow* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Robert Roth <robert.roth.off@gmail.com>");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_strdup ("Klaus Niederkrüger");
	_tmp3_ = g_strdup ("Robin Sonefors");
	_tmp4_ = g_strdup ("Rich Burridge");
	_tmp5_ = g_new0 (gchar*, 6 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	_tmp5_[5] = NULL;
	authors = _tmp5_;
	authors_length1 = 6;
	_authors_size_ = authors_length1;
	_tmp6_ = g_strdup ("Sun Microsystems");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp7_[1] = NULL;
	documenters = _tmp7_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp8_ = g_strdup (_ ("translator-credits"));
	translator_credits = _tmp8_;
	_tmp9_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp10_ = g_strconcat (NAME_PREFIX, _ ("Calculator"), NULL);
	_tmp11_ = _tmp10_;
	gtk_show_about_dialog (_tmp9_, "program-name", _tmp11_, "title", _ ("About Calculator"), "version", VERSION, "website", "https://wiki.gnome.org/Apps/Calculator", "copyright", "\xc2\xa9 1986–2016 The Calculator authors", "license-type", GTK_LICENSE_GPL_3_0, "comments", _ ("Calculator with financial and scientific modes."), "authors", authors, "documenters", documenters, "translator_credits", translator_credits, "logo-icon-name", APP_ID, NULL);
	_g_free0 (_tmp11_);
	_g_free0 (translator_credits);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda52_ (Calculator* self,
              gint _result_)
{
	if (_result_ == ((gint) GTK_RESPONSE_CLOSE)) {
		g_application_quit ((GApplication*) self);
	}
}

static void
____lambda52__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda52_ ((Calculator*) self, response_id);
}

static void
calculator_quit_cb (Calculator* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (g_list_length (_tmp0_) > ((guint) 1)) {
		GtkMessageDialog* dialog = NULL;
		MathWindow* _tmp1_;
		MathWindow* _tmp2_;
		GtkMessageDialog* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* _tmp6_;
		GtkMessageDialog* _tmp7_;
		_tmp1_ = calculator_get_active_math_window (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) _tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_CANCEL, "%s", _ ("Are you sure you want to close all open windows?"));
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		dialog = _tmp4_;
		_tmp5_ = dialog;
		gtk_dialog_add_buttons ((GtkDialog*) _tmp5_, _ ("Close _All"), GTK_RESPONSE_CLOSE, NULL);
		_tmp6_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp6_, "response", (GCallback) ____lambda52__gtk_dialog_response, self, 0);
		_tmp7_ = dialog;
		gtk_widget_show ((GtkWidget*) _tmp7_);
		_g_object_unref0 (dialog);
	} else {
		g_application_quit ((GApplication*) self);
	}
}

static void
calculator_new_window_cb (Calculator* self)
{
	MathWindow* window = NULL;
	GSettings* _tmp0_;
	MathWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = calculator_create_new_window (self, _tmp0_);
	window = _tmp1_;
	gtk_widget_show ((GtkWidget*) window);
	_g_object_unref0 (window);
}

static gint
calculator_main (gchar** args,
                 gint args_length1)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	Calculator* app = NULL;
	Calculator* _tmp3_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	g_random_set_seed ((guint32) g_date_time_get_microsecond (now));
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_g_free0 (calculator_program_name);
	calculator_program_name = _tmp2_;
	gtk_window_set_default_icon_name (APP_ID "-symbolic");
	_tmp3_ = calculator_new ();
	app = _tmp3_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	_g_date_time_unref0 (now);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return calculator_main (argv, argc);
}

static void
calculator_class_init (CalculatorClass * klass,
                       gpointer klass_data)
{
	calculator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Calculator_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) calculator_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) calculator_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) calculator_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) calculator_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = calculator_finalize;
}

static void
calculator_instance_init (Calculator * self,
                          gpointer klass)
{
	self->priv = calculator_get_instance_private (self);
}

static void
calculator_finalize (GObject * obj)
{
	Calculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALCULATOR, Calculator);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->last_opened_window);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->shortcuts_window);
	G_OBJECT_CLASS (calculator_parent_class)->finalize (obj);
}

static GType
calculator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Calculator), 0, (GInstanceInitFunc) calculator_instance_init, NULL };
	GType calculator_type_id;
	calculator_type_id = g_type_register_static (adw_application_get_type (), "Calculator", &g_define_type_info, 0);
	Calculator_private_offset = g_type_add_instance_private (calculator_type_id, sizeof (CalculatorPrivate));
	return calculator_type_id;
}

GType
calculator_get_type (void)
{
	static volatile gsize calculator_type_id__once = 0;
	if (g_once_init_enter (&calculator_type_id__once)) {
		GType calculator_type_id;
		calculator_type_id = calculator_get_type_once ();
		g_once_init_leave (&calculator_type_id__once, calculator_type_id);
	}
	return calculator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

