/* application.c generated by valac 0.56.0, the Vala compiler
 * generated from application.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <gtk/gtk.h>
#include <libgweather/gweather.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
typedef struct _ClocksApplicationPrivate ClocksApplicationPrivate;

#define CLOCKS_TYPE_SEARCH_PROVIDER (clocks_search_provider_get_type ())
#define CLOCKS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProvider))
#define CLOCKS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))
#define CLOCKS_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))

typedef struct _ClocksSearchProvider ClocksSearchProvider;
typedef struct _ClocksSearchProviderClass ClocksSearchProviderClass;

#define CLOCKS_WORLD_TYPE_SHELL_WORLD_CLOCKS (clocks_world_shell_world_clocks_get_type ())
#define CLOCKS_WORLD_SHELL_WORLD_CLOCKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_SHELL_WORLD_CLOCKS, ClocksWorldShellWorldClocks))
#define CLOCKS_WORLD_SHELL_WORLD_CLOCKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_SHELL_WORLD_CLOCKS, ClocksWorldShellWorldClocksClass))
#define CLOCKS_WORLD_IS_SHELL_WORLD_CLOCKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_SHELL_WORLD_CLOCKS))
#define CLOCKS_WORLD_IS_SHELL_WORLD_CLOCKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_SHELL_WORLD_CLOCKS))
#define CLOCKS_WORLD_SHELL_WORLD_CLOCKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_SHELL_WORLD_CLOCKS, ClocksWorldShellWorldClocksClass))

typedef struct _ClocksWorldShellWorldClocks ClocksWorldShellWorldClocks;
typedef struct _ClocksWorldShellWorldClocksClass ClocksWorldShellWorldClocksClass;

#define CLOCKS_TYPE_WINDOW (clocks_window_get_type ())
#define CLOCKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_WINDOW, ClocksWindow))
#define CLOCKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_WINDOW, ClocksWindowClass))
#define CLOCKS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_WINDOW))
#define CLOCKS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_WINDOW))
#define CLOCKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_WINDOW, ClocksWindowClass))

typedef struct _ClocksWindow ClocksWindow;
typedef struct _ClocksWindowClass ClocksWindowClass;
enum  {
	CLOCKS_APPLICATION_0_PROPERTY,
	CLOCKS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* clocks_application_properties[CLOCKS_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ClocksApplication {
	AdwApplication parent_instance;
	ClocksApplicationPrivate * priv;
};

struct _ClocksApplicationClass {
	AdwApplicationClass parent_class;
};

struct _ClocksApplicationPrivate {
	ClocksSearchProvider* search_provider;
	guint search_provider_id;
	ClocksWorldShellWorldClocks* world_clocks;
	guint world_clocks_id;
	ClocksWindow* window;
	GList* system_notifications;
};

static gint ClocksApplication_private_offset;
static gpointer clocks_application_parent_class = NULL;

VALA_EXTERN GType clocks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksApplication, g_object_unref)
VALA_EXTERN GType clocks_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksSearchProvider, g_object_unref)
VALA_EXTERN guint clocks_search_provider_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType clocks_world_shell_world_clocks_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldShellWorldClocks, g_object_unref)
VALA_EXTERN guint clocks_world_shell_world_clocks_register_object (void* object,
                                                       GDBusConnection* connection,
                                                       const gchar* path,
                                                       GError** error);
VALA_EXTERN GType clocks_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWindow, g_object_unref)
static void clocks_application_on_quit_activate (ClocksApplication* self);
static void _clocks_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
VALA_EXTERN void clocks_application_on_add_location_activate (ClocksApplication* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void _clocks_application_on_add_location_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static ClocksWindow* clocks_application_ensure_window (ClocksApplication* self);
VALA_EXTERN ClocksWindow* clocks_window_new (ClocksApplication* app);
VALA_EXTERN ClocksWindow* clocks_window_construct (GType object_type,
                                       ClocksApplication* app);
VALA_EXTERN ClocksApplication* clocks_application_new (void);
VALA_EXTERN ClocksApplication* clocks_application_construct (GType object_type);
VALA_EXTERN ClocksSearchProvider* clocks_search_provider_new (void);
VALA_EXTERN ClocksSearchProvider* clocks_search_provider_construct (GType object_type);
static void __lambda54_ (ClocksApplication* self,
                  guint32 timestamp);
VALA_EXTERN void clocks_window_show_world (ClocksWindow* self);
static void ___lambda54__clocks_search_provider_activate (ClocksSearchProvider* _sender,
                                                   guint32 timestamp,
                                                   gpointer self);
static gboolean clocks_application_real_dbus_register (GApplication* base,
                                                GDBusConnection* connection,
                                                const gchar* object_path,
                                                GError** error);
VALA_EXTERN ClocksWorldShellWorldClocks* clocks_world_shell_world_clocks_new (GDBusConnection* connection,
                                                                  const gchar* object_path);
VALA_EXTERN ClocksWorldShellWorldClocks* clocks_world_shell_world_clocks_construct (GType object_type,
                                                                        GDBusConnection* connection,
                                                                        const gchar* object_path);
static void clocks_application_real_dbus_unregister (GApplication* base,
                                              GDBusConnection* connection,
                                              const gchar* object_path);
static void clocks_application_real_activate (GApplication* base);
static void clocks_application_real_startup (GApplication* base);
static gint clocks_application_real_handle_local_options (GApplication* base,
                                                   GVariantDict* options);
static GVariant* _variant_get10 (GVariant* value);
VALA_EXTERN void clocks_window_add_world_location (ClocksWindow* self,
                                       GWeatherLocation* location);
VALA_EXTERN void clocks_application_send_notification (ClocksApplication* self,
                                           const gchar* notification_id,
                                           GNotification* notification);
VALA_EXTERN void clocks_application_withdraw_notifications (ClocksApplication* self);
static void clocks_application_real_shutdown (GApplication* base);
static void clocks_application_finalize (GObject * obj);
static GType clocks_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry CLOCKS_APPLICATION_OPTION_ENTRIES[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print version information and exit"), NULL}, {(const gchar*) NULL}};
static const GActionEntry CLOCKS_APPLICATION_ACTION_ENTRIES[4] = {{"stop-alarm", NULL, "s"}, {"snooze-alarm", NULL, "s"}, {"quit", _clocks_application_on_quit_activate_gsimple_action_activate_callback}, {"add-location", _clocks_application_on_add_location_activate_gsimple_action_activate_callback, "v"}};

static inline gpointer
clocks_application_get_instance_private (ClocksApplication* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksApplication_private_offset);
}

static void
_clocks_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	clocks_application_on_quit_activate ((ClocksApplication*) self);
}

static void
_clocks_application_on_add_location_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	clocks_application_on_add_location_activate ((ClocksApplication*) self, action, parameter);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ClocksWindow*
clocks_application_ensure_window (ClocksApplication* self)
{
	ClocksWindow* _tmp0_;
	ClocksWindow* _tmp2_;
	ClocksWindow* _tmp3_;
	ClocksWindow* _tmp4_;
	ClocksWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		ClocksWindow* _tmp1_;
		_tmp1_ = clocks_window_new (self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->window);
		self->priv->window = _tmp1_;
	}
	_tmp2_ = self->priv->window;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_WINDOW, ClocksWindow));
	result = _tmp3_;
	_tmp4_ = self->priv->window;
	_vala_warn_if_fail (_tmp4_ != NULL, "window != null");
	return result;
}

static void
__lambda54_ (ClocksApplication* self,
             guint32 timestamp)
{
	ClocksWindow* win = NULL;
	ClocksWindow* _tmp0_;
	_tmp0_ = clocks_application_ensure_window (self);
	win = _tmp0_;
	clocks_window_show_world (win);
	gtk_window_present_with_time ((GtkWindow*) win, timestamp);
	_g_object_unref0 (win);
}

static void
___lambda54__clocks_search_provider_activate (ClocksSearchProvider* _sender,
                                              guint32 timestamp,
                                              gpointer self)
{
	__lambda54_ ((ClocksApplication*) self, timestamp);
}

ClocksApplication*
clocks_application_construct (GType object_type)
{
	ClocksApplication * self = NULL;
	ClocksSearchProvider* _tmp0_;
	ClocksSearchProvider* _tmp1_;
	self = (ClocksApplication*) g_object_new (object_type, "application-id", APP_ID, "resource-base-path", "/org/gnome/clocks/", NULL);
	gtk_window_set_default_icon_name (APP_ID);
	g_application_add_main_option_entries ((GApplication*) self, CLOCKS_APPLICATION_OPTION_ENTRIES);
	g_action_map_add_action_entries ((GActionMap*) self, CLOCKS_APPLICATION_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CLOCKS_APPLICATION_ACTION_ENTRIES), self);
	_tmp0_ = clocks_search_provider_new ();
	_g_object_unref0 (self->priv->search_provider);
	self->priv->search_provider = _tmp0_;
	_tmp1_ = self->priv->search_provider;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda54__clocks_search_provider_activate, self, 0);
	(self->priv->system_notifications == NULL) ? NULL : (self->priv->system_notifications = (_g_list_free__g_free0_ (self->priv->system_notifications), NULL));
	self->priv->system_notifications = NULL;
	return self;
}

ClocksApplication*
clocks_application_new (void)
{
	return clocks_application_construct (CLOCKS_TYPE_APPLICATION);
}

static gboolean
clocks_application_real_dbus_register (GApplication* base,
                                       GDBusConnection* connection,
                                       const gchar* object_path,
                                       GError** error)
{
	ClocksApplication * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ClocksApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		guint _tmp0_ = 0U;
		gchar* _tmp1_;
		gchar* _tmp2_;
		ClocksSearchProvider* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp1_ = g_strconcat (object_path, "/SearchProvider", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->search_provider;
		_tmp4_ = clocks_search_provider_register_object (_tmp3_, connection, _tmp2_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		self->priv->search_provider_id = _tmp0_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_printerr ("Could not register search provider service: %s\n", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	{
		ClocksWorldShellWorldClocks* _tmp10_;
		guint _tmp11_ = 0U;
		ClocksWorldShellWorldClocks* _tmp12_;
		guint _tmp13_;
		_tmp10_ = clocks_world_shell_world_clocks_new (connection, object_path);
		_g_object_unref0 (self->priv->world_clocks);
		self->priv->world_clocks = _tmp10_;
		_tmp12_ = self->priv->world_clocks;
		_tmp13_ = clocks_world_shell_world_clocks_register_object (_tmp12_, connection, object_path, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp14_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp14_;
		}
		self->priv->world_clocks_id = _tmp11_;
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_printerr ("Could not register world clocks service: %s\n", _tmp16_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	result = TRUE;
	return result;
}

static void
clocks_application_real_dbus_unregister (GApplication* base,
                                         GDBusConnection* connection,
                                         const gchar* object_path)
{
	ClocksApplication * self;
	self = (ClocksApplication*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	if (self->priv->search_provider_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (connection, self->priv->search_provider_id);
		self->priv->search_provider_id = (guint) 0;
	}
	if (self->priv->world_clocks_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (connection, self->priv->world_clocks_id);
		self->priv->world_clocks_id = (guint) 0;
	}
}

static void
clocks_application_real_activate (GApplication* base)
{
	ClocksApplication * self;
	ClocksWindow* win = NULL;
	ClocksWindow* _tmp0_;
	self = (ClocksApplication*) base;
	G_APPLICATION_CLASS (clocks_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = clocks_application_ensure_window (self);
	win = _tmp0_;
	gtk_window_present ((GtkWindow*) win);
	_g_object_unref0 (win);
}

static void
clocks_application_real_startup (GApplication* base)
{
	ClocksApplication * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	self = (ClocksApplication*) base;
	G_APPLICATION_CLASS (clocks_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = g_strdup ("<Control>n");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("F10");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-primary-menu", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("F1");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.help", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Control>q");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Control><Alt>Page_Up");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.navigate-backward", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Control><Alt>Page_Down");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.navigate-forward", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
}

static gint
clocks_application_real_handle_local_options (GApplication* base,
                                              GVariantDict* options)
{
	ClocksApplication * self;
	gint result;
	self = (ClocksApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		const gchar* _tmp0_;
		_tmp0_ = g_get_application_name ();
		g_print ("%s %s\n", (const gchar*) _tmp0_, VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

static GVariant*
_variant_get10 (GVariant* value)
{
	return g_variant_get_variant (value);
}

void
clocks_application_on_add_location_activate (ClocksApplication* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	ClocksWindow* win = NULL;
	ClocksWindow* _tmp0_;
	ClocksWindow* _tmp1_;
	ClocksWindow* _tmp2_;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp3_;
	GWeatherLocation* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (parameter == NULL) {
		return;
	}
	_tmp0_ = clocks_application_ensure_window (self);
	win = _tmp0_;
	_tmp1_ = win;
	clocks_window_show_world (_tmp1_);
	_tmp2_ = win;
	gtk_window_present ((GtkWindow*) _tmp2_);
	_tmp3_ = gweather_location_get_world ();
	world = _tmp3_;
	_tmp4_ = world;
	if (_tmp4_ != NULL) {
		GWeatherLocation* location = NULL;
		GWeatherLocation* _tmp5_;
		GVariant* _tmp6_;
		GWeatherLocation* _tmp7_;
		GWeatherLocation* _tmp8_;
		_tmp5_ = world;
		_tmp6_ = _variant_get10 (parameter);
		_tmp7_ = gweather_location_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gweather_location_get_type (), GWeatherLocation), _tmp6_);
		location = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gweather_location_get_type (), GWeatherLocation);
		_tmp8_ = location;
		if (_tmp8_ != NULL) {
			ClocksWindow* _tmp9_;
			GWeatherLocation* _tmp10_;
			_tmp9_ = win;
			_tmp10_ = location;
			clocks_window_add_world_location (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gweather_location_get_type (), GWeatherLocation));
		}
		_g_object_unref0 (location);
	} else {
		g_warning ("application.vala:140: the world is missing");
	}
	_g_object_unref0 (world);
	_g_object_unref0 (win);
}

void
clocks_application_send_notification (ClocksApplication* self,
                                      const gchar* notification_id,
                                      GNotification* notification)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification_id != NULL);
	g_return_if_fail (notification != NULL);
	g_application_send_notification ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication), notification_id, notification);
	_tmp0_ = g_strdup (notification_id);
	self->priv->system_notifications = g_list_append (self->priv->system_notifications, _tmp0_);
}

void
clocks_application_withdraw_notifications (ClocksApplication* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->system_notifications;
	{
		GList* notification_collection = NULL;
		GList* notification_it = NULL;
		notification_collection = _tmp0_;
		for (notification_it = notification_collection; notification_it != NULL; notification_it = notification_it->next) {
			gchar* _tmp1_;
			gchar* notification = NULL;
			_tmp1_ = g_strdup ((const gchar*) notification_it->data);
			notification = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = notification;
				g_application_withdraw_notification ((GApplication*) self, _tmp2_);
				_g_free0 (notification);
			}
		}
	}
}

static void
clocks_application_real_shutdown (GApplication* base)
{
	ClocksApplication * self;
	self = (ClocksApplication*) base;
	G_APPLICATION_CLASS (clocks_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	clocks_application_withdraw_notifications (self);
}

static void
clocks_application_on_quit_activate (ClocksApplication* self)
{
	ClocksWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		ClocksWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_window_destroy ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_TYPE_WINDOW, ClocksWindow));
	}
	g_application_quit ((GApplication*) self);
}

static void
clocks_application_class_init (ClocksApplicationClass * klass,
                               gpointer klass_data)
{
	clocks_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksApplication_private_offset);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) clocks_application_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) clocks_application_real_dbus_unregister;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) clocks_application_real_activate;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) clocks_application_real_startup;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) clocks_application_real_handle_local_options;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) clocks_application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = clocks_application_finalize;
}

static void
clocks_application_instance_init (ClocksApplication * self,
                                  gpointer klass)
{
	self->priv = clocks_application_get_instance_private (self);
	self->priv->search_provider_id = (guint) 0;
	self->priv->world_clocks_id = (guint) 0;
}

static void
clocks_application_finalize (GObject * obj)
{
	ClocksApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_APPLICATION, ClocksApplication);
	_g_object_unref0 (self->priv->search_provider);
	_g_object_unref0 (self->priv->world_clocks);
	_g_object_unref0 (self->priv->window);
	(self->priv->system_notifications == NULL) ? NULL : (self->priv->system_notifications = (_g_list_free__g_free0_ (self->priv->system_notifications), NULL));
	G_OBJECT_CLASS (clocks_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksApplication), 0, (GInstanceInitFunc) clocks_application_instance_init, NULL };
	GType clocks_application_type_id;
	clocks_application_type_id = g_type_register_static (adw_application_get_type (), "ClocksApplication", &g_define_type_info, 0);
	ClocksApplication_private_offset = g_type_add_instance_private (clocks_application_type_id, sizeof (ClocksApplicationPrivate));
	return clocks_application_type_id;
}

GType
clocks_application_get_type (void)
{
	static volatile gsize clocks_application_type_id__once = 0;
	if (g_once_init_enter (&clocks_application_type_id__once)) {
		GType clocks_application_type_id;
		clocks_application_type_id = clocks_application_get_type_once ();
		g_once_init_leave (&clocks_application_type_id__once, clocks_application_type_id);
	}
	return clocks_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

