/* timer-item.c generated by valac 0.56.0, the Vala compiler
 * generated from timer-item.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Bilal Elmoussaoui <bilal.elmoussaoui@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_TIMER_TYPE_ITEM (clocks_timer_item_get_type ())
#define CLOCKS_TIMER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem))
#define CLOCKS_TIMER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItemClass))
#define CLOCKS_TIMER_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_ITEM))
#define CLOCKS_TIMER_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_ITEM))
#define CLOCKS_TIMER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItemClass))

typedef struct _ClocksTimerItem ClocksTimerItem;
typedef struct _ClocksTimerItemClass ClocksTimerItemClass;
typedef struct _ClocksTimerItemPrivate ClocksTimerItemPrivate;
typedef enum  {
	CLOCKS_TIMER_ITEM_STATE_STOPPED,
	CLOCKS_TIMER_ITEM_STATE_RUNNING,
	CLOCKS_TIMER_ITEM_STATE_PAUSED
} ClocksTimerItemState;

#define CLOCKS_TIMER_ITEM_TYPE_STATE (clocks_timer_item_state_get_type ())
enum  {
	CLOCKS_TIMER_ITEM_0_PROPERTY,
	CLOCKS_TIMER_ITEM_STATE_PROPERTY,
	CLOCKS_TIMER_ITEM_NAME_PROPERTY,
	CLOCKS_TIMER_ITEM_HOURS_PROPERTY,
	CLOCKS_TIMER_ITEM_MINUTES_PROPERTY,
	CLOCKS_TIMER_ITEM_SECONDS_PROPERTY,
	CLOCKS_TIMER_ITEM_NUM_PROPERTIES
};
static GParamSpec* clocks_timer_item_properties[CLOCKS_TIMER_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
enum  {
	CLOCKS_TIMER_ITEM_RING_SIGNAL,
	CLOCKS_TIMER_ITEM_COUNTDOWN_UPDATED_SIGNAL,
	CLOCKS_TIMER_ITEM_START_SIGNAL,
	CLOCKS_TIMER_ITEM_PAUSE_SIGNAL,
	CLOCKS_TIMER_ITEM_RESET_SIGNAL,
	CLOCKS_TIMER_ITEM_NUM_SIGNALS
};
static guint clocks_timer_item_signals[CLOCKS_TIMER_ITEM_NUM_SIGNALS] = {0};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksTimerItem {
	GObject parent_instance;
	ClocksTimerItemPrivate * priv;
};

struct _ClocksTimerItemClass {
	GObjectClass parent_class;
	void (*start) (ClocksTimerItem* self);
	void (*pause) (ClocksTimerItem* self);
	void (*reset) (ClocksTimerItem* self);
};

struct _ClocksTimerItemPrivate {
	ClocksTimerItemState _state;
	gchar* _name;
	gint _hours;
	gint _minutes;
	gint _seconds;
	gdouble span;
	GTimer* timer;
	guint timeout_id;
	gint stored_hour;
	gint stored_minute;
	gint stored_second;
};

static gint ClocksTimerItem_private_offset;
static gpointer clocks_timer_item_parent_class = NULL;
static ClocksContentItemIface * clocks_timer_item_clocks_content_item_parent_iface = NULL;

VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN GType clocks_timer_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerItem, g_object_unref)
VALA_EXTERN GType clocks_timer_item_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint clocks_timer_item_get_total_seconds (ClocksTimerItem* self);
VALA_EXTERN gint clocks_timer_item_get_hours (ClocksTimerItem* self);
VALA_EXTERN gint clocks_timer_item_get_minutes (ClocksTimerItem* self);
VALA_EXTERN gint clocks_timer_item_get_seconds (ClocksTimerItem* self);
static void clocks_timer_item_real_serialize (ClocksContentItem* base,
                                       GVariantBuilder* builder);
VALA_EXTERN const gchar* clocks_content_item_get_name (ClocksContentItem* self);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_deserialize (GVariant* time_variant);
static gint32 _variant_get11 (GVariant* value);
static gchar* _variant_get12 (GVariant* value);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_new_from_seconds (gint seconds,
                                                     const gchar* name);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_construct_from_seconds (GType object_type,
                                                           gint seconds,
                                                           const gchar* name);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_new (gint h,
                                        gint m,
                                        gint s,
                                        const gchar* name);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_construct (GType object_type,
                                              gint h,
                                              gint m,
                                              gint s,
                                              const gchar* name);
VALA_EXTERN void clocks_timer_item_set_hours (ClocksTimerItem* self,
                                  gint value);
VALA_EXTERN void clocks_timer_item_set_minutes (ClocksTimerItem* self,
                                    gint value);
VALA_EXTERN void clocks_timer_item_set_seconds (ClocksTimerItem* self,
                                    gint value);
VALA_EXTERN ClocksTimerItemState clocks_timer_item_get_state (ClocksTimerItem* self);
static void clocks_timer_item_set_state (ClocksTimerItem* self,
                                  ClocksTimerItemState value);
static void g_cclosure_user_marshal_VOID__INT_INT_INT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void clocks_timer_item_real_start (ClocksTimerItem* self);
static gboolean __lambda30_ (ClocksTimerItem* self);
VALA_EXTERN void clocks_utils_time_to_hms (gdouble t,
                               gint* h,
                               gint* m,
                               gint* s,
                               gdouble* remainder);
static gboolean ___lambda30__gsource_func (gpointer self);
static void clocks_timer_item_real_pause (ClocksTimerItem* self);
static void clocks_timer_item_real_reset (ClocksTimerItem* self);
VALA_EXTERN void clocks_content_item_serialize (ClocksContentItem* self,
                                    GVariantBuilder* builder);
VALA_EXTERN void clocks_content_item_set_name (ClocksContentItem* self,
                                   const gchar* value);
static void clocks_timer_item_finalize (GObject * obj);
static GType clocks_timer_item_get_type_once (void);
static void _vala_clocks_timer_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_timer_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
clocks_timer_item_get_instance_private (ClocksTimerItem* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksTimerItem_private_offset);
}

 G_GNUC_NO_INLINE static GType
clocks_timer_item_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_TIMER_ITEM_STATE_STOPPED, "CLOCKS_TIMER_ITEM_STATE_STOPPED", "stopped"}, {CLOCKS_TIMER_ITEM_STATE_RUNNING, "CLOCKS_TIMER_ITEM_STATE_RUNNING", "running"}, {CLOCKS_TIMER_ITEM_STATE_PAUSED, "CLOCKS_TIMER_ITEM_STATE_PAUSED", "paused"}, {0, NULL, NULL}};
	GType clocks_timer_item_state_type_id;
	clocks_timer_item_state_type_id = g_enum_register_static ("ClocksTimerItemState", values);
	return clocks_timer_item_state_type_id;
}

GType
clocks_timer_item_state_get_type (void)
{
	static volatile gsize clocks_timer_item_state_type_id__once = 0;
	if (g_once_init_enter (&clocks_timer_item_state_type_id__once)) {
		GType clocks_timer_item_state_type_id;
		clocks_timer_item_state_type_id = clocks_timer_item_state_get_type_once ();
		g_once_init_leave (&clocks_timer_item_state_type_id__once, clocks_timer_item_state_type_id);
	}
	return clocks_timer_item_state_type_id__once;
}

gint
clocks_timer_item_get_total_seconds (ClocksTimerItem* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_hours;
	_tmp1_ = self->priv->_minutes;
	_tmp2_ = self->priv->_seconds;
	result = ((_tmp0_ * 3600) + (_tmp1_ * 60)) + _tmp2_;
	return result;
}

static void
clocks_timer_item_real_serialize (ClocksContentItem* base,
                                  GVariantBuilder* builder)
{
	ClocksTimerItem * self;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	self = (ClocksTimerItem*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_variant_type_new ("a{sv}");
	_tmp1_ = _tmp0_;
	g_variant_builder_open (builder, _tmp1_);
	_g_variant_type_free0 (_tmp1_);
	_tmp2_ = g_variant_new_int32 ((gint32) clocks_timer_item_get_total_seconds (self));
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	g_variant_builder_add (builder, "{sv}", "duration", _tmp3_, NULL);
	_g_variant_unref0 (_tmp3_);
	_tmp4_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp6_ = clocks_content_item_get_name ((ClocksContentItem*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_variant_new_string ((const gchar*) _tmp7_);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_variant_builder_add (builder, "{sv}", "name", _tmp9_, NULL);
		_g_variant_unref0 (_tmp9_);
	}
	g_variant_builder_close (builder);
}

static gint32
_variant_get11 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gchar*
_variant_get12 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

ClocksTimerItem*
clocks_timer_item_deserialize (GVariant* time_variant)
{
	gchar* key = NULL;
	GVariant* val = NULL;
	gint duration = 0;
	gchar* name = NULL;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp0_;
	ClocksTimerItem* _tmp13_ = NULL;
	ClocksTimerItem* result;
	g_return_val_if_fail (time_variant != NULL, NULL);
	duration = 0;
	name = NULL;
	_tmp0_ = g_variant_iter_new (time_variant);
	iter = _tmp0_;
	while (TRUE) {
		GVariantIter* _tmp1_;
		gchar* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		gboolean _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GQuark _tmp8_ = 0U;
		static GQuark _tmp7_label0 = 0;
		static GQuark _tmp7_label1 = 0;
		_tmp1_ = iter;
		_tmp4_ = g_variant_iter_next (_tmp1_, "{sv}", &_tmp2_, &_tmp3_, NULL);
		_g_free0 (key);
		key = _tmp2_;
		_g_variant_unref0 (val);
		val = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = key;
		_tmp6_ = _tmp5_;
		_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
		if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("duration")))) {
			switch (0) {
				default:
				{
					GVariant* _tmp9_;
					gint32 _tmp10_;
					_tmp9_ = val;
					_tmp10_ = _variant_get11 (_tmp9_);
					duration = (gint) _tmp10_;
					break;
				}
			}
		} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("name")))) {
			switch (0) {
				default:
				{
					GVariant* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = val;
					_tmp12_ = _variant_get12 (_tmp11_);
					_g_free0 (name);
					name = _tmp12_;
					break;
				}
			}
		}
	}
	if (duration != 0) {
		const gchar* _tmp14_;
		ClocksTimerItem* _tmp15_;
		_tmp14_ = name;
		_tmp15_ = clocks_timer_item_new_from_seconds (duration, _tmp14_);
		_g_object_unref0 (_tmp13_);
		_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem);
	} else {
		_g_object_unref0 (_tmp13_);
		_tmp13_ = NULL;
	}
	result = _tmp13_;
	_g_variant_iter_free0 (iter);
	_g_free0 (name);
	_g_variant_unref0 (val);
	_g_free0 (key);
	return result;
}

ClocksTimerItem*
clocks_timer_item_construct_from_seconds (GType object_type,
                                          gint seconds,
                                          const gchar* name)
{
	ClocksTimerItem * self = NULL;
	gint rest = 0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	rest = 0;
	h = seconds / 3600;
	rest = seconds - (h * 3600);
	m = rest / 60;
	s = rest - (m * 60);
	self = (ClocksTimerItem*) clocks_timer_item_construct (object_type, h, m, s, name);
	return self;
}

ClocksTimerItem*
clocks_timer_item_new_from_seconds (gint seconds,
                                    const gchar* name)
{
	return clocks_timer_item_construct_from_seconds (CLOCKS_TIMER_TYPE_ITEM, seconds, name);
}

ClocksTimerItem*
clocks_timer_item_construct (GType object_type,
                             gint h,
                             gint m,
                             gint s,
                             const gchar* name)
{
	ClocksTimerItem * self = NULL;
	GTimer* _tmp0_;
	self = (ClocksTimerItem*) g_object_new (object_type, "name", name, NULL);
	clocks_timer_item_set_hours (self, h);
	clocks_timer_item_set_minutes (self, m);
	clocks_timer_item_set_seconds (self, s);
	self->priv->span = (gdouble) clocks_timer_item_get_total_seconds (self);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp0_;
	self->priv->timeout_id = (guint) 0;
	return self;
}

ClocksTimerItem*
clocks_timer_item_new (gint h,
                       gint m,
                       gint s,
                       const gchar* name)
{
	return clocks_timer_item_construct (CLOCKS_TIMER_TYPE_ITEM, h, m, s, name);
}

ClocksTimerItemState
clocks_timer_item_get_state (ClocksTimerItem* self)
{
	ClocksTimerItemState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
clocks_timer_item_set_state (ClocksTimerItem* self,
                             ClocksTimerItemState value)
{
	ClocksTimerItemState old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_timer_item_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_STATE_PROPERTY]);
	}
}

static const gchar*
clocks_timer_item_real_get_name (ClocksContentItem* base)
{
	const gchar* result;
	ClocksTimerItem* self;
	const gchar* _tmp0_;
	self = (ClocksTimerItem*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
clocks_timer_item_real_set_name (ClocksContentItem* base,
                                 const gchar* value)
{
	ClocksTimerItem* self;
	gchar* old_value;
	self = (ClocksTimerItem*) base;
	old_value = clocks_timer_item_real_get_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_NAME_PROPERTY]);
	}
}

gint
clocks_timer_item_get_hours (ClocksTimerItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_hours;
	return result;
}

void
clocks_timer_item_set_hours (ClocksTimerItem* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_timer_item_get_hours (self);
	if (old_value != value) {
		self->priv->_hours = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_HOURS_PROPERTY]);
	}
}

gint
clocks_timer_item_get_minutes (ClocksTimerItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_minutes;
	return result;
}

void
clocks_timer_item_set_minutes (ClocksTimerItem* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_timer_item_get_minutes (self);
	if (old_value != value) {
		self->priv->_minutes = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_MINUTES_PROPERTY]);
	}
}

gint
clocks_timer_item_get_seconds (ClocksTimerItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_seconds;
	return result;
}

void
clocks_timer_item_set_seconds (ClocksTimerItem* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_timer_item_get_seconds (self);
	if (old_value != value) {
		self->priv->_seconds = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_SECONDS_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static gboolean
__lambda30_ (ClocksTimerItem* self)
{
	gdouble e = 0.0;
	GTimer* _tmp0_;
	ClocksTimerItemState _tmp1_;
	gdouble elapsed = 0.0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble r = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	_tmp0_ = self->priv->timer;
	e = g_timer_elapsed (_tmp0_, NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != CLOCKS_TIMER_ITEM_STATE_RUNNING) {
		result = FALSE;
		return result;
	}
	if (e >= self->priv->span) {
		g_signal_emit (self, clocks_timer_item_signals[CLOCKS_TIMER_ITEM_RESET_SIGNAL], 0);
		g_signal_emit (self, clocks_timer_item_signals[CLOCKS_TIMER_ITEM_RING_SIGNAL], 0);
		self->priv->timeout_id = (guint) 0;
		result = FALSE;
		return result;
	}
	elapsed = ceil (self->priv->span - e);
	clocks_utils_time_to_hms (elapsed, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	h = _tmp2_;
	m = _tmp3_;
	s = _tmp4_;
	r = _tmp5_;
	if (self->priv->stored_hour != h) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = self->priv->stored_minute != m;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = self->priv->stored_second != s;
	}
	if (_tmp6_) {
		self->priv->stored_hour = h;
		self->priv->stored_minute = m;
		self->priv->stored_second = s;
		g_signal_emit (self, clocks_timer_item_signals[CLOCKS_TIMER_ITEM_COUNTDOWN_UPDATED_SIGNAL], 0, h, m, s);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda30__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda30_ ((ClocksTimerItem*) self);
	return result;
}

static void
clocks_timer_item_real_start (ClocksTimerItem* self)
{
	GTimer* _tmp0_;
	clocks_timer_item_set_state (self, CLOCKS_TIMER_ITEM_STATE_RUNNING);
	self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda30__gsource_func, g_object_ref (self), g_object_unref);
	_tmp0_ = self->priv->timer;
	g_timer_start (_tmp0_);
}

static void
clocks_timer_item_real_pause (ClocksTimerItem* self)
{
	GTimer* _tmp0_;
	GTimer* _tmp1_;
	clocks_timer_item_set_state (self, CLOCKS_TIMER_ITEM_STATE_PAUSED);
	_tmp0_ = self->priv->timer;
	self->priv->span = self->priv->span - g_timer_elapsed (_tmp0_, NULL);
	_tmp1_ = self->priv->timer;
	g_timer_stop (_tmp1_);
}

static void
clocks_timer_item_real_reset (ClocksTimerItem* self)
{
	GTimer* _tmp0_;
	clocks_timer_item_set_state (self, CLOCKS_TIMER_ITEM_STATE_STOPPED);
	self->priv->span = (gdouble) clocks_timer_item_get_total_seconds (self);
	_tmp0_ = self->priv->timer;
	g_timer_reset (_tmp0_);
	self->priv->timeout_id = (guint) 0;
}

static void
clocks_timer_item_class_init (ClocksTimerItemClass * klass,
                              gpointer klass_data)
{
	clocks_timer_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksTimerItem_private_offset);
	((ClocksTimerItemClass *) klass)->start = clocks_timer_item_real_start;
	((ClocksTimerItemClass *) klass)->pause = clocks_timer_item_real_pause;
	((ClocksTimerItemClass *) klass)->reset = clocks_timer_item_real_reset;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_timer_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_timer_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_ITEM_STATE_PROPERTY, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CLOCKS_TIMER_ITEM_TYPE_STATE, CLOCKS_TIMER_ITEM_STATE_STOPPED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_ITEM_NAME_PROPERTY, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_ITEM_HOURS_PROPERTY, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_HOURS_PROPERTY] = g_param_spec_int ("hours", "hours", "hours", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_ITEM_MINUTES_PROPERTY, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_MINUTES_PROPERTY] = g_param_spec_int ("minutes", "minutes", "minutes", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_ITEM_SECONDS_PROPERTY, clocks_timer_item_properties[CLOCKS_TIMER_ITEM_SECONDS_PROPERTY] = g_param_spec_int ("seconds", "seconds", "seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	clocks_timer_item_signals[CLOCKS_TIMER_ITEM_RING_SIGNAL] = g_signal_new ("ring", CLOCKS_TIMER_TYPE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	clocks_timer_item_signals[CLOCKS_TIMER_ITEM_COUNTDOWN_UPDATED_SIGNAL] = g_signal_new ("countdown-updated", CLOCKS_TIMER_TYPE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	clocks_timer_item_signals[CLOCKS_TIMER_ITEM_START_SIGNAL] = g_signal_new ("start", CLOCKS_TIMER_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksTimerItemClass, start), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	clocks_timer_item_signals[CLOCKS_TIMER_ITEM_PAUSE_SIGNAL] = g_signal_new ("pause", CLOCKS_TIMER_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksTimerItemClass, pause), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	clocks_timer_item_signals[CLOCKS_TIMER_ITEM_RESET_SIGNAL] = g_signal_new ("reset", CLOCKS_TIMER_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksTimerItemClass, reset), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
clocks_timer_item_clocks_content_item_interface_init (ClocksContentItemIface * iface,
                                                      gpointer iface_data)
{
	clocks_timer_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (void (*) (ClocksContentItem*, GVariantBuilder*)) clocks_timer_item_real_serialize;
	iface->get_name = clocks_timer_item_real_get_name;
	iface->set_name = clocks_timer_item_real_set_name;
}

static void
clocks_timer_item_instance_init (ClocksTimerItem * self,
                                 gpointer klass)
{
	self->priv = clocks_timer_item_get_instance_private (self);
	self->priv->_state = CLOCKS_TIMER_ITEM_STATE_STOPPED;
	self->priv->_hours = 0;
	self->priv->_minutes = 0;
	self->priv->_seconds = 0;
}

static void
clocks_timer_item_finalize (GObject * obj)
{
	ClocksTimerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem);
	_g_free0 (self->priv->_name);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (clocks_timer_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_timer_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerItem), 0, (GInstanceInitFunc) clocks_timer_item_instance_init, NULL };
	static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_timer_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_timer_item_type_id;
	clocks_timer_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksTimerItem", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_timer_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
	ClocksTimerItem_private_offset = g_type_add_instance_private (clocks_timer_item_type_id, sizeof (ClocksTimerItemPrivate));
	return clocks_timer_item_type_id;
}

GType
clocks_timer_item_get_type (void)
{
	static volatile gsize clocks_timer_item_type_id__once = 0;
	if (g_once_init_enter (&clocks_timer_item_type_id__once)) {
		GType clocks_timer_item_type_id;
		clocks_timer_item_type_id = clocks_timer_item_get_type_once ();
		g_once_init_leave (&clocks_timer_item_type_id__once, clocks_timer_item_type_id);
	}
	return clocks_timer_item_type_id__once;
}

static void
_vala_clocks_timer_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksTimerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem);
	switch (property_id) {
		case CLOCKS_TIMER_ITEM_STATE_PROPERTY:
		g_value_set_enum (value, clocks_timer_item_get_state (self));
		break;
		case CLOCKS_TIMER_ITEM_NAME_PROPERTY:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_TIMER_ITEM_HOURS_PROPERTY:
		g_value_set_int (value, clocks_timer_item_get_hours (self));
		break;
		case CLOCKS_TIMER_ITEM_MINUTES_PROPERTY:
		g_value_set_int (value, clocks_timer_item_get_minutes (self));
		break;
		case CLOCKS_TIMER_ITEM_SECONDS_PROPERTY:
		g_value_set_int (value, clocks_timer_item_get_seconds (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_timer_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksTimerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem);
	switch (property_id) {
		case CLOCKS_TIMER_ITEM_STATE_PROPERTY:
		clocks_timer_item_set_state (self, g_value_get_enum (value));
		break;
		case CLOCKS_TIMER_ITEM_NAME_PROPERTY:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		case CLOCKS_TIMER_ITEM_HOURS_PROPERTY:
		clocks_timer_item_set_hours (self, g_value_get_int (value));
		break;
		case CLOCKS_TIMER_ITEM_MINUTES_PROPERTY:
		clocks_timer_item_set_minutes (self, g_value_get_int (value));
		break;
		case CLOCKS_TIMER_ITEM_SECONDS_PROPERTY:
		clocks_timer_item_set_seconds (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

