/* contacts-setup-window.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-setup-window.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "contacts.h"
#include <glib.h>
#include <config.h>
#include <folks/folks.h>
#include <folks/folks-eds.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_SETUP_WINDOW (contacts_setup_window_get_type ())
#define CONTACTS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow))
#define CONTACTS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))
#define CONTACTS_IS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_IS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_SETUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))

typedef struct _ContactsSetupWindow ContactsSetupWindow;
typedef struct _ContactsSetupWindowClass ContactsSetupWindowClass;
typedef struct _ContactsSetupWindowPrivate ContactsSetupWindowPrivate;

#define CONTACTS_TYPE_ACCOUNTS_LIST (contacts_accounts_list_get_type ())
#define CONTACTS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsList))
#define CONTACTS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))
#define CONTACTS_IS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_IS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_ACCOUNTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))

typedef struct _ContactsAccountsList ContactsAccountsList;
typedef struct _ContactsAccountsListClass ContactsAccountsListClass;
enum  {
	CONTACTS_SETUP_WINDOW_0_PROPERTY,
	CONTACTS_SETUP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* contacts_setup_window_properties[CONTACTS_SETUP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _Block38Data Block38Data;
typedef struct _ContactsAccountsListPrivate ContactsAccountsListPrivate;
enum  {
	CONTACTS_SETUP_WINDOW_SETUP_DONE_SIGNAL,
	CONTACTS_SETUP_WINDOW_NUM_SIGNALS
};
static guint contacts_setup_window_signals[CONTACTS_SETUP_WINDOW_NUM_SIGNALS] = {0};

struct _ContactsSetupWindow {
	AdwApplicationWindow parent_instance;
	ContactsSetupWindowPrivate * priv;
};

struct _ContactsSetupWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ContactsSetupWindowPrivate {
	AdwClamp* clamp;
	GtkButton* setup_done_button;
	ContactsAccountsList* setup_accounts_list;
};

struct _Block38Data {
	int _ref_count_;
	ContactsSetupWindow* self;
	gulong id2;
};

struct _ContactsAccountsList {
	AdwBin parent_instance;
	ContactsAccountsListPrivate * priv;
	FolksPersonaStore* selected_store;
};

struct _ContactsAccountsListClass {
	AdwBinClass parent_class;
};

static gint ContactsSetupWindow_private_offset;
static gpointer contacts_setup_window_parent_class = NULL;

VALA_EXTERN GType contacts_setup_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSetupWindow, g_object_unref)
VALA_EXTERN GType contacts_accounts_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAccountsList, g_object_unref)
VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_new (ContactsApp* app,
                                                ContactsStore* store);
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_construct (GType object_type,
                                                      ContactsApp* app,
                                                      ContactsStore* store);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
VALA_EXTERN ContactsAccountsList* contacts_accounts_list_new (ContactsStore* contacts_store);
VALA_EXTERN ContactsAccountsList* contacts_accounts_list_construct (GType object_type,
                                                        ContactsStore* contacts_store);
static void __lambda63_ (ContactsSetupWindow* self);
VALA_EXTERN void contacts_accounts_list_update_contents (ContactsAccountsList* self,
                                             gboolean select_active);
static void ___lambda63__folks_backend_store_backend_available (FolksBackendStore* _sender,
                                                         FolksBackend* backend,
                                                         gpointer self);
static void __lambda64_ (Block38Data* _data38_);
static void ___lambda64__contacts_accounts_list_account_selected (ContactsAccountsList* _sender,
                                                           gpointer self);
static void contacts_setup_window_fill_accounts_list (ContactsSetupWindow* self,
                                               ContactsStore* store);
static void __lambda66_ (ContactsSetupWindow* self);
static void ___lambda66__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda65_ (ContactsSetupWindow* self);
static void ___lambda65__contacts_store_prepared (ContactsStore* _sender,
                                           gpointer self);
static void contacts_setup_window_finalize (GObject * obj);
static GType contacts_setup_window_get_type_once (void);

static inline gpointer
contacts_setup_window_get_instance_private (ContactsSetupWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsSetupWindow_private_offset);
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		ContactsSetupWindow* self;
		self = _data38_->self;
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static void
__lambda63_ (ContactsSetupWindow* self)
{
	ContactsAccountsList* _tmp0_;
	_tmp0_ = self->priv->setup_accounts_list;
	contacts_accounts_list_update_contents (_tmp0_, FALSE);
}

static void
___lambda63__folks_backend_store_backend_available (FolksBackendStore* _sender,
                                                    FolksBackend* backend,
                                                    gpointer self)
{
	__lambda63_ ((ContactsSetupWindow*) self);
}

static void
__lambda64_ (Block38Data* _data38_)
{
	ContactsSetupWindow* self;
	GtkButton* _tmp0_;
	ContactsAccountsList* _tmp1_;
	self = _data38_->self;
	_tmp0_ = self->priv->setup_done_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->setup_accounts_list;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data38_->id2);
}

static void
___lambda64__contacts_accounts_list_account_selected (ContactsAccountsList* _sender,
                                                      gpointer self)
{
	__lambda64_ (self);
}

static void
__lambda66_ (ContactsSetupWindow* self)
{
	EdsfPersonaStore* selected_store = NULL;
	ContactsAccountsList* _tmp0_;
	FolksPersonaStore* _tmp1_;
	_tmp0_ = self->priv->setup_accounts_list;
	_tmp1_ = _tmp0_->selected_store;
	selected_store = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, EDSF_TYPE_PERSONA_STORE) ? ((EdsfPersonaStore*) _tmp1_) : NULL;
	g_signal_emit (self, contacts_setup_window_signals[CONTACTS_SETUP_WINDOW_SETUP_DONE_SIGNAL], 0, selected_store);
}

static void
___lambda66__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda66_ ((ContactsSetupWindow*) self);
}

ContactsSetupWindow*
contacts_setup_window_construct (GType object_type,
                                 ContactsApp* app,
                                 ContactsStore* store)
{
	ContactsSetupWindow * self = NULL;
	Block38Data* _data38_;
	ContactsAccountsList* _tmp0_;
	ContactsAccountsList* _tmp1_;
	AdwClamp* _tmp2_;
	ContactsAccountsList* _tmp3_;
	FolksBackendStore* _tmp4_;
	FolksBackendStore* _tmp5_;
	ContactsAccountsList* _tmp6_;
	gulong _tmp7_;
	GtkButton* _tmp8_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	self = (ContactsSetupWindow*) g_object_new (object_type, "application", app, "icon-name", APP_ID, NULL);
	_data38_->self = g_object_ref (self);
	_tmp0_ = contacts_accounts_list_new (store);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->setup_accounts_list);
	self->priv->setup_accounts_list = _tmp0_;
	_tmp1_ = self->priv->setup_accounts_list;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->clamp;
	_tmp3_ = self->priv->setup_accounts_list;
	adw_clamp_set_child (_tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = contacts_store_get_backend_store (store);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "backend-available", (GCallback) ___lambda63__folks_backend_store_backend_available, self, 0);
	_data38_->id2 = (gulong) 0;
	_tmp6_ = self->priv->setup_accounts_list;
	_tmp7_ = g_signal_connect_data (_tmp6_, "account-selected", (GCallback) ___lambda64__contacts_accounts_list_account_selected, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	_data38_->id2 = _tmp7_;
	contacts_setup_window_fill_accounts_list (self, store);
	_tmp8_ = self->priv->setup_done_button;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) ___lambda66__gtk_button_clicked, self, 0);
	if (g_strcmp0 (PROFILE, "development") == 0) {
		GtkStyleContext* _tmp9_;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp9_, "devel");
	}
	block38_data_unref (_data38_);
	_data38_ = NULL;
	return self;
}

ContactsSetupWindow*
contacts_setup_window_new (ContactsApp* app,
                           ContactsStore* store)
{
	return contacts_setup_window_construct (CONTACTS_TYPE_SETUP_WINDOW, app, store);
}

static void
__lambda65_ (ContactsSetupWindow* self)
{
	ContactsAccountsList* _tmp0_;
	_tmp0_ = self->priv->setup_accounts_list;
	contacts_accounts_list_update_contents (_tmp0_, FALSE);
}

static void
___lambda65__contacts_store_prepared (ContactsStore* _sender,
                                      gpointer self)
{
	__lambda65_ ((ContactsSetupWindow*) self);
}

static void
contacts_setup_window_fill_accounts_list (ContactsSetupWindow* self,
                                          ContactsStore* store)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = contacts_store_get_is_prepared (store);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ContactsAccountsList* _tmp2_;
		_tmp2_ = self->priv->setup_accounts_list;
		contacts_accounts_list_update_contents (_tmp2_, FALSE);
		return;
	}
	g_signal_connect_object (store, "prepared", (GCallback) ___lambda65__contacts_store_prepared, self, 0);
}

static void
contacts_setup_window_class_init (ContactsSetupWindowClass * klass,
                                  gpointer klass_data)
{
	contacts_setup_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsSetupWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contacts_setup_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-setup-window.ui");
	/**
	   * Fired after the user has successfully performed the setup proess.
	   */
	contacts_setup_window_signals[CONTACTS_SETUP_WINDOW_SETUP_DONE_SIGNAL] = g_signal_new ("setup-done", CONTACTS_TYPE_SETUP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EDSF_TYPE_PERSONA_STORE);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clamp", FALSE, ContactsSetupWindow_private_offset + G_STRUCT_OFFSET (ContactsSetupWindowPrivate, clamp));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_done_button", FALSE, ContactsSetupWindow_private_offset + G_STRUCT_OFFSET (ContactsSetupWindowPrivate, setup_done_button));
}

static void
contacts_setup_window_instance_init (ContactsSetupWindow * self,
                                     gpointer klass)
{
	self->priv = contacts_setup_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_setup_window_finalize (GObject * obj)
{
	ContactsSetupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow);
	_g_object_unref0 (self->priv->setup_accounts_list);
	G_OBJECT_CLASS (contacts_setup_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_setup_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsSetupWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_setup_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsSetupWindow), 0, (GInstanceInitFunc) contacts_setup_window_instance_init, NULL };
	GType contacts_setup_window_type_id;
	contacts_setup_window_type_id = g_type_register_static (adw_application_window_get_type (), "ContactsSetupWindow", &g_define_type_info, 0);
	ContactsSetupWindow_private_offset = g_type_add_instance_private (contacts_setup_window_type_id, sizeof (ContactsSetupWindowPrivate));
	return contacts_setup_window_type_id;
}

GType
contacts_setup_window_get_type (void)
{
	static volatile gsize contacts_setup_window_type_id__once = 0;
	if (g_once_init_enter (&contacts_setup_window_type_id__once)) {
		GType contacts_setup_window_type_id;
		contacts_setup_window_type_id = contacts_setup_window_get_type_once ();
		g_once_init_leave (&contacts_setup_window_type_id__once, contacts_setup_window_type_id);
	}
	return contacts_setup_window_type_id__once;
}

