/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 29 "../gobject-introspection/giscanner/scannerparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "sourcescanner.h"
#include "scannerparser.h"

#ifdef G_OS_WIN32
#include <io.h>
#endif

extern FILE *yyin;
extern int lineno;
extern char linebuf[2000];
extern char *yytext;

extern int yylex (GISourceScanner *scanner);
static void yyerror (GISourceScanner *scanner, const char *str);

extern void ctype_free (GISourceType * type);

static int last_enum_value = -1;
static gboolean is_bitfield;

/**
 * parse_c_string_literal:
 * @str: A string containing a C string literal
 *
 * Based on g_strcompress(), but also handles
 * hexadecimal escapes.
 */
static char *
parse_c_string_literal (const char *str)
{
  const gchar *p = str, *num;
  gchar *dest = g_malloc (strlen (str) + 1);
  gchar *q = dest;

  while (*p)
    {
      if (*p == '\\')
        {
          p++;
          switch (*p)
            {
            case '\0':
              g_warning ("parse_c_string_literal: trailing \\");
              goto out;
            case '0':  case '1':  case '2':  case '3':  case '4':
            case '5':  case '6':  case '7':
              *q = 0;
              num = p;
              while ((p < num + 3) && (*p >= '0') && (*p <= '7'))
                {
                  *q = (*q * 8) + (*p - '0');
                  p++;
                }
              q++;
              p--;
              break;
	    case 'x':
	      *q = 0;
	      p++;
	      num = p;
	      while ((p < num + 2) && (g_ascii_isxdigit(*p)))
		{
		  *q = (*q * 16) + g_ascii_xdigit_value(*p);
		  p++;
		}
              q++;
              p--;
	      break;
            case 'b':
              *q++ = '\b';
              break;
            case 'f':
              *q++ = '\f';
              break;
            case 'n':
              *q++ = '\n';
              break;
            case 'r':
              *q++ = '\r';
              break;
            case 't':
              *q++ = '\t';
              break;
            default:            /* Also handles \" and \\ */
              *q++ = *p;
              break;
            }
        }
      else
        *q++ = *p;
      p++;
    }
out:
  *q = 0;

  return dest;
}

enum {
  IRRELEVANT = 1,
  NOT_GI_SCANNER = 2,
  FOR_GI_SCANNER = 3,
};

static void
update_skipping (GISourceScanner *scanner)
{
  GList *l;
  for (l = scanner->conditionals.head; l != NULL; l = g_list_next (l))
    {
      if (GPOINTER_TO_INT (l->data) == NOT_GI_SCANNER)
        {
           scanner->skipping = TRUE;
           return;
        }
    }

  scanner->skipping = FALSE;
}

static void
push_conditional (GISourceScanner *scanner,
                  gint type)
{
  g_assert (type != 0);
  g_queue_push_head (&scanner->conditionals, GINT_TO_POINTER (type));
}

static gint
pop_conditional (GISourceScanner *scanner)
{
  gint type = GPOINTER_TO_INT (g_queue_pop_head (&scanner->conditionals));

  if (type == 0)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: mismatched %s", filename, lineno, yytext);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }

  return type;
}

static void
warn_if_cond_has_gi_scanner (GISourceScanner *scanner,
                             const gchar *text)
{
  /* Some other conditional that is not __GI_SCANNER__ */
  if (strstr (text, "__GI_SCANNER__"))
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: the __GI_SCANNER__ constant should only be used with simple #ifdef or #endif: %s",
               filename, lineno, text);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }
}

static void
toggle_conditional (GISourceScanner *scanner)
{
  switch (pop_conditional (scanner))
    {
    case FOR_GI_SCANNER:
      push_conditional (scanner, NOT_GI_SCANNER);
      break;
    case NOT_GI_SCANNER:
      push_conditional (scanner, FOR_GI_SCANNER);
      break;
    case 0:
      break;
    default:
      push_conditional (scanner, IRRELEVANT);
      break;
    }
}

static void
set_or_merge_base_type (GISourceType *type,
                        GISourceType *base)
{
  /* combine basic types like unsigned int and long long */
  if (base->type == CTYPE_BASIC_TYPE && type->type == CTYPE_BASIC_TYPE)
    {
      char *name = g_strdup_printf ("%s %s", type->name, base->name);
      g_free (type->name);
      type->name = name;

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else if (base->type == CTYPE_INVALID)
    {
      g_assert (base->base_type == NULL);

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else
    {
      g_assert (type->base_type == NULL);

      type->base_type = base;
    }
}


#line 295 "giscanner/scannerparser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "scannerparser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_BASIC_TYPE = 3,                 /* BASIC_TYPE  */
  YYSYMBOL_IDENTIFIER = 4,                 /* "identifier"  */
  YYSYMBOL_TYPEDEF_NAME = 5,               /* "typedef-name"  */
  YYSYMBOL_INTEGER = 6,                    /* INTEGER  */
  YYSYMBOL_FLOATING = 7,                   /* FLOATING  */
  YYSYMBOL_BOOLEAN = 8,                    /* BOOLEAN  */
  YYSYMBOL_CHARACTER = 9,                  /* CHARACTER  */
  YYSYMBOL_STRING = 10,                    /* STRING  */
  YYSYMBOL_INTL_CONST = 11,                /* INTL_CONST  */
  YYSYMBOL_INTUL_CONST = 12,               /* INTUL_CONST  */
  YYSYMBOL_ELLIPSIS = 13,                  /* ELLIPSIS  */
  YYSYMBOL_ADDEQ = 14,                     /* ADDEQ  */
  YYSYMBOL_SUBEQ = 15,                     /* SUBEQ  */
  YYSYMBOL_MULEQ = 16,                     /* MULEQ  */
  YYSYMBOL_DIVEQ = 17,                     /* DIVEQ  */
  YYSYMBOL_MODEQ = 18,                     /* MODEQ  */
  YYSYMBOL_XOREQ = 19,                     /* XOREQ  */
  YYSYMBOL_ANDEQ = 20,                     /* ANDEQ  */
  YYSYMBOL_OREQ = 21,                      /* OREQ  */
  YYSYMBOL_SL = 22,                        /* SL  */
  YYSYMBOL_SR = 23,                        /* SR  */
  YYSYMBOL_SLEQ = 24,                      /* SLEQ  */
  YYSYMBOL_SREQ = 25,                      /* SREQ  */
  YYSYMBOL_EQ = 26,                        /* EQ  */
  YYSYMBOL_NOTEQ = 27,                     /* NOTEQ  */
  YYSYMBOL_LTEQ = 28,                      /* LTEQ  */
  YYSYMBOL_GTEQ = 29,                      /* GTEQ  */
  YYSYMBOL_ANDAND = 30,                    /* ANDAND  */
  YYSYMBOL_OROR = 31,                      /* OROR  */
  YYSYMBOL_PLUSPLUS = 32,                  /* PLUSPLUS  */
  YYSYMBOL_MINUSMINUS = 33,                /* MINUSMINUS  */
  YYSYMBOL_ARROW = 34,                     /* ARROW  */
  YYSYMBOL_AUTO = 35,                      /* AUTO  */
  YYSYMBOL_BREAK = 36,                     /* BREAK  */
  YYSYMBOL_CASE = 37,                      /* CASE  */
  YYSYMBOL_CONST = 38,                     /* CONST  */
  YYSYMBOL_CONTINUE = 39,                  /* CONTINUE  */
  YYSYMBOL_DEFAULT = 40,                   /* DEFAULT  */
  YYSYMBOL_DO = 41,                        /* DO  */
  YYSYMBOL_ELSE = 42,                      /* ELSE  */
  YYSYMBOL_ENUM = 43,                      /* ENUM  */
  YYSYMBOL_EXTENSION = 44,                 /* EXTENSION  */
  YYSYMBOL_EXTERN = 45,                    /* EXTERN  */
  YYSYMBOL_FOR = 46,                       /* FOR  */
  YYSYMBOL_GOTO = 47,                      /* GOTO  */
  YYSYMBOL_IF = 48,                        /* IF  */
  YYSYMBOL_INLINE = 49,                    /* INLINE  */
  YYSYMBOL_REGISTER = 50,                  /* REGISTER  */
  YYSYMBOL_RESTRICT = 51,                  /* RESTRICT  */
  YYSYMBOL_RETURN = 52,                    /* RETURN  */
  YYSYMBOL_SHORT = 53,                     /* SHORT  */
  YYSYMBOL_SIGNED = 54,                    /* SIGNED  */
  YYSYMBOL_SIZEOF = 55,                    /* SIZEOF  */
  YYSYMBOL_STATIC = 56,                    /* STATIC  */
  YYSYMBOL_STRUCT = 57,                    /* STRUCT  */
  YYSYMBOL_SWITCH = 58,                    /* SWITCH  */
  YYSYMBOL_THREAD_LOCAL = 59,              /* THREAD_LOCAL  */
  YYSYMBOL_TYPEDEF = 60,                   /* TYPEDEF  */
  YYSYMBOL_UNION = 61,                     /* UNION  */
  YYSYMBOL_UNSIGNED = 62,                  /* UNSIGNED  */
  YYSYMBOL_VOID = 63,                      /* VOID  */
  YYSYMBOL_VOLATILE = 64,                  /* VOLATILE  */
  YYSYMBOL_WHILE = 65,                     /* WHILE  */
  YYSYMBOL_FUNCTION_MACRO = 66,            /* FUNCTION_MACRO  */
  YYSYMBOL_OBJECT_MACRO = 67,              /* OBJECT_MACRO  */
  YYSYMBOL_IFDEF_GI_SCANNER = 68,          /* IFDEF_GI_SCANNER  */
  YYSYMBOL_IFNDEF_GI_SCANNER = 69,         /* IFNDEF_GI_SCANNER  */
  YYSYMBOL_IFDEF_COND = 70,                /* IFDEF_COND  */
  YYSYMBOL_IFNDEF_COND = 71,               /* IFNDEF_COND  */
  YYSYMBOL_IF_COND = 72,                   /* IF_COND  */
  YYSYMBOL_ELIF_COND = 73,                 /* ELIF_COND  */
  YYSYMBOL_ELSE_COND = 74,                 /* ELSE_COND  */
  YYSYMBOL_ENDIF_COND = 75,                /* ENDIF_COND  */
  YYSYMBOL_76_ = 76,                       /* '('  */
  YYSYMBOL_77_ = 77,                       /* ')'  */
  YYSYMBOL_78_ = 78,                       /* '{'  */
  YYSYMBOL_79_ = 79,                       /* '}'  */
  YYSYMBOL_80_ = 80,                       /* '['  */
  YYSYMBOL_81_ = 81,                       /* ']'  */
  YYSYMBOL_82_ = 82,                       /* '.'  */
  YYSYMBOL_83_ = 83,                       /* ','  */
  YYSYMBOL_84_ = 84,                       /* '&'  */
  YYSYMBOL_85_ = 85,                       /* '*'  */
  YYSYMBOL_86_ = 86,                       /* '+'  */
  YYSYMBOL_87_ = 87,                       /* '-'  */
  YYSYMBOL_88_ = 88,                       /* '~'  */
  YYSYMBOL_89_ = 89,                       /* '!'  */
  YYSYMBOL_90_ = 90,                       /* '/'  */
  YYSYMBOL_91_ = 91,                       /* '%'  */
  YYSYMBOL_92_ = 92,                       /* '<'  */
  YYSYMBOL_93_ = 93,                       /* '>'  */
  YYSYMBOL_94_ = 94,                       /* '^'  */
  YYSYMBOL_95_ = 95,                       /* '|'  */
  YYSYMBOL_96_ = 96,                       /* '?'  */
  YYSYMBOL_97_ = 97,                       /* ':'  */
  YYSYMBOL_98_ = 98,                       /* '='  */
  YYSYMBOL_99_ = 99,                       /* ';'  */
  YYSYMBOL_YYACCEPT = 100,                 /* $accept  */
  YYSYMBOL_primary_expression = 101,       /* primary_expression  */
  YYSYMBOL_strings = 102,                  /* strings  */
  YYSYMBOL_identifier = 103,               /* identifier  */
  YYSYMBOL_identifier_or_typedef_name = 104, /* identifier_or_typedef_name  */
  YYSYMBOL_postfix_expression = 105,       /* postfix_expression  */
  YYSYMBOL_argument_expression_list = 106, /* argument_expression_list  */
  YYSYMBOL_unary_expression = 107,         /* unary_expression  */
  YYSYMBOL_unary_operator = 108,           /* unary_operator  */
  YYSYMBOL_cast_expression = 109,          /* cast_expression  */
  YYSYMBOL_multiplicative_expression = 110, /* multiplicative_expression  */
  YYSYMBOL_additive_expression = 111,      /* additive_expression  */
  YYSYMBOL_shift_expression = 112,         /* shift_expression  */
  YYSYMBOL_relational_expression = 113,    /* relational_expression  */
  YYSYMBOL_equality_expression = 114,      /* equality_expression  */
  YYSYMBOL_and_expression = 115,           /* and_expression  */
  YYSYMBOL_exclusive_or_expression = 116,  /* exclusive_or_expression  */
  YYSYMBOL_inclusive_or_expression = 117,  /* inclusive_or_expression  */
  YYSYMBOL_logical_and_expression = 118,   /* logical_and_expression  */
  YYSYMBOL_logical_or_expression = 119,    /* logical_or_expression  */
  YYSYMBOL_conditional_expression = 120,   /* conditional_expression  */
  YYSYMBOL_assignment_expression = 121,    /* assignment_expression  */
  YYSYMBOL_assignment_operator = 122,      /* assignment_operator  */
  YYSYMBOL_expression = 123,               /* expression  */
  YYSYMBOL_constant_expression = 124,      /* constant_expression  */
  YYSYMBOL_declaration = 125,              /* declaration  */
  YYSYMBOL_empty_declaration = 126,        /* empty_declaration  */
  YYSYMBOL_declaration_specifiers = 127,   /* declaration_specifiers  */
  YYSYMBOL_init_declarator_list = 128,     /* init_declarator_list  */
  YYSYMBOL_init_declarator = 129,          /* init_declarator  */
  YYSYMBOL_storage_class_specifier = 130,  /* storage_class_specifier  */
  YYSYMBOL_basic_type = 131,               /* basic_type  */
  YYSYMBOL_type_specifier = 132,           /* type_specifier  */
  YYSYMBOL_struct_or_union_specifier = 133, /* struct_or_union_specifier  */
  YYSYMBOL_struct_or_union = 134,          /* struct_or_union  */
  YYSYMBOL_struct_declaration_list = 135,  /* struct_declaration_list  */
  YYSYMBOL_struct_declaration = 136,       /* struct_declaration  */
  YYSYMBOL_specifier_qualifier_list = 137, /* specifier_qualifier_list  */
  YYSYMBOL_struct_declarator_list = 138,   /* struct_declarator_list  */
  YYSYMBOL_struct_declarator = 139,        /* struct_declarator  */
  YYSYMBOL_enum_specifier = 140,           /* enum_specifier  */
  YYSYMBOL_enum_keyword = 141,             /* enum_keyword  */
  YYSYMBOL_static_keyword = 142,           /* static_keyword  */
  YYSYMBOL_enumerator_list = 143,          /* enumerator_list  */
  YYSYMBOL_144_1 = 144,                    /* $@1  */
  YYSYMBOL_enumerator = 145,               /* enumerator  */
  YYSYMBOL_type_qualifier = 146,           /* type_qualifier  */
  YYSYMBOL_function_specifier = 147,       /* function_specifier  */
  YYSYMBOL_declarator = 148,               /* declarator  */
  YYSYMBOL_direct_declarator = 149,        /* direct_declarator  */
  YYSYMBOL_pointer = 150,                  /* pointer  */
  YYSYMBOL_type_qualifier_list = 151,      /* type_qualifier_list  */
  YYSYMBOL_parameter_list = 152,           /* parameter_list  */
  YYSYMBOL_parameter_declaration = 153,    /* parameter_declaration  */
  YYSYMBOL_identifier_list = 154,          /* identifier_list  */
  YYSYMBOL_type_name = 155,                /* type_name  */
  YYSYMBOL_abstract_declarator = 156,      /* abstract_declarator  */
  YYSYMBOL_direct_abstract_declarator = 157, /* direct_abstract_declarator  */
  YYSYMBOL_typedef_name = 158,             /* typedef_name  */
  YYSYMBOL_initializer = 159,              /* initializer  */
  YYSYMBOL_initializer_list = 160,         /* initializer_list  */
  YYSYMBOL_statement = 161,                /* statement  */
  YYSYMBOL_labeled_statement = 162,        /* labeled_statement  */
  YYSYMBOL_compound_statement = 163,       /* compound_statement  */
  YYSYMBOL_block_item_list = 164,          /* block_item_list  */
  YYSYMBOL_block_item = 165,               /* block_item  */
  YYSYMBOL_expression_statement = 166,     /* expression_statement  */
  YYSYMBOL_selection_statement = 167,      /* selection_statement  */
  YYSYMBOL_iteration_statement = 168,      /* iteration_statement  */
  YYSYMBOL_jump_statement = 169,           /* jump_statement  */
  YYSYMBOL_translation_unit = 170,         /* translation_unit  */
  YYSYMBOL_external_declaration = 171,     /* external_declaration  */
  YYSYMBOL_function_definition = 172,      /* function_definition  */
  YYSYMBOL_declaration_list = 173,         /* declaration_list  */
  YYSYMBOL_function_macro = 174,           /* function_macro  */
  YYSYMBOL_object_macro = 175,             /* object_macro  */
  YYSYMBOL_function_macro_define = 176,    /* function_macro_define  */
  YYSYMBOL_object_macro_define = 177,      /* object_macro_define  */
  YYSYMBOL_preproc_conditional = 178,      /* preproc_conditional  */
  YYSYMBOL_macro = 179                     /* macro  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  74
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2406

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  100
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  80
/* YYNRULES -- Number of rules.  */
#define YYNRULES  256
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  428

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   330


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    89,     2,     2,     2,    91,    84,     2,
      76,    77,    85,    86,    83,    87,    82,    90,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    97,    99,
      92,    98,    93,    96,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    80,     2,    81,    94,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    78,    95,    79,    88,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   348,   348,   357,   373,   379,   385,   392,   393,   397,
     405,   420,   434,   441,   442,   446,   447,   451,   455,   459,
     463,   467,   471,   478,   479,   483,   484,   488,   492,   515,
     522,   529,   533,   541,   545,   549,   553,   557,   561,   568,
     569,   581,   582,   588,   596,   607,   608,   614,   623,   624,
     636,   645,   646,   652,   658,   664,   673,   674,   680,   689,
     690,   699,   700,   709,   710,   719,   720,   731,   732,   743,
     744,   751,   752,   759,   760,   761,   762,   763,   764,   765,
     766,   767,   768,   769,   773,   774,   775,   782,   788,   806,
     813,   816,   821,   826,   831,   832,   837,   842,   847,   855,
     859,   866,   867,   871,   875,   879,   883,   887,   891,   898,
     905,   909,   913,   917,   922,   923,   924,   932,   952,   957,
     965,   970,   978,   979,   986,  1006,  1011,  1012,  1017,  1025,
    1029,  1037,  1040,  1041,  1045,  1056,  1063,  1070,  1077,  1084,
    1091,  1099,  1106,  1106,  1115,  1123,  1131,  1143,  1147,  1151,
    1155,  1162,  1169,  1174,  1178,  1183,  1187,  1192,  1197,  1202,
    1212,  1219,  1228,  1233,  1237,  1248,  1261,  1262,  1269,  1273,
    1280,  1285,  1290,  1295,  1302,  1308,  1317,  1318,  1322,  1327,
    1328,  1336,  1340,  1345,  1350,  1355,  1360,  1366,  1376,  1382,
    1395,  1402,  1403,  1404,  1408,  1409,  1415,  1416,  1417,  1418,
    1419,  1420,  1424,  1425,  1426,  1430,  1431,  1435,  1436,  1440,
    1441,  1445,  1446,  1450,  1451,  1452,  1456,  1457,  1458,  1459,
    1460,  1461,  1462,  1463,  1464,  1465,  1469,  1470,  1471,  1472,
    1473,  1479,  1480,  1484,  1485,  1486,  1487,  1491,  1492,  1496,
    1497,  1503,  1510,  1517,  1530,  1547,  1552,  1557,  1562,  1567,
    1572,  1579,  1584,  1592,  1593,  1594,  1595
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "BASIC_TYPE",
  "\"identifier\"", "\"typedef-name\"", "INTEGER", "FLOATING", "BOOLEAN",
  "CHARACTER", "STRING", "INTL_CONST", "INTUL_CONST", "ELLIPSIS", "ADDEQ",
  "SUBEQ", "MULEQ", "DIVEQ", "MODEQ", "XOREQ", "ANDEQ", "OREQ", "SL", "SR",
  "SLEQ", "SREQ", "EQ", "NOTEQ", "LTEQ", "GTEQ", "ANDAND", "OROR",
  "PLUSPLUS", "MINUSMINUS", "ARROW", "AUTO", "BREAK", "CASE", "CONST",
  "CONTINUE", "DEFAULT", "DO", "ELSE", "ENUM", "EXTENSION", "EXTERN",
  "FOR", "GOTO", "IF", "INLINE", "REGISTER", "RESTRICT", "RETURN", "SHORT",
  "SIGNED", "SIZEOF", "STATIC", "STRUCT", "SWITCH", "THREAD_LOCAL",
  "TYPEDEF", "UNION", "UNSIGNED", "VOID", "VOLATILE", "WHILE",
  "FUNCTION_MACRO", "OBJECT_MACRO", "IFDEF_GI_SCANNER",
  "IFNDEF_GI_SCANNER", "IFDEF_COND", "IFNDEF_COND", "IF_COND", "ELIF_COND",
  "ELSE_COND", "ENDIF_COND", "'('", "')'", "'{'", "'}'", "'['", "']'",
  "'.'", "','", "'&'", "'*'", "'+'", "'-'", "'~'", "'!'", "'/'", "'%'",
  "'<'", "'>'", "'^'", "'|'", "'?'", "':'", "'='", "';'", "$accept",
  "primary_expression", "strings", "identifier",
  "identifier_or_typedef_name", "postfix_expression",
  "argument_expression_list", "unary_expression", "unary_operator",
  "cast_expression", "multiplicative_expression", "additive_expression",
  "shift_expression", "relational_expression", "equality_expression",
  "and_expression", "exclusive_or_expression", "inclusive_or_expression",
  "logical_and_expression", "logical_or_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration", "empty_declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "storage_class_specifier", "basic_type", "type_specifier",
  "struct_or_union_specifier", "struct_or_union",
  "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enum_keyword", "static_keyword",
  "enumerator_list", "$@1", "enumerator", "type_qualifier",
  "function_specifier", "declarator", "direct_declarator", "pointer",
  "type_qualifier_list", "parameter_list", "parameter_declaration",
  "identifier_list", "type_name", "abstract_declarator",
  "direct_abstract_declarator", "typedef_name", "initializer",
  "initializer_list", "statement", "labeled_statement",
  "compound_statement", "block_item_list", "block_item",
  "expression_statement", "selection_statement", "iteration_statement",
  "jump_statement", "translation_unit", "external_declaration",
  "function_definition", "declaration_list", "function_macro",
  "object_macro", "function_macro_define", "object_macro_define",
  "preproc_conditional", "macro", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-249)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-15)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     536,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  -249,    23,  2342,  -249,  2342,  -249,    74,
    -249,    77,  2342,  2342,  -249,   443,  -249,  -249,   -46,  1794,
    -249,  -249,  -249,  -249,  -249,    47,   122,  -249,  -249,   -58,
    -249,  1043,   140,    20,  -249,  -249,  2215,  -249,     5,  -249,
    -249,    57,  -249,  -249,  -249,  -249,    76,  -249,  -249,  -249,
    -249,  -249,   -16,    25,  1833,  1833,    64,  1883,  1381,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,   157,  -249,   146,  -249,
    1794,  -249,   104,    56,   249,   109,   250,    61,    68,    75,
     147,    -3,  -249,  -249,   131,  -249,  -249,   122,    47,  -249,
     609,  1500,  -249,    23,  -249,  2125,  2187,  1442,   140,  2215,
     411,  -249,    18,  2215,  2215,   152,    76,  -249,  -249,   -43,
    1833,  1833,  1922,  -249,  -249,   106,  1381,  -249,  1941,   529,
    -249,  -249,   -25,   -23,   134,  -249,  -249,  -249,   275,  1539,
    1922,   275,  -249,  1794,  1794,  1794,  1794,  1794,  1794,  1794,
    1794,  1794,  1794,  1794,  1794,  1794,  1794,  1794,  1794,  1794,
    1794,  1922,  -249,  -249,  -249,  -249,   101,    97,  1794,   125,
     137,   986,   160,   275,   187,  1104,   213,   222,  -249,  -249,
     203,   205,   -51,  -249,   210,  -249,  -249,  -249,   706,  -249,
    -249,  -249,  -249,  -249,  1500,  -249,  -249,  -249,  -249,  -249,
    -249,    31,   115,  -249,   126,  -249,  -249,   227,  1794,  -249,
    -249,  -249,  1794,   -45,  -249,   214,  -249,  2088,  -249,    39,
     215,  -249,   177,  -249,    76,   237,   238,  1941,   900,   239,
    1319,   235,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  1794,  -249,  1794,  2061,  1589,   143,  -249,
     193,  1794,  -249,  -249,   135,  -249,   -18,  -249,  -249,  -249,
    -249,   104,   104,    56,    56,   249,   249,   249,   249,   109,
     109,   250,    61,    68,    75,   147,    66,  -249,   224,  -249,
     986,   254,  1120,   228,  1922,  -249,    65,  1922,  1922,   986,
    -249,  -249,  -249,  -249,   191,  1999,  -249,    45,  -249,  -249,
    2311,  -249,  -249,   242,  -249,    18,  -249,  1794,  -249,  -249,
    -249,  1794,  -249,    52,  -249,  -249,  -249,   803,  -249,  -249,
    -249,  -249,   138,   251,  -249,   245,   193,  2249,  1628,  -249,
    -249,  1794,  -249,  1922,   986,  -249,   255,  1206,    98,  -249,
     161,  -249,   166,   168,  -249,  -249,  1481,  -249,  -249,  -249,
    -249,  -249,  -249,   253,  -249,  -249,  -249,  -249,   169,  -249,
     252,  -249,   235,  -249,  1922,  1647,   105,  1222,   986,   986,
     986,  -249,  -249,  -249,  -249,  -249,   170,   986,   171,  1686,
    1736,   107,   290,  -249,  -249,   236,  -249,   986,   986,   181,
     986,   182,  1775,   986,  -249,  -249,  -249,   986,  -249,   986,
     986,   184,  -249,  -249,  -249,  -249,   986,  -249
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,   256,   109,   190,   106,   147,   140,   149,   104,   151,
     107,   148,   111,   105,   120,   108,   103,   121,   112,   110,
     150,   241,   242,   245,   246,   247,   248,   249,   250,   251,
     252,    90,   234,   235,     0,    92,   113,    94,   114,     0,
     115,     0,    96,    98,   116,     0,   231,   233,     0,     0,
     253,   254,   255,   236,    12,     0,   163,    89,   154,     0,
      99,   101,   153,     0,    91,    93,     0,    13,   119,    14,
     142,   139,    95,    97,     1,   232,     0,     3,     6,     4,
       5,    10,     0,     0,     0,     0,     0,     0,     0,    33,
      34,    35,    36,    37,    38,    15,     7,     2,    25,    39,
       0,    41,    45,    48,    51,    56,    59,    61,    63,    65,
      67,    69,    87,   244,     0,   166,   165,   162,     0,    88,
       0,     0,   239,     0,   238,     0,     0,     0,   152,   126,
       0,   122,   131,   128,     0,     0,     0,   142,   174,     0,
       0,     0,     0,    26,    27,     0,     0,    31,   149,    39,
      71,    84,     0,   176,     0,    11,    21,    22,     0,     0,
       0,     0,    28,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,   167,   164,   100,   101,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,   211,
       2,     0,     0,   209,   116,   210,   196,   197,     0,   207,
     198,   199,   200,   201,     0,   191,   102,   240,   237,   173,
     161,   172,     0,   168,     0,   141,   158,     0,     0,   125,
     118,   123,     0,     0,   129,   132,   127,     0,   136,     0,
     145,   143,     0,   243,     0,     0,     0,     0,     0,     0,
       0,    86,    77,    78,    74,    75,    76,    82,    81,    83,
      79,    80,    73,     0,     8,     0,     0,     0,   178,   177,
     179,     0,    20,    18,     0,    23,     0,    19,    42,    43,
      44,    46,    47,    49,    50,    54,    55,    52,    53,    57,
      58,    60,    62,    64,    66,    68,     0,   228,     0,   227,
       0,     0,     0,     0,     0,   229,     0,     0,     0,     0,
     212,   206,   208,   194,     0,     0,   170,   178,   171,   159,
       0,   160,   157,     0,   133,   131,   124,     0,   117,   138,
     144,     0,   135,     0,   175,    29,    30,     0,    32,    72,
      85,   186,     0,     0,   182,     0,   180,     0,     0,    40,
      17,     0,    16,     0,     0,   204,     0,     0,     0,   226,
       0,   230,     0,     0,   202,   192,     0,   169,   156,   130,
     134,   146,   137,     0,   187,   181,   183,   188,     0,   184,
       0,    24,    70,   203,     0,     0,     0,     0,     0,     0,
       0,   193,   195,     9,   189,   185,     0,     0,     0,     0,
       0,     0,   213,   215,   216,     0,   218,     0,     0,     0,
       0,     0,     0,     0,   217,   222,   220,     0,   219,     0,
       0,     0,   214,   224,   223,   221,     0,   225
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -249,  -249,  -249,   -34,   -22,  -249,  -249,   257,  -249,   -89,
     118,   119,   123,   130,   158,   159,   162,   164,   165,  -249,
     -41,  -109,  -249,   -75,  -162,    16,  -249,     2,  -249,   220,
    -249,  -249,     0,  -249,  -249,   217,  -120,   -74,  -249,    14,
    -249,  -249,  -249,   211,  -249,   216,   -20,  -249,   -28,   -62,
     -53,  -249,  -122,    27,   232,   207,  -130,  -248,    -8,  -205,
    -249,    50,  -249,    26,   112,  -193,  -249,  -249,  -249,  -249,
    -249,   316,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    95,    96,    97,   201,    98,   274,   149,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     150,   151,   263,   202,   113,   203,    33,   123,    59,    60,
      35,    36,    37,    38,    39,   130,   131,   132,   233,   234,
      40,    41,   228,   135,   136,   330,    42,    43,   114,    62,
      63,   117,   342,   223,   139,   154,   343,   270,    44,   216,
     314,   205,   206,   207,   208,   209,   210,   211,   212,   213,
      45,    46,    47,   125,    48,    49,    50,    51,    52,    53
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      58,   128,    34,   116,   222,    67,    61,    67,   112,   313,
     231,   162,   215,   152,   153,   312,    32,    68,   227,    71,
     346,    58,    54,   269,    54,   118,   298,    54,   180,    58,
      76,    69,   265,    69,   243,    54,   115,    64,   325,    65,
     244,   119,   138,    54,    72,    73,   133,    34,   310,    54,
     275,    54,   264,   266,   326,   229,    54,   267,   265,   236,
     140,    32,    56,   352,   184,   265,   129,   152,   133,   346,
     324,   152,   153,   251,   278,   279,   280,   122,    54,     3,
      54,    54,     3,   134,    58,   276,   200,   124,   129,    58,
     186,   318,   138,   181,    55,   186,    55,   183,    58,    55,
     268,   141,   240,    56,   235,   215,   296,   315,    56,   133,
     133,   267,   204,   133,   133,   232,    56,   231,   329,   323,
     306,   315,    57,    55,    67,   267,   133,    67,   221,   129,
     129,   372,    56,   129,   129,   137,   272,   170,   171,   277,
     145,   217,   166,   167,   312,   176,   129,   112,   265,   265,
      69,   218,    66,    69,   339,    70,   340,   200,   345,    67,
       5,   392,   177,   353,   361,   370,     7,   155,   317,   371,
     178,   303,   251,    11,   200,   152,   153,   179,   156,   157,
     158,   265,   349,    69,   248,    69,    20,    58,   265,   163,
     265,   112,   319,   316,   164,   165,   297,   387,   320,   121,
     204,   172,   173,   321,   399,   240,   412,    56,   182,   244,
     334,   271,   350,   268,   200,   374,   126,   133,   351,   266,
     127,   320,   159,   267,   299,   378,   160,   358,   161,   360,
     133,   238,   362,   363,   300,   239,   302,   129,   388,   380,
     204,   301,   381,   389,   265,   390,   394,   405,   407,   265,
     129,   265,   320,   265,   265,   128,   332,   215,   417,   419,
     333,   426,   317,   304,   265,   265,   200,   265,   221,   347,
     365,   168,   169,   348,   366,   200,   174,   175,   382,    54,
       3,    58,   386,    58,   281,   282,   112,   283,   284,   307,
     112,    58,    69,   285,   286,   287,   288,   235,   308,   240,
     -13,    69,   309,   200,   289,   290,    99,   -14,   322,   396,
     398,   327,   401,   331,   335,   336,   338,   221,   265,   356,
     200,   354,   221,   368,   409,   411,   376,   359,   375,   204,
     393,   384,   413,   395,   291,   414,   292,   421,   185,   369,
     293,   143,   144,   294,   147,   295,    69,   367,   242,   221,
     355,   237,   241,   249,   200,   200,   200,    99,   224,   364,
     337,    75,     0,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,   200,     0,   200,     0,     0,   200,
      69,    69,    69,   200,     0,   200,   200,     0,     0,    69,
       0,     0,   200,     0,     0,     0,     0,   245,   246,    69,
      69,     0,    69,     0,   383,    69,     0,     0,     0,    69,
       0,    69,    69,     0,     2,     0,     3,     0,    69,     0,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
      99,    99,    99,    99,    99,    99,    99,    99,   402,   403,
     404,     0,     0,    74,     1,    99,     2,   406,     3,     5,
       0,     0,     0,     0,     6,     7,     0,   415,   416,     0,
     418,     0,    11,   422,     0,    12,     0,   423,    14,   424,
     425,     0,    17,    18,    19,    20,   427,     0,     4,     0,
       0,     5,     0,     0,     0,     0,     6,     7,     8,    99,
     230,     0,     9,    10,    11,     0,     0,    12,     0,    13,
      14,     0,    15,    16,    17,    18,    19,    20,     0,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    99,     0,
       0,     0,     0,     0,     0,     0,     0,     1,     0,     2,
       0,     3,    31,   252,   253,   254,   255,   256,   257,   258,
     259,     0,     0,   260,   261,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     5,     0,     0,     0,     0,     6,
       7,     8,     0,     0,    99,     9,    10,    11,    99,     0,
      12,     0,    13,    14,     0,    15,    16,    17,    18,    19,
      20,     0,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,     2,    54,     3,    77,    78,    79,    80,    81,
      82,    83,     0,     0,     0,     0,     0,   262,     0,     0,
       0,     0,     0,     0,     0,    31,     0,     0,     0,     0,
       0,    84,    85,     0,     4,   187,   188,     5,   189,   190,
     191,     0,     6,   148,     8,   192,   193,   194,     9,    10,
      11,   195,     0,    12,    87,    13,    14,   196,    15,    16,
      17,    18,    19,    20,   197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    88,     0,   120,   198,     0,
       0,     0,     0,    89,    90,    91,    92,    93,    94,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     2,
      54,     3,    77,    78,    79,    80,    81,    82,    83,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    84,    85,
       0,     4,   187,   188,     5,   189,   190,   191,     0,     6,
     148,     8,   192,   193,   194,     9,    10,    11,   195,     0,
      12,    87,    13,    14,   196,    15,    16,    17,    18,    19,
      20,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,   120,   311,     0,     0,     0,     0,
      89,    90,    91,    92,    93,    94,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   199,     2,    54,     3,    77,
      78,    79,    80,    81,    82,    83,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    84,    85,     0,     4,   187,
     188,     5,   189,   190,   191,     0,     6,   148,     8,   192,
     193,   194,     9,    10,    11,   195,     0,    12,    87,    13,
      14,   196,    15,    16,    17,    18,    19,    20,   197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    88,
       0,   120,   373,     0,     0,     0,     0,    89,    90,    91,
      92,    93,    94,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   199,     2,    54,     3,    77,    78,    79,    80,
      81,    82,    83,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    84,    85,     0,     4,   187,   188,     5,   189,
     190,   191,     0,     6,   148,     8,   192,   193,   194,     9,
      10,    11,   195,     0,    12,    87,    13,    14,   196,    15,
      16,    17,    18,    19,    20,   197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    88,     0,   120,     0,
       0,     0,     0,     0,    89,    90,    91,    92,    93,    94,
      54,     3,    77,    78,    79,    80,    81,    82,    83,   199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    84,    85,
       0,     0,   187,   188,     0,   189,   190,   191,     0,     0,
     247,     0,   192,   193,   194,     0,     0,     0,   195,     0,
       0,    87,     0,     0,   196,     0,     2,     0,     3,     0,
       0,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,   120,     0,     0,     0,     0,     0,
      89,    90,    91,    92,    93,    94,     0,     0,     4,     0,
       0,     5,     0,     0,     0,   199,     6,     7,     8,     0,
       0,     0,     9,    10,    11,     0,     0,    12,     0,    13,
      14,     0,    15,    16,    17,    18,    19,    20,    54,     0,
      77,    78,    79,    80,    81,    82,    83,     0,     0,     0,
       0,   120,     0,     0,    54,     0,    77,    78,    79,    80,
      81,    82,    83,     0,     0,     0,    84,    85,     0,     0,
       0,   121,     0,     0,     0,     0,     0,     0,   247,     0,
       0,     0,    84,    85,     0,     0,     0,     0,     0,    87,
       0,     0,     0,     0,   247,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    87,     0,     0,     0,     0,
      88,     0,     0,     0,     0,     0,     0,     0,    89,    90,
      91,    92,    93,    94,     0,     0,    88,     0,     0,     0,
       0,     0,     0,   305,    89,    90,    91,    92,    93,    94,
      54,     0,    77,    78,    79,    80,    81,    82,    83,   357,
       0,     0,     0,     0,     0,     0,    54,     0,    77,    78,
      79,    80,    81,    82,    83,     0,     0,     0,    84,    85,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     247,     0,     0,     0,    84,    85,     0,     0,     0,     0,
       0,    87,     0,     0,     0,     0,   247,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    87,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
      89,    90,    91,    92,    93,    94,     0,     0,    88,     0,
       0,     0,     0,     0,     0,   385,    89,    90,    91,    92,
      93,    94,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   400,     2,    54,     3,    77,    78,    79,    80,    81,
      82,    83,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    84,    85,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     6,   148,     0,     0,     0,     0,     0,     0,
      11,     0,     0,    12,    87,     0,    14,     0,     0,     0,
      17,    18,    19,    20,     2,    54,     3,    77,    78,    79,
      80,    81,    82,    83,     0,    88,     0,   248,     0,     0,
       0,     0,     0,    89,    90,    91,    92,    93,    94,     0,
       0,     0,     0,    84,    85,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     6,   148,     0,     0,     0,     0,
       0,     0,    11,     0,     0,    12,    87,     0,    14,     0,
       0,     0,    17,    18,    19,    20,    54,     0,    77,    78,
      79,    80,    81,    82,    83,     0,     0,    88,     0,     0,
       0,     0,     0,     0,     0,    89,    90,    91,    92,    93,
      94,     0,     0,     0,    84,    85,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,    86,    77,    78,    79,
      80,    81,    82,    83,     0,     0,     0,    87,   225,     0,
       0,     0,     0,     0,    54,     0,    77,    78,    79,    80,
      81,    82,    83,    84,    85,     0,     0,     0,    88,     0,
       0,     0,     0,   226,     0,    86,    89,    90,    91,    92,
      93,    94,    84,    85,     0,     0,    87,     0,     0,     0,
       0,     0,     0,    54,    86,    77,    78,    79,    80,    81,
      82,    83,     0,     0,     0,    87,     0,    88,     0,   214,
     391,     0,     0,     0,     0,    89,    90,    91,    92,    93,
      94,    84,    85,     0,     0,     0,    88,     0,   214,     0,
       0,     0,     0,    86,    89,    90,    91,    92,    93,    94,
       0,     0,     0,    54,    87,    77,    78,    79,    80,    81,
      82,    83,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    88,   273,     0,     0,     0,
       0,    84,    85,    89,    90,    91,    92,    93,    94,     0,
       0,     0,    54,    86,    77,    78,    79,    80,    81,    82,
      83,     0,     0,     0,    87,     0,     0,     0,     0,     0,
       0,    54,     0,    77,    78,    79,    80,    81,    82,    83,
      84,    85,     0,     0,     0,    88,     0,     0,     0,     0,
     344,     0,    86,    89,    90,    91,    92,    93,    94,    84,
      85,     0,     0,    87,     0,     0,     0,     0,     0,     0,
      54,   247,    77,    78,    79,    80,    81,    82,    83,     0,
       0,     0,    87,     0,    88,     0,     0,     0,     0,   379,
       0,     0,    89,    90,    91,    92,    93,    94,    84,    85,
       0,     0,     0,    88,   397,     0,     0,     0,     0,     0,
     247,    89,    90,    91,    92,    93,    94,     0,     0,     0,
      54,    87,    77,    78,    79,    80,    81,    82,    83,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,   408,     0,     0,     0,     0,    84,    85,
      89,    90,    91,    92,    93,    94,     0,     0,     0,    54,
     247,    77,    78,    79,    80,    81,    82,    83,     0,     0,
       0,    87,     0,     0,     0,     0,     0,     0,    54,     0,
      77,    78,    79,    80,    81,    82,    83,    84,    85,     0,
       0,     0,    88,   410,     0,     0,     0,     0,     0,   247,
      89,    90,    91,    92,    93,    94,    84,    85,     0,     0,
      87,     0,     0,     0,     0,     0,     0,    54,    86,    77,
      78,    79,    80,    81,    82,    83,     0,     0,     0,    87,
       0,    88,   420,     0,     0,     0,     0,     0,     0,    89,
      90,    91,    92,    93,    94,    84,    85,     0,     0,     0,
      88,     0,     0,     0,     0,     0,     0,    86,    89,    90,
      91,    92,    93,    94,     0,     0,     0,    54,    87,    77,
      78,    79,    80,    81,    82,    83,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,     0,    84,    85,    89,    90,    91,
      92,    93,    94,     0,     0,     0,    54,    86,    77,    78,
      79,    80,    81,    82,    83,     0,     0,     0,    87,     0,
       0,     0,     0,     0,     0,    54,     0,    77,    78,    79,
      80,    81,    82,    83,    84,    85,     0,     0,     0,   146,
       0,     0,     0,     0,     0,     0,   247,    89,    90,    91,
      92,    93,    94,    84,    85,     0,     0,    87,     0,     0,
       0,     0,     0,     0,     0,   247,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    87,     0,    88,     0,
       0,     0,     2,    54,     3,     0,    89,    90,    91,    92,
      93,    94,   219,     0,     0,     0,     0,   250,     0,     0,
       0,     0,     0,     0,     0,    89,    90,    91,    92,    93,
      94,     0,     0,     0,     4,     0,     0,     5,     0,     0,
       0,     0,     6,     7,     8,     0,     0,     0,     9,    10,
      11,     0,     0,    12,     0,    13,    14,     0,    15,    16,
      17,    18,    19,    20,     2,     0,     3,     0,     0,     0,
       0,     0,     0,     0,   219,   315,   341,     0,     0,   267,
       0,     0,     0,     0,    56,     0,     0,     0,     0,     0,
       0,     2,     0,     3,     0,     0,     4,     0,     0,     5,
       0,     0,     0,     0,     6,     7,     8,     0,     0,     0,
       9,    10,    11,     0,     0,    12,     0,    13,    14,     0,
      15,    16,    17,    18,    19,    20,     5,     0,     2,     0,
       3,     6,     7,     0,     0,     0,     0,   266,   341,    11,
       0,   267,    12,     0,     0,    14,    56,     0,     0,    17,
      18,    19,    20,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     5,     0,     0,     0,   328,     6,     7,
       8,     0,     0,     0,     9,    10,    11,     0,     0,    12,
       0,    13,    14,     0,    15,    16,    17,    18,    19,    20,
       2,    54,     3,     0,     0,     0,     0,     0,     0,     0,
     219,     0,     0,   120,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     2,     0,
       3,     0,     4,     0,     0,     5,     0,     0,     0,     0,
       6,     7,     8,     0,     0,     0,     9,    10,    11,     0,
       0,    12,     0,    13,    14,     0,    15,    16,    17,    18,
      19,    20,     2,     5,     3,     0,     0,     0,     6,     7,
       0,     0,   219,     0,   220,     0,    11,     0,     0,    12,
       0,     0,    14,     0,     0,     0,    17,    18,    19,    20,
       0,     0,     0,     0,     4,     0,     0,     5,     0,     0,
       0,     0,     6,     7,     8,     0,     0,     0,     9,    10,
      11,     0,     0,    12,     0,    13,    14,     0,    15,    16,
      17,    18,    19,    20,     2,     0,     3,     0,     0,     0,
       0,     0,     0,     0,   219,     0,   377,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     2,     4,     3,     0,     5,
       0,     0,     0,     0,     6,     7,     8,     0,     0,     0,
       9,    10,    11,     0,     0,    12,     0,    13,    14,     0,
      15,    16,    17,    18,    19,    20,     0,     4,     0,     0,
       5,     0,     0,     0,     0,     6,     7,     8,     0,     0,
       0,     9,    10,    11,     0,     0,    12,     0,    13,    14,
       0,    15,    16,    17,    18,    19,    20
};

static const yytype_int16 yycheck[] =
{
      34,    63,     0,    56,   126,    39,    34,    41,    49,   214,
     130,   100,   121,    88,    88,   208,     0,    39,   127,    41,
     268,    55,     4,   153,     4,    83,   188,     4,    31,    63,
      76,    39,    83,    41,    77,     4,    56,    35,    83,    37,
      83,    99,    76,     4,    42,    43,    66,    45,    99,     4,
     159,     4,    77,    76,    99,   129,     4,    80,    83,   133,
      76,    45,    85,    81,   117,    83,    66,   142,    88,   317,
     232,   146,   146,   148,   163,   164,   165,    61,     4,     5,
       4,     4,     5,    78,   118,   160,   120,    61,    88,   123,
     118,   221,   126,    96,    76,   123,    76,   117,   132,    76,
     153,    76,   136,    85,   132,   214,   181,    76,    85,   129,
     130,    80,   120,   133,   134,    97,    85,   237,    79,   228,
     195,    76,    99,    76,   158,    80,   146,   161,   126,   129,
     130,    79,    85,   133,   134,    78,   158,    28,    29,   161,
      76,   125,    86,    87,   337,    84,   146,   188,    83,    83,
     158,   125,    78,   161,   263,    78,   265,   191,   267,   193,
      38,   366,    94,    97,    99,   327,    44,    10,   221,   331,
      95,   193,   247,    51,   208,   250,   250,    30,    32,    33,
      34,    83,   271,   191,    78,   193,    64,   221,    83,    85,
      83,   232,    77,   221,    90,    91,    99,    99,    83,    98,
     208,    92,    93,    77,    99,   239,    99,    85,    77,    83,
     244,    77,    77,   266,   248,    77,    76,   237,    83,    76,
      80,    83,    76,    80,    99,   347,    80,   302,    82,   304,
     250,    79,   307,   308,    97,    83,    76,   237,    77,   348,
     248,   191,   351,    77,    83,    77,    77,    77,    77,    83,
     250,    83,    83,    83,    83,   317,    79,   366,    77,    77,
      83,    77,   315,    76,    83,    83,   300,    83,   266,    76,
      79,    22,    23,    80,    83,   309,    26,    27,   353,     4,
       5,   315,   357,   317,   166,   167,   327,   168,   169,    76,
     331,   325,   300,   170,   171,   172,   173,   325,    76,   333,
      97,   309,    97,   337,   174,   175,    49,    97,    81,   384,
     385,    97,   387,    98,    77,    77,    77,   315,    83,    65,
     354,    97,   320,    81,   399,   400,    81,    99,    77,   337,
      77,    76,    42,    81,   176,    99,   177,   412,   118,   325,
     178,    84,    85,   179,    87,   180,   354,   320,   137,   347,
     300,   134,   136,   146,   388,   389,   390,   100,   126,   309,
     248,    45,    -1,   397,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   407,   408,    -1,   410,    -1,    -1,   413,
     388,   389,   390,   417,    -1,   419,   420,    -1,    -1,   397,
      -1,    -1,   426,    -1,    -1,    -1,    -1,   140,   141,   407,
     408,    -1,   410,    -1,   354,   413,    -1,    -1,    -1,   417,
      -1,   419,   420,    -1,     3,    -1,     5,    -1,   426,    -1,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   388,   389,
     390,    -1,    -1,     0,     1,   188,     3,   397,     5,    38,
      -1,    -1,    -1,    -1,    43,    44,    -1,   407,   408,    -1,
     410,    -1,    51,   413,    -1,    54,    -1,   417,    57,   419,
     420,    -1,    61,    62,    63,    64,   426,    -1,    35,    -1,
      -1,    38,    -1,    -1,    -1,    -1,    43,    44,    45,   232,
      79,    -1,    49,    50,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   271,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,     3,
      -1,     5,    99,    14,    15,    16,    17,    18,    19,    20,
      21,    -1,    -1,    24,    25,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    38,    -1,    -1,    -1,    -1,    43,
      44,    45,    -1,    -1,   327,    49,    50,    51,   331,    -1,
      54,    -1,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,
      -1,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    -1,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    -1,    78,    79,    -1,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    -1,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    -1,    78,    79,    -1,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    -1,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      -1,    78,    79,    -1,    -1,    -1,    -1,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    -1,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    78,    -1,
      -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,    89,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,    33,
      -1,    -1,    36,    37,    -1,    39,    40,    41,    -1,    -1,
      44,    -1,    46,    47,    48,    -1,    -1,    -1,    52,    -1,
      -1,    55,    -1,    -1,    58,    -1,     3,    -1,     5,    -1,
      -1,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    -1,    -1,    35,    -1,
      -1,    38,    -1,    -1,    -1,    99,    43,    44,    45,    -1,
      -1,    -1,    49,    50,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    78,    -1,    -1,     4,    -1,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    32,    33,    -1,    -1,
      -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    -1,    32,    33,    -1,    -1,    -1,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    -1,    -1,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    84,    85,    86,    87,    88,    89,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    99,
      -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    32,    33,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,
      -1,    55,    -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    55,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    84,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    32,    33,    -1,    -1,    -1,    -1,    38,    -1,    -1,
      -1,    -1,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,
      61,    62,    63,    64,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    76,    -1,    78,    -1,    -1,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,    38,
      -1,    -1,    -1,    -1,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    61,    62,    63,    64,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    44,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    -1,     4,    -1,     6,     7,     8,     9,
      10,    11,    12,    32,    33,    -1,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    81,    -1,    44,    84,    85,    86,    87,
      88,    89,    32,    33,    -1,    -1,    55,    -1,    -1,    -1,
      -1,    -1,    -1,     4,    44,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    55,    -1,    76,    -1,    78,
      79,    -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    32,    33,    -1,    -1,    -1,    76,    -1,    78,    -1,
      -1,    -1,    -1,    44,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,     4,    55,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    32,    33,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,     4,    44,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,     4,    -1,     6,     7,     8,     9,    10,    11,    12,
      32,    33,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      81,    -1,    44,    84,    85,    86,    87,    88,    89,    32,
      33,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    44,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    55,    -1,    76,    -1,    -1,    -1,    -1,    81,
      -1,    -1,    84,    85,    86,    87,    88,    89,    32,    33,
      -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      44,    84,    85,    86,    87,    88,    89,    -1,    -1,    -1,
       4,    55,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    32,    33,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,     4,
      44,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,    32,    33,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    44,
      84,    85,    86,    87,    88,    89,    32,    33,    -1,    -1,
      55,    -1,    -1,    -1,    -1,    -1,    -1,     4,    44,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    55,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    32,    33,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    44,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,     4,    55,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    -1,    32,    33,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,     4,    44,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    55,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    -1,     6,     7,     8,
       9,    10,    11,    12,    32,    33,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    84,    85,    86,
      87,    88,    89,    32,    33,    -1,    -1,    55,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    55,    -1,    76,    -1,
      -1,    -1,     3,     4,     5,    -1,    84,    85,    86,    87,
      88,    89,    13,    -1,    -1,    -1,    -1,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    35,    -1,    -1,    38,    -1,    -1,
      -1,    -1,    43,    44,    45,    -1,    -1,    -1,    49,    50,
      51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,     3,    -1,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    76,    77,    -1,    -1,    80,
      -1,    -1,    -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,
      -1,     3,    -1,     5,    -1,    -1,    35,    -1,    -1,    38,
      -1,    -1,    -1,    -1,    43,    44,    45,    -1,    -1,    -1,
      49,    50,    51,    -1,    -1,    54,    -1,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    38,    -1,     3,    -1,
       5,    43,    44,    -1,    -1,    -1,    -1,    76,    77,    51,
      -1,    80,    54,    -1,    -1,    57,    85,    -1,    -1,    61,
      62,    63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    38,    -1,    -1,    -1,    79,    43,    44,
      45,    -1,    -1,    -1,    49,    50,    51,    -1,    -1,    54,
      -1,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
       3,     4,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,
       5,    -1,    35,    -1,    -1,    38,    -1,    -1,    -1,    -1,
      43,    44,    45,    -1,    -1,    -1,    49,    50,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,     3,    38,     5,    -1,    -1,    -1,    43,    44,
      -1,    -1,    13,    -1,    77,    -1,    51,    -1,    -1,    54,
      -1,    -1,    57,    -1,    -1,    -1,    61,    62,    63,    64,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    38,    -1,    -1,
      -1,    -1,    43,    44,    45,    -1,    -1,    -1,    49,    50,
      51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,     3,    -1,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    35,     5,    -1,    38,
      -1,    -1,    -1,    -1,    43,    44,    45,    -1,    -1,    -1,
      49,    50,    51,    -1,    -1,    54,    -1,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    -1,    35,    -1,    -1,
      38,    -1,    -1,    -1,    -1,    43,    44,    45,    -1,    -1,
      -1,    49,    50,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    60,    61,    62,    63,    64
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,    35,    38,    43,    44,    45,    49,
      50,    51,    54,    56,    57,    59,    60,    61,    62,    63,
      64,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    99,   125,   126,   127,   130,   131,   132,   133,   134,
     140,   141,   146,   147,   158,   170,   171,   172,   174,   175,
     176,   177,   178,   179,     4,    76,    85,    99,   103,   128,
     129,   148,   149,   150,   127,   127,    78,   103,   104,   158,
      78,   104,   127,   127,     0,   171,    76,     6,     7,     8,
       9,    10,    11,    12,    32,    33,    44,    55,    76,    84,
      85,    86,    87,    88,    89,   101,   102,   103,   105,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   124,   148,   146,   150,   151,    83,    99,
      78,    98,   125,   127,   163,   173,    76,    80,   149,   132,
     135,   136,   137,   146,    78,   143,   144,    78,   103,   154,
      76,    76,    76,   107,   107,    76,    76,   107,    44,   107,
     120,   121,   123,   137,   155,    10,    32,    33,    34,    76,
      80,    82,   109,    85,    90,    91,    86,    87,    22,    23,
      28,    29,    92,    93,    26,    27,    84,    94,    95,    30,
      31,    96,    77,   146,   150,   129,   148,    36,    37,    39,
      40,    41,    46,    47,    48,    52,    58,    65,    79,    99,
     103,   104,   123,   125,   158,   161,   162,   163,   164,   165,
     166,   167,   168,   169,    78,   121,   159,   125,   163,    13,
      77,   127,   152,   153,   154,    56,    81,   121,   142,   137,
      79,   136,    97,   138,   139,   148,   137,   135,    79,    83,
     103,   145,   143,    77,    83,   107,   107,    44,    78,   155,
      76,   123,    14,    15,    16,    17,    18,    19,    20,    21,
      24,    25,    98,   122,    77,    83,    76,    80,   150,   156,
     157,    77,   104,    77,   106,   121,   123,   104,   109,   109,
     109,   110,   110,   111,   111,   112,   112,   112,   112,   113,
     113,   114,   115,   116,   117,   118,   123,    99,   124,    99,
      97,   161,    76,   104,    76,    99,   123,    76,    76,    97,
      99,    79,   165,   159,   160,    76,   148,   150,   156,    77,
      83,    77,    81,   121,   124,    83,    99,    97,    79,    79,
     145,    98,    79,    83,   103,    77,    77,   164,    77,   121,
     121,    77,   152,   156,    81,   121,   157,    76,    80,   109,
      77,    83,    81,    97,    97,   161,    65,    99,   123,    99,
     123,    99,   123,   123,   161,    79,    83,   153,    81,   139,
     124,   124,    79,    79,    77,    77,    81,    77,   152,    81,
     121,   121,   123,   161,    76,    99,   123,    99,    77,    77,
      77,    79,   159,    77,    77,    81,   123,    77,   123,    99,
      99,   123,   161,   161,   161,    77,   161,    77,    77,   123,
      77,   123,    99,    42,    99,   161,   161,    77,   161,    77,
      77,   123,   161,   161,   161,   161,    77,   161
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   100,   101,   101,   101,   101,   101,   101,   101,   101,
     102,   102,   103,   104,   104,   105,   105,   105,   105,   105,
     105,   105,   105,   106,   106,   107,   107,   107,   107,   107,
     107,   107,   107,   108,   108,   108,   108,   108,   108,   109,
     109,   110,   110,   110,   110,   111,   111,   111,   112,   112,
     112,   113,   113,   113,   113,   113,   114,   114,   114,   115,
     115,   116,   116,   117,   117,   118,   118,   119,   119,   120,
     120,   121,   121,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   123,   123,   123,   124,   125,   125,
     126,   127,   127,   127,   127,   127,   127,   127,   127,   128,
     128,   129,   129,   130,   130,   130,   130,   130,   130,   131,
     132,   132,   132,   132,   132,   132,   132,   133,   133,   133,
     134,   134,   135,   135,   136,   137,   137,   137,   137,   138,
     138,   139,   139,   139,   139,   140,   140,   140,   140,   140,
     141,   142,   144,   143,   143,   145,   145,   146,   146,   146,
     146,   147,   148,   148,   149,   149,   149,   149,   149,   149,
     149,   149,   150,   150,   150,   150,   151,   151,   152,   152,
     153,   153,   153,   153,   154,   154,   155,   155,   156,   156,
     156,   157,   157,   157,   157,   157,   157,   157,   157,   157,
     158,   159,   159,   159,   160,   160,   161,   161,   161,   161,
     161,   161,   162,   162,   162,   163,   163,   164,   164,   165,
     165,   166,   166,   167,   167,   167,   168,   168,   168,   168,
     168,   168,   168,   168,   168,   168,   169,   169,   169,   169,
     169,   170,   170,   171,   171,   171,   171,   172,   172,   173,
     173,   174,   175,   176,   177,   178,   178,   178,   178,   178,
     178,   178,   178,   179,   179,   179,   179
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     2,     1,     1,     1,     1,     4,     4,     3,     3,
       3,     2,     2,     1,     3,     1,     2,     2,     2,     4,
       4,     2,     4,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     3,     3,     3,     1,     3,     3,     1,     3,
       3,     1,     3,     3,     3,     3,     1,     3,     3,     1,
       3,     1,     3,     1,     3,     1,     3,     1,     3,     1,
       5,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     3,     2,
       1,     2,     1,     2,     1,     2,     1,     2,     1,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     5,     4,     2,
       1,     1,     1,     2,     3,     2,     1,     2,     1,     1,
       3,     0,     1,     2,     3,     5,     4,     6,     5,     2,
       1,     1,     0,     2,     3,     1,     3,     1,     1,     1,
       1,     1,     2,     1,     1,     3,     5,     4,     3,     4,
       4,     3,     2,     1,     3,     2,     1,     2,     1,     3,
       2,     2,     1,     1,     1,     3,     1,     2,     1,     1,
       2,     3,     2,     3,     3,     4,     2,     3,     3,     4,
       1,     1,     3,     4,     1,     3,     1,     1,     1,     1,
       1,     1,     3,     4,     3,     2,     3,     1,     2,     1,
       1,     1,     2,     5,     7,     5,     5,     7,     6,     7,
       7,     8,     7,     8,     8,     9,     3,     2,     2,     2,
       3,     1,     2,     1,     1,     1,     1,     4,     3,     1,
       2,     1,     1,     4,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, GISourceScanner* scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, GISourceScanner* scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (GISourceScanner* scanner)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* primary_expression: identifier  */
#line 349 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = g_hash_table_lookup (scanner->const_table, (yyvsp[0].str));
		if ((yyval.symbol) == NULL) {
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		} else {
			(yyval.symbol) = gi_source_symbol_ref ((yyval.symbol));
		}
	  }
#line 2469 "giscanner/scannerparser.c"
    break;

  case 3: /* primary_expression: INTEGER  */
#line 358 "../gobject-introspection/giscanner/scannerparser.y"
          {
		char *rest;
		guint64 value;
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if (g_str_has_prefix (yytext, "0x") && strlen (yytext) > 2) {
			value = g_ascii_strtoull (yytext + 2, &rest, 16);
		} else if (g_str_has_prefix (yytext, "0") && strlen (yytext) > 1) {
			value = g_ascii_strtoull (yytext + 1, &rest, 8);
		} else {
			value = g_ascii_strtoull (yytext, &rest, 10);
		}
		(yyval.symbol)->const_int = value;
		(yyval.symbol)->const_int_is_unsigned = (rest && (rest[0] == 'U'));
	  }
#line 2489 "giscanner/scannerparser.c"
    break;

  case 4: /* primary_expression: BOOLEAN  */
#line 374 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_boolean_set = TRUE;
		(yyval.symbol)->const_boolean = g_ascii_strcasecmp (yytext, "true") == 0 ? TRUE : FALSE;
	  }
#line 2499 "giscanner/scannerparser.c"
    break;

  case 5: /* primary_expression: CHARACTER  */
#line 380 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = g_utf8_get_char(yytext + 1);
	  }
#line 2509 "giscanner/scannerparser.c"
    break;

  case 6: /* primary_expression: FLOATING  */
#line 386 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_double_set = TRUE;
		(yyval.symbol)->const_double = 0.0;
        sscanf (yytext, "%lf", &((yyval.symbol)->const_double));
	  }
#line 2520 "giscanner/scannerparser.c"
    break;

  case 8: /* primary_expression: '(' expression ')'  */
#line 394 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 2528 "giscanner/scannerparser.c"
    break;

  case 9: /* primary_expression: EXTENSION '(' '{' block_item_list '}' ')'  */
#line 398 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2536 "giscanner/scannerparser.c"
    break;

  case 10: /* strings: STRING  */
#line 406 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		yytext[strlen (yytext) - 1] = '\0';
		(yyval.symbol)->const_string = parse_c_string_literal (yytext + 1);
                if (!g_utf8_validate ((yyval.symbol)->const_string, -1, NULL))
                  {
#if 0
                    g_warning ("Ignoring non-UTF-8 constant string \"%s\"", yytext + 1);
#endif
                    g_free((yyval.symbol)->const_string);
                    (yyval.symbol)->const_string = NULL;
                  }

	  }
#line 2555 "giscanner/scannerparser.c"
    break;

  case 11: /* strings: strings STRING  */
#line 421 "../gobject-introspection/giscanner/scannerparser.y"
          {
		char *strings, *string2;
		(yyval.symbol) = (yyvsp[-1].symbol);
		yytext[strlen (yytext) - 1] = '\0';
		string2 = parse_c_string_literal (yytext + 1);
		strings = g_strconcat ((yyval.symbol)->const_string, string2, NULL);
		g_free ((yyval.symbol)->const_string);
		g_free (string2);
		(yyval.symbol)->const_string = strings;
	  }
#line 2570 "giscanner/scannerparser.c"
    break;

  case 12: /* identifier: "identifier"  */
#line 435 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 2578 "giscanner/scannerparser.c"
    break;

  case 16: /* postfix_expression: postfix_expression '[' expression ']'  */
#line 448 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2586 "giscanner/scannerparser.c"
    break;

  case 17: /* postfix_expression: postfix_expression '(' argument_expression_list ')'  */
#line 452 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2594 "giscanner/scannerparser.c"
    break;

  case 18: /* postfix_expression: postfix_expression '(' ')'  */
#line 456 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2602 "giscanner/scannerparser.c"
    break;

  case 19: /* postfix_expression: postfix_expression '.' identifier_or_typedef_name  */
#line 460 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2610 "giscanner/scannerparser.c"
    break;

  case 20: /* postfix_expression: postfix_expression ARROW identifier_or_typedef_name  */
#line 464 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2618 "giscanner/scannerparser.c"
    break;

  case 21: /* postfix_expression: postfix_expression PLUSPLUS  */
#line 468 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2626 "giscanner/scannerparser.c"
    break;

  case 22: /* postfix_expression: postfix_expression MINUSMINUS  */
#line 472 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2634 "giscanner/scannerparser.c"
    break;

  case 26: /* unary_expression: PLUSPLUS unary_expression  */
#line 485 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2642 "giscanner/scannerparser.c"
    break;

  case 27: /* unary_expression: MINUSMINUS unary_expression  */
#line 489 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2650 "giscanner/scannerparser.c"
    break;

  case 28: /* unary_expression: unary_operator cast_expression  */
#line 493 "../gobject-introspection/giscanner/scannerparser.y"
          {
		switch ((yyvsp[-1].unary_operator)) {
		case UNARY_PLUS:
			(yyval.symbol) = (yyvsp[0].symbol);
			break;
		case UNARY_MINUS:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = -(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_BITWISE_COMPLEMENT:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = ~(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_LOGICAL_NEGATION:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = !gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
			break;
		default:
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
			break;
		}
	  }
#line 2677 "giscanner/scannerparser.c"
    break;

  case 29: /* unary_expression: INTL_CONST '(' unary_expression ')'  */
#line 516 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ((yyval.symbol)->const_int_is_unsigned ? "guint64" : "gint64");
		}
	  }
#line 2688 "giscanner/scannerparser.c"
    break;

  case 30: /* unary_expression: INTUL_CONST '(' unary_expression ')'  */
#line 523 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ("guint64");
		}
	  }
#line 2699 "giscanner/scannerparser.c"
    break;

  case 31: /* unary_expression: SIZEOF unary_expression  */
#line 530 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2707 "giscanner/scannerparser.c"
    break;

  case 32: /* unary_expression: SIZEOF '(' type_name ')'  */
#line 534 "../gobject-introspection/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2716 "giscanner/scannerparser.c"
    break;

  case 33: /* unary_operator: '&'  */
#line 542 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_ADDRESS_OF;
	  }
#line 2724 "giscanner/scannerparser.c"
    break;

  case 34: /* unary_operator: '*'  */
#line 546 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_POINTER_INDIRECTION;
	  }
#line 2732 "giscanner/scannerparser.c"
    break;

  case 35: /* unary_operator: '+'  */
#line 550 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_PLUS;
	  }
#line 2740 "giscanner/scannerparser.c"
    break;

  case 36: /* unary_operator: '-'  */
#line 554 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_MINUS;
	  }
#line 2748 "giscanner/scannerparser.c"
    break;

  case 37: /* unary_operator: '~'  */
#line 558 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_BITWISE_COMPLEMENT;
	  }
#line 2756 "giscanner/scannerparser.c"
    break;

  case 38: /* unary_operator: '!'  */
#line 562 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_LOGICAL_NEGATION;
	  }
#line 2764 "giscanner/scannerparser.c"
    break;

  case 40: /* cast_expression: '(' type_name ')' cast_expression  */
#line 570 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		if ((yyval.symbol)->const_int_set || (yyval.symbol)->const_double_set || (yyval.symbol)->const_string != NULL) {
			(yyval.symbol)->base_type = (yyvsp[-2].ctype);
		} else {
			ctype_free ((yyvsp[-2].ctype));
		}
	  }
#line 2777 "giscanner/scannerparser.c"
    break;

  case 42: /* multiplicative_expression: multiplicative_expression '*' cast_expression  */
#line 583 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int * (yyvsp[0].symbol)->const_int;
	  }
#line 2787 "giscanner/scannerparser.c"
    break;

  case 43: /* multiplicative_expression: multiplicative_expression '/' cast_expression  */
#line 589 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int / (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2799 "giscanner/scannerparser.c"
    break;

  case 44: /* multiplicative_expression: multiplicative_expression '%' cast_expression  */
#line 597 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int % (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2811 "giscanner/scannerparser.c"
    break;

  case 46: /* additive_expression: additive_expression '+' multiplicative_expression  */
#line 609 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int + (yyvsp[0].symbol)->const_int;
	  }
#line 2821 "giscanner/scannerparser.c"
    break;

  case 47: /* additive_expression: additive_expression '-' multiplicative_expression  */
#line 615 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int - (yyvsp[0].symbol)->const_int;
	  }
#line 2831 "giscanner/scannerparser.c"
    break;

  case 49: /* shift_expression: shift_expression SL additive_expression  */
#line 625 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int << (yyvsp[0].symbol)->const_int;

		/* assume this is a bitfield/flags declaration
		 * if a left shift operator is sued in an enum value
                 * This mimics the glib-mkenum behavior.
		 */
		is_bitfield = TRUE;
	  }
#line 2847 "giscanner/scannerparser.c"
    break;

  case 50: /* shift_expression: shift_expression SR additive_expression  */
#line 637 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >> (yyvsp[0].symbol)->const_int;
	  }
#line 2857 "giscanner/scannerparser.c"
    break;

  case 52: /* relational_expression: relational_expression '<' shift_expression  */
#line 647 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int < (yyvsp[0].symbol)->const_int;
	  }
#line 2867 "giscanner/scannerparser.c"
    break;

  case 53: /* relational_expression: relational_expression '>' shift_expression  */
#line 653 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int > (yyvsp[0].symbol)->const_int;
	  }
#line 2877 "giscanner/scannerparser.c"
    break;

  case 54: /* relational_expression: relational_expression LTEQ shift_expression  */
#line 659 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int <= (yyvsp[0].symbol)->const_int;
	  }
#line 2887 "giscanner/scannerparser.c"
    break;

  case 55: /* relational_expression: relational_expression GTEQ shift_expression  */
#line 665 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >= (yyvsp[0].symbol)->const_int;
	  }
#line 2897 "giscanner/scannerparser.c"
    break;

  case 57: /* equality_expression: equality_expression EQ relational_expression  */
#line 675 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int == (yyvsp[0].symbol)->const_int;
	  }
#line 2907 "giscanner/scannerparser.c"
    break;

  case 58: /* equality_expression: equality_expression NOTEQ relational_expression  */
#line 681 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int != (yyvsp[0].symbol)->const_int;
	  }
#line 2917 "giscanner/scannerparser.c"
    break;

  case 60: /* and_expression: and_expression '&' equality_expression  */
#line 691 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int & (yyvsp[0].symbol)->const_int;
	  }
#line 2927 "giscanner/scannerparser.c"
    break;

  case 62: /* exclusive_or_expression: exclusive_or_expression '^' and_expression  */
#line 701 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int ^ (yyvsp[0].symbol)->const_int;
	  }
#line 2937 "giscanner/scannerparser.c"
    break;

  case 64: /* inclusive_or_expression: inclusive_or_expression '|' exclusive_or_expression  */
#line 711 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int | (yyvsp[0].symbol)->const_int;
	  }
#line 2947 "giscanner/scannerparser.c"
    break;

  case 66: /* logical_and_expression: logical_and_expression ANDAND inclusive_or_expression  */
#line 721 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) &&
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 2959 "giscanner/scannerparser.c"
    break;

  case 68: /* logical_or_expression: logical_or_expression OROR logical_and_expression  */
#line 733 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) ||
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 2971 "giscanner/scannerparser.c"
    break;

  case 70: /* conditional_expression: logical_or_expression '?' expression ':' expression  */
#line 745 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_get_const_boolean ((yyvsp[-4].symbol)) ? (yyvsp[-2].symbol) : (yyvsp[0].symbol);
	  }
#line 2979 "giscanner/scannerparser.c"
    break;

  case 72: /* assignment_expression: unary_expression assignment_operator assignment_expression  */
#line 753 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2987 "giscanner/scannerparser.c"
    break;

  case 86: /* expression: EXTENSION expression  */
#line 776 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2995 "giscanner/scannerparser.c"
    break;

  case 88: /* declaration: declaration_specifiers init_declarator_list ';'  */
#line 789 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GList *l;
		for (l = (yyvsp[-1].list); l != NULL; l = l->next) {
			GISourceSymbol *sym = l->data;
			gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
			if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF) {
				sym->type = CSYMBOL_TYPE_TYPEDEF;
			} else if (sym->base_type->type == CTYPE_FUNCTION) {
				sym->type = CSYMBOL_TYPE_FUNCTION;
			} else {
				sym->type = CSYMBOL_TYPE_OBJECT;
			}
			gi_source_scanner_add_symbol (scanner, sym);
			gi_source_symbol_unref (sym);
		}
		ctype_free ((yyvsp[-2].ctype));
	  }
#line 3017 "giscanner/scannerparser.c"
    break;

  case 89: /* declaration: declaration_specifiers ';'  */
#line 807 "../gobject-introspection/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
	  }
#line 3025 "giscanner/scannerparser.c"
    break;

  case 91: /* declaration_specifiers: storage_class_specifier declaration_specifiers  */
#line 817 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[-1].storage_class_specifier);
	  }
#line 3034 "giscanner/scannerparser.c"
    break;

  case 92: /* declaration_specifiers: storage_class_specifier  */
#line 822 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[0].storage_class_specifier);
	  }
#line 3043 "giscanner/scannerparser.c"
    break;

  case 93: /* declaration_specifiers: type_specifier declaration_specifiers  */
#line 827 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3052 "giscanner/scannerparser.c"
    break;

  case 95: /* declaration_specifiers: type_qualifier declaration_specifiers  */
#line 833 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3061 "giscanner/scannerparser.c"
    break;

  case 96: /* declaration_specifiers: type_qualifier  */
#line 838 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3070 "giscanner/scannerparser.c"
    break;

  case 97: /* declaration_specifiers: function_specifier declaration_specifiers  */
#line 843 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->function_specifier |= (yyvsp[-1].function_specifier);
	  }
#line 3079 "giscanner/scannerparser.c"
    break;

  case 98: /* declaration_specifiers: function_specifier  */
#line 848 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->function_specifier |= (yyvsp[0].function_specifier);
	  }
#line 3088 "giscanner/scannerparser.c"
    break;

  case 99: /* init_declarator_list: init_declarator  */
#line 856 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3096 "giscanner/scannerparser.c"
    break;

  case 100: /* init_declarator_list: init_declarator_list ',' init_declarator  */
#line 860 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3104 "giscanner/scannerparser.c"
    break;

  case 103: /* storage_class_specifier: TYPEDEF  */
#line 872 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_TYPEDEF;
	  }
#line 3112 "giscanner/scannerparser.c"
    break;

  case 104: /* storage_class_specifier: EXTERN  */
#line 876 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_EXTERN;
	  }
#line 3120 "giscanner/scannerparser.c"
    break;

  case 105: /* storage_class_specifier: STATIC  */
#line 880 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_STATIC;
	  }
#line 3128 "giscanner/scannerparser.c"
    break;

  case 106: /* storage_class_specifier: AUTO  */
#line 884 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_AUTO;
	  }
#line 3136 "giscanner/scannerparser.c"
    break;

  case 107: /* storage_class_specifier: REGISTER  */
#line 888 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_REGISTER;
	  }
#line 3144 "giscanner/scannerparser.c"
    break;

  case 108: /* storage_class_specifier: THREAD_LOCAL  */
#line 892 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_THREAD_LOCAL;
	  }
#line 3152 "giscanner/scannerparser.c"
    break;

  case 109: /* basic_type: BASIC_TYPE  */
#line 899 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3160 "giscanner/scannerparser.c"
    break;

  case 110: /* type_specifier: VOID  */
#line 906 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_VOID);
	  }
#line 3168 "giscanner/scannerparser.c"
    break;

  case 111: /* type_specifier: SIGNED  */
#line 910 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("signed");
	  }
#line 3176 "giscanner/scannerparser.c"
    break;

  case 112: /* type_specifier: UNSIGNED  */
#line 914 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("unsigned");
	  }
#line 3184 "giscanner/scannerparser.c"
    break;

  case 113: /* type_specifier: basic_type  */
#line 918 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_BASIC_TYPE);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3193 "giscanner/scannerparser.c"
    break;

  case 116: /* type_specifier: typedef_name  */
#line 925 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_typedef_new ((yyvsp[0].str));
		g_free ((yyvsp[0].str));
	  }
#line 3202 "giscanner/scannerparser.c"
    break;

  case 117: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name '{' struct_declaration_list '}'  */
#line 933 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym;
		(yyval.ctype) = (yyvsp[-4].ctype);
		(yyval.ctype)->name = (yyvsp[-3].str);
		(yyval.ctype)->child_list = (yyvsp[-1].list);

		sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		if ((yyval.ctype)->type == CTYPE_STRUCT) {
			sym->type = CSYMBOL_TYPE_STRUCT;
		} else if ((yyval.ctype)->type == CTYPE_UNION) {
			sym->type = CSYMBOL_TYPE_UNION;
		} else {
			g_assert_not_reached ();
		}
		sym->ident = g_strdup ((yyval.ctype)->name);
		sym->base_type = gi_source_type_copy ((yyval.ctype));
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	  }
#line 3226 "giscanner/scannerparser.c"
    break;

  case 118: /* struct_or_union_specifier: struct_or_union '{' struct_declaration_list '}'  */
#line 953 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-3].ctype);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
	  }
#line 3235 "giscanner/scannerparser.c"
    break;

  case 119: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name  */
#line 958 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3244 "giscanner/scannerparser.c"
    break;

  case 120: /* struct_or_union: STRUCT  */
#line 966 "../gobject-introspection/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_struct_new (NULL);
	  }
#line 3253 "giscanner/scannerparser.c"
    break;

  case 121: /* struct_or_union: UNION  */
#line 971 "../gobject-introspection/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_union_new (NULL);
	  }
#line 3262 "giscanner/scannerparser.c"
    break;

  case 123: /* struct_declaration_list: struct_declaration_list struct_declaration  */
#line 980 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_concat ((yyvsp[-1].list), (yyvsp[0].list));
	  }
#line 3270 "giscanner/scannerparser.c"
    break;

  case 124: /* struct_declaration: specifier_qualifier_list struct_declarator_list ';'  */
#line 987 "../gobject-introspection/giscanner/scannerparser.y"
          {
	    GList *l;
	    (yyval.list) = NULL;
	    for (l = (yyvsp[-1].list); l != NULL; l = l->next)
	      {
		GISourceSymbol *sym = l->data;
		if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF)
		    sym->type = CSYMBOL_TYPE_TYPEDEF;
		else
		    sym->type = CSYMBOL_TYPE_MEMBER;
		gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
                sym->private = scanner->private;
                (yyval.list) = g_list_append ((yyval.list), sym);
	      }
	    ctype_free ((yyvsp[-2].ctype));
	  }
#line 3291 "giscanner/scannerparser.c"
    break;

  case 125: /* specifier_qualifier_list: type_specifier specifier_qualifier_list  */
#line 1007 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3300 "giscanner/scannerparser.c"
    break;

  case 127: /* specifier_qualifier_list: type_qualifier specifier_qualifier_list  */
#line 1013 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3309 "giscanner/scannerparser.c"
    break;

  case 128: /* specifier_qualifier_list: type_qualifier  */
#line 1018 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3318 "giscanner/scannerparser.c"
    break;

  case 129: /* struct_declarator_list: struct_declarator  */
#line 1026 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3326 "giscanner/scannerparser.c"
    break;

  case 130: /* struct_declarator_list: struct_declarator_list ',' struct_declarator  */
#line 1030 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3334 "giscanner/scannerparser.c"
    break;

  case 131: /* struct_declarator: %empty  */
#line 1037 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3342 "giscanner/scannerparser.c"
    break;

  case 133: /* struct_declarator: ':' constant_expression  */
#line 1042 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3350 "giscanner/scannerparser.c"
    break;

  case 134: /* struct_declarator: declarator ':' constant_expression  */
#line 1046 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		if ((yyvsp[0].symbol)->const_int_set) {
		  (yyval.symbol)->const_int_set = TRUE;
		  (yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		}
	  }
#line 3362 "giscanner/scannerparser.c"
    break;

  case 135: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list '}'  */
#line 1057 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-3].str));
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3373 "giscanner/scannerparser.c"
    break;

  case 136: /* enum_specifier: enum_keyword '{' enumerator_list '}'  */
#line 1064 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3384 "giscanner/scannerparser.c"
    break;

  case 137: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list ',' '}'  */
#line 1071 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-4].str));
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3395 "giscanner/scannerparser.c"
    break;

  case 138: /* enum_specifier: enum_keyword '{' enumerator_list ',' '}'  */
#line 1078 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3406 "giscanner/scannerparser.c"
    break;

  case 139: /* enum_specifier: enum_keyword identifier_or_typedef_name  */
#line 1085 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[0].str));
	  }
#line 3414 "giscanner/scannerparser.c"
    break;

  case 140: /* enum_keyword: ENUM  */
#line 1092 "../gobject-introspection/giscanner/scannerparser.y"
          {
                scanner->flags = FALSE;
                scanner->private = FALSE;
          }
#line 3423 "giscanner/scannerparser.c"
    break;

  case 141: /* static_keyword: STATIC  */
#line 1100 "../gobject-introspection/giscanner/scannerparser.y"
          {
          }
#line 3430 "giscanner/scannerparser.c"
    break;

  case 142: /* $@1: %empty  */
#line 1106 "../gobject-introspection/giscanner/scannerparser.y"
          {
		/* reset flag before the first enum value */
		is_bitfield = FALSE;
	  }
#line 3439 "giscanner/scannerparser.c"
    break;

  case 143: /* enumerator_list: $@1 enumerator  */
#line 1111 "../gobject-introspection/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3448 "giscanner/scannerparser.c"
    break;

  case 144: /* enumerator_list: enumerator_list ',' enumerator  */
#line 1116 "../gobject-introspection/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3457 "giscanner/scannerparser.c"
    break;

  case 145: /* enumerator: identifier  */
#line 1124 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = ++last_enum_value;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3469 "giscanner/scannerparser.c"
    break;

  case 146: /* enumerator: identifier '=' constant_expression  */
#line 1132 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[-2].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		last_enum_value = (yyval.symbol)->const_int;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3482 "giscanner/scannerparser.c"
    break;

  case 147: /* type_qualifier: CONST  */
#line 1144 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_CONST;
	  }
#line 3490 "giscanner/scannerparser.c"
    break;

  case 148: /* type_qualifier: RESTRICT  */
#line 1148 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_RESTRICT;
	  }
#line 3498 "giscanner/scannerparser.c"
    break;

  case 149: /* type_qualifier: EXTENSION  */
#line 1152 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_EXTENSION;
	  }
#line 3506 "giscanner/scannerparser.c"
    break;

  case 150: /* type_qualifier: VOLATILE  */
#line 1156 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_VOLATILE;
	  }
#line 3514 "giscanner/scannerparser.c"
    break;

  case 151: /* function_specifier: INLINE  */
#line 1163 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.function_specifier) = FUNCTION_INLINE;
	  }
#line 3522 "giscanner/scannerparser.c"
    break;

  case 152: /* declarator: pointer direct_declarator  */
#line 1170 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3531 "giscanner/scannerparser.c"
    break;

  case 154: /* direct_declarator: identifier  */
#line 1179 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
	  }
#line 3540 "giscanner/scannerparser.c"
    break;

  case 155: /* direct_declarator: '(' declarator ')'  */
#line 1184 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3548 "giscanner/scannerparser.c"
    break;

  case 156: /* direct_declarator: direct_declarator '[' static_keyword assignment_expression ']'  */
#line 1188 "../gobject-introspection/giscanner/scannerparser.y"
          {
                (yyval.symbol) = (yyvsp[-4].symbol);
                gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
          }
#line 3557 "giscanner/scannerparser.c"
    break;

  case 157: /* direct_declarator: direct_declarator '[' assignment_expression ']'  */
#line 1193 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3566 "giscanner/scannerparser.c"
    break;

  case 158: /* direct_declarator: direct_declarator '[' ']'  */
#line 1198 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3575 "giscanner/scannerparser.c"
    break;

  case 159: /* direct_declarator: direct_declarator '(' parameter_list ')'  */
#line 1203 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3589 "giscanner/scannerparser.c"
    break;

  case 160: /* direct_declarator: direct_declarator '(' identifier_list ')'  */
#line 1213 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		func->child_list = (yyvsp[-1].list);
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3600 "giscanner/scannerparser.c"
    break;

  case 161: /* direct_declarator: direct_declarator '(' ')'  */
#line 1220 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3610 "giscanner/scannerparser.c"
    break;

  case 162: /* pointer: '*' type_qualifier_list  */
#line 1229 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
		(yyval.ctype)->type_qualifier = (yyvsp[0].type_qualifier);
	  }
#line 3619 "giscanner/scannerparser.c"
    break;

  case 163: /* pointer: '*'  */
#line 1234 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
	  }
#line 3627 "giscanner/scannerparser.c"
    break;

  case 164: /* pointer: '*' type_qualifier_list pointer  */
#line 1238 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(*base)->type_qualifier = (yyvsp[-1].type_qualifier);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3642 "giscanner/scannerparser.c"
    break;

  case 165: /* pointer: '*' pointer  */
#line 1249 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3656 "giscanner/scannerparser.c"
    break;

  case 167: /* type_qualifier_list: type_qualifier_list type_qualifier  */
#line 1263 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = (yyvsp[-1].type_qualifier) | (yyvsp[0].type_qualifier);
	  }
#line 3664 "giscanner/scannerparser.c"
    break;

  case 168: /* parameter_list: parameter_declaration  */
#line 1270 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3672 "giscanner/scannerparser.c"
    break;

  case 169: /* parameter_list: parameter_list ',' parameter_declaration  */
#line 1274 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3680 "giscanner/scannerparser.c"
    break;

  case 170: /* parameter_declaration: declaration_specifiers declarator  */
#line 1281 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3689 "giscanner/scannerparser.c"
    break;

  case 171: /* parameter_declaration: declaration_specifiers abstract_declarator  */
#line 1286 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3698 "giscanner/scannerparser.c"
    break;

  case 172: /* parameter_declaration: declaration_specifiers  */
#line 1291 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->base_type = (yyvsp[0].ctype);
	  }
#line 3707 "giscanner/scannerparser.c"
    break;

  case 173: /* parameter_declaration: ELLIPSIS  */
#line 1296 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
	  }
#line 3715 "giscanner/scannerparser.c"
    break;

  case 174: /* identifier_list: identifier  */
#line 1303 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3725 "giscanner/scannerparser.c"
    break;

  case 175: /* identifier_list: identifier_list ',' identifier  */
#line 1309 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append ((yyvsp[-2].list), sym);
	  }
#line 3735 "giscanner/scannerparser.c"
    break;

  case 178: /* abstract_declarator: pointer  */
#line 1323 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[0].ctype));
	  }
#line 3744 "giscanner/scannerparser.c"
    break;

  case 180: /* abstract_declarator: pointer direct_abstract_declarator  */
#line 1329 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3753 "giscanner/scannerparser.c"
    break;

  case 181: /* direct_abstract_declarator: '(' abstract_declarator ')'  */
#line 1337 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3761 "giscanner/scannerparser.c"
    break;

  case 182: /* direct_abstract_declarator: '[' ']'  */
#line 1341 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3770 "giscanner/scannerparser.c"
    break;

  case 183: /* direct_abstract_declarator: '[' assignment_expression ']'  */
#line 1346 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3779 "giscanner/scannerparser.c"
    break;

  case 184: /* direct_abstract_declarator: direct_abstract_declarator '[' ']'  */
#line 1351 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3788 "giscanner/scannerparser.c"
    break;

  case 185: /* direct_abstract_declarator: direct_abstract_declarator '[' assignment_expression ']'  */
#line 1356 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3797 "giscanner/scannerparser.c"
    break;

  case 186: /* direct_abstract_declarator: '(' ')'  */
#line 1361 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3807 "giscanner/scannerparser.c"
    break;

  case 187: /* direct_abstract_declarator: '(' parameter_list ')'  */
#line 1367 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3821 "giscanner/scannerparser.c"
    break;

  case 188: /* direct_abstract_declarator: direct_abstract_declarator '(' ')'  */
#line 1377 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3831 "giscanner/scannerparser.c"
    break;

  case 189: /* direct_abstract_declarator: direct_abstract_declarator '(' parameter_list ')'  */
#line 1383 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3845 "giscanner/scannerparser.c"
    break;

  case 190: /* typedef_name: "typedef-name"  */
#line 1396 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3853 "giscanner/scannerparser.c"
    break;

  case 241: /* function_macro: FUNCTION_MACRO  */
#line 1504 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 3861 "giscanner/scannerparser.c"
    break;

  case 242: /* object_macro: OBJECT_MACRO  */
#line 1511 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 3869 "giscanner/scannerparser.c"
    break;

  case 243: /* function_macro_define: function_macro '(' identifier_list ')'  */
#line 1518 "../gobject-introspection/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-3].str));
		func->child_list = (yyvsp[-1].list);
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 3883 "giscanner/scannerparser.c"
    break;

  case 244: /* object_macro_define: object_macro constant_expression  */
#line 1531 "../gobject-introspection/giscanner/scannerparser.y"
          {
		if ((yyvsp[0].symbol)->const_int_set || (yyvsp[0].symbol)->const_boolean_set || (yyvsp[0].symbol)->const_double_set || (yyvsp[0].symbol)->const_string != NULL) {
			GISourceSymbol *macro = gi_source_symbol_copy ((yyvsp[0].symbol));
			g_free (macro->ident);
			macro->ident = (yyvsp[-1].str);
			gi_source_scanner_add_symbol (scanner, macro);
			gi_source_symbol_unref (macro);
			gi_source_symbol_unref ((yyvsp[0].symbol));
		} else {
			g_free ((yyvsp[-1].str));
			gi_source_symbol_unref ((yyvsp[0].symbol));
		}
	  }
#line 3901 "giscanner/scannerparser.c"
    break;

  case 245: /* preproc_conditional: IFDEF_GI_SCANNER  */
#line 1548 "../gobject-introspection/giscanner/scannerparser.y"
          {
		push_conditional (scanner, FOR_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 3910 "giscanner/scannerparser.c"
    break;

  case 246: /* preproc_conditional: IFNDEF_GI_SCANNER  */
#line 1553 "../gobject-introspection/giscanner/scannerparser.y"
          {
		push_conditional (scanner, NOT_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 3919 "giscanner/scannerparser.c"
    break;

  case 247: /* preproc_conditional: IFDEF_COND  */
#line 1558 "../gobject-introspection/giscanner/scannerparser.y"
          {
	 	warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 3928 "giscanner/scannerparser.c"
    break;

  case 248: /* preproc_conditional: IFNDEF_COND  */
#line 1563 "../gobject-introspection/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 3937 "giscanner/scannerparser.c"
    break;

  case 249: /* preproc_conditional: IF_COND  */
#line 1568 "../gobject-introspection/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 3946 "giscanner/scannerparser.c"
    break;

  case 250: /* preproc_conditional: ELIF_COND  */
#line 1573 "../gobject-introspection/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		pop_conditional (scanner);
		push_conditional (scanner, IRRELEVANT);
		update_skipping (scanner);
	  }
#line 3957 "giscanner/scannerparser.c"
    break;

  case 251: /* preproc_conditional: ELSE_COND  */
#line 1580 "../gobject-introspection/giscanner/scannerparser.y"
          {
		toggle_conditional (scanner);
		update_skipping (scanner);
	  }
#line 3966 "giscanner/scannerparser.c"
    break;

  case 252: /* preproc_conditional: ENDIF_COND  */
#line 1585 "../gobject-introspection/giscanner/scannerparser.y"
          {
		pop_conditional (scanner);
		update_skipping (scanner);
	  }
#line 3975 "giscanner/scannerparser.c"
    break;


#line 3979 "giscanner/scannerparser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 1598 "../gobject-introspection/giscanner/scannerparser.y"

static void
yyerror (GISourceScanner *scanner, const char *s)
{
  /* ignore errors while doing a macro scan as not all object macros
   * have valid expressions */
  if (!scanner->macro_scan)
    {
      gchar *error = g_strdup_printf ("%s:%d: %s in '%s' at '%s'",
          g_file_get_parse_name (scanner->current_file), lineno, s, linebuf, yytext);
      g_ptr_array_add (scanner->errors, error);
    }
}

static int
eat_hspace (FILE * f)
{
  int c;
  do
    {
      c = fgetc (f);
    }
  while (c == ' ' || c == '\t');
  return c;
}

static int
pass_line (FILE * f, int c,
           FILE *out)
{
  while (c != EOF && c != '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
    }
  if (c == '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
      if (c == ' ' || c == '\t')
        {
          c = eat_hspace (f);
        }
    }
  return c;
}

static int
eat_line (FILE * f, int c)
{
  return pass_line (f, c, NULL);
}

static int
read_identifier (FILE * f, int c, char **identifier)
{
  GString *id = g_string_new ("");
  while (g_ascii_isalnum (c) || c == '_')
    {
      g_string_append_c (id, c);
      c = fgetc (f);
    }
  *identifier = g_string_free (id, FALSE);
  return c;
}

static gboolean
parse_file (GISourceScanner *scanner, FILE *file)
{
  g_return_val_if_fail (file != NULL, FALSE);

  lineno = 1;
  yyin = file;
  yyparse (scanner);
  yyin = NULL;

  return TRUE;
}

void
gi_source_scanner_parse_macros (GISourceScanner *scanner, GList *filenames)
{
  GError *error = NULL;
  char *tmp_name = NULL;
  gint tmp_fd;
  FILE *fmacros;
  GList *l;

  tmp_fd = g_file_open_tmp ("gen-introspect-XXXXXX.h", &tmp_name, &error);

  if (tmp_fd == -1)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to create temporary file '%s' while parsing macros: %s", filename, tmp_name, error->message);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      g_error_free (error);
      return;
    }

  fmacros = fdopen (tmp_fd, "w+");

  if (!fmacros)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to open temporary file '%s' while parsing macros", filename, tmp_name);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      close (tmp_fd);
      g_unlink (tmp_name);
      g_free (tmp_name);
      return;
    }

  for (l = filenames; l != NULL; l = l->next)
    {
      FILE *f = fopen (l->data, "r");
      int line = 1;

      GString *define_line;
      char *str;
      gboolean error_line = FALSE;
      gboolean end_of_word;
      int c = eat_hspace (f);
      while (c != EOF)
        {
          if (c != '#')
            {
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }

          /* print current location */
          str = g_strescape (l->data, "");
          fprintf (fmacros, "# %d \"%s\"\n", line, str);
          g_free (str);

          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          end_of_word = (c == ' ' || c == '\t' || c == '\n' || c == EOF);
          if (end_of_word &&
              (g_str_equal (str, "if") ||
               g_str_equal (str, "endif") ||
               g_str_equal (str, "ifndef") ||
               g_str_equal (str, "ifdef") ||
               g_str_equal (str, "else") ||
               g_str_equal (str, "elif")))
            {
              fprintf (fmacros, "#%s ", str);
              g_free (str);
              c = pass_line (f, c, fmacros);
              line++;
              continue;
            }
          else if (strcmp (str, "define") != 0 || !end_of_word)
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          g_free (str);
          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strlen (str) == 0 || (c != ' ' && c != '\t' && c != '('))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          define_line = g_string_new ("#define ");
          g_string_append (define_line, str);
          g_free (str);
          if (c == '(')
            {
              while (c != ')')
                {
                  g_string_append_c (define_line, c);
                  c = fgetc (f);
                  if (c == EOF || c == '\n')
                    {
                      error_line = TRUE;
                      break;
                    }
                }
              if (error_line)
                {
                  g_string_free (define_line, TRUE);
                  /* ignore line */
                  c = eat_line (f, c);
                  line++;
                  continue;
                }

              g_assert (c == ')');
              g_string_append_c (define_line, c);
              c = fgetc (f);

              /* found function-like macro */
              fprintf (fmacros, "%s\n", define_line->str);

              g_string_free (define_line, TRUE);
              /* ignore rest of line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          if (c != ' ' && c != '\t')
            {
              g_string_free (define_line, TRUE);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          while (c != EOF && c != '\n')
            {
              g_string_append_c (define_line, c);
              c = fgetc (f);
              if (c == '\\')
                {
                  c = fgetc (f);
                  if (c == '\n')
                    {
                      /* fold lines when seeing backslash new-line sequence */
                      c = fgetc (f);
                    }
                  else
                    {
                      g_string_append_c (define_line, '\\');
                    }
                }
            }

          /* found object-like macro */
          fprintf (fmacros, "%s\n", define_line->str);

          c = eat_line (f, c);
          line++;
        }

      fclose (f);
    }

  rewind (fmacros);
  parse_file (scanner, fmacros);
  fclose (fmacros);
  g_unlink (tmp_name);
  g_free (tmp_name);
}

gboolean
gi_source_scanner_parse_file (GISourceScanner *scanner, const gchar *filename)
{
  FILE *file;
  gboolean result;

  file = g_fopen (filename, "r");
  result = parse_file (scanner, file);
  fclose (file);

  return result;
}

gboolean
gi_source_scanner_lex_filename (GISourceScanner *scanner, const gchar *filename)
{
  lineno = 1;
  yyin = g_fopen (filename, "r");

  while (yylex (scanner) != YYEOF)
    ;

  fclose (yyin);

  return TRUE;
}
