// Copyright (c) 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "qtwebengine/common/extensions/api/generated_schemas.h"

#include <algorithm>
#include <iterator>

#include "base/stl_util.h"

namespace {
constexpr char kResourcesPrivate[] = R"R({"namespace":"resourcesPrivate","types":[{"id":"resourcesPrivate.Component","type":"string","enum":[{"name":"identity"},{"name":"pdf"}]}],"functions":[{"parameters":[{"name":"component","$ref":"resourcesPrivate.Component"},{"name":"callback","parameters":[{"name":"result","type":"object","additionalProperties":{"type":"any"}}],"type":"function"}],"name":"getStrings","type":"function"}],"properties":{},"internal":false,"events":[],"platforms":null,"deprecated":null,"documentation_options":{}})R";
constexpr char kWebrtcDesktopCapturePrivate[] = R"R({"namespace":"webrtcDesktopCapturePrivate","types":[{"id":"webrtcDesktopCapturePrivate.RequestInfo","properties":{"guestProcessId":{"name":"guestProcessId","type":"integer"},"guestRenderFrameId":{"name":"guestRenderFrameId","type":"integer"}},"type":"object"},{"id":"webrtcDesktopCapturePrivate.Options","properties":{"canRequestAudioTrack":{"name":"canRequestAudioTrack","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"request","$ref":"webrtcDesktopCapturePrivate.RequestInfo"},{"name":"callback","parameters":[{"name":"streamId","type":"string"},{"name":"options","$ref":"webrtcDesktopCapturePrivate.Options"}],"type":"function"}],"returns":{"name":"chooseDesktopMedia","type":"integer"},"name":"chooseDesktopMedia","type":"function"}],"properties":{},"internal":false,"events":[],"platforms":null,"deprecated":null,"documentation_options":{}})R";
}  // namespace

namespace extensions {
namespace api {

// static
bool QtWebEngineGeneratedSchemas::IsGenerated(base::StringPiece name) {
  return !Get(name).empty();
}

// static
base::StringPiece QtWebEngineGeneratedSchemas::Get(base::StringPiece name) {
  static const struct kSchemaMapping {
    const base::StringPiece name;
    const base::StringPiece schema;
    constexpr bool operator<(const kSchemaMapping& that) const {
      return name < that.name;
    }
  } kSchemas[] = {
    {"resourcesPrivate", kResourcesPrivate},
    {"webrtcDesktopCapturePrivate", kWebrtcDesktopCapturePrivate},
  };
  auto it = std::lower_bound(std::begin(kSchemas), std::end(kSchemas),
    kSchemaMapping{name, base::StringPiece()});
  if (it != std::end(kSchemas) && it->name == name)
    return it->schema;
  return base::StringPiece();
}

}  // namespace api
}  // namespace extensions
