// services/network/public/mojom/network_service_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_service_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/network_service_test.mojom-params-data.h"
#include "services/network/public/mojom/network_service_test.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_service_test.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
Rule::Rule()
    : resolver_type(),
      host_pattern(),
      replacement(),
      host_resolver_flags(),
      canonical_name() {}

Rule::Rule(
    ResolverType resolver_type_in,
    const std::string& host_pattern_in,
    const std::string& replacement_in,
    int32_t host_resolver_flags_in,
    const std::string& canonical_name_in)
    : resolver_type(std::move(resolver_type_in)),
      host_pattern(std::move(host_pattern_in)),
      replacement(std::move(replacement_in)),
      host_resolver_flags(std::move(host_resolver_flags_in)),
      canonical_name(std::move(canonical_name_in)) {}

Rule::~Rule() = default;
size_t Rule::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->resolver_type);
  seed = mojo::internal::Hash(seed, this->host_pattern);
  seed = mojo::internal::Hash(seed, this->replacement);
  seed = mojo::internal::Hash(seed, this->host_resolver_flags);
  seed = mojo::internal::Hash(seed, this->canonical_name);
  return seed;
}

void Rule::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("resolver_type", base::trace_event::ValueToString(this->resolver_type));
  value->SetString("host_pattern", this->host_pattern);
  value->SetString("replacement", this->replacement);
  value->SetInteger("host_resolver_flags", this->host_resolver_flags);
  value->SetString("canonical_name", this->canonical_name);
}

bool Rule::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NetworkServiceTest::Name_[] = "network.mojom.NetworkServiceTest";
bool NetworkServiceTest::AddRules(std::vector<RulePtr> rules) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::MockCertVerifierSetDefaultResult(int32_t default_result) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::SetRequireCT(NetworkServiceTest::RequireCT required) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::SetTransportSecurityStateSource(uint16_t reporting_port) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::SetAllowNetworkAccessToHostResolutions() {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::GetLatestMemoryPressureLevel(::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::GetPeerToPeerConnectionsCountChange(uint32_t* out_connection_count) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::GetEnvironmentVariableValue(const std::string& name, std::string* out_value) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::Log(const std::string& message) {
  NOTREACHED();
  return false;
}
bool NetworkServiceTest::SetEVPolicy(const std::vector<uint8_t>& fingerprint_sha256, const std::string& policy_oid) {
  NOTREACHED();
  return false;
}
class NetworkServiceTest_AddRules_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_AddRules_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_AddRules_HandleSyncResponse);
};

class NetworkServiceTest_AddRules_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_AddRules_ForwardToCallback(
      NetworkServiceTest::AddRulesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::AddRulesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_AddRules_ForwardToCallback);
};

class NetworkServiceTest_SimulateNetworkChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SimulateNetworkChange_ForwardToCallback(
      NetworkServiceTest::SimulateNetworkChangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SimulateNetworkChangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SimulateNetworkChange_ForwardToCallback);
};

class NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback(
      NetworkServiceTest::SimulateNetworkQualityChangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SimulateNetworkQualityChangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback);
};
class NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse);
};

class NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback(
      NetworkServiceTest::MockCertVerifierSetDefaultResultCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::MockCertVerifierSetDefaultResultCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback);
};
class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse);
};

class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback(
      NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback);
};
class NetworkServiceTest_SetRequireCT_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetRequireCT_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetRequireCT_HandleSyncResponse);
};

class NetworkServiceTest_SetRequireCT_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetRequireCT_ForwardToCallback(
      NetworkServiceTest::SetRequireCTCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetRequireCTCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetRequireCT_ForwardToCallback);
};
class NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse);
};

class NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback(
      NetworkServiceTest::SetTransportSecurityStateSourceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetTransportSecurityStateSourceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback);
};
class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse);
};

class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback(
      NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback);
};
class NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse(
      bool* result, ::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level)
      : result_(result), out_memory_pressure_level_(out_memory_pressure_level) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse);
};

class NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback(
      NetworkServiceTest::GetLatestMemoryPressureLevelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetLatestMemoryPressureLevelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback);
};
class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse(
      bool* result, uint32_t* out_connection_count)
      : result_(result), out_connection_count_(out_connection_count) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint32_t* out_connection_count_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse);
};

class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback(
      NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback);
};
class NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse(
      bool* result, std::string* out_value)
      : result_(result), out_value_(out_value) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::string* out_value_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse);
};

class NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback(
      NetworkServiceTest::GetEnvironmentVariableValueCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetEnvironmentVariableValueCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback);
};
class NetworkServiceTest_Log_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_Log_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_Log_HandleSyncResponse);
};

class NetworkServiceTest_Log_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_Log_ForwardToCallback(
      NetworkServiceTest::LogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::LogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_Log_ForwardToCallback);
};
class NetworkServiceTest_SetEVPolicy_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetEVPolicy_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetEVPolicy_HandleSyncResponse);
};

class NetworkServiceTest_SetEVPolicy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetEVPolicy_ForwardToCallback(
      NetworkServiceTest::SetEVPolicyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetEVPolicyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetEVPolicy_ForwardToCallback);
};

NetworkServiceTestProxy::NetworkServiceTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NetworkServiceTestProxy::AddRules(
    std::vector<RulePtr> param_rules) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::AddRules", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("rules");
      for (const auto& item0 : param_rules) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_AddRules_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_AddRules_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->rules)::BaseType::BufferWriter
      rules_writer;
  const mojo::internal::ContainerValidateParams rules_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::RuleDataView>>(
      param_rules, buffer, &rules_writer, &rules_validate_params,
      &serialization_context);
  params->rules.Set(
      rules_writer.is_null() ? nullptr : rules_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rules.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rules in NetworkServiceTest.AddRules request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AddRules");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_AddRules_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::AddRules");
#endif
  return result;
}

void NetworkServiceTestProxy::AddRules(
    std::vector<RulePtr> in_rules, AddRulesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::AddRules", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("rules");
      for (const auto& item0 : in_rules) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_AddRules_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_AddRules_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->rules)::BaseType::BufferWriter
      rules_writer;
  const mojo::internal::ContainerValidateParams rules_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::RuleDataView>>(
      in_rules, buffer, &rules_writer, &rules_validate_params,
      &serialization_context);
  params->rules.Set(
      rules_writer.is_null() ? nullptr : rules_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rules.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rules in NetworkServiceTest.AddRules request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AddRules");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_AddRules_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceTestProxy::SimulateNetworkChange(
    ::network::mojom::ConnectionType in_type, SimulateNetworkChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::SimulateNetworkChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("type", base::trace_event::ValueToString(in_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SimulateNetworkChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SimulateNetworkChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::ConnectionType>(
      in_type, &params->type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SimulateNetworkChange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceTestProxy::SimulateNetworkQualityChange(
    ::net::EffectiveConnectionType in_type, SimulateNetworkQualityChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::SimulateNetworkQualityChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("type", static_cast<int>(in_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SimulateNetworkQualityChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::EffectiveConnectionType>(
      in_type, &params->type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkQualityChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceTestProxy::SimulateCrash(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkServiceTest::SimulateCrash");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SimulateCrash_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SimulateCrash_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateCrash");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool NetworkServiceTestProxy::MockCertVerifierSetDefaultResult(
    int32_t param_default_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("default_result", param_default_result);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->default_result = param_default_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierSetDefaultResult");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult");
#endif
  return result;
}

void NetworkServiceTestProxy::MockCertVerifierSetDefaultResult(
    int32_t in_default_result, MockCertVerifierSetDefaultResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("default_result", in_default_result);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->default_result = in_default_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierSetDefaultResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::MockCertVerifierAddResultForCertAndHost(
    const ::scoped_refptr<::net::X509Certificate>& param_cert, const std::string& param_host_pattern, const ::net::CertVerifyResult& param_verify_result, int32_t param_rv) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cert", base::trace_event::ValueToString(param_cert, "<value of type const ::scoped_refptr<::net::X509Certificate>&>"));
      raw_value->SetString("host_pattern", param_host_pattern);
      raw_value->SetString("verify_result", base::trace_event::ValueToString(param_verify_result, "<value of type const ::net::CertVerifyResult&>"));
      raw_value->SetInteger("rv", param_rv);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cert)::BaseType::BufferWriter
      cert_writer;
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      param_cert, buffer, &cert_writer, &serialization_context);
  params->cert.Set(
      cert_writer.is_null() ? nullptr : cert_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cert.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cert in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  typename decltype(params->host_pattern)::BaseType::BufferWriter
      host_pattern_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_host_pattern, buffer, &host_pattern_writer, &serialization_context);
  params->host_pattern.Set(
      host_pattern_writer.is_null() ? nullptr : host_pattern_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host_pattern.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_pattern in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  typename decltype(params->verify_result)::BaseType::BufferWriter
      verify_result_writer;
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
      param_verify_result, buffer, &verify_result_writer, &serialization_context);
  params->verify_result.Set(
      verify_result_writer.is_null() ? nullptr : verify_result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->verify_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null verify_result in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  params->rv = param_rv;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierAddResultForCertAndHost");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost");
#endif
  return result;
}

void NetworkServiceTestProxy::MockCertVerifierAddResultForCertAndHost(
    const ::scoped_refptr<::net::X509Certificate>& in_cert, const std::string& in_host_pattern, const ::net::CertVerifyResult& in_verify_result, int32_t in_rv, MockCertVerifierAddResultForCertAndHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cert", base::trace_event::ValueToString(in_cert, "<value of type const ::scoped_refptr<::net::X509Certificate>&>"));
      raw_value->SetString("host_pattern", in_host_pattern);
      raw_value->SetString("verify_result", base::trace_event::ValueToString(in_verify_result, "<value of type const ::net::CertVerifyResult&>"));
      raw_value->SetInteger("rv", in_rv);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cert)::BaseType::BufferWriter
      cert_writer;
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      in_cert, buffer, &cert_writer, &serialization_context);
  params->cert.Set(
      cert_writer.is_null() ? nullptr : cert_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cert.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cert in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  typename decltype(params->host_pattern)::BaseType::BufferWriter
      host_pattern_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host_pattern, buffer, &host_pattern_writer, &serialization_context);
  params->host_pattern.Set(
      host_pattern_writer.is_null() ? nullptr : host_pattern_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host_pattern.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_pattern in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  typename decltype(params->verify_result)::BaseType::BufferWriter
      verify_result_writer;
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
      in_verify_result, buffer, &verify_result_writer, &serialization_context);
  params->verify_result.Set(
      verify_result_writer.is_null() ? nullptr : verify_result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->verify_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null verify_result in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  params->rv = in_rv;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierAddResultForCertAndHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::SetRequireCT(
    NetworkServiceTest::RequireCT param_required) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::SetRequireCT", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("required", base::trace_event::ValueToString(param_required));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetRequireCT_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetRequireCT_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::NetworkServiceTest_RequireCT>(
      param_required, &params->required);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetRequireCT");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetRequireCT_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::SetRequireCT");
#endif
  return result;
}

void NetworkServiceTestProxy::SetRequireCT(
    NetworkServiceTest::RequireCT in_required, SetRequireCTCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::SetRequireCT", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("required", base::trace_event::ValueToString(in_required));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetRequireCT_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetRequireCT_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::NetworkServiceTest_RequireCT>(
      in_required, &params->required);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetRequireCT");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetRequireCT_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::SetTransportSecurityStateSource(
    uint16_t param_reporting_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::SetTransportSecurityStateSource", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("reporting_port", param_reporting_port);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetTransportSecurityStateSource_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->reporting_port = param_reporting_port;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTransportSecurityStateSource");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::SetTransportSecurityStateSource");
#endif
  return result;
}

void NetworkServiceTestProxy::SetTransportSecurityStateSource(
    uint16_t in_reporting_port, SetTransportSecurityStateSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::SetTransportSecurityStateSource", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("reporting_port", in_reporting_port);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetTransportSecurityStateSource_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->reporting_port = in_reporting_port;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTransportSecurityStateSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::SetAllowNetworkAccessToHostResolutions(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetAllowNetworkAccessToHostResolutions");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif
  return result;
}

void NetworkServiceTestProxy::SetAllowNetworkAccessToHostResolutions(
    SetAllowNetworkAccessToHostResolutionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetAllowNetworkAccessToHostResolutions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceTestProxy::CrashOnResolveHost(
    const std::string& in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::CrashOnResolveHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", in_host);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_CrashOnResolveHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_CrashOnResolveHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in NetworkServiceTest.CrashOnResolveHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("CrashOnResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceTestProxy::CrashOnGetCookieList(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkServiceTest::CrashOnGetCookieList");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_CrashOnGetCookieList_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("CrashOnGetCookieList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool NetworkServiceTestProxy::GetLatestMemoryPressureLevel(
    ::base::MemoryPressureListener::MemoryPressureLevel* out_param_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetLatestMemoryPressureLevel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetLatestMemoryPressureLevel");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse(
          &result, out_param_memory_pressure_level));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_memory_pressure_level) {
        raw_value->SetInteger("memory_pressure_level", static_cast<int>((*out_param_memory_pressure_level)));
      } else {
        raw_value->SetString("memory_pressure_level", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NetworkServiceTestProxy::GetLatestMemoryPressureLevel(
    GetLatestMemoryPressureLevelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetLatestMemoryPressureLevel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetLatestMemoryPressureLevel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::GetPeerToPeerConnectionsCountChange(
    uint32_t* out_param_connection_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetPeerToPeerConnectionsCountChange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse(
          &result, out_param_connection_count));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_connection_count) {
        raw_value->SetString("connection_count", base::NumberToString((*out_param_connection_count)));
      } else {
        raw_value->SetString("connection_count", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NetworkServiceTestProxy::GetPeerToPeerConnectionsCountChange(
    GetPeerToPeerConnectionsCountChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetPeerToPeerConnectionsCountChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::GetEnvironmentVariableValue(
    const std::string& param_name, std::string* out_param_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::GetEnvironmentVariableValue", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", param_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetEnvironmentVariableValue_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NetworkServiceTest.GetEnvironmentVariableValue request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetEnvironmentVariableValue");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse(
          &result, out_param_value));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "network::mojom::NetworkServiceTest::GetEnvironmentVariableValue", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_value) {
        raw_value->SetString("value", (*out_param_value));
      } else {
        raw_value->SetString("value", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NetworkServiceTestProxy::GetEnvironmentVariableValue(
    const std::string& in_name, GetEnvironmentVariableValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::GetEnvironmentVariableValue", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", in_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetEnvironmentVariableValue_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NetworkServiceTest.GetEnvironmentVariableValue request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetEnvironmentVariableValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkServiceTestProxy::Log(
    const std::string& param_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::Log", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", param_message);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_Log_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_Log_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in NetworkServiceTest.Log request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("Log");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_Log_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::Log");
#endif
  return result;
}

void NetworkServiceTestProxy::Log(
    const std::string& in_message, LogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::Log", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", in_message);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_Log_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_Log_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in NetworkServiceTest.Log request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("Log");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_Log_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceTestProxy::ActivateFieldTrial(
    const std::string& in_field_trial_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::ActivateFieldTrial", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("field_trial_name", in_field_trial_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_ActivateFieldTrial_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_ActivateFieldTrial_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->field_trial_name)::BaseType::BufferWriter
      field_trial_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_field_trial_name, buffer, &field_trial_name_writer, &serialization_context);
  params->field_trial_name.Set(
      field_trial_name_writer.is_null() ? nullptr : field_trial_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_trial_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_trial_name in NetworkServiceTest.ActivateFieldTrial request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ActivateFieldTrial");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool NetworkServiceTestProxy::SetEVPolicy(
    const std::vector<uint8_t>& param_fingerprint_sha256, const std::string& param_policy_oid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkServiceTest::SetEVPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("fingerprint_sha256");
      for (const auto& item0 : param_fingerprint_sha256) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      raw_value->SetString("policy_oid", param_policy_oid);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetEVPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetEVPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->fingerprint_sha256)::BaseType::BufferWriter
      fingerprint_sha256_writer;
  const mojo::internal::ContainerValidateParams fingerprint_sha256_validate_params(
      32, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      param_fingerprint_sha256, buffer, &fingerprint_sha256_writer, &fingerprint_sha256_validate_params,
      &serialization_context);
  params->fingerprint_sha256.Set(
      fingerprint_sha256_writer.is_null() ? nullptr : fingerprint_sha256_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fingerprint_sha256.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprint_sha256 in NetworkServiceTest.SetEVPolicy request");
  typename decltype(params->policy_oid)::BaseType::BufferWriter
      policy_oid_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_policy_oid, buffer, &policy_oid_writer, &serialization_context);
  params->policy_oid.Set(
      policy_oid_writer.is_null() ? nullptr : policy_oid_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_oid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_oid in NetworkServiceTest.SetEVPolicy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetEVPolicy");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetEVPolicy_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkServiceTest::SetEVPolicy");
#endif
  return result;
}

void NetworkServiceTestProxy::SetEVPolicy(
    const std::vector<uint8_t>& in_fingerprint_sha256, const std::string& in_policy_oid, SetEVPolicyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceTest::SetEVPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("fingerprint_sha256");
      for (const auto& item0 : in_fingerprint_sha256) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      raw_value->SetString("policy_oid", in_policy_oid);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetEVPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetEVPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->fingerprint_sha256)::BaseType::BufferWriter
      fingerprint_sha256_writer;
  const mojo::internal::ContainerValidateParams fingerprint_sha256_validate_params(
      32, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_fingerprint_sha256, buffer, &fingerprint_sha256_writer, &fingerprint_sha256_validate_params,
      &serialization_context);
  params->fingerprint_sha256.Set(
      fingerprint_sha256_writer.is_null() ? nullptr : fingerprint_sha256_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fingerprint_sha256.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprint_sha256 in NetworkServiceTest.SetEVPolicy request");
  typename decltype(params->policy_oid)::BaseType::BufferWriter
      policy_oid_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_policy_oid, buffer, &policy_oid_writer, &serialization_context);
  params->policy_oid.Set(
      policy_oid_writer.is_null() ? nullptr : policy_oid_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_oid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_oid in NetworkServiceTest.SetEVPolicy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetEVPolicy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetEVPolicy_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NetworkServiceTest_AddRules_ProxyToResponder {
 public:
  static NetworkServiceTest::AddRulesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_AddRules_ProxyToResponder> proxy(
        new NetworkServiceTest_AddRules_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_AddRules_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_AddRules_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_AddRules_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::AddRulesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_AddRules_ProxyToResponder);
};

bool NetworkServiceTest_AddRules_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::AddRulesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_AddRules_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_AddRules_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_AddRules_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_AddRules_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::AddRulesCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_AddRules_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_AddRules_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::AddRulesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AddRules");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_AddRules_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_AddRules_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_AddRules_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_AddRules_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 0, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_SimulateNetworkChange_ProxyToResponder {
 public:
  static NetworkServiceTest::SimulateNetworkChangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_SimulateNetworkChange_ProxyToResponder> proxy(
        new NetworkServiceTest_SimulateNetworkChange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_SimulateNetworkChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SimulateNetworkChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_SimulateNetworkChange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SimulateNetworkChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SimulateNetworkChange_ProxyToResponder);
};

bool NetworkServiceTest_SimulateNetworkChange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::SimulateNetworkChangeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SimulateNetworkChange_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_SimulateNetworkChange_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkChangeCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SimulateNetworkChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkChangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkChange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder {
 public:
  static NetworkServiceTest::SimulateNetworkQualityChangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder> proxy(
        new NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SimulateNetworkQualityChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder);
};

bool NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::SimulateNetworkQualityChangeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkQualityChangeCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SimulateNetworkQualityChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkQualityChangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkQualityChange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder {
 public:
  static NetworkServiceTest::MockCertVerifierSetDefaultResultCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder> proxy(
        new NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::MockCertVerifierSetDefaultResultCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder);
};

bool NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResultCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResultCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResultCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierSetDefaultResult");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 4, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder {
 public:
  static NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder> proxy(
        new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder);
};

bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierAddResultForCertAndHost");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 5, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetRequireCT_ProxyToResponder {
 public:
  static NetworkServiceTest::SetRequireCTCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_SetRequireCT_ProxyToResponder> proxy(
        new NetworkServiceTest_SetRequireCT_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_SetRequireCT_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetRequireCT_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_SetRequireCT_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetRequireCTCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetRequireCT_ProxyToResponder);
};

bool NetworkServiceTest_SetRequireCT_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::SetRequireCTCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetRequireCT_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetRequireCT_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetRequireCT_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_SetRequireCT_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::SetRequireCTCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetRequireCT_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetRequireCT_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::SetRequireCTCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetRequireCT");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetRequireCT_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetRequireCT_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetRequireCT_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetRequireCT_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 6, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder {
 public:
  static NetworkServiceTest::SetTransportSecurityStateSourceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder> proxy(
        new NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetTransportSecurityStateSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder);
};

bool NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::SetTransportSecurityStateSourceCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetTransportSecurityStateSource_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::SetTransportSecurityStateSourceCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetTransportSecurityStateSource_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::SetTransportSecurityStateSourceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTransportSecurityStateSource");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetTransportSecurityStateSource_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 7, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder {
 public:
  static NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder> proxy(
        new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder);
};

bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetAllowNetworkAccessToHostResolutions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 8, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder {
 public:
  static NetworkServiceTest::GetLatestMemoryPressureLevelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder> proxy(
        new NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetLatestMemoryPressureLevelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::MemoryPressureListener::MemoryPressureLevel in_memory_pressure_level);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder);
};

bool NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevelCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::MemoryPressureListener::MemoryPressureLevel p_memory_pressure_level{};
  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_memory_pressure_level));
  return true;
}

void NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder::Run(
    ::base::MemoryPressureListener::MemoryPressureLevel in_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevelCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("memory_pressure_level", static_cast<int>(in_memory_pressure_level));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetLatestMemoryPressureLevel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
      in_memory_pressure_level, &params->memory_pressure_level);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetLatestMemoryPressureLevel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::MemoryPressureListener::MemoryPressureLevel p_memory_pressure_level{};
  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 11, true);
    return false;
  }
  *out_memory_pressure_level_ = std::move(p_memory_pressure_level);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder {
 public:
  static NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder> proxy(
        new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_connection_count);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder);
};

bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  uint32_t p_connection_count{};
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_connection_count = input_data_view.connection_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_connection_count));
  return true;
}

void NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder::Run(
    uint32_t in_connection_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("connection_count", base::NumberToString(in_connection_count));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->connection_count = in_connection_count;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetPeerToPeerConnectionsCountChange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  uint32_t p_connection_count{};
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_connection_count = input_data_view.connection_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 12, true);
    return false;
  }
  *out_connection_count_ = std::move(p_connection_count);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder {
 public:
  static NetworkServiceTest::GetEnvironmentVariableValueCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder> proxy(
        new NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetEnvironmentVariableValueCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_value);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder);
};

bool NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::GetEnvironmentVariableValueCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::string p_value{};
  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_value));
  return true;
}

void NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder::Run(
    const std::string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkServiceTest::GetEnvironmentVariableValueCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("value", in_value);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_GetEnvironmentVariableValue_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->value)::BaseType::BufferWriter
      value_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_value, buffer, &value_writer, &serialization_context);
  params->value.Set(
      value_writer.is_null() ? nullptr : value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::GetEnvironmentVariableValueCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetEnvironmentVariableValue");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::string p_value{};
  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 13, true);
    return false;
  }
  *out_value_ = std::move(p_value);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_Log_ProxyToResponder {
 public:
  static NetworkServiceTest::LogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_Log_ProxyToResponder> proxy(
        new NetworkServiceTest_Log_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_Log_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_Log_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_Log_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::LogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_Log_ProxyToResponder);
};

bool NetworkServiceTest_Log_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::LogCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_Log_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_Log_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_Log_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_Log_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::LogCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_Log_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_Log_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::LogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("Log");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_Log_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_Log_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_Log_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_Log_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 14, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetEVPolicy_ProxyToResponder {
 public:
  static NetworkServiceTest::SetEVPolicyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceTest_SetEVPolicy_ProxyToResponder> proxy(
        new NetworkServiceTest_SetEVPolicy_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceTest_SetEVPolicy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetEVPolicy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceTest_SetEVPolicy_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetEVPolicyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceTest_SetEVPolicy_ProxyToResponder);
};

bool NetworkServiceTest_SetEVPolicy_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceTest::SetEVPolicyCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetEVPolicy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetEVPolicy_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetEVPolicy_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceTest_SetEVPolicy_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceTest::SetEVPolicyCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceTest_SetEVPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkServiceTest_SetEVPolicy_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceTest::SetEVPolicyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetEVPolicy");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetEVPolicy_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetEVPolicy_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetEVPolicy_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkServiceTest_SetEVPolicy_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 16, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool NetworkServiceTestStubDispatch::Accept(
    NetworkServiceTest* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNetworkServiceTest_AddRules_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SimulateNetworkChange_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SimulateNetworkQualityChange_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SimulateCrash_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SimulateCrash",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SimulateCrash");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_SimulateCrash_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_SimulateCrash_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkServiceTest_SimulateCrash_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateCrash();
      return true;
    }
    case internal::kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name: {
      break;
    }
    case internal::kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SetRequireCT_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SetTransportSecurityStateSource_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name: {
      break;
    }
    case internal::kNetworkServiceTest_CrashOnResolveHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::CrashOnResolveHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::CrashOnResolveHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_CrashOnResolveHost_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_CrashOnResolveHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      NetworkServiceTest_CrashOnResolveHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashOnResolveHost(
std::move(p_host));
      return true;
    }
    case internal::kNetworkServiceTest_CrashOnGetCookieList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::CrashOnGetCookieList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::CrashOnGetCookieList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkServiceTest_CrashOnGetCookieList_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashOnGetCookieList();
      return true;
    }
    case internal::kNetworkServiceTest_GetLatestMemoryPressureLevel_Name: {
      break;
    }
    case internal::kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name: {
      break;
    }
    case internal::kNetworkServiceTest_GetEnvironmentVariableValue_Name: {
      break;
    }
    case internal::kNetworkServiceTest_Log_Name: {
      break;
    }
    case internal::kNetworkServiceTest_ActivateFieldTrial_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::ActivateFieldTrial",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::ActivateFieldTrial");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_ActivateFieldTrial_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_ActivateFieldTrial_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_field_trial_name{};
      NetworkServiceTest_ActivateFieldTrial_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFieldTrialName(&p_field_trial_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateFieldTrial(
std::move(p_field_trial_name));
      return true;
    }
    case internal::kNetworkServiceTest_SetEVPolicy_Name: {
      break;
    }
  }
  return false;
}

// static
bool NetworkServiceTestStubDispatch::AcceptWithResponder(
    NetworkServiceTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkServiceTest_AddRules_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::AddRules",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::AddRules");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_AddRules_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_AddRules_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<RulePtr> p_rules{};
      NetworkServiceTest_AddRules_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRules(&p_rules))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 0, false);
        return false;
      }
      NetworkServiceTest::AddRulesCallback callback =
          NetworkServiceTest_AddRules_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddRules(
std::move(p_rules), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_SimulateNetworkChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_SimulateNetworkChange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SimulateNetworkChange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::network::mojom::ConnectionType p_type{};
      NetworkServiceTest_SimulateNetworkChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 1, false);
        return false;
      }
      NetworkServiceTest::SimulateNetworkChangeCallback callback =
          NetworkServiceTest_SimulateNetworkChange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateNetworkChange(
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_SimulateNetworkQualityChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkQualityChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SimulateNetworkQualityChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::EffectiveConnectionType p_type{};
      NetworkServiceTest_SimulateNetworkQualityChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 2, false);
        return false;
      }
      NetworkServiceTest::SimulateNetworkQualityChangeCallback callback =
          NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateNetworkQualityChange(
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_SimulateCrash_Name: {
      break;
    }
    case internal::kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_default_result{};
      NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_default_result = input_data_view.default_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 4, false);
        return false;
      }
      NetworkServiceTest::MockCertVerifierSetDefaultResultCallback callback =
          NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MockCertVerifierSetDefaultResult(
std::move(p_default_result), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_cert{};
      std::string p_host_pattern{};
      ::net::CertVerifyResult p_verify_result{};
      int32_t p_rv{};
      NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCert(&p_cert))
        success = false;
      if (success && !input_data_view.ReadHostPattern(&p_host_pattern))
        success = false;
      if (success && !input_data_view.ReadVerifyResult(&p_verify_result))
        success = false;
      if (success)
        p_rv = input_data_view.rv();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 5, false);
        return false;
      }
      NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback callback =
          NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MockCertVerifierAddResultForCertAndHost(
std::move(p_cert), 
std::move(p_host_pattern), 
std::move(p_verify_result), 
std::move(p_rv), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_SetRequireCT_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SetRequireCT",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SetRequireCT");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_SetRequireCT_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetRequireCT_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkServiceTest::RequireCT p_required{};
      NetworkServiceTest_SetRequireCT_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequired(&p_required))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 6, false);
        return false;
      }
      NetworkServiceTest::SetRequireCTCallback callback =
          NetworkServiceTest_SetRequireCT_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRequireCT(
std::move(p_required), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_SetTransportSecurityStateSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SetTransportSecurityStateSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SetTransportSecurityStateSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint16_t p_reporting_port{};
      NetworkServiceTest_SetTransportSecurityStateSource_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_reporting_port = input_data_view.reporting_port();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 7, false);
        return false;
      }
      NetworkServiceTest::SetTransportSecurityStateSourceCallback callback =
          NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTransportSecurityStateSource(
std::move(p_reporting_port), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 8, false);
        return false;
      }
      NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback callback =
          NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAllowNetworkAccessToHostResolutions(std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_CrashOnResolveHost_Name: {
      break;
    }
    case internal::kNetworkServiceTest_CrashOnGetCookieList_Name: {
      break;
    }
    case internal::kNetworkServiceTest_GetLatestMemoryPressureLevel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 11, false);
        return false;
      }
      NetworkServiceTest::GetLatestMemoryPressureLevelCallback callback =
          NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLatestMemoryPressureLevel(std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 12, false);
        return false;
      }
      NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback callback =
          NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPeerToPeerConnectionsCountChange(std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_GetEnvironmentVariableValue_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::GetEnvironmentVariableValue",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::GetEnvironmentVariableValue");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      NetworkServiceTest_GetEnvironmentVariableValue_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 13, false);
        return false;
      }
      NetworkServiceTest::GetEnvironmentVariableValueCallback callback =
          NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEnvironmentVariableValue(
std::move(p_name), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_Log_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::Log",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::Log");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_Log_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_Log_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_message{};
      NetworkServiceTest_Log_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 14, false);
        return false;
      }
      NetworkServiceTest::LogCallback callback =
          NetworkServiceTest_Log_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Log(
std::move(p_message), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceTest_ActivateFieldTrial_Name: {
      break;
    }
    case internal::kNetworkServiceTest_SetEVPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceTest::SetEVPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceTest::SetEVPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceTest_SetEVPolicy_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetEVPolicy_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_fingerprint_sha256{};
      std::string p_policy_oid{};
      NetworkServiceTest_SetEVPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFingerprintSha256(&p_fingerprint_sha256))
        success = false;
      if (success && !input_data_view.ReadPolicyOid(&p_policy_oid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 16, false);
        return false;
      }
      NetworkServiceTest::SetEVPolicyCallback callback =
          NetworkServiceTest_SetEVPolicy_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEVPolicy(
std::move(p_fingerprint_sha256), 
std::move(p_policy_oid), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkServiceTestValidationInfo[] = {
    {internal::kNetworkServiceTest_AddRules_Name,
     {&internal::NetworkServiceTest_AddRules_Params_Data::Validate,
      &internal::NetworkServiceTest_AddRules_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_SimulateNetworkChange_Name,
     {&internal::NetworkServiceTest_SimulateNetworkChange_Params_Data::Validate,
      &internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_SimulateNetworkQualityChange_Name,
     {&internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::Validate,
      &internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_SimulateCrash_Name,
     {&internal::NetworkServiceTest_SimulateCrash_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name,
     {&internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::Validate,
      &internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name,
     {&internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::Validate,
      &internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_SetRequireCT_Name,
     {&internal::NetworkServiceTest_SetRequireCT_Params_Data::Validate,
      &internal::NetworkServiceTest_SetRequireCT_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_SetTransportSecurityStateSource_Name,
     {&internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data::Validate,
      &internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name,
     {&internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::Validate,
      &internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_CrashOnResolveHost_Name,
     {&internal::NetworkServiceTest_CrashOnResolveHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceTest_CrashOnGetCookieList_Name,
     {&internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceTest_GetLatestMemoryPressureLevel_Name,
     {&internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::Validate,
      &internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name,
     {&internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::Validate,
      &internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_GetEnvironmentVariableValue_Name,
     {&internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::Validate,
      &internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_Log_Name,
     {&internal::NetworkServiceTest_Log_Params_Data::Validate,
      &internal::NetworkServiceTest_Log_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceTest_ActivateFieldTrial_Name,
     {&internal::NetworkServiceTest_ActivateFieldTrial_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceTest_SetEVPolicy_Name,
     {&internal::NetworkServiceTest_SetEVPolicy_Params_Data::Validate,
      &internal::NetworkServiceTest_SetEVPolicy_ResponseParams_Data::Validate}},
};

bool NetworkServiceTestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkServiceTest::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkServiceTestValidationInfo);
}

bool NetworkServiceTestResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkServiceTest::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetworkServiceTestValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::Rule::DataView, ::network::mojom::RulePtr>::Read(
    ::network::mojom::Rule::DataView input,
    ::network::mojom::RulePtr* output) {
  bool success = true;
  ::network::mojom::RulePtr result(::network::mojom::Rule::New());
  
      if (success && !input.ReadResolverType(&result->resolver_type))
        success = false;
      if (success && !input.ReadHostPattern(&result->host_pattern))
        success = false;
      if (success && !input.ReadReplacement(&result->replacement))
        success = false;
      if (success)
        result->host_resolver_flags = input.host_resolver_flags();
      if (success && !input.ReadCanonicalName(&result->canonical_name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif