// third_party/blink/public/mojom/agents/agent_metrics.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/agents/agent_metrics.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/agents/agent_metrics.mojom-params-data.h"
#include "third_party/blink/public/mojom/agents/agent_metrics.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/agents/agent_metrics.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AGENTS_AGENT_METRICS_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AGENTS_AGENT_METRICS_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
AgentMetricsData::AgentMetricsData()
    : agents() {}

AgentMetricsData::AgentMetricsData(
    WTF::Vector<WTF::String> agents_in)
    : agents(std::move(agents_in)) {}

AgentMetricsData::~AgentMetricsData() = default;

void AgentMetricsData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("agents");
  for (const auto& item0 : this->agents) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
}

bool AgentMetricsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AgentMetricsCollectorHost::Name_[] = "blink.mojom.AgentMetricsCollectorHost";

AgentMetricsCollectorHostProxy::AgentMetricsCollectorHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AgentMetricsCollectorHostProxy::ReportRendererMetrics(
    AgentMetricsDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AgentMetricsCollectorHost::ReportRendererMetrics", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_data.is_null()) {
        raw_value->SetString("data", "nullptr");
      } else {
        raw_value->BeginDictionary("data");
        in_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAgentMetricsCollectorHost_ReportRendererMetrics_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::AgentMetricsCollectorHost_ReportRendererMetrics_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::blink::mojom::AgentMetricsDataDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in AgentMetricsCollectorHost.ReportRendererMetrics request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentMetricsCollectorHost::Name_);
  message.set_method_name("ReportRendererMetrics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AgentMetricsCollectorHostStubDispatch::Accept(
    AgentMetricsCollectorHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAgentMetricsCollectorHost_ReportRendererMetrics_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AgentMetricsCollectorHost::ReportRendererMetrics",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AgentMetricsCollectorHost::ReportRendererMetrics");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentMetricsCollectorHost_ReportRendererMetrics_Params_Data* params =
          reinterpret_cast<internal::AgentMetricsCollectorHost_ReportRendererMetrics_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AgentMetricsDataPtr p_data{};
      AgentMetricsCollectorHost_ReportRendererMetrics_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentMetricsCollectorHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportRendererMetrics(
std::move(p_data));
      return true;
    }
  }
  return false;
}

// static
bool AgentMetricsCollectorHostStubDispatch::AcceptWithResponder(
    AgentMetricsCollectorHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAgentMetricsCollectorHost_ReportRendererMetrics_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAgentMetricsCollectorHostValidationInfo[] = {
    {&internal::AgentMetricsCollectorHost_ReportRendererMetrics_Params_Data::Validate,
     nullptr /* no response */},
};

bool AgentMetricsCollectorHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::AgentMetricsCollectorHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAgentMetricsCollectorHostValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AgentMetricsData::DataView, ::blink::mojom::blink::AgentMetricsDataPtr>::Read(
    ::blink::mojom::blink::AgentMetricsData::DataView input,
    ::blink::mojom::blink::AgentMetricsDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AgentMetricsDataPtr result(::blink::mojom::blink::AgentMetricsData::New());
  
      if (success && !input.ReadAgents(&result->agents))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif