// third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, EmulatedScreenType value) {
  switch(value) {
    case EmulatedScreenType::kDesktop:
      return os << "EmulatedScreenType::kDesktop";
    case EmulatedScreenType::kMobile:
      return os << "EmulatedScreenType::kMobile";
    default:
      return os << "Unknown EmulatedScreenType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool DeviceEmulationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceEmulationParams_Data* object = static_cast<const DeviceEmulationParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 72 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::blink::mojom::internal::EmulatedScreenType_Data
        ::Validate(object->screen_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->view_position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_offset, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_offset, validation_context))
    return false;


  if (!::blink::mojom::internal::ScreenOrientation_Data
        ::Validate(object->screen_orientation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_segments, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams window_segments_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->window_segments, validation_context,
                                         &window_segments_validate_params)) {
    return false;
  }

  return true;
}

DeviceEmulationParams_Data::DeviceEmulationParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink