
#line 135 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQml module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <private/qqmljsengine_p.h>
#include <private/qqmljslexer_p.h>
#include <private/qqmljsast_p.h>
#include <private/qqmljsmemorypool_p.h>

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>


#line 495 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"


#include "qqmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qqmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qqmljs.g
//

#define UNIMPLEMENTED syntaxError(loc(1), "Unimplemented"); return false

using namespace QQmlJS;

QT_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<SourceLocation*> (realloc(location_stack, stack_size * sizeof(SourceLocation)));
    string_stack.resize(stack_size);
    rawString_stack.resize(stack_size);
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool())
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
    }
}

static inline SourceLocation location(Lexer *lexer)
{
    SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringView, 4> nameIds;
    QVarLengthArray<SourceLocation, 4> locations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
        }

        return currentId->finish();
    }

    return 0;
}

void Parser::pushToken(int token)
{
    Q_ASSERT(last_token);
    Q_ASSERT(last_token < &token_buffer[TOKEN_BUFFER_SIZE]);
    last_token->token = yytoken;
    last_token->dval = yylval;
    last_token->spell = yytokenspell;
    last_token->raw = yytokenraw;
    last_token->loc = yylloc;
    ++last_token;
    yytoken = token;
}

int Parser::lookaheadToken(Lexer *lexer)
{
    if (yytoken < 0) {
        yytoken = lexer->lex();
        yylval = lexer->tokenValue();
        yytokenspell = lexer->tokenSpell();
        yytokenraw = lexer->rawString();
        yylloc = location(lexer);
    }
    return yytoken;
}

bool Parser::ensureNoFunctionTypeAnnotations(AST::TypeAnnotation *returnValueAnnotation, AST::FormalParameterList *formals)
{
    for (auto formal = formals; formal; formal = formal->next) {
        if (formal->element && formal->element->typeAnnotation) {
            syntaxError(formal->element->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in function parameters in JavaScript functions");
            return false;
        }
    }
    if (returnValueAnnotation) {
        syntaxError(returnValueAnnotation->firstSourceLocation(), "Type annotations are not permitted for the return value of JavaScript functions");
        return false;
    }
    return true;
}

//#define PARSER_DEBUG

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_SCRIPT && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yytokenraw = lexer->rawString();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yytokenraw = first_token->raw;
                yylloc = first_token->loc;
                ++first_token;
                if (first_token == last_token)
                    first_token = last_token = &token_buffer[0];
            }
        }

#ifdef PARSER_DEBUG
       qDebug() << "   in state" << action;
#endif

        action = t_action(action, yytoken);
#ifdef PARSER_DEBUG
       qDebug() << "   current token" << yytoken << (yytoken >= 0 ? spell[yytoken] : "(null)") << "new state" << action;
#endif
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                rawStringRef(1) = yytokenraw;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

#ifdef PARSER_DEBUG
          qDebug() << "        reducing through rule " << -action;
#endif

          switch (r) {

#line 722 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 0: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 730 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 1: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 738 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 2: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 746 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 3: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 754 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 4: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 762 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 5: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 771 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 6: {
        sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList, sym(2).UiObjectMemberList->finish());
    } break;

#line 779 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 8: {
        sym(1).Node = sym(1).UiHeaderItemList->finish();
    } break;

#line 786 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 9: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
    } break;

#line 793 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 10: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
    } break;

#line 800 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 11: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
    } break;

#line 807 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 12: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
    } break;

#line 819 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 16: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2));
        pragma->pragmaToken = loc(1);
        pragma->semicolonToken = loc(3);
        sym(1).Node = pragma;
    } break;

#line 829 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 17: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2), stringRef(4));
        pragma->pragmaToken = loc(1);
        pragma->semicolonToken = loc(5);
        sym(1).Node = pragma;
    } break;

#line 841 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 19: {
        sym(1).UiImport->semicolonToken = loc(2);
    } break;

#line 848 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 20: {
        const int major = sym(1).dval;
        const int minor = sym(3).dval;
        if (!QTypeRevision::isValidSegment(major) || !QTypeRevision::isValidSegment(minor)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(major, minor);
        version->majorToken = loc(1);
        version->minorToken = loc(3);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 867 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 21: {
        const int major = sym(1).dval;
        if (!QTypeRevision::isValidSegment(major)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid major version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval);
        version->majorToken = loc(1);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 883 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 22: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->semicolonToken = loc(3);
    } break;

#line 891 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 23: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->asToken = loc(3);
        sym(1).UiImport->importIdToken = loc(4);
        sym(1).UiImport->importId = stringRef(4);
        sym(1).UiImport->semicolonToken = loc(5);
    } break;

#line 902 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 24: {
        sym(1).UiImport->asToken = loc(2);
        sym(1).UiImport->importIdToken = loc(3);
        sym(1).UiImport->importId = stringRef(3);
        sym(1).UiImport->semicolonToken = loc(4);
    } break;

#line 912 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 25: {
        AST::UiImport *node = 0;

        if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
            node = new (pool) AST::UiImport(importIdLiteral->value);
            node->fileNameToken = loc(2);
        } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
            node = new (pool) AST::UiImport(qualifiedId);
            node->fileNameToken = loc(2);
        }

        sym(1).Node = node;

        if (node) {
            node->importToken = loc(1);
        } else {
            diagnostic_messages.append(compileError(loc(1),
             QLatin1String("Expected a qualified name id or a string literal")));

            return false; // ### remove me
        }
    } break;

#line 938 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 26: {
        sym(1).Node = nullptr;
    } break;

#line 945 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 27: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 952 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 28: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 961 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 29: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 971 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 30: {
        if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
            sym(1).UiQualifiedId = qualifiedId;
        } else {
            sym(1).UiQualifiedId = 0;

            diagnostic_messages.append(compileError(loc(1),
            QLatin1String("Expected a qualified name id")));

            return false;
        }
        AST::UiAnnotation *node = new (pool) AST::UiAnnotation(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 989 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

case 31: {
    sym(1).Node = sym(2).Node;
} break;

#line 997 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 32: {
        sym(1).Node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotation);
    } break;

#line 1004 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 33: {
        AST::UiAnnotationList *node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotationList, sym(2).UiAnnotation);
        sym(1).Node = node;
    } break;

#line 1012 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

   case 34: {
       AST::UiObjectDefinition *node = sym(2).UiObjectDefinition;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = node;
   } break;

#line 1023 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 36: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 1030 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 37: {
        AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(sym(1).UiObjectMemberList, sym(2).UiObjectMember);
        sym(1).Node = node;
    } break;

#line 1038 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 38: {
        sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
    } break;

#line 1045 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 39: {
        AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(sym(1).UiArrayMemberList, sym(3).UiObjectMember);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1054 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 40: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1064 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 41: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1074 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 42: {
        AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 1082 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

   case 43: {
       AST::UiObjectMember *node = sym(2).UiObjectMember;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = sym(2).Node;
   } break;

#line 1095 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 46: {
        AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(sym(1).UiQualifiedId, sym(5).UiArrayMemberList->finish());
        node->colonToken = loc(2);
        node->lbracketToken = loc(4);
        node->rbracketToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1106 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 47: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
            sym(1).UiQualifiedId, sym(4).UiQualifiedId, sym(5).UiObjectInitializer);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1116 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 48: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
          sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
        node->colonToken = loc(2);
        node->hasOnToken = true;
        sym(1).Node = node;
    } break;

#line 1128 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 49: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(4);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(5);
        sym(1).Node = node;
    } break;

#line 1141 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 50: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(5);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1154 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 51: Q_FALLTHROUGH(); 
#line 1156 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 52: Q_FALLTHROUGH(); 
#line 1158 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 53: {
        sym(1).Node = sym(3).Node;
    } break;

#line 1166 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 54: Q_FALLTHROUGH(); 
#line 1168 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 55: Q_FALLTHROUGH(); 
#line 1170 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 56: Q_FALLTHROUGH(); 
#line 1172 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 57: Q_FALLTHROUGH(); 
#line 1174 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 58: Q_FALLTHROUGH(); 
#line 1176 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 59: {
        sym(1).Node = sym(2).Node;
    } break;

#line 1183 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

case 60:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
    } break;

#line 1193 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 61: Q_FALLTHROUGH(); 
#line 1195 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 62: Q_FALLTHROUGH(); 
#line 1197 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 63: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1206 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 64: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1215 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 65: {
        sym(1).Node = nullptr;
    } break;

#line 1222 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 66: {
        sym(1).Node = sym(1).UiParameterList->finish();
    } break;

#line 1229 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 67: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(3).UiQualifiedId->finish(), stringRef(1));
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        node->propertyTypeToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1240 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 68: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiQualifiedId->finish(), stringRef(2));
        node->propertyTypeToken = loc(1);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1250 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 69: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(5).UiQualifiedId->finish(), stringRef(3));
        node->propertyTypeToken = loc(5);
        node->commaToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1262 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 70: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).UiQualifiedId->finish(), stringRef(4));
        node->propertyTypeToken = loc(3);
        node->commaToken = loc(2);
        node->identifierToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1273 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 71: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->parameters = sym(4).UiParameterList;
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1287 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 72: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1313 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 76: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isRequired())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'required' attribute is not allowed."), QtCriticalMsg));
        node->m_requiredToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1324 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 77: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isDefaultMember())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'default' attribute is not allowed."), QtCriticalMsg));
        node->m_defaultToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1335 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 78: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isReadonly())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'readonly' attribute is not allowed."), QtCriticalMsg));
        node->m_readonlyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1346 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 79: {
        AST::UiPropertyAttributes *node = new (pool) AST::UiPropertyAttributes();
        node->m_propertyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1355 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 80: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        node->setAttributes(attributes);
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtWarningMsg));
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1374 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 82: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1392 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

/* we need OptionalSemicolon because UiScriptStatement might already parse the last semicolon
  and then we would miss a semicolon (see tests/auto/quick/qquickvisualdatamodel/data/objectlist.qml)*/
 
#line 1398 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 86: {
        AST::UiRequired *node = new (pool) AST::UiRequired(stringRef(2));
        node->requiredToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1410 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 88: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3), sym(5).Statement);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1427 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 90: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7); // insert a fake ';' before ':'

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
        propertyName->identifierToken = loc(6);
        propertyName->next = nullptr;

        AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(propertyName, sym(9).UiArrayMemberList->finish());
        binding->colonToken = loc(7);
        binding->lbracketToken = loc(8);
        binding->rbracketToken = loc(10);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1458 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 92: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtWarningMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4); // insert a fake ';' before ':'

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
        propertyName->identifierToken = loc(3);
        propertyName->next = nullptr;

        AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
          propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
        binding->colonToken = loc(4);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1486 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 94: {
        auto node = new (pool) AST::UiSourceElement(sym(1).Node);
        sym(1).Node = node;
    } break;

#line 1494 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 95: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1501 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 96: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1508 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 97: {
      if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
        diagnostic_messages.append(compileError(mem->lbracketToken,
          QLatin1String("Ignored annotation"), QtWarningMsg));

        sym(1).Expression = mem->base;
      }

      if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
        sym(1).UiQualifiedId = qualifiedId;
      } else {
        sym(1).UiQualifiedId = 0;

        diagnostic_messages.append(compileError(loc(1),
          QLatin1String("Expected a qualified name id")));

        return false; // ### recover
      }
    } break;

#line 1531 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 98: {
        AST::UiEnumDeclaration *enumDeclaration = new (pool) AST::UiEnumDeclaration(stringRef(2), sym(4).UiEnumMemberList->finish());
        enumDeclaration->enumToken = loc(1);
        enumDeclaration->rbraceToken = loc(5);
        sym(1).Node = enumDeclaration;
        break;
    }

#line 1542 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 99: {
        if (!stringRef(2).front().isUpper()) {
            diagnostic_messages.append(compileError(loc(2),
                QLatin1String("Type name must be upper case"), QtWarningMsg));
        }
        auto inlineComponent = new (pool) AST::UiInlineComponent(stringRef(2), sym(4).UiObjectDefinition);
        inlineComponent->componentToken = loc(1);
        sym(1).Node = inlineComponent;
    } break;

#line 1555 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 100: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1));
        node->memberToken = loc(1);
        sym(1).Node = node;
        break;
    }

#line 1565 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 101: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), sym(3).dval);
        node->memberToken = loc(1);
        node->valueToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1576 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 102: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3));
        node->memberToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1586 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 103: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), sym(5).dval);
        node->memberToken = loc(3);
        node->valueToken = loc(5);
        sym(1).Node = node;
        break;
    }

#line 1630 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 130: {
        sym(1).TypeArgumentList = new (pool) AST::TypeArgumentList(sym(1).Type);
    } break;

#line 1637 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 131: {
        sym(1).TypeArgumentList = new (pool) AST::TypeArgumentList(sym(1).TypeArgumentList, sym(3).Type);
    } break;

#line 1644 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 132: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId, sym(3).TypeArgumentList->finish());
    } break;

#line 1651 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 133: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1660 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 134: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId);
    } break;

#line 1667 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 135: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1676 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 136: {
        sym(1).TypeAnnotation = new (pool) AST::TypeAnnotation(sym(2).Type);
        sym(1).TypeAnnotation->colonToken = loc(1);
    } break;

#line 1685 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 138: {
        sym(1).TypeAnnotation = nullptr;
    } break;

#line 1696 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 139: {
        AST::ThisExpression *node = new (pool) AST::ThisExpression();
        node->thisToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1705 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 140: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1723 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 149: {
        if (coverExpressionType != CE_ParenthesizedExpression) {
            syntaxError(coverExpressionErrorLocation, "Expected token ')'.");
            return false;
        }
    } break;

#line 1734 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 150: {
        AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
        node->lparenToken = loc(1);
        node->rparenToken = loc(3);
        sym(1).Node = node;
        coverExpressionType = CE_ParenthesizedExpression;
    } break;

#line 1745 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 151: {
        sym(1).Node = nullptr;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1754 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 152: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(2).PatternElement))->finish(pool);
        sym(1).Node = node;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1764 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 153: {
        AST::FormalParameterList *list = sym(2).Expression->reparseAsFormalParameterList(pool);
        if (!list) {
            syntaxError(loc(1), "Invalid Arrow parameter list.");
            return false;
        }
        if (sym(4).Node) {
            list = new (pool) AST::FormalParameterList(list, sym(4).PatternElement);
        }
        coverExpressionErrorLocation = loc(4);
        coverExpressionType = CE_FormalParameterList;
        sym(1).Node = list->finish(pool);
    } break;

#line 1781 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 154: {
        AST::NullExpression *node = new (pool) AST::NullExpression();
        node->nullToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1790 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 155: {
        AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
        node->trueToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1799 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 156: {
        AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
        node->falseToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1808 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 157: {
        AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1817 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 158: Q_FALLTHROUGH(); 
#line 1820 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 159: {
        AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1832 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

{
    Lexer::RegExpBodyPrefix prefix;
    case 160:
        prefix = Lexer::NoPrefix;
        goto scan_regexp;

#line 1844 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 161:
        prefix = Lexer::EqualPrefix;
        goto scan_regexp;

    scan_regexp: {
        bool rx = lexer->scanRegExp(prefix);
        if (!rx) {
            diagnostic_messages.append(compileError(location(lexer), lexer->errorMessage()));
            return false;
        }

        loc(1).length = lexer->tokenLength();
        yylloc = loc(1); // adjust the location of the current token

        AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;
}

#line 1868 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 162: {
        AST::PatternElementList *list = nullptr;
        if (sym(2).Elision)
            list = (new (pool) AST::PatternElementList(sym(2).Elision, nullptr))->finish();
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1881 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 163: {
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList->finish());
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1891 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 164: {
        auto *list = sym(2).PatternElementList;
        if (sym(4).Elision) {
            AST::PatternElementList *l = new (pool) AST::PatternElementList(sym(4).Elision, nullptr);
            list = list->append(l);
        }
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list->finish());
        node->lbracketToken = loc(1);
        node->commaToken = loc(3);
        node->rbracketToken = loc(5);
        sym(1).Node = node;
        Q_ASSERT(node->isValidArrayLiteral());
    } break;

#line 1908 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 165: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(1).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(nullptr, e);
    } break;

#line 1916 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 166: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(2).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision->finish(), e);
    } break;

#line 1924 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 167: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
        sym(1).Node = node;
    } break;

#line 1932 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 168: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(4).Expression);
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, e);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 1941 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 169: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 1949 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 170: {
        AST::Elision *node = new (pool) AST::Elision();
        node->commaToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1958 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 171: {
        AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1967 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 172: {
        sym(1).Node = nullptr;
    } break;

#line 1974 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 173: {
        sym(1).Node = sym(1).Elision->finish();
    } break;

#line 1981 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 174: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Expression, AST::PatternElement::SpreadElement);
        sym(1).Node = node;
    } break;

#line 1989 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 175: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern();
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1999 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 176: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2009 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 177: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2020 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 178: Q_FALLTHROUGH(); 
#line 2022 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 179: {
      sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 2029 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 180: Q_FALLTHROUGH(); 
#line 2031 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 181: {
        AST::PatternPropertyList *node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
        sym(1).Node = node;
    } break;

#line 2039 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 182: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *expr = new (pool) AST::IdentifierExpression(stringRef(1));
        expr->identifierToken = loc(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, expr);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2055 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 184: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *left = new (pool) AST::IdentifierExpression(stringRef(1));
        left->identifierToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::BinaryExpression *assignment = new (pool) AST::BinaryExpression(left, QSOperator::Assign, sym(2).Expression);
        assignment->operatorToken = loc(2);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, assignment);
        node->colonToken = loc(1);
        sym(1).Node = node;

    } break;

#line 2076 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 185: Q_FALLTHROUGH(); 
#line 2078 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 186: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Expression);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (!AST::cast<AST::ComputedPropertyName *>(sym(1).PropertyName))
                c->name = driver->newStringRef(sym(1).PropertyName->asString());
        }
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2096 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 190: {
        AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2105 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 191: Q_FALLTHROUGH(); 
#line 2107 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 192: {
        AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2116 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 193: Q_FALLTHROUGH(); 
#line 2118 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 194: {
        AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2169 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 235: {
        AST::ComputedPropertyName *node = new (pool) AST::ComputedPropertyName(sym(2).Expression);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2178 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 236: Q_FALLTHROUGH(); 
#line 2180 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

case 237: {
    sym(1) = sym(2);
} break;

#line 2188 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 238: Q_FALLTHROUGH(); 
#line 2190 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 239: {
        sym(1).Node = nullptr;
    } break;

#line 2200 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 242: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        node->hasNoSubstitution = true;
        sym(1).Node = node;
    } break;

#line 2210 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 243: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2219 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 244: Q_FALLTHROUGH(); 
#line 2222 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 245: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), sym(2).Expression);
        node->next = sym(3).Template;
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2235 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 247: {
        AST::SuperLiteral *node = new (pool) AST::SuperLiteral();
        node->superToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2245 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 248: Q_FALLTHROUGH(); 
#line 2247 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 249: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2256 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 250: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2268 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 251:
    {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken= loc(1);
        sym(1).Node = node;
    } Q_FALLTHROUGH();

#line 2276 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 252: Q_FALLTHROUGH(); 
#line 2278 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 253: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2288 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 254: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2301 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 256: {
        AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
        node->newToken = loc(1);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        sym(1).Node = node;
    } break;

#line 2317 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 259: {
        AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
        node->newToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2327 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 260: Q_FALLTHROUGH(); 
#line 2329 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 261: {
        AST::TaggedTemplate *node = new (pool) AST::TaggedTemplate(sym(1).Expression, sym(2).Template);
        sym(1).Node = node;
    } break;

#line 2337 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 262: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2347 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 263: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2358 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 264: Q_FALLTHROUGH(); 
#line 2360 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 265: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2370 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 266: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2382 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 267: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2392 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 268: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2403 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 269: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2413 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 270: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2424 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 271: {
        sym(1).Node = nullptr;
    } break;

#line 2431 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 272: Q_FALLTHROUGH(); 
#line 2433 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 273: {
        sym(1).Node = sym(1).ArgumentList->finish();
    } break;

#line 2440 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 274: {
        sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
    } break;

#line 2447 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 275: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(2).Expression);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2456 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 276: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2465 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 277: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(4).Expression);
        node->commaToken = loc(2);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2480 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 281: {
        AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
        node->incrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2489 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 282: {
        AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
        node->decrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2498 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 283: {
        AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
        node->incrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2507 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 284: {
        AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
        node->decrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2518 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 286: {
        AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
        node->deleteToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2527 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 287: {
        AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
        node->voidToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2536 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 288: {
        AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
        node->typeofToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2545 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 289: {
        AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
        node->plusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2554 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 290: {
        AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
        node->minusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2563 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 291: {
        AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
        node->tildeToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2572 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 292: {
        AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
        node->notToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2583 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 294: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Exp, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2594 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 296: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2603 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 297: {
        sym(1).ival = QSOperator::Mul;
    } break;

#line 2610 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 298: {
        sym(1).ival = QSOperator::Div;
    } break;

#line 2617 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 299: {
        sym(1).ival = QSOperator::Mod;
    } break;

#line 2626 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 301: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Add, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2635 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 302: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Sub, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2646 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 304: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::LShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2655 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 305: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::RShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2664 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 306: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::URShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2676 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 309: Q_FALLTHROUGH(); 
#line 2678 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 310: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2687 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 311: {
        sym(1).ival = QSOperator::Lt;
    } break;

#line 2693 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 312: {
        sym(1).ival = QSOperator::Gt;
    } break;

#line 2699 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 313: {
        sym(1).ival = QSOperator::Le;
    } break;

#line 2705 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 314: {
        sym(1).ival = QSOperator::Ge;
    } break;

#line 2711 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 315: {
        sym(1).ival = QSOperator::InstanceOf;
    } break;

#line 2717 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 316: {
        sym(1).ival = QSOperator::As;
    } break;

#line 2724 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 317: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::In, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2736 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 320: Q_FALLTHROUGH(); 
#line 2738 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 321: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2747 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 322: {
        sym(1).ival = QSOperator::Equal;
    } break;

#line 2753 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 323: {
        sym(1).ival = QSOperator::NotEqual;
    } break;

#line 2759 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 324: {
        sym(1).ival = QSOperator::StrictEqual;
    } break;

#line 2765 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 325: {
        sym(1).ival = QSOperator::StrictNotEqual;
    } break;

#line 2776 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 328: Q_FALLTHROUGH(); 
#line 2778 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 329: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2791 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 332: Q_FALLTHROUGH(); 
#line 2793 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 333: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2805 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 336: Q_FALLTHROUGH(); 
#line 2807 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 337: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2819 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 340: Q_FALLTHROUGH(); 
#line 2821 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 341: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::And, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2833 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 344: Q_FALLTHROUGH(); 
#line 2835 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 345: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Or, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2847 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 348: Q_FALLTHROUGH(); 
#line 2849 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 349: {

        auto *lhs = sym(1).Expression;
        auto *rhs = sym(3).Expression;

        // Check if lhs or rhs contain || or &&

        if (lhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = lhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Left-hand side may not contain || or &&");
                return false;
            }
        }

        if (rhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = rhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Right-hand side may not contain || or &&");
                return false;
            }
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(lhs, QSOperator::Coalesce, rhs);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2883 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 352: Q_FALLTHROUGH(); 
#line 2885 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 353: {
        AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression, sym(3).Expression, sym(5).Expression);
        node->questionToken = loc(2);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2904 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 360: Q_FALLTHROUGH(); 
#line 2906 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 361: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(1).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                f->name = id->name;
        }
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                c->name = id->name;
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Assign, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2937 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 362: Q_FALLTHROUGH(); 
#line 2939 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 363: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2951 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 364: {
        sym(1).ival = QSOperator::InplaceMul;
    } break;

#line 2958 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 365: {
        sym(1).ival = QSOperator::InplaceExp;
    } break;

#line 2965 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 366: {
        sym(1).ival = QSOperator::InplaceDiv;
    } break;

#line 2972 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 367: {
        sym(1).ival = QSOperator::InplaceMod;
    } break;

#line 2979 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 368: {
        sym(1).ival = QSOperator::InplaceAdd;
    } break;

#line 2986 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 369: {
        sym(1).ival = QSOperator::InplaceSub;
    } break;

#line 2993 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 370: {
        sym(1).ival = QSOperator::InplaceLeftShift;
    } break;

#line 3000 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 371: {
        sym(1).ival = QSOperator::InplaceRightShift;
    } break;

#line 3007 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 372: {
        sym(1).ival = QSOperator::InplaceURightShift;
    } break;

#line 3014 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 373: {
        sym(1).ival = QSOperator::InplaceAnd;
    } break;

#line 3021 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 374: {
        sym(1).ival = QSOperator::InplaceXor;
    } break;

#line 3028 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 375: {
        sym(1).ival = QSOperator::InplaceOr;
    } break;

#line 3038 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 378: Q_FALLTHROUGH(); 
#line 3040 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 379: {
          AST::Expression *node = new (pool) AST::Expression(sym(1).Expression, sym(3).Expression);
          node->commaToken = loc(2);
          sym(1).Node = node;
    } break;

#line 3049 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 380: Q_FALLTHROUGH(); 
#line 3051 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 381: {
      sym(1).Node = nullptr;
    } break;

#line 3063 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 384: {
        sym(1).Node = sym(3).Node;
    } break;

#line 3070 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 385: Q_FALLTHROUGH(); 
#line 3072 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 386: Q_FALLTHROUGH(); 
#line 3074 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 387: Q_FALLTHROUGH(); 
#line 3076 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 388: Q_FALLTHROUGH(); 
#line 3078 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 389: Q_FALLTHROUGH(); 
#line 3080 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 390: Q_FALLTHROUGH(); 
#line 3082 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 391: Q_FALLTHROUGH(); 
#line 3084 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 392: Q_FALLTHROUGH(); 
#line 3086 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 393: Q_FALLTHROUGH(); 
#line 3088 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 394: Q_FALLTHROUGH(); 
#line 3090 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 395: Q_FALLTHROUGH(); 
#line 3092 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 396: Q_FALLTHROUGH(); 
#line 3094 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 397: {
        sym(1).Node = sym(2).Node;
    } break;

#line 3116 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 408: {
        AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3128 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 410: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 3135 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 411: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Statement);
    } break;

#line 3142 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 412: {
        sym(1).Node = new (pool) AST::StatementList(sym(3).FunctionDeclaration);
    } break;

#line 3149 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 413: {
        sym(1).Node = nullptr;
    } break;

#line 3156 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 414: {
        sym(1).Node = sym(1).StatementList->finish();
    } break;

#line 3163 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 415: {
        sym(1).scope = AST::VariableScope::Let;
    } break;

#line 3169 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 416: {
        sym(1).scope = AST::VariableScope::Const;
    } break;

#line 3176 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 417: {
        sym(1).scope = AST::VariableScope::Var;
    } break;

#line 3183 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 418: Q_FALLTHROUGH(); 
#line 3185 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 419: Q_FALLTHROUGH(); 
#line 3187 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 420: Q_FALLTHROUGH(); 
#line 3189 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 421: {
        AST::VariableDeclarationList *declarations = sym(2).VariableDeclarationList->finish(sym(1).scope);
        for (auto it = declarations; it; it = it->next) {
            if (it->declaration && it->declaration->typeAnnotation) {
                syntaxError(it->declaration->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
                return false;
            }
        }
        AST::VariableStatement *node = new (pool) AST::VariableStatement(declarations);
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3207 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 423: Q_FALLTHROUGH(); 
#line 3209 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 424: Q_FALLTHROUGH(); 
#line 3211 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 425: Q_FALLTHROUGH(); 
#line 3213 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 426: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).PatternElement);
    } break;

#line 3220 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 427: Q_FALLTHROUGH(); 
#line 3222 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 428: Q_FALLTHROUGH(); 
#line 3224 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 429: Q_FALLTHROUGH(); 
#line 3226 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 430: {
        AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3235 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 431: Q_FALLTHROUGH(); 
#line 3237 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 432: Q_FALLTHROUGH(); 
#line 3239 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 433: Q_FALLTHROUGH(); 
#line 3241 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 434: {
        auto *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
            c->name = stringRef(1);
    } break;

#line 3255 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 435: Q_FALLTHROUGH(); 
#line 3257 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 436: Q_FALLTHROUGH(); 
#line 3259 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 437: Q_FALLTHROUGH(); 
#line 3261 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 438: {
        auto *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3270 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 439: {
        auto *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3281 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 440: {
        auto *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3292 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 441: {
        sym(1).Node = nullptr;
    } break;

#line 3299 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
 case 442: 
#line 3301 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 443: {
        sym(1).Node = sym(1).PatternPropertyList->finish();
    } break;

#line 3308 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 444: {
        if (sym(1).Elision || sym(2).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
            sym(1).Node = l->finish();
        } else {
            sym(1).Node = nullptr;
        }
    } break;

#line 3320 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 445: {
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3327 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 446: {
        if (sym(3).Elision || sym(4).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
            l = sym(1).PatternElementList->append(l);
            sym(1).Node = l;
        }
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3339 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 447: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 3346 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 448: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
    } break;

#line 3355 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 450: {
        sym(1).PatternElementList = sym(1).PatternElementList->append(sym(3).PatternElementList);
    } break;

#line 3362 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 451: {
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
    } break;

#line 3370 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 452: {
        AST::StringLiteralPropertyName *name = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        sym(1).Node = new (pool) AST::PatternProperty(name, stringRef(1), sym(2).Expression);
    } break;

#line 3384 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 453: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, stringRef(3), sym(4).Expression);
        sym(1).Node = node;
    } break;

#line 3392 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 454: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Pattern, sym(4).Expression);
        sym(1).Node = node;
    } break;

#line 3400 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 455: {
      AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
      node->identifierToken = loc(1);
      // if initializer is an anonymous function expression, we need to assign identifierref as it's name
      if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
          f->name = stringRef(1);
      if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
          c->name = stringRef(1);
      sym(1).Node = node;
    } break;

#line 3414 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 456: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3422 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 457: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(2), /*type annotation*/nullptr, nullptr, AST::PatternElement::RestElement);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3431 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 458: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr, AST::PatternElement::RestElement);
        sym(1).Node = node;
    } break;

#line 3439 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 459: {
        sym(1).Node = nullptr;
    } break;

#line 3449 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 461: {
        AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
        node->semicolonToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3464 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 462: {
        int token = lookaheadToken(lexer);
        if (token == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
        else if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS || token == T_LET || token == T_CONST)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 3475 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 463: {
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3484 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 464: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->elseToken = loc(6);
        sym(1).Node = node;
    } break;

#line 3496 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 465: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3509 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 467: {
        AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
        node->doToken = loc(1);
        node->whileToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 3522 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 468: {
        AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
        node->whileToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3533 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 469: {
        AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3546 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 470: Q_FALLTHROUGH(); 
#line 3548 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 471: {
        // ### get rid of the static_cast!
        AST::ForStatement *node = new (pool) AST::ForStatement(
          static_cast<AST::VariableStatement *>(sym(3).Node)->declarations, sym(5).Expression,
          sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3564 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 472: {
        sym(1).forEachType = AST::ForEachType::In;
    } break;

#line 3571 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 473: {
        sym(1).forEachType = AST::ForEachType::Of;
    } break;

#line 3578 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 474: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(3).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3600 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 475: {
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).PatternElement, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3613 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 476: Q_FALLTHROUGH(); 
#line 3615 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 477: {
        if (auto typeAnnotation = sym(3).TypeAnnotation) {
            syntaxError(typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
            return false;
        }
        auto *node = new (pool) AST::PatternElement(stringRef(2), sym(3).TypeAnnotation, nullptr);
        node->identifierToken = loc(2);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3630 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 478: Q_FALLTHROUGH(); 
#line 3632 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 479: {
        auto *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3642 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 480: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
        node->continueToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3652 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 481: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
        node->continueToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3663 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 482: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringView());
        node->breakToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3673 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 483: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
        node->breakToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3684 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 484: {
        if (!functionNestingLevel) {
            syntaxError(loc(1), "Return statement not allowed outside of Function declaration.");
            return false;
        }
        AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
        node->returnToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3698 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 485: {
        AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
        node->withToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3709 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 486: {
        AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
        node->switchToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3720 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 487: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3730 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 488: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 3740 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 489: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
    } break;

#line 3747 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 490: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
    } break;

#line 3754 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 491: {
        sym(1).Node = nullptr;
    } break;

#line 3761 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 492: {
        sym(1).Node = sym(1).CaseClauses->finish();
    } break;

#line 3768 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 493: {
        AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
        node->caseToken = loc(1);
        node->colonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3778 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 494: {
        AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
        node->defaultToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3788 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 495: {
        AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3800 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 497: {
        syntaxError(loc(3), "FunctionDeclarations are not allowed after a label.");
        return false;
    } break;

#line 3808 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 498: {
        AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
        node->throwToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3818 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 499: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3827 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 500: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3836 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 501: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3845 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 502: {
        AST::Catch *node = new (pool) AST::Catch(sym(3).PatternElement, sym(5).Block);
        node->catchToken = loc(1);
        node->lparenToken = loc(2);
        node->identifierToken = loc(3);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3857 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 503: {
        AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
        node->finallyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3866 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 504: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1));
        node->identifierToken = loc(1);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3876 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 505: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3885 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 506: {
        AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
        node->debuggerToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3902 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 508: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3919 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 509: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3935 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 511: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3951 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 512: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        if (! stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3969 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 513: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3987 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 515: {
        sym(1).Node = nullptr;
    } break;

#line 3994 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 516: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4002 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
 case 517: 
#line 4004 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 518: {
        sym(1).Node = sym(1).FormalParameterList->finish(pool);
    } break;

#line 4011 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 519: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4019 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 520: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement);
        sym(1).Node = node;
    } break;

#line 4028 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 521: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement);
        sym(1).Node = node;
    } break;

#line 4038 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 523: {
        ++functionNestingLevel;
    } break;

#line 4045 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 524: {
        --functionNestingLevel;
    } break;

#line 4055 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 526: Q_FALLTHROUGH(); 
#line 4057 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 527: {
        AST::ReturnStatement *ret = new (pool) AST::ReturnStatement(sym(4).Expression);
        ret->returnToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        ret->semicolonToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        AST::StatementList *statements = (new (pool) AST::StatementList(ret))->finish();
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), sym(1).FormalParameterList, statements);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation().startZeroLengthLocation() : loc(1).startZeroLengthLocation();
        f->lbraceToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        f->rbraceToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        sym(1).Node = f;
    } break;

#line 4073 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 528: Q_FALLTHROUGH(); 
#line 4075 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 529: {
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), sym(1).FormalParameterList, sym(6).StatementList);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation().startZeroLengthLocation() : loc(1).startZeroLengthLocation();
        f->lbraceToken = loc(5);
        f->rbraceToken = loc(7);
        sym(1).Node = f;
    } break;

#line 4087 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 530: {
        AST::PatternElement *e = new (pool) AST::PatternElement(stringRef(1), /*type annotation*/nullptr, nullptr, AST::PatternElement::Binding);
        e->identifierToken = loc(1);
        sym(1).FormalParameterList = (new (pool) AST::FormalParameterList(nullptr, e))->finish(pool);
    } break;

#line 4098 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 531: {
        if (coverExpressionType != CE_FormalParameterList) {
            AST::NestedExpression *ne = static_cast<AST::NestedExpression *>(sym(1).Node);
            AST::FormalParameterList *list = ne->expression->reparseAsFormalParameterList(pool);
            if (!list) {
                syntaxError(loc(1), "Invalid Arrow parameter list.");
                return false;
            }
            sym(1).Node = list->finish(pool);
        }
    } break;

#line 4116 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 532: {
        if (lookaheadToken(lexer) == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
    } break;

#line 4124 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 533: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(1), sym(3).FormalParameterList, sym(7).StatementList);
        f->functionToken = sym(1).PropertyName->firstSourceLocation();
        f->lparenToken = loc(2);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4141 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 534: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        f->isGenerator = true;
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4160 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 535: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, /*formals*/nullptr))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), nullptr, sym(7).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Getter);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4177 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 536: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Setter);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4195 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 537: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4203 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 538: {
        lexer->enterGeneratorBody();
    } break;

#line 4210 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 539: {
        --functionNestingLevel;
        lexer->leaveGeneratorBody();
    } break;

#line 4220 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 541: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4236 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 543: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4250 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 544: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        if (!stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4266 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 545: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4282 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 547: Q_FALLTHROUGH(); 
#line 4284 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 548: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression();
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4293 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 549: Q_FALLTHROUGH(); 
#line 4295 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 550: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(3).Expression);
        node->yieldToken = loc(1);
        node->isYieldStar = true;
        sym(1).Node = node;
    } break;

#line 4305 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 551: Q_FALLTHROUGH(); 
#line 4307 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 552: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(2).Expression);
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4317 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 553: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4329 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 554: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4341 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 555: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4352 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 556: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4365 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 558: {
        lexer->setStaticIsKeyword(true);
    } break;

#line 4372 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
 case 559: 
#line 4374 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 560: {
        lexer->setStaticIsKeyword(false);
    } break;

#line 4381 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 561: {
        sym(1).Node = nullptr;
    } break;

#line 4388 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 562: {
        sym(1).Node = sym(2).Node;
    } break;

#line 4395 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 563: {
        sym(1).Node = nullptr;
    } break;

#line 4402 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 564: {
        if (sym(1).Node)
            sym(1).Node = sym(1).ClassElementList->finish();
    } break;

#line 4412 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 566: {
        if (sym(1).Node) {
            if (sym(2).Node)
                sym(1).ClassElementList = sym(1).ClassElementList->append(sym(2).ClassElementList);
        } else if (sym(2).Node) {
            sym(1).Node = sym(2).Node;
        }
    } break;

#line 4424 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 567: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(1).PatternProperty, false);
        sym(1).Node = node;
    } break;

#line 4432 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 568: {
        lexer->setStaticIsKeyword(true);
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(2).PatternProperty, true);
        sym(1).Node = node;
    } break;

#line 4441 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 569: {
        sym(1).Node = nullptr;
    } break;

#line 4450 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 570: {
        sym(1).Node = nullptr;
    } break;

#line 4459 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 572: {
        sym(1).Node = new (pool) AST::Program(sym(1).StatementList->finish());
    } break;

#line 4466 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
  case 573: {
        sym(1).Node = new (pool) AST::ESModule(sym(1).StatementList);
    } break;

#line 4472 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 574: {
        sym(1).StatementList = sym(1).StatementList->finish();
    } break;

#line 4479 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 575: {
        sym(1).StatementList = nullptr;
    } break;

#line 4489 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 578: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 4497 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
 case 579:  Q_FALLTHROUGH(); 
#line 4499 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 580: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Node);
    } break;

#line 4508 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 582: {
        auto decl = new (pool) AST::ImportDeclaration(sym(2).ImportClause, sym(3).FromClause);
        decl->importToken = loc(1);
        sym(1).Node = decl;
    } break;

#line 4516 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 583: {
        auto decl = new (pool) AST::ImportDeclaration(stringRef(2));
        decl->importToken = loc(1);
        decl->moduleSpecifierToken = loc(2);
        sym(1).Node = decl;
    } break;

#line 4526 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 584: {
        auto clause = new (pool) AST::ImportClause(stringRef(1));
        clause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = clause;
    } break;

#line 4534 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 585: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NameSpaceImport);
    } break;

#line 4540 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 586: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NamedImports);
    } break;

#line 4546 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 587: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NameSpaceImport);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4554 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 588: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NamedImports);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4565 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 590: {
        auto import = new (pool) AST::NameSpaceImport(stringRef(3));
        import->starToken = loc(1);
        import->importedBindingToken = loc(3);
        sym(1).NameSpaceImport = import;
    } break;

#line 4575 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 591: {
        auto namedImports = new (pool) AST::NamedImports();
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(2);
        sym(1).NamedImports = namedImports;
    } break;

#line 4584 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 592: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(3);
        sym(1).NamedImports = namedImports;
    } break;

#line 4593 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 593: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(4);
        sym(1).NamedImports = namedImports;
    } break;

#line 4603 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 594: {
        auto clause = new (pool) AST::FromClause(stringRef(2));
        clause->fromToken = loc(1);
        clause->moduleSpecifierToken = loc(2);
        sym(1).FromClause = clause;
    } break;

#line 4613 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 595: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportSpecifier);
        importsList->importSpecifierToken = loc(1);
        sym(1).ImportsList = importsList;
    } break;

#line 4621 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 596: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportsList, sym(3).ImportSpecifier);
        importsList->importSpecifierToken = loc(3);
        sym(1).ImportsList = importsList;
    } break;

#line 4633 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 597: {
        auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1));
        importSpecifier->importedBindingToken = loc(1);
        sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4641 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 598: {
    auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1), stringRef(3));
    importSpecifier->identifierToken = loc(1);
    importSpecifier->importedBindingToken = loc(3);
    sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4658 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 601: {
        int token = lookaheadToken(lexer);
        if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 4667 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 602: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4675 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 603: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause, sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4683 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 604: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4691 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"
 case 605:  Q_FALLTHROUGH(); 
#line 4693 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 606: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/false, sym(2).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4701 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 607: {
        if (auto *f = AST::cast<AST::FunctionDeclaration*>(sym(5).Node)) {
            if (f->name.isEmpty()) {
                f->name = stringRef(2);
                f->identifierToken = loc(2);
            }
        }
    } Q_FALLTHROUGH();

#line 4712 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 608: {
        // Emulate 15.2.3.11
        if (auto *cls = AST::cast<AST::ClassDeclaration*>(sym(5).Node)) {
            if (cls->name.isEmpty()) {
                cls->name = stringRef(2);
                cls->identifierToken = loc(2);
            }
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(5).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4728 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 609: {
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(4).Node)) {
            f->name = stringRef(2);
        }
        if (auto *c = asAnonymousClassDefinition(sym(4).Expression)) {
            c->name = stringRef(2);
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(4).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4745 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 610: {
        auto exportClause = new (pool) AST::ExportClause();
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(2);
        sym(1).ExportClause = exportClause;
    } break;

#line 4754 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 611: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(3);
        sym(1).ExportClause = exportClause;
    } break;

#line 4763 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 612: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(4);
        sym(1).ExportClause = exportClause;
    } break;

#line 4773 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 613: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportSpecifier);
    } break;

#line 4779 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 614: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportsList, sym(3).ExportSpecifier);
    } break;

#line 4786 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 615: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1));
        exportSpecifier->identifierToken = loc(1);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4794 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    case 616: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1), stringRef(3));
        exportSpecifier->identifierToken = loc(1);
        exportSpecifier->exportedIdentifierToken = loc(3);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4805 "../../../qtdeclarative-everywhere-src-6.3.0/src/qml/parser/qqmljs.g"

    // ------------ end of switch statement
            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

#ifdef PARSER_DEBUG
    qDebug() << "Done or error.";
#endif

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting automatic semicolon.";
#endif
            SavedToken &tk = token_buffer[0];
            tk.token = yytoken;
            tk.dval = yylval;
            tk.spell = yytokenspell;
            tk.raw = yytokenraw;
            tk.loc = yylloc;

            yylloc = yyprevlloc;
            yylloc.offset += yylloc.length;
            yylloc.startColumn += yylloc.length;
            yylloc.length = 0;

            //const QString msg = QCoreApplication::translate("QQmlParser", "Missing `;'");
            //diagnostic_messages.append(compileError(yyloc, msg, QtWarningMsg));

            first_token = &token_buffer[0];
            last_token = &token_buffer[1];

            yytoken = T_SEMICOLON;
            yylval = 0;

            action = errorState;

            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].raw = yytokenraw;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].raw   = yytokenraw    = lexer->rawString();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
#ifdef PARSER_DEBUG
            qDebug() << "Parse error, trying to recover.";
#endif
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
#ifdef PARSER_DEBUG
                qDebug() << "Parse error, trying to recover (2).";
#endif
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(*tk);
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(tk);
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(compileError(token_buffer[0].loc, msg));
    }

    return false;
}

QT_END_NAMESPACE


