/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.sql.Timestamp;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.catalina.tribes.io.ObjectReader;
import org.apache.catalina.tribes.transport.AbstractRxTask;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.catalina.tribes.transport.RxTaskPool;
import org.apache.catalina.tribes.transport.nio.NioReceiverMBean;
import org.apache.catalina.tribes.transport.nio.NioReplicationTask;
import org.apache.catalina.tribes.util.ExceptionUtils;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NioReceiver
extends ReceiverBase
implements Runnable,
NioReceiverMBean {
    private static final Log log = LogFactory.getLog(NioReceiver.class);
    protected static final StringManager sm = StringManager.getManager(NioReceiver.class);
    private volatile boolean running = false;
    private AtomicReference<Selector> selector = new AtomicReference();
    private ServerSocketChannel serverChannel = null;
    private DatagramChannel datagramChannel = null;
    protected final Deque<Runnable> events = new ConcurrentLinkedDeque<Runnable>();
    protected long lastCheck = System.currentTimeMillis();

    @Override
    public void stop() {
        this.stopListening();
        super.stop();
    }

    @Override
    public void start() throws IOException {
        super.start();
        try {
            this.setPool(new RxTaskPool(this.getMaxThreads(), this.getMinThreads(), this));
        }
        catch (Exception exception) {
            log.fatal((Object)sm.getString("nioReceiver.threadpool.fail"), (Throwable)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
        try {
            this.getBind();
            this.bind();
            String string = "";
            if (this.getChannel().getName() != null) {
                string = "[" + this.getChannel().getName() + "]";
            }
            Thread thread = new Thread((Runnable)this, "NioReceiver" + string);
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception exception) {
            log.fatal((Object)sm.getString("nioReceiver.start.fail"), (Throwable)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public AbstractRxTask createRxTask() {
        NioReplicationTask nioReplicationTask = new NioReplicationTask(this, this);
        nioReplicationTask.setUseBufferPool(this.getUseBufferPool());
        nioReplicationTask.setRxBufSize(this.getRxBufSize());
        nioReplicationTask.setOptions(this.getWorkerThreadOptions());
        return nioReplicationTask;
    }

    protected void bind() throws IOException {
        this.serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = this.serverChannel.socket();
        this.selector.set(Selector.open());
        this.bind(serverSocket, this.getPort(), this.getAutoBind());
        this.serverChannel.configureBlocking(false);
        this.serverChannel.register(this.selector.get(), 16);
        if (this.getUdpPort() > 0) {
            this.datagramChannel = DatagramChannel.open();
            this.configureDatagraChannel();
            this.bindUdp(this.datagramChannel.socket(), this.getUdpPort(), this.getAutoBind());
        }
    }

    private void configureDatagraChannel() throws IOException {
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.socket().setSendBufferSize(this.getUdpTxBufSize());
        this.datagramChannel.socket().setReceiveBufferSize(this.getUdpRxBufSize());
        this.datagramChannel.socket().setReuseAddress(this.getSoReuseAddress());
        this.datagramChannel.socket().setSoTimeout(this.getTimeout());
        this.datagramChannel.socket().setTrafficClass(this.getSoTrafficClass());
    }

    public void addEvent(Runnable runnable) {
        Selector selector = this.selector.get();
        if (selector != null) {
            this.events.add(runnable);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding event to selector:" + runnable));
            }
            if (this.isListening()) {
                selector.wakeup();
            }
        }
    }

    public void events() {
        if (this.events.isEmpty()) {
            return;
        }
        Runnable runnable = null;
        while ((runnable = this.events.pollFirst()) != null) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing event in selector:" + runnable));
                }
                runnable.run();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("nioReceiver.eventsError"), (Throwable)exception);
            }
        }
    }

    public static void cancelledKey(SelectionKey selectionKey) {
        block11: {
            block10: {
                block9: {
                    ObjectReader objectReader = (ObjectReader)selectionKey.attachment();
                    if (objectReader != null) {
                        objectReader.setCancelled(true);
                        objectReader.finish();
                    }
                    selectionKey.cancel();
                    selectionKey.attach(null);
                    if (selectionKey.channel() instanceof SocketChannel) {
                        try {
                            ((SocketChannel)selectionKey.channel()).socket().close();
                        }
                        catch (IOException iOException) {
                            if (!log.isDebugEnabled()) break block9;
                            log.debug((Object)"", (Throwable)iOException);
                        }
                    }
                }
                if (selectionKey.channel() instanceof DatagramChannel) {
                    try {
                        ((DatagramChannel)selectionKey.channel()).socket().close();
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block10;
                        log.debug((Object)"", (Throwable)exception);
                    }
                }
            }
            try {
                selectionKey.channel().close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)"", (Throwable)iOException);
            }
        }
    }

    protected void socketTimeouts() {
        Set<SelectionKey> set;
        long l = System.currentTimeMillis();
        if (l - this.lastCheck < this.getSelectorTimeout()) {
            return;
        }
        Selector selector = this.selector.get();
        Set<SelectionKey> set2 = set = this.isListening() && selector != null ? selector.keys() : null;
        if (set == null) {
            return;
        }
        for (SelectionKey selectionKey : set) {
            try {
                if (selectionKey.interestOps() != 0) continue;
                ObjectReader objectReader = (ObjectReader)selectionKey.attachment();
                if (objectReader != null) {
                    long l2 = l - objectReader.getLastAccess();
                    if (l2 <= (long)this.getTimeout() || objectReader.isAccessed()) continue;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)sm.getString("nioReceiver.threadsExhausted", this.getTimeout(), objectReader.isCancelled(), selectionKey, new Timestamp(objectReader.getLastAccess())));
                    }
                    objectReader.setLastAccess(l);
                    continue;
                }
                NioReceiver.cancelledKey(selectionKey);
            }
            catch (CancelledKeyException cancelledKeyException) {
                NioReceiver.cancelledKey(selectionKey);
            }
        }
        this.lastCheck = System.currentTimeMillis();
    }

    protected void listen() throws Exception {
        if (this.doListen()) {
            log.warn((Object)sm.getString("nioReceiver.alreadyStarted"));
            return;
        }
        this.setListen(true);
        Selector selector = this.selector.get();
        if (selector != null && this.datagramChannel != null) {
            ObjectReader objectReader = new ObjectReader(65535);
            this.registerChannel(selector, this.datagramChannel, 1, objectReader);
        }
        while (this.doListen() && selector != null) {
            try {
                this.events();
                this.socketTimeouts();
                int n = selector.select(this.getSelectorTimeout());
                if (n == 0) continue;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (iterator != null && iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    if (selectionKey.isAcceptable()) {
                        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                        SocketChannel socketChannel = serverSocketChannel.accept();
                        socketChannel.socket().setReceiveBufferSize(this.getRxBufSize());
                        socketChannel.socket().setSendBufferSize(this.getTxBufSize());
                        socketChannel.socket().setTcpNoDelay(this.getTcpNoDelay());
                        socketChannel.socket().setKeepAlive(this.getSoKeepAlive());
                        socketChannel.socket().setOOBInline(this.getOoBInline());
                        socketChannel.socket().setReuseAddress(this.getSoReuseAddress());
                        socketChannel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
                        socketChannel.socket().setSoTimeout(this.getTimeout());
                        ObjectReader objectReader = new ObjectReader(socketChannel);
                        this.registerChannel(selector, socketChannel, 1, objectReader);
                    }
                    if (selectionKey.isReadable()) {
                        this.readDataFromSocket(selectionKey);
                    } else {
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                    }
                    iterator.remove();
                }
            }
            catch (ClosedSelectorException closedSelectorException) {
            }
            catch (CancelledKeyException cancelledKeyException) {
                log.warn((Object)sm.getString("nioReceiver.clientDisconnect"));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                log.error((Object)sm.getString("nioReceiver.requestError"), throwable);
            }
        }
        this.serverChannel.close();
        if (this.datagramChannel != null) {
            block14: {
                try {
                    this.datagramChannel.close();
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block14;
                    log.debug((Object)"Unable to close datagram channel.", (Throwable)exception);
                }
            }
            this.datagramChannel = null;
        }
        this.closeSelector();
    }

    protected void stopListening() {
        this.setListen(false);
        Selector selector = this.selector.get();
        if (selector != null) {
            try {
                selector.wakeup();
                for (int i = 0; this.running && i < 50; ++i) {
                    Thread.sleep(100L);
                }
                if (this.running) {
                    log.warn((Object)sm.getString("nioReceiver.stop.threadRunning"));
                }
                this.closeSelector();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("nioReceiver.stop.fail"), (Throwable)exception);
            }
            finally {
                this.selector.set(null);
            }
        }
    }

    private void closeSelector() throws IOException {
        Selector selector = this.selector.getAndSet(null);
        if (selector == null) {
            return;
        }
        try {
            for (SelectionKey selectionKey : selector.keys()) {
                selectionKey.channel().close();
                selectionKey.attach(null);
                selectionKey.cancel();
            }
        }
        catch (IOException iOException) {
            if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("nioReceiver.cleanup.fail"), (Throwable)iOException);
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
        try {
            selector.selectNow();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
        }
        selector.close();
    }

    protected void registerChannel(Selector selector, SelectableChannel selectableChannel, int n, Object object) throws Exception {
        if (selectableChannel == null) {
            return;
        }
        selectableChannel.configureBlocking(false);
        selectableChannel.register(selector, n, object);
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.listen();
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("nioReceiver.run.fail"), (Throwable)exception);
        }
        finally {
            this.running = false;
        }
    }

    protected void readDataFromSocket(SelectionKey selectionKey) throws Exception {
        NioReplicationTask nioReplicationTask = (NioReplicationTask)this.getTaskPool().getRxTask();
        if (nioReplicationTask == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No TcpReplicationThread available");
            }
        } else {
            nioReplicationTask.serviceChannel(selectionKey);
            this.getExecutor().execute(nioReplicationTask);
        }
    }
}

