/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.jvmstat.JvmJvmstatModel_4;
import org.graalvm.visualvm.jvmstat.JvmJvmstatModel_5;
import org.graalvm.visualvm.jvmstat.JvmJvmstatModel_8;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModelFactory;

public class JvmJvmstatModelProvider
extends AbstractModelProvider<JvmJvmstatModel, Application> {
    private static final Logger LOGGER = Logger.getLogger(JvmJvmstatModelProvider.class.getName());

    public JvmJvmstatModel createModelFor(Application app) {
        JvmstatModel jvmstat = JvmstatModelFactory.getJvmstatFor((Application)app);
        if (jvmstat != null) {
            JvmJvmstatModel model = null;
            String javaVersion = jvmstat.findByName("java.property.java.version");
            if (javaVersion != null) {
                if (javaVersion.startsWith("1.6.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (javaVersion.startsWith("1.7.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (javaVersion.startsWith("1.8.")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (javaVersion.startsWith("1.9.")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "9")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "10")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "11")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "12")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "13")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "14")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "15")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "16")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "17")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                } else if (JvmJvmstatModelProvider.isJavaVersion(javaVersion, "18")) {
                    model = new JvmJvmstatModel_8(app, jvmstat);
                }
            }
            if (model == null) {
                String vmVersion = jvmstat.findByName("java.property.java.vm.version");
                if (vmVersion.startsWith("1.4.")) {
                    model = new JvmJvmstatModel_4(app, jvmstat);
                } else if (vmVersion.startsWith("1.5.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("1.6.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("1.7.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("10.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("11.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("12.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("13.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                } else if (vmVersion.startsWith("14.")) {
                    model = new JvmJvmstatModel_5(app, jvmstat);
                }
                if (model == null) {
                    LOGGER.log(Level.WARNING, "Unrecognized java.vm.version " + vmVersion);
                    model = new JvmJvmstatModel_8(app, jvmstat);
                }
            }
            return model;
        }
        return null;
    }

    private static final boolean isJavaVersion(String javaVersionProperty, String releaseVersion) {
        if (javaVersionProperty.equals(releaseVersion)) {
            return true;
        }
        if (javaVersionProperty.equals(releaseVersion + "-ea")) {
            return true;
        }
        return javaVersionProperty.startsWith(releaseVersion + ".");
    }
}

