/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat;

import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.jvmstat.JvmstatModelImpl;
import org.graalvm.visualvm.jvmstat.application.JvmstatApplicationProvider;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;

public class JvmstatModelProvider
extends AbstractModelProvider<JvmstatModel, Application> {
    private static final Logger LOGGER = Logger.getLogger(JvmstatModelProvider.class.getName());

    static MonitoredVm getMonitoredVm(Application app) throws MonitorException {
        if (app.isRemoved() || app.getPid() == -1) {
            return null;
        }
        String vmId = "//" + app.getPid();
        try {
            MonitoredHost monitoredHost = JvmstatApplicationProvider.findMonitoredHost(app);
            if (monitoredHost != null) {
                int refreshInterval = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
                return monitoredHost.getMonitoredVm(new VmIdentifier(vmId), refreshInterval);
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "getMonitoredVm failed", ex);
        }
        return null;
    }

    public JvmstatModel createModelFor(Application app) {
        MonitoredVm vm = null;
        try {
            vm = JvmstatModelProvider.getMonitoredVm(app);
            if (vm != null) {
                if (vm.findByName("java.property.java.vm.version") != null) {
                    JvmstatModelImpl jvmstat = new JvmstatModelImpl(app, vm);
                    app.notifyWhenRemoved((DataRemovedListener)jvmstat);
                    return jvmstat;
                }
                LOGGER.log(Level.INFO, "java.property.java.vm.version is null");
            }
        }
        catch (MonitorException ex) {
            LOGGER.log(Level.INFO, "Could not get MonitoredVM", ex);
        }
        if (vm != null) {
            vm.detach();
        }
        return null;
    }
}

